/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.globusonlinetool.myswingutils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TextAreaRenderer
extends JTextArea
implements TableCellRenderer {
    private final DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
    private final Map<JTable, Map<Object, Map<Object, Integer>>> tablecellSizes = new HashMap<JTable, Map<Object, Map<Object, Integer>>>();

    public TextAreaRenderer() {
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (column == 4) {
            Font statusFont = new Font("Verdana", 1, 12);
            if (this.renderer.getText().equals("SUCCEEDED")) {
                this.setBackground(Color.GREEN);
                this.setForeground(Color.WHITE);
                this.setFont(statusFont);
            } else if (this.renderer.getText().equals("FAILED")) {
                this.setBackground(Color.RED);
                this.setForeground(Color.WHITE);
                this.setFont(statusFont);
            } else if (this.renderer.getText().equals("ACTIVE")) {
                this.setBackground(Color.BLUE);
                this.setForeground(Color.WHITE);
                this.setFont(statusFont);
            }
        } else {
            this.setBackground(this.renderer.getBackground());
            this.setForeground(this.renderer.getForeground());
            this.setFont(this.renderer.getFont());
        }
        this.setBorder(this.renderer.getBorder());
        this.setText(this.renderer.getText());
        TableColumnModel columnModel = table.getColumnModel();
        this.setSize(columnModel.getColumn(column).getWidth(), 0);
        int height_wanted = (int)this.getPreferredSize().getHeight();
        this.addSize(table, row, column, height_wanted);
        height_wanted = 50;
        if (height_wanted != table.getRowHeight(row)) {
            table.setRowHeight(row, height_wanted);
        }
        return this;
    }

    private void addSize(JTable table, int row, int column, int height) {
        Map<Object, Integer> rowheightsMap;
        Map<Object, Map<Object, Integer>> rowsMap = this.tablecellSizes.get(table);
        if (rowsMap == null) {
            rowsMap = new HashMap<Object, Map<Object, Integer>>();
            this.tablecellSizes.put(table, rowsMap);
        }
        if ((rowheightsMap = rowsMap.get(row)) == null) {
            rowheightsMap = new HashMap<Object, Integer>();
            rowsMap.put(row, rowheightsMap);
        }
        rowheightsMap.put(column, height);
    }

    private int findTotalMaximumRowSize(JTable table, int row) {
        int maximum_height = 0;
        Enumeration<TableColumn> columns = table.getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            TableColumn tc = columns.nextElement();
            TableCellRenderer cellRenderer = tc.getCellRenderer();
            if (!(cellRenderer instanceof TextAreaRenderer)) continue;
            TextAreaRenderer tar = (TextAreaRenderer)cellRenderer;
            maximum_height = Math.max(maximum_height, tar.findMaximumRowSize(table, row));
        }
        return maximum_height;
    }

    private int findMaximumRowSize(JTable table, int row) {
        Map<Object, Map<Object, Integer>> rows = this.tablecellSizes.get(table);
        if (rows == null) {
            return 0;
        }
        Map<Object, Integer> rowheights = rows.get(row);
        if (rowheights == null) {
            return 0;
        }
        int maximum_height = 0;
        for (Map.Entry<Object, Integer> entry : rowheights.entrySet()) {
            int cellHeight = entry.getValue();
            maximum_height = Math.max(maximum_height, cellHeight);
        }
        return maximum_height;
    }
}

