/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.myproxytool;

import com.sshtools.common.myproxytool.CredentialHelper;
import com.sshtools.common.ui.NumericTextField;
import com.sshtools.common.ui.PreferencesStore;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.common.ui.XTextField;
import com.sshtools.j2ssh.authentication.ExampleFileFilter;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.LinkedHashSet;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.globus.gsi.X509Credential;

public class MyProxyToolPanel
extends JPanel
implements DocumentListener,
ActionListener {
    private JButton browseInput;
    private JPanel localCertificatePanel;
    private JButton browsePKCS12Cert;
    private JButton browseExistingProxyCert;
    private JComboBox certType;
    private JComboBox myproxyServer;
    private JLabel certTypeLabel;
    private JLabel myproxyServerLabel;
    private JLabel myproxyServerPortLabel;
    private JLabel myproxyServerLifetimeLabel;
    private JLabel usernameLabel;
    private JLabel vonameInfoText;
    private JLabel vonameLabel;
    private JLabel certInfoLabel;
    private JLabel pkcs12CertLabel;
    private JLabel existingProxyCertLabel;
    private JLabel localPassphraseLabel;
    private JLabel typeLabel;
    private JLabel vomsLabel;
    private JLabel vomsLabel2;
    private JPasswordField passphrase;
    private JPasswordField confirmPassphrase;
    private JProgressBar strength;
    private XTextField username;
    private XTextField voname;
    private XTextField pkcs12cert;
    private XTextField existingProxyCert;
    private JPasswordField localPassphrase;
    private JRadioButton vomsSupport;
    private JRadioButton vomsSupport2;
    private NumericTextField port;
    private NumericTextField lifetime;
    private String[] infoText = new String[]{"Assumes the PEM certficates 'usercert.pem' and 'userkey.pem' are in {home.directory}/.globus directory.", "Assumes the lifetime of uploaded proxy is the same as the life of the existing local proxy certificate."};
    private static int defaultLifetime = 168;

    public MyProxyToolPanel() {
        String val = ConfigurationLoader.checkAndGetProperty("user.home", null);
        File userPrefDir = null;
        if (val != null) {
            userPrefDir = new File(val + File.separator + ".sshterm");
        }
        if (userPrefDir != null) {
            PreferencesStore.init(new File(userPrefDir, "GSI-SSHTerm_for_PRACE_EGI_LRZ.properties"));
        }
        JPanel myproxyPanel = new JPanel(new GridBagLayout());
        myproxyPanel.setBorder(BorderFactory.createTitledBorder("MyProxy Server Information"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 17;
        Insets normalInsets = new Insets(0, 2, 4, 2);
        Insets indentedInsets = new Insets(0, 26, 4, 2);
        gbc.insets = normalInsets;
        gbc.weightx = 1.0;
        gbc.insets = indentedInsets;
        UIUtil.jGridBagAdd(myproxyPanel, new JLabel("Server"), gbc, 1);
        String recordedMyproxyHostname = PreferencesStore.get("sshterm.myproxy.defaults.hostname", "").trim().toLowerCase();
        String[] myProxyHostNames = this.getMyProxyHostNames(recordedMyproxyHostname);
        this.myproxyServer = new JComboBox<String>(myProxyHostNames);
        this.myproxyServer.setEditable(true);
        this.myproxyServer.addActionListener(this);
        gbc.insets = normalInsets;
        gbc.weightx = 2.0;
        UIUtil.jGridBagAdd(myproxyPanel, this.myproxyServer, gbc, -1);
        UIUtil.jGridBagAdd(myproxyPanel, new JLabel(), gbc, 0);
        int recordedMyproxyPort = 0;
        try {
            recordedMyproxyPort = Integer.getInteger(PreferencesStore.get("sshterm.myproxy.defaults.port", ""));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (recordedMyproxyPort == 0) {
            recordedMyproxyPort = 7512;
        }
        gbc.insets = indentedInsets;
        this.myproxyServerPortLabel = new JLabel("Port");
        UIUtil.jGridBagAdd(myproxyPanel, this.myproxyServerPortLabel, gbc, 1);
        gbc.insets = normalInsets;
        gbc.weightx = 2.0;
        this.port = new NumericTextField(new Integer(1), new Integer(50000), (Number)recordedMyproxyPort);
        this.myproxyServerPortLabel.setLabelFor(this.port);
        UIUtil.jGridBagAdd(myproxyPanel, this.port, gbc, -1);
        UIUtil.jGridBagAdd(myproxyPanel, new JLabel(), gbc, 0);
        gbc.insets = indentedInsets;
        this.myproxyServerLifetimeLabel = new JLabel("Lifetime (hours)");
        UIUtil.jGridBagAdd(myproxyPanel, this.myproxyServerLifetimeLabel, gbc, 1);
        gbc.insets = normalInsets;
        gbc.weightx = 2.0;
        this.lifetime = new NumericTextField(new Integer(0), new Integer(8760), new Integer(defaultLifetime));
        this.myproxyServerLifetimeLabel.setLabelFor(this.lifetime);
        UIUtil.jGridBagAdd(myproxyPanel, this.lifetime, gbc, -1);
        UIUtil.jGridBagAdd(myproxyPanel, new JLabel(""), gbc, 0);
        gbc.insets = indentedInsets;
        this.usernameLabel = new JLabel("Username");
        UIUtil.jGridBagAdd(myproxyPanel, this.usernameLabel, gbc, 1);
        gbc.insets = normalInsets;
        gbc.weightx = 1.0;
        String usernameStr = PreferencesStore.get("sshterm.myproxy.defaults.username", "");
        if (usernameStr == null || usernameStr.equals("")) {
            usernameStr = System.getProperty("user.name");
        }
        this.username = usernameStr != null ? new XTextField(usernameStr, 20) : new XTextField(20);
        this.usernameLabel.setLabelFor(this.username);
        UIUtil.jGridBagAdd(myproxyPanel, this.username, gbc, -1);
        UIUtil.jGridBagAdd(myproxyPanel, new JLabel(), gbc, 0);
        this.localCertificatePanel = new JPanel(new GridBagLayout());
        this.localCertificatePanel.setBorder(BorderFactory.createTitledBorder("Local Certificate"));
        gbc.insets = indentedInsets;
        this.certTypeLabel = new JLabel("Certificate Format");
        UIUtil.jGridBagAdd(this.localCertificatePanel, this.certTypeLabel, gbc, 1);
        gbc.insets = normalInsets;
        gbc.weightx = 2.0;
        this.certType = new JComboBox<String>(new String[]{"PEM", "PKCS12", "Existing proxy"});
        this.certType.addActionListener(this);
        this.certType.setFont(this.certType.getFont());
        this.certTypeLabel.setLabelFor(this.certType);
        UIUtil.jGridBagAdd(this.localCertificatePanel, this.certType, gbc, -1);
        UIUtil.jGridBagAdd(this.localCertificatePanel, new JLabel(), gbc, 0);
        gbc.insets = indentedInsets;
        gbc.weightx = 0.0;
        this.certInfoLabel = new JLabel(this.infoText[0]);
        this.certInfoLabel.setFont(new Font("Serif", 2, 14));
        UIUtil.jGridBagAdd(this.localCertificatePanel, this.certInfoLabel, gbc, 0);
        String recordedPKCS12File = PreferencesStore.get("sshterm.pkcs12.defaults.file", "").trim().toLowerCase();
        gbc.insets = indentedInsets;
        this.pkcs12CertLabel = new JLabel("PKCS12 certificate location");
        UIUtil.jGridBagAdd(this.localCertificatePanel, this.pkcs12CertLabel, gbc, 1);
        gbc.insets = normalInsets;
        gbc.weightx = 1.0;
        this.pkcs12cert = recordedPKCS12File != null && !recordedPKCS12File.equals("") ? new XTextField(recordedPKCS12File, 25) : new XTextField(25);
        UIUtil.jGridBagAdd(this.localCertificatePanel, this.pkcs12cert, gbc, -1);
        this.pkcs12CertLabel.setLabelFor(this.pkcs12cert);
        gbc.weightx = 0.0;
        this.browsePKCS12Cert = new JButton("Browse");
        this.browsePKCS12Cert.setMnemonic('b');
        this.browsePKCS12Cert.addActionListener(this);
        UIUtil.jGridBagAdd(this.localCertificatePanel, this.browsePKCS12Cert, gbc, 0);
        gbc.insets = indentedInsets;
        this.existingProxyCertLabel = new JLabel("Existing proxy location");
        UIUtil.jGridBagAdd(this.localCertificatePanel, this.existingProxyCertLabel, gbc, 1);
        gbc.insets = normalInsets;
        gbc.weightx = 1.0;
        String existingProxyCertStr = "";
        if (CredentialHelper.getExistingProxyLocation() != null) {
            existingProxyCertStr = CredentialHelper.getExistingProxyLocation();
        }
        this.existingProxyCert = new XTextField(existingProxyCertStr, 25);
        UIUtil.jGridBagAdd(this.localCertificatePanel, this.existingProxyCert, gbc, -1);
        this.existingProxyCertLabel.setLabelFor(this.existingProxyCert);
        gbc.weightx = 0.0;
        this.browseExistingProxyCert = new JButton("Browse");
        this.browseExistingProxyCert.setMnemonic('b');
        this.browseExistingProxyCert.addActionListener(this);
        UIUtil.jGridBagAdd(this.localCertificatePanel, this.browseExistingProxyCert, gbc, 0);
        gbc.insets = indentedInsets;
        this.localPassphraseLabel = new JLabel("Passphrase");
        UIUtil.jGridBagAdd(this.localCertificatePanel, this.localPassphraseLabel, gbc, 1);
        gbc.insets = normalInsets;
        gbc.weightx = 2.0;
        this.localPassphrase = new JPasswordField(20);
        this.localPassphrase.setBackground(Color.white);
        this.localPassphrase.getDocument().addDocumentListener(this);
        this.localPassphraseLabel.setLabelFor(this.localPassphrase);
        UIUtil.jGridBagAdd(this.localCertificatePanel, this.localPassphrase, gbc, -1);
        UIUtil.jGridBagAdd(this.localCertificatePanel, new JLabel(), gbc, 0);
        gbc.insets = indentedInsets;
        this.vomsSupport = new JRadioButton("  VOMS Enabled Proxy (locally)");
        UIUtil.jGridBagAdd(this.localCertificatePanel, this.vomsSupport, gbc, 1);
        gbc.insets = normalInsets;
        gbc.weightx = 3.0;
        this.vomsLabel = new JLabel(" (Generates VOMS extension locally)");
        this.vomsLabel.setFont(new Font("Serif", 2, 14));
        UIUtil.jGridBagAdd(this.localCertificatePanel, this.vomsLabel, gbc, 0);
        gbc.insets = indentedInsets;
        this.vomsSupport2 = new JRadioButton("  VOMS Enabled Proxy (remotely)");
        UIUtil.jGridBagAdd(this.localCertificatePanel, this.vomsSupport2, gbc, 1);
        gbc.insets = normalInsets;
        gbc.weightx = 3.0;
        this.vomsLabel2 = new JLabel(" (Gets VOMS extensions via MyProxy server)");
        this.vomsLabel2.setFont(new Font("Serif", 2, 14));
        UIUtil.jGridBagAdd(this.localCertificatePanel, this.vomsLabel2, gbc, 0);
        ButtonGroup vomsGroup = new ButtonGroup();
        vomsGroup.add(this.vomsSupport);
        vomsGroup.add(this.vomsSupport2);
        this.triggerCertificateFormat("PEM");
        this.setLayout(new BorderLayout());
        this.add((Component)myproxyPanel, "Center");
        this.add((Component)this.localCertificatePanel, "South");
    }

    public void triggerLifetime(boolean isEnabled) {
        this.lifetime.setEnabled(isEnabled);
        this.myproxyServerLifetimeLabel.setEnabled(isEnabled);
    }

    public void triggerCertificateFormat(String certFormat) {
        this.localPassphrase.setText("");
        if (certFormat.equals("PEM")) {
            this.pkcs12CertLabel.setVisible(false);
            this.pkcs12cert.setVisible(false);
            this.browsePKCS12Cert.setVisible(false);
            this.existingProxyCertLabel.setVisible(false);
            this.existingProxyCert.setVisible(false);
            this.browseExistingProxyCert.setVisible(false);
            this.certInfoLabel.setVisible(true);
            this.certInfoLabel.setText(this.infoText[0]);
            this.localPassphraseLabel.setVisible(true);
            this.localPassphrase.setVisible(true);
            this.lifetime.setEnabled(true);
        } else if (certFormat.equals("PKCS12")) {
            this.pkcs12CertLabel.setVisible(true);
            this.pkcs12cert.setVisible(true);
            this.browsePKCS12Cert.setVisible(true);
            this.existingProxyCertLabel.setVisible(false);
            this.existingProxyCert.setVisible(false);
            this.browseExistingProxyCert.setVisible(false);
            this.certInfoLabel.setVisible(false);
            this.localPassphraseLabel.setVisible(true);
            this.localPassphrase.setVisible(true);
            this.lifetime.setEnabled(true);
        } else if (certFormat.equals("Existing proxy")) {
            this.pkcs12CertLabel.setVisible(false);
            this.pkcs12cert.setVisible(false);
            this.browsePKCS12Cert.setVisible(false);
            this.existingProxyCertLabel.setVisible(true);
            this.existingProxyCert.setVisible(true);
            this.browseExistingProxyCert.setVisible(true);
            this.certInfoLabel.setVisible(true);
            this.certInfoLabel.setText(this.infoText[1]);
            this.localPassphraseLabel.setVisible(false);
            this.localPassphrase.setVisible(false);
            this.lifetime.setEnabled(false);
            if (this.existingProxyCert.getText().trim().equals("") && CredentialHelper.getExistingProxyLocation() != null) {
                this.existingProxyCert.setText(CredentialHelper.getExistingProxyLocation());
            }
        }
    }

    public void triggerLocalCertificatePanel(boolean isEnabled) {
        this.localCertificatePanel.setVisible(isEnabled);
    }

    public String[] getMyProxyHostNames(String recordedHostName) {
        LinkedHashSet<String> myProxyHostNames = new LinkedHashSet<String>();
        myProxyHostNames.add("myproxy.lrz.de");
        myProxyHostNames.add("px.grid.sara.nl");
        myProxyHostNames.add("myproxy.egi.eu");
        if (recordedHostName != null && !recordedHostName.equals("")) {
            myProxyHostNames.add(recordedHostName);
        }
        String[] hostnames = new String[myProxyHostNames.size()];
        hostnames = myProxyHostNames.toArray(hostnames);
        return hostnames;
    }

    public int getPort() {
        return (Integer)this.port.getValue();
    }

    public String getMyProxyServer() {
        return (String)this.myproxyServer.getSelectedItem();
    }

    public int getLifetime() {
        return (Integer)this.lifetime.getValue();
    }

    public String getUsername() {
        return this.username.getText().trim();
    }

    public String getCertType() {
        return (String)this.certType.getSelectedItem();
    }

    public String getPKCS12Cert() {
        return this.pkcs12cert.getText();
    }

    public String getExistingProxyCert() {
        return this.existingProxyCert.getText();
    }

    public char[] getLocalPassphrase() {
        return this.localPassphrase.getPassword();
    }

    public boolean getVOMSSupport() {
        return this.vomsSupport.isSelected();
    }

    public boolean getVOMSRemoteSupport() {
        return this.vomsSupport2.isSelected();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        JFileChooser chooser;
        if (evt.getSource() == this.certType) {
            this.triggerCertificateFormat(this.getCertType());
        }
        if (evt.getSource() == this.browsePKCS12Cert) {
            chooser = new JFileChooser();
            ExampleFileFilter filter = new ExampleFileFilter();
            filter.addExtension("pfx");
            filter.addExtension("p12");
            filter.setDescription("pfx and p12 files");
            if (this.getPKCS12Cert() != null && !this.getPKCS12Cert().equals("")) {
                chooser.setSelectedFile(new File(this.getPKCS12Cert()));
            }
            chooser.setFileFilter(filter);
            chooser.setFileHidingEnabled(false);
            chooser.setDialogTitle("Select PKCS12 Certificate File");
            if (chooser.showOpenDialog(this) == 0) {
                this.pkcs12cert.setText(chooser.getSelectedFile().getPath());
            }
        }
        if (evt.getSource() == this.browseExistingProxyCert) {
            chooser = new JFileChooser();
            chooser.setFileHidingEnabled(false);
            if (this.getExistingProxyCert() != null && !this.getExistingProxyCert().equals("")) {
                chooser.setSelectedFile(new File(this.getExistingProxyCert()));
            }
            chooser.setDialogTitle("Select Existing Proxy File");
            if (chooser.showOpenDialog(this) == 0) {
                this.existingProxyCert.setText(chooser.getSelectedFile().getPath());
                try {
                    X509Credential proxy = CredentialHelper.retrieveExistingProxy(this.getExistingProxyCert());
                    if (proxy != null) {
                        int timeleft = (int)proxy.getTimeLeft() / 3600;
                        this.lifetime.setValue(timeleft);
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, ex.getMessage(), "MyProxy Error", 0);
                }
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
    }
}

