/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh;

import com.sshtools.j2ssh.DirectoryOperation;
import com.sshtools.j2ssh.FileTransferProgress;
import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.TransferCancelledException;
import com.sshtools.j2ssh.connection.ChannelEventListener;
import com.sshtools.j2ssh.io.IOUtil;
import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.sftp.FileAttributes;
import com.sshtools.j2ssh.sftp.SftpFile;
import com.sshtools.j2ssh.sftp.SftpFileInputStream;
import com.sshtools.j2ssh.sftp.SftpFileOutputStream;
import com.sshtools.j2ssh.sftp.SftpSubsystemClient;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SftpClient {
    SftpSubsystemClient sftp;
    String cwd;
    String lcwd;
    private int BLOCKSIZE = 65535;
    int umask = 18;
    int default_permissions = 511;
    private boolean preserve = true;
    protected static Log log = LogFactory.getLog(SftpClient.class);
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm.ss");

    public boolean getPreserve() {
        return this.preserve;
    }

    public void setPreserve(boolean preserve) {
        this.preserve = preserve;
    }

    SftpClient(SshClient ssh) throws IOException {
        this(ssh, null);
    }

    SftpClient(SshClient ssh, ChannelEventListener eventListener) throws IOException {
        if (!ssh.isConnected()) {
            throw new IOException("SshClient is not connected");
        }
        this.sftp = ssh.openSftpChannel(eventListener);
        this.cwd = this.sftp.getDefaultDirectory();
        this.lcwd = System.getProperty("user.home");
    }

    public int umask(int umask) {
        int old = umask;
        this.umask = umask;
        return old;
    }

    public void cd(String dir) throws IOException {
        try {
            String actual;
            if (dir.equals("")) {
                actual = this.sftp.getDefaultDirectory();
            } else {
                actual = this.resolveRemotePath(dir);
                actual = this.sftp.getAbsolutePath(actual);
            }
            FileAttributes attr = this.sftp.getAttributes(actual);
            if (!attr.isDirectory()) {
                throw new IOException(dir + " is not a directory");
            }
            this.cwd = actual;
        }
        catch (IOException ex) {
            throw new FileNotFoundException(dir + " could not be found");
        }
    }

    private File resolveLocalPath(String path) throws IOException {
        File f = new File(path);
        if (!f.isAbsolute()) {
            f = new File(this.lcwd, path);
        }
        return f;
    }

    private String resolveRemotePath(String path) throws IOException {
        this.verifyConnection();
        String actual = !path.startsWith("/") ? this.cwd + (this.cwd.endsWith("/") ? "" : "/") + path : path;
        return actual;
    }

    private void verifyConnection() throws SshException {
        if (this.sftp.isClosed()) {
            throw new SshException("The SFTP connection has been closed");
        }
    }

    public void mkdir(String dir) throws IOException {
        String actual = this.resolveRemotePath(dir);
        try {
            FileAttributes attrs = this.stat(actual);
            if (!attrs.isDirectory()) {
                throw new IOException("File already exists named " + dir);
            }
        }
        catch (IOException ex) {
            this.sftp.makeDirectory(actual);
            this.chmod(this.default_permissions ^ this.umask, actual);
        }
    }

    public void mkdirs(String dir) {
        String path;
        StringTokenizer tokens = new StringTokenizer(dir, "/");
        String string = path = dir.startsWith("/") ? "/" : "";
        while (tokens.hasMoreElements()) {
            path = path + (String)tokens.nextElement();
            try {
                this.stat(path);
            }
            catch (IOException ex) {
                try {
                    this.mkdir(path);
                }
                catch (IOException ex2) {
                    // empty catch block
                }
            }
            path = path + "/";
        }
    }

    public String pwd() {
        return this.cwd;
    }

    public List ls() throws IOException {
        return this.ls(this.cwd);
    }

    public List ls(String path) throws IOException {
        String actual = this.resolveRemotePath(path);
        FileAttributes attrs = this.sftp.getAttributes(actual);
        if (!attrs.isDirectory()) {
            throw new IOException(path + " is not a directory");
        }
        SftpFile file = this.sftp.openDirectory(actual);
        Vector children = new Vector();
        while (this.sftp.listChildren(file, children) > -1) {
        }
        file.close();
        return children;
    }

    public void lcd(String path) throws IOException {
        File actual = !SftpClient.isLocalAbsolutePath(path) ? new File(this.lcwd, path) : new File(path);
        if (!actual.isDirectory()) {
            throw new IOException(path + " is not a directory");
        }
        this.lcwd = actual.getCanonicalPath();
    }

    private static boolean isLocalAbsolutePath(String path) {
        return new File(path).isAbsolute();
    }

    public String lpwd() {
        return this.lcwd;
    }

    public FileAttributes get(String path, FileTransferProgress progress) throws IOException, TransferCancelledException {
        String localfile = path.lastIndexOf("/") > -1 ? path.substring(path.lastIndexOf("/") + 1) : path;
        return this.get(path, localfile, progress);
    }

    public FileAttributes get(String path) throws IOException {
        return this.get(path, (FileTransferProgress)null);
    }

    private void transferFile(InputStream in, OutputStream out) throws IOException, TransferCancelledException {
        this.transferFile(in, out, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferFile(InputStream in, OutputStream out, FileTransferProgress progress) throws IOException, TransferCancelledException {
        try {
            int read;
            long bytesSoFar = 0L;
            byte[] buffer = new byte[this.BLOCKSIZE];
            while ((read = in.read(buffer)) > -1) {
                if (progress != null && progress.isCancelled()) {
                    throw new TransferCancelledException();
                }
                if (read <= 0) continue;
                out.write(buffer, 0, read);
                bytesSoFar += (long)read;
                if (progress == null) continue;
                progress.progressed(bytesSoFar);
            }
        }
        finally {
            try {
                in.close();
                out.close();
            }
            catch (IOException ex) {}
        }
    }

    public FileAttributes get(String remote, String local, FileTransferProgress progress) throws IOException, TransferCancelledException {
        File localPath = this.resolveLocalPath(local);
        if (!localPath.exists()) {
            localPath.getParentFile().mkdirs();
            localPath.createNewFile();
        }
        FileOutputStream out = new FileOutputStream(localPath);
        FileAttributes attrs = this.get(remote, out, progress);
        if (this.preserve) {
            this.setLocalAttrs(localPath.getCanonicalPath(), attrs);
        }
        return attrs;
    }

    public void setLocalAttrs(String localPath, FileAttributes attrs) {
        try {
            Date mtime = new Date(attrs.getModifiedTime().longValue() * 1000L);
            Date atime = new Date(attrs.getAccessedTime().longValue() * 1000L);
            Runtime.getRuntime().exec("touch -m -t " + sdf.format(mtime) + " " + localPath).waitFor();
            Runtime.getRuntime().exec("touch -a -t " + sdf.format(atime) + " " + localPath).waitFor();
            String s = attrs.getMaskString();
            Runtime.getRuntime().exec("chmod " + s + " " + localPath).waitFor();
        }
        catch (Exception e) {
            System.err.println("Problem preserving attributes: " + e.getMessage());
        }
    }

    private String run(String cmd) throws IOException, InterruptedException {
        Process p = Runtime.getRuntime().exec(cmd);
        String res = new BufferedReader(new InputStreamReader(p.getInputStream())).readLine();
        p.waitFor();
        return res;
    }

    public void setRemoteAttrs(FileAttributes attrs, String localPath) {
        try {
            String octal = this.run("stat -c %a " + localPath);
            String mtimeS = this.run("stat -c %Y " + localPath);
            String atimeS = this.run("stat -c %X " + localPath);
            long atime = Long.parseLong(atimeS);
            long mtime = Long.parseLong(mtimeS);
            attrs.setPermissionsFromMaskString("0" + octal);
            attrs.setTimes(new UnsignedInteger32(atime), new UnsignedInteger32(mtime));
        }
        catch (Exception e) {
            System.err.println("Problem preserving attributes: " + e.getMessage());
        }
    }

    public FileAttributes setRemoteAttrs2(String localPath) {
        try {
            FileAttributes attrs = new FileAttributes();
            String octal = this.run("stat -c %a " + localPath);
            String mtimeS = this.run("stat -c %Y " + localPath);
            String atimeS = this.run("stat -c %X " + localPath);
            long atime = Long.parseLong(atimeS);
            long mtime = Long.parseLong(mtimeS);
            attrs.setPermissionsFromMaskString("0" + octal);
            attrs.setTimes(new UnsignedInteger32(atime), new UnsignedInteger32(mtime));
            return attrs;
        }
        catch (Exception e) {
            System.err.println("Problem preserving attributes: " + e.getMessage());
            return null;
        }
    }

    public FileAttributes get(String remote, String local) throws IOException {
        return this.get(remote, local, null);
    }

    public FileAttributes get(String remote, OutputStream local, FileTransferProgress progress) throws IOException, TransferCancelledException {
        String remotePath = this.resolveRemotePath(remote);
        FileAttributes attrs = this.stat(remotePath);
        if (progress != null) {
            progress.started(attrs.getSize().longValue(), remotePath);
        }
        SftpFileInputStream in = new SftpFileInputStream(this.sftp.openFile(remotePath, 1));
        this.transferFile(in, local, progress);
        if (progress != null) {
            progress.completed();
        }
        return attrs;
    }

    public FileAttributes get(String remote, OutputStream local) throws IOException {
        return this.get(remote, local, null);
    }

    public boolean isClosed() {
        return this.sftp.isClosed();
    }

    public void put(String local, FileTransferProgress progress) throws IOException, TransferCancelledException {
        File f = new File(local);
        this.put(local, f.getName(), progress);
    }

    public void put(String local) throws IOException {
        this.put(local, (FileTransferProgress)null);
    }

    public void put(String local, String remote, FileTransferProgress progress) throws IOException, TransferCancelledException {
        FileAttributes attrs;
        File localPath = this.resolveLocalPath(local);
        FileInputStream in = new FileInputStream(localPath);
        try {
            attrs = this.stat(remote);
            if (attrs.isDirectory()) {
                File f = new File(local);
                remote = remote + (remote.endsWith("/") ? "" : "/") + f.getName();
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        this.put(in, remote, progress);
        if (this.preserve) {
            attrs = this.stat(remote);
            this.setRemoteAttrs(attrs, localPath.getCanonicalPath());
            this.sftp.setAttributes(remote, attrs);
        }
    }

    public void put(String local, String remote) throws IOException {
        this.put(local, remote, null);
    }

    public void put(InputStream in, String remote, FileTransferProgress progress) throws IOException, TransferCancelledException {
        SftpFileOutputStream out;
        String remotePath = this.resolveRemotePath(remote);
        boolean newfile = false;
        try {
            FileAttributes attrs = this.stat(remotePath);
            out = new SftpFileOutputStream(this.sftp.openFile(remotePath, 26));
        }
        catch (IOException ex) {
            FileAttributes attrs = new FileAttributes();
            newfile = true;
            attrs.setPermissions(new UnsignedInteger32(this.default_permissions ^ this.umask));
            out = new SftpFileOutputStream(this.sftp.openFile(remotePath, 10, attrs));
        }
        if (progress != null) {
            progress.started(in.available(), remotePath);
        }
        this.transferFile(in, out, progress);
        if (progress != null) {
            progress.completed();
        }
        if (newfile) {
            this.chmod(this.default_permissions ^ this.umask, remotePath);
        }
    }

    public void put(InputStream in, String remote) throws IOException {
        this.put(in, remote, null);
    }

    public void chown(int uid, String path) throws IOException {
        String actual = this.resolveRemotePath(path);
        FileAttributes attrs = this.sftp.getAttributes(actual);
        attrs.setUID(new UnsignedInteger32(uid));
        this.sftp.setAttributes(actual, attrs);
    }

    public void chgrp(int gid, String path) throws IOException {
        String actual = this.resolveRemotePath(path);
        FileAttributes attrs = this.sftp.getAttributes(actual);
        attrs.setGID(new UnsignedInteger32(gid));
        this.sftp.setAttributes(actual, attrs);
    }

    public void chmod(int permissions, String path) throws IOException {
        String actual = this.resolveRemotePath(path);
        this.sftp.changePermissions(actual, permissions);
    }

    public void umask(String umask) throws IOException {
        try {
            this.umask = Integer.parseInt(umask, 8);
        }
        catch (NumberFormatException ex) {
            throw new IOException("umask must be 4 digit octal number e.g. 0022");
        }
    }

    public void rename(String oldpath, String newpath) throws IOException {
        String from = this.resolveRemotePath(oldpath);
        String to = this.resolveRemotePath(newpath);
        this.sftp.renameFile(from, to);
    }

    public void rm(String path) throws IOException {
        String actual = this.resolveRemotePath(path);
        FileAttributes attrs = this.sftp.getAttributes(actual);
        if (attrs.isDirectory()) {
            this.sftp.removeDirectory(actual);
        } else {
            this.sftp.removeFile(actual);
        }
    }

    public void rm(String path, boolean force, boolean recurse) throws IOException {
        String actual = this.resolveRemotePath(path);
        FileAttributes attrs = this.sftp.getAttributes(actual);
        if (attrs.isDirectory()) {
            List list = this.ls(path);
            if (!force && list.size() > 0) {
                throw new IOException("You cannot delete non-empty directory, use force=true to overide");
            }
            for (SftpFile file : list) {
                if (file.isDirectory() && !file.getFilename().equals(".") && !file.getFilename().equals("..")) {
                    if (recurse) {
                        this.rm(file.getAbsolutePath(), force, recurse);
                        continue;
                    }
                    throw new IOException("Directory has contents, cannot delete without recurse=true");
                }
                if (!file.isFile()) continue;
                this.sftp.removeFile(file.getAbsolutePath());
            }
            this.sftp.removeDirectory(actual);
        } else {
            this.sftp.removeFile(actual);
        }
    }

    public void symlink(String path, String link) throws IOException {
        String actualPath = this.resolveRemotePath(path);
        String actualLink = this.resolveRemotePath(link);
        this.sftp.createSymbolicLink(actualPath, actualLink);
    }

    public String symlinkTarget(String path) throws IOException {
        String actualPath = this.resolveRemotePath(path);
        return this.sftp.getSymbolicLinkTarget(actualPath);
    }

    public FileAttributes stat(String path) throws IOException {
        String actual = this.resolveRemotePath(path);
        return this.sftp.getAttributes(actual);
    }

    public String getAbsolutePath(String path) throws IOException {
        String actual = this.resolveRemotePath(path);
        return this.sftp.getAbsolutePath(path);
    }

    public void quit() throws IOException {
        this.sftp.close();
    }

    public DirectoryOperation copyLocalDirectory(String localdir, String remotedir, boolean recurse, boolean sync, boolean commit, FileTransferProgress progress) throws IOException {
        FileAttributes attrs;
        File f;
        File[] ls;
        DirectoryOperation op = new DirectoryOperation();
        File local = this.resolveLocalPath(localdir);
        remotedir = this.resolveRemotePath(remotedir);
        remotedir = remotedir + (remotedir.endsWith("/") ? "" : "/");
        remotedir = remotedir + local.getName();
        remotedir = remotedir + (remotedir.endsWith("/") ? "" : "/");
        if (commit) {
            try {
                FileAttributes attrs2 = this.stat(remotedir);
            }
            catch (IOException ex) {
                this.mkdir(remotedir);
            }
        }
        if ((ls = local.listFiles()) != null) {
            for (int i = 0; i < ls.length; ++i) {
                boolean copy = false;
                if (ls[i].isDirectory() && !ls[i].getName().equals(".") && !ls[i].getName().equals("..")) {
                    if (!recurse) continue;
                    f = new File(local, ls[i].getName());
                    op.addDirectoryOperation(this.copyLocalDirectory(f.getAbsolutePath(), remotedir, recurse, sync, commit, progress), f);
                    continue;
                }
                if (!ls[i].isFile()) continue;
                try {
                    FileAttributes attrs3 = this.stat(remotedir + ls[i].getName());
                    if (ls[i].length() == attrs3.getSize().longValue() && ls[i].lastModified() / 1000L == attrs3.getModifiedTime().longValue()) {
                        op.addUnchangedFile(ls[i]);
                    } else {
                        op.addUpdatedFile(ls[i]);
                        copy = true;
                    }
                }
                catch (IOException ex1) {
                    op.addNewFile(ls[i]);
                    copy = true;
                }
                if (!commit || !copy) continue;
                this.put(ls[i].getAbsolutePath(), remotedir + ls[i].getName(), progress);
            }
        }
        if (sync) {
            try {
                List files = this.ls(remotedir);
                for (SftpFile file : files) {
                    f = new File(local, file.getFilename());
                    if (op.containsFile(file) || file.getFilename().equals(".") || file.getFilename().equals("..")) continue;
                    op.addDeletedFile(file);
                    if (!commit) continue;
                    if (file.isDirectory()) {
                        this.recurseMarkForDeletion(file, op);
                        if (!commit) continue;
                        this.rm(file.getAbsolutePath(), true, true);
                        continue;
                    }
                    if (!file.isFile()) continue;
                    this.rm(file.getAbsolutePath());
                }
            }
            catch (IOException ex2) {
                // empty catch block
            }
        }
        if (this.preserve && commit && (attrs = this.setRemoteAttrs2(local.getCanonicalPath())) != null) {
            this.sftp.setAttributes(remotedir, attrs);
        }
        return op;
    }

    public void addEventListener(ChannelEventListener eventListener) {
        this.sftp.addEventListener(eventListener);
    }

    private void recurseMarkForDeletion(SftpFile file2, DirectoryOperation op) throws IOException {
        List list = this.ls(file2.getAbsolutePath());
        op.addDeletedFile(file2);
        for (SftpFile file2 : list) {
            if (file2.isDirectory() && !file2.getFilename().equals(".") && !file2.getFilename().equals("..")) {
                this.recurseMarkForDeletion(file2, op);
                continue;
            }
            if (!file2.isFile()) continue;
            op.addDeletedFile(file2);
        }
    }

    private void recurseMarkForDeletion(File file, DirectoryOperation op) throws IOException {
        File[] list = file.listFiles();
        op.addDeletedFile(file);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                file = list[i];
                if (file.isDirectory() && !file.getName().equals(".") && !file.getName().equals("..")) {
                    this.recurseMarkForDeletion(file, op);
                    continue;
                }
                if (!file.isFile()) continue;
                op.addDeletedFile(file);
            }
        }
    }

    public DirectoryOperation copyRemoteDirectory(String remotedir, String localdir, boolean recurse, boolean sync, boolean commit, FileTransferProgress progress) throws IOException {
        File[] contents;
        File local;
        String actual;
        DirectoryOperation op = new DirectoryOperation();
        if (remotedir.equals("")) {
            actual = this.sftp.getDefaultDirectory();
        } else {
            actual = this.resolveRemotePath(remotedir);
            actual = this.sftp.getAbsolutePath(actual);
        }
        FileAttributes attr = this.sftp.getAttributes(actual);
        if (!attr.isDirectory()) {
            throw new IOException(remotedir + " is not a directory");
        }
        String cwd = actual;
        String base = remotedir;
        int idx = base.lastIndexOf(47);
        if (idx != -1) {
            base = base.substring(idx + 1);
        }
        if (!(local = new File(localdir, base)).isAbsolute()) {
            local = new File(this.lpwd(), localdir);
        }
        if (!local.exists() && commit) {
            local.mkdir();
        }
        if (commit && this.preserve) {
            this.setLocalAttrs(local.getCanonicalPath(), attr);
        }
        List files = this.ls(cwd);
        for (SftpFile file : files) {
            File f;
            if (file.isDirectory() && !file.getFilename().equals(".") && !file.getFilename().equals("..")) {
                if (!recurse) continue;
                f = new File(local, file.getFilename());
                op.addDirectoryOperation(this.copyRemoteDirectory(file.getAbsolutePath(), local.getAbsolutePath(), recurse, sync, commit, progress), f);
                continue;
            }
            if (!file.isFile()) continue;
            f = new File(local, file.getFilename());
            if (f.exists() && f.length() == file.getAttributes().getSize().longValue() && f.lastModified() / 1000L == file.getAttributes().getModifiedTime().longValue()) {
                if (commit) {
                    op.addUnchangedFile(f);
                    continue;
                }
                op.addUnchangedFile(file);
                continue;
            }
            if (f.exists()) {
                if (commit) {
                    op.addUpdatedFile(f);
                } else {
                    op.addUpdatedFile(file);
                }
            } else if (commit) {
                op.addNewFile(f);
            } else {
                op.addNewFile(file);
            }
            if (!commit) continue;
            FileAttributes attrs = this.get(file.getAbsolutePath(), f.getAbsolutePath(), progress);
        }
        if (sync && (contents = local.listFiles()) != null) {
            for (int i = 0; i < contents.length; ++i) {
                if (op.containsFile(contents[i])) continue;
                op.addDeletedFile(contents[i]);
                if (contents[i].isDirectory() && !contents[i].getName().equals(".") && !contents[i].getName().equals("..")) {
                    this.recurseMarkForDeletion(contents[i], op);
                    if (!commit) continue;
                    IOUtil.recurseDeleteDirectory(contents[i]);
                    continue;
                }
                if (!commit) continue;
                contents[i].delete();
            }
        }
        return op;
    }
}

