/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.authentication;

import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.j2ssh.authentication.AuthenticationProtocolClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthRequest;
import com.sshtools.j2ssh.authentication.SshMsgUserauthGssapiError;
import com.sshtools.j2ssh.authentication.SshMsgUserauthGssapiErrtok;
import com.sshtools.j2ssh.authentication.SshMsgUserauthGssapiMIC;
import com.sshtools.j2ssh.authentication.SshMsgUserauthGssapiResponse;
import com.sshtools.j2ssh.authentication.SshMsgUserauthGssapiToken;
import com.sshtools.j2ssh.authentication.TerminatedStateException;
import com.sshtools.j2ssh.authentication.UserGridCredential;
import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.io.UnsignedInteger32;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.GlobusGSSManagerImpl;
import org.globus.gsi.gssapi.auth.HostAuthorization;
import org.gridforum.jgss.ExtendedGSSContext;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class GSSAuthenticationClient
extends SshAuthenticationClient {
    private String ukcaCert = "01621954.0";
    private String ukcaSigningPolicy = "01621954.signing_policy";
    private static Log log = LogFactory.getLog(GSSAuthenticationClient.class);

    @Override
    public final String getMethodName() {
        return "gssapi-with-mic";
    }

    @Override
    public void reset() {
    }

    @Override
    public void authenticate(AuthenticationProtocolClient authenticationprotocolclient, String s) throws IOException, TerminatedStateException {
        try {
            GSSCredential gsscredential = UserGridCredential.getUserCredential(this.properties);
            log.debug("Registering gss-ssh return messages.");
            authenticationprotocolclient.registerMessage(SshMsgUserauthGssapiResponse.class, 60);
            authenticationprotocolclient.registerMessage(SshMsgUserauthGssapiToken.class, 61);
            authenticationprotocolclient.registerMessage(SshMsgUserauthGssapiError.class, 64);
            authenticationprotocolclient.registerMessage(SshMsgUserauthGssapiErrtok.class, 65);
            log.debug("Sending gssapi user auth request.");
            ByteArrayWriter bytearraywriter = new ByteArrayWriter();
            bytearraywriter.writeUINT32(new UnsignedInteger32(1L));
            byte[] abyte0 = GSSConstants.MECH_OID.getDER();
            bytearraywriter.writeBinaryString(abyte0);
            SshMsgUserAuthRequest sshmsguserauthrequest = new SshMsgUserAuthRequest(this.getUsername(), s, "gssapi-with-mic", bytearraywriter.toByteArray());
            authenticationprotocolclient.sendMessage(sshmsguserauthrequest);
            log.debug("Receiving user auth response.");
            SshMsgUserauthGssapiResponse sshmsguserauthgssapiresponse = (SshMsgUserauthGssapiResponse)authenticationprotocolclient.readMessage(60);
            ByteArrayReader bytearrayreader = new ByteArrayReader(sshmsguserauthgssapiresponse.getRequestData());
            byte[] abyte1 = bytearrayreader.readBinaryString();
            log.debug("Mechanism requested: " + GSSConstants.MECH_OID);
            log.debug("Mechanism selected: " + new Oid(abyte1));
            log.debug("Verify that selected mechanism is GSSAPI.");
            if (!GSSConstants.MECH_OID.equals(new Oid(abyte1))) {
                log.debug("Mechanism do not match!");
                throw new IOException("Mechanism do not match!");
            }
            log.debug("Creating GSS context base on grid credentials.");
            GlobusGSSManagerImpl globusgssmanagerimpl = new GlobusGSSManagerImpl();
            HostAuthorization gssAuth = new HostAuthorization(null);
            GSSName targetName = gssAuth.getExpectedName(null, this.hostname);
            GSSContext gsscontext = globusgssmanagerimpl.createContext(targetName, new Oid(abyte1), gsscredential, 0);
            gsscontext.requestCredDeleg(true);
            gsscontext.requestMutualAuth(true);
            gsscontext.requestReplayDet(true);
            gsscontext.requestSequenceDet(true);
            gsscontext.requestConf(false);
            gsscontext.requestInteg(true);
            Integer type = GSIConstants.DELEGATION_TYPE_LIMITED;
            String cur = "None";
            if (this.properties instanceof SshToolsConnectionProfile) {
                cur = ((SshToolsConnectionProfile)this.properties).getApplicationProperty("sshterm.delegationType", "Full");
                if (cur.equals("full")) {
                    type = GSIConstants.DELEGATION_TYPE_FULL;
                } else if (cur.equals("limited")) {
                    type = GSIConstants.DELEGATION_TYPE_LIMITED;
                } else if (cur.equals("none")) {
                    type = GSIConstants.DELEGATION_TYPE_LIMITED;
                    gsscontext.requestCredDeleg(false);
                }
                log.debug("Enabling delegation setting: " + cur);
            }
            ((ExtendedGSSContext)gsscontext).setOption(GSSConstants.DELEGATION_TYPE, type);
            log.debug("Starting GSS token exchange.");
            byte[] abyte2 = new byte[]{};
            Object obj = null;
            while (!gsscontext.isEstablished()) {
                byte[] abyte3 = gsscontext.initSecContext(abyte2, 0, abyte2.length);
                if (abyte3 != null) {
                    ByteArrayWriter bytearraywriter1 = new ByteArrayWriter();
                    bytearraywriter1.writeBinaryString(abyte3);
                    SshMsgUserauthGssapiToken sshmsguserauthgssapitoken = new SshMsgUserauthGssapiToken(bytearraywriter1.toByteArray());
                    authenticationprotocolclient.sendMessage(sshmsguserauthgssapitoken);
                }
                if (gsscontext.isEstablished()) continue;
                SshMsgUserauthGssapiToken sshmsguserauthgssapitoken1 = (SshMsgUserauthGssapiToken)authenticationprotocolclient.readMessage(61);
                ByteArrayReader bytearrayreader1 = new ByteArrayReader(sshmsguserauthgssapitoken1.getRequestData());
                abyte2 = bytearrayreader1.readBinaryString();
            }
            ByteArrayWriter baw = new ByteArrayWriter();
            baw.writeBinaryString(authenticationprotocolclient.getSessionIdentifier());
            baw.write(50);
            baw.writeString(this.getUsername());
            baw.writeString(s);
            baw.writeString("gssapi-with-mic");
            log.debug("Sending gssapi MIC.");
            SshMsgUserauthGssapiMIC micMsg = new SshMsgUserauthGssapiMIC(gsscontext.getMIC(baw.toByteArray(), 0, baw.toByteArray().length, null));
            authenticationprotocolclient.sendMessage(micMsg);
            log.debug("Context established.");
            log.debug("Initiator : " + gsscontext.getSrcName());
            log.debug("Acceptor  : " + gsscontext.getTargName());
            log.debug("Lifetime  : " + gsscontext.getLifetime());
            log.debug("Privacy   : " + gsscontext.getConfState());
            log.debug("Anonymity : " + gsscontext.getAnonymityState());
            log.debug("Integrity : " + gsscontext.getIntegState());
        }
        catch (GSSException gssexception) {
            gssexception.printStackTrace();
            StringWriter stringwriter = new StringWriter();
            gssexception.printStackTrace(new PrintWriter(stringwriter));
            log.debug(stringwriter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Properties getPersistableProperties() {
        Properties properties = new Properties();
        return properties;
    }

    @Override
    public void setPersistableProperties(Properties properties) {
    }

    @Override
    public boolean canAuthenticate() {
        return true;
    }
}

