/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.authentication;

import com.sshtools.j2ssh.authentication.AuthenticationProtocolClient;
import com.sshtools.j2ssh.authentication.AuthenticationProtocolException;
import com.sshtools.j2ssh.authentication.PasswordChangePrompt;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthPwdChangeReq;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthRequest;
import com.sshtools.j2ssh.authentication.TerminatedStateException;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PasswordAuthenticationClient
extends SshAuthenticationClient {
    private static Log log = LogFactory.getLog(PasswordAuthenticationClient.class);
    private PasswordChangePrompt changePrompt = null;
    protected String password = null;

    @Override
    public final String getMethodName() {
        return "password";
    }

    public final void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void reset() {
        this.password = null;
    }

    public void setPasswordChangePrompt(PasswordChangePrompt changePrompt) {
        this.changePrompt = changePrompt;
    }

    @Override
    public void authenticate(AuthenticationProtocolClient authentication, String serviceToStart) throws IOException, TerminatedStateException {
        String newpassword;
        if (this.getUsername() == null || this.password == null) {
            throw new AuthenticationProtocolException("Username and password cannot be null!");
        }
        authentication.registerMessage(SshMsgUserAuthPwdChangeReq.class, 60);
        ByteArrayWriter baw = new ByteArrayWriter();
        baw.write(0);
        baw.writeString(this.password);
        SshMsgUserAuthRequest msg = new SshMsgUserAuthRequest(this.getUsername(), serviceToStart, "password", baw.toByteArray());
        authentication.sendMessage(msg);
        SshMsgUserAuthPwdChangeReq pwd = (SshMsgUserAuthPwdChangeReq)authentication.readMessage(60);
        if (this.changePrompt != null) {
            newpassword = this.changePrompt.changePassword(pwd.getPrompt());
            if (newpassword == null) {
                throw new TerminatedStateException(2);
            }
        } else {
            throw new TerminatedStateException(2);
        }
        log.debug("Setting new password");
        baw = new ByteArrayWriter();
        baw.write(1);
        baw.writeString(this.password);
        baw.writeString(newpassword);
        msg = new SshMsgUserAuthRequest(this.getUsername(), serviceToStart, "password", baw.toByteArray());
        authentication.sendMessage(msg);
    }

    @Override
    public Properties getPersistableProperties() {
        Properties properties = new Properties();
        if (this.getUsername() != null) {
            properties.setProperty("Username", this.getUsername());
        }
        return properties;
    }

    @Override
    public void setPersistableProperties(Properties properties) {
        this.setUsername(properties.getProperty("Username"));
        if (properties.getProperty("Password") != null) {
            this.setPassword(properties.getProperty("Password"));
        }
    }

    @Override
    public boolean canAuthenticate() {
        return this.getUsername() != null && this.password != null;
    }
}

