/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.forwarding;

import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelEventListener;
import com.sshtools.j2ssh.forwarding.ForwardingBindingChannel;
import com.sshtools.j2ssh.forwarding.ForwardingChannel;
import com.sshtools.j2ssh.forwarding.ForwardingConfigurationException;
import com.sshtools.j2ssh.forwarding.ForwardingConfigurationListener;
import com.sshtools.j2ssh.forwarding.ForwardingIOChannel;
import com.sshtools.j2ssh.forwarding.ForwardingSocketChannel;
import com.sshtools.j2ssh.forwarding.ForwardingSocketX11Channel;
import com.sshtools.j2ssh.forwarding.ForwardingUNIXSocketChannel;
import com.sshtools.j2ssh.forwarding.ForwardingUNIXSocketX11Channel;
import com.sshtools.j2ssh.util.StartStopState;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ForwardingConfiguration {
    private static Log log = LogFactory.getLog(ForwardingConfiguration.class);
    protected StartStopState state = new StartStopState(2);
    protected String addressToBind;
    protected String hostToConnect;
    protected String name;
    protected int portToBind;
    protected int portToConnect;
    protected ForwardingConfigurationMonitor monitor = new ForwardingConfigurationMonitor();
    protected EventListenerList listenerList = new EventListenerList();
    private List activeForwardings = new Vector();

    public ForwardingConfiguration(String name, String addressToBind, int portToBind, String hostToConnect, int portToConnect) {
        this.addressToBind = addressToBind;
        this.portToBind = portToBind;
        this.name = name;
        this.hostToConnect = hostToConnect;
        this.portToConnect = portToConnect;
    }

    public ForwardingConfiguration(String addressToBind, int portToBind) {
        this(addressToBind + ":" + String.valueOf(portToBind), addressToBind, portToBind, "[Specified by connecting computer]", -1);
    }

    public void addForwardingConfigurationListener(ForwardingConfigurationListener l) {
        this.listenerList.add(ForwardingConfigurationListener.class, l);
    }

    public void removeForwardingConfigurationListener(ForwardingConfigurationListener l) {
        this.listenerList.remove(ForwardingConfigurationListener.class, l);
    }

    public List getActiveForwardingSocketChannels() {
        return this.activeForwardings;
    }

    public boolean isForwarding() {
        return this.state.getValue() == 1;
    }

    public String getAddressToBind() {
        return this.addressToBind;
    }

    public String getHostToConnect() {
        return this.hostToConnect;
    }

    public String getName() {
        return this.name;
    }

    public int getPortToBind() {
        return this.portToBind;
    }

    public int getPortToConnect() {
        return this.portToConnect;
    }

    public StartStopState getState() {
        return this.state;
    }

    public void start() throws IOException {
        this.state.setValue(1);
    }

    public void stop() {
        this.state.setValue(2);
    }

    public ForwardingSocketChannel createForwardingSocketChannel(String type, String hostToConnect, int portToConnect, String originatingHost, int originatingPort) throws ForwardingConfigurationException {
        if (this.state.getValue() == 2) {
            throw new ForwardingConfigurationException("The forwarding has been stopped");
        }
        if (!(type.equals("direct-tcpip") || type.equals("forwarded-tcpip") || type.equals("x11"))) {
            throw new ForwardingConfigurationException("The channel type must either be ForwardingSocketChannel.LOCAL_FORWARDING_CHANNEL_TYPE or ForwardingSocketChannel.REMOTE_FORWARDING_CHANNEL_TYPE");
        }
        ForwardingSocketChannel channel = type.equals("direct-tcpip") ? new ForwardingSocketChannel(type, this.name, hostToConnect, portToConnect, originatingHost, originatingPort) : new ForwardingSocketChannel(type, this.name, this.getAddressToBind(), this.getPortToBind(), originatingHost, originatingPort);
        channel.addEventListener(this.monitor);
        return channel;
    }

    public ForwardingSocketX11Channel createForwardingSocketX11Channel(String type, String hostToConnect, int portToConnect, String originatingHost, int originatingPort, String authType, String fakeAuthData, String realAuthData) throws ForwardingConfigurationException {
        if (this.state.getValue() == 2) {
            throw new ForwardingConfigurationException("The forwarding has been stopped");
        }
        if (!(type.equals("direct-tcpip") || type.equals("forwarded-tcpip") || type.equals("x11"))) {
            throw new ForwardingConfigurationException("The channel type must either be ForwardingSocketChannel.LOCAL_FORWARDING_CHANNEL_TYPE or ForwardingSocketChannel.REMOTE_FORWARDING_CHANNEL_TYPE");
        }
        ForwardingSocketX11Channel channel = type.equals("direct-tcpip") ? new ForwardingSocketX11Channel(type, this.name, hostToConnect, portToConnect, originatingHost, originatingPort, authType, fakeAuthData, realAuthData) : new ForwardingSocketX11Channel(type, this.name, this.getAddressToBind(), this.getPortToBind(), originatingHost, originatingPort, authType, fakeAuthData, realAuthData);
        channel.addEventListener(this.monitor);
        return channel;
    }

    public ForwardingUNIXSocketChannel createForwardingUNIXSocketChannel(String type, String hostToConnect, int portToConnect, String originatingHost, int originatingPort) throws ForwardingConfigurationException {
        if (this.state.getValue() == 2) {
            throw new ForwardingConfigurationException("The forwarding has been stopped");
        }
        if (!(type.equals("direct-tcpip") || type.equals("forwarded-tcpip") || type.equals("x11"))) {
            throw new ForwardingConfigurationException("The channel type must either be ForwardingSocketChannel.LOCAL_FORWARDING_CHANNEL_TYPE or ForwardingSocketChannel.REMOTE_FORWARDING_CHANNEL_TYPE");
        }
        ForwardingUNIXSocketChannel channel = type.equals("direct-tcpip") ? new ForwardingUNIXSocketChannel(type, this.name, hostToConnect, portToConnect, originatingHost, originatingPort) : new ForwardingUNIXSocketChannel(type, this.name, this.getAddressToBind(), this.getPortToBind(), originatingHost, originatingPort);
        channel.addEventListener(this.monitor);
        return channel;
    }

    public ForwardingUNIXSocketX11Channel createForwardingUNIXSocketX11Channel(String type, String hostToConnect, int portToConnect, String originatingHost, int originatingPort, String authType, String fakeAuthData, String realAuthData) throws ForwardingConfigurationException {
        if (this.state.getValue() == 2) {
            throw new ForwardingConfigurationException("The forwarding has been stopped");
        }
        if (!(type.equals("direct-tcpip") || type.equals("forwarded-tcpip") || type.equals("x11"))) {
            throw new ForwardingConfigurationException("The channel type must either be ForwardingSocketChannel.LOCAL_FORWARDING_CHANNEL_TYPE or ForwardingSocketChannel.REMOTE_FORWARDING_CHANNEL_TYPE");
        }
        ForwardingUNIXSocketX11Channel channel = type.equals("direct-tcpip") ? new ForwardingUNIXSocketX11Channel(type, this.name, hostToConnect, portToConnect, originatingHost, originatingPort, authType, fakeAuthData, realAuthData) : new ForwardingUNIXSocketX11Channel(type, this.name, this.getAddressToBind(), this.getPortToBind(), originatingHost, originatingPort, authType, fakeAuthData, realAuthData);
        channel.addEventListener(this.monitor);
        return channel;
    }

    public ForwardingIOChannel createForwardingIOChannel(String type, String hostToConnect, int portToConnect, String originatingHost, int originatingPort) throws ForwardingConfigurationException {
        if (this.state.getValue() == 2) {
            throw new ForwardingConfigurationException("The forwarding has been stopped");
        }
        if (!(type.equals("direct-tcpip") || type.equals("forwarded-tcpip") || type.equals("x11"))) {
            throw new ForwardingConfigurationException("The channel type must either be ForwardingSocketChannel.LOCAL_FORWARDING_CHANNEL_TYPE or ForwardingSocketChannel.REMOTE_FORWARDING_CHANNEL_TYPE");
        }
        ForwardingIOChannel channel = type.equals("direct-tcpip") ? new ForwardingIOChannel(type, this.name, this.getHostToConnect(), this.getPortToConnect(), originatingHost, originatingPort) : new ForwardingIOChannel(type, this.name, this.getAddressToBind(), this.getPortToBind(), originatingHost, originatingPort);
        channel.addEventListener(this.monitor);
        return channel;
    }

    public ForwardingBindingChannel createForwardingBindingChannel(String type, String hostToConnect, int portToConnect, String originatingHost, int originatingPort) throws ForwardingConfigurationException {
        if (this.state.getValue() == 2) {
            throw new ForwardingConfigurationException("The forwarding has been stopped");
        }
        if (!(type.equals("direct-tcpip") || type.equals("forwarded-tcpip") || type.equals("x11"))) {
            throw new ForwardingConfigurationException("The channel type must either be ForwardingSocketChannel.LOCAL_FORWARDING_CHANNEL_TYPE or ForwardingSocketChannel.REMOTE_FORWARDING_CHANNEL_TYPE");
        }
        ForwardingBindingChannel channel = type.equals("direct-tcpip") ? new ForwardingBindingChannel(type, this.name, this.getHostToConnect(), this.getPortToConnect(), originatingHost, originatingPort) : new ForwardingBindingChannel(type, this.name, this.getAddressToBind(), this.getPortToBind(), originatingHost, originatingPort);
        channel.addEventListener(this.monitor);
        return channel;
    }

    public class ForwardingConfigurationMonitor
    implements ChannelEventListener {
        @Override
        public void onChannelOpen(Channel channel) {
            if (log.isDebugEnabled()) {
                ForwardingChannel fch = (ForwardingChannel)((Object)channel);
                log.debug("Opening forwarding channel from " + fch.getOriginatingHost() + ":" + String.valueOf(fch.getOriginatingPort()));
            }
            ForwardingConfiguration.this.activeForwardings.add(channel);
            ForwardingConfigurationListener[] l = (ForwardingConfigurationListener[])ForwardingConfiguration.this.listenerList.getListeners(ForwardingConfigurationListener.class);
            for (int i = l.length - 1; i >= 0; --i) {
                l[i].opened(ForwardingConfiguration.this, (ForwardingSocketChannel)channel);
            }
        }

        @Override
        public void onChannelEOF(Channel channel) {
        }

        @Override
        public void onChannelClose(Channel channel) {
            if (log.isDebugEnabled()) {
                ForwardingChannel fch = (ForwardingChannel)((Object)channel);
                log.debug("Closing forwarding channel from " + fch.getOriginatingHost() + ":" + String.valueOf(fch.getOriginatingPort()));
            }
            ForwardingConfiguration.this.activeForwardings.remove(channel);
            ForwardingConfigurationListener[] l = (ForwardingConfigurationListener[])ForwardingConfiguration.this.listenerList.getListeners(ForwardingConfigurationListener.class);
            for (int i = l.length - 1; i >= 0; --i) {
                l[i].closed(ForwardingConfiguration.this, (ForwardingSocketChannel)channel);
            }
        }

        @Override
        public void onDataReceived(Channel channel, byte[] data) {
            ForwardingConfigurationListener[] l = (ForwardingConfigurationListener[])ForwardingConfiguration.this.listenerList.getListeners(ForwardingConfigurationListener.class);
            for (int i = l.length - 1; i >= 0; --i) {
                l[i].dataReceived(ForwardingConfiguration.this, (ForwardingSocketChannel)channel, data.length);
            }
        }

        @Override
        public void onDataSent(Channel channel, byte[] data) {
            ForwardingConfigurationListener[] l = (ForwardingConfigurationListener[])ForwardingConfiguration.this.listenerList.getListeners(ForwardingConfigurationListener.class);
            for (int i = l.length - 1; i >= 0; --i) {
                l[i].dataSent(ForwardingConfiguration.this, (ForwardingSocketChannel)channel, data.length);
            }
        }
    }
}

