/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.sftp;

import com.sshtools.j2ssh.io.UnsignedInteger64;
import com.sshtools.j2ssh.sftp.SftpFile;
import java.io.IOException;
import java.io.InputStream;

public class SftpFileInputStream
extends InputStream {
    SftpFile file;
    UnsignedInteger64 position = new UnsignedInteger64("0");

    public SftpFileInputStream(SftpFile file) throws IOException {
        if (file.getHandle() == null) {
            throw new IOException("The file does not have a valid handle!");
        }
        if (file.getSFTPSubsystem() == null) {
            throw new IOException("The file is not attached to an SFTP subsystem!");
        }
        this.file = file;
    }

    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        int read = this.file.getSFTPSubsystem().readFile(this.file.getHandle(), this.position, buffer, offset, len);
        if (read > 0) {
            this.position = UnsignedInteger64.add(this.position, read);
        }
        return read;
    }

    @Override
    public int read() throws IOException {
        byte[] buffer = new byte[1];
        int read = this.file.getSFTPSubsystem().readFile(this.file.getHandle(), this.position, buffer, 0, 1);
        this.position = UnsignedInteger64.add(this.position, read);
        return buffer[0] & 0xFF;
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    protected void finalize() throws IOException {
        if (this.file.getHandle() != null) {
            this.close();
        }
    }
}

