/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.sftp;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.sftp.FileAttributes;
import com.sshtools.j2ssh.sftp.MessageRequestId;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import java.io.IOException;

public class SshFxpFSetStat
extends SubsystemMessage
implements MessageRequestId {
    public static final int SSH_FXP_FSETSTAT = 10;
    private UnsignedInteger32 id;
    private byte[] handle;
    private FileAttributes attrs;

    public SshFxpFSetStat() {
        super(10);
    }

    public SshFxpFSetStat(UnsignedInteger32 id, byte[] handle, FileAttributes attrs) {
        super(10);
        this.id = id;
        this.handle = handle;
        this.attrs = attrs;
    }

    @Override
    public UnsignedInteger32 getId() {
        return this.id;
    }

    public byte[] getHandle() {
        return this.handle;
    }

    public FileAttributes getAttributes() {
        return this.attrs;
    }

    @Override
    public void constructMessage(ByteArrayReader bar) throws IOException, InvalidMessageException {
        this.id = bar.readUINT32();
        this.handle = bar.readBinaryString();
        this.attrs = new FileAttributes(bar);
    }

    @Override
    public String getMessageName() {
        return "SSH_FXP_FSETSTAT";
    }

    @Override
    public void constructByteArray(ByteArrayWriter baw) throws IOException, InvalidMessageException {
        baw.writeUINT32(this.id);
        baw.writeBinaryString(this.handle);
        baw.write(this.attrs.toByteArray());
    }
}

