/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey.rsa;

import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshKeyPair;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import com.sshtools.j2ssh.transport.publickey.rsa.SshRsaPrivateKey;
import com.sshtools.j2ssh.transport.publickey.rsa.SshRsaPublicKey;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public class SshRsaKeyPair
extends SshKeyPair {
    private RSAPrivateKey prvKey;
    private RSAPublicKey pubKey;

    @Override
    public SshPrivateKey decodePrivateKey(byte[] encoded) throws InvalidSshKeyException {
        return new SshRsaPrivateKey(encoded);
    }

    @Override
    public SshPublicKey decodePublicKey(byte[] encoded) throws InvalidSshKeyException {
        return new SshRsaPublicKey(encoded);
    }

    @Override
    public void generate(int bits) {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(bits, ConfigurationLoader.getRND());
            KeyPair pair = keyGen.generateKeyPair();
            this.setPrivateKey(new SshRsaPrivateKey((RSAPrivateKey)pair.getPrivate(), (RSAPublicKey)pair.getPublic()));
        }
        catch (NoSuchAlgorithmException nsae) {
            this.prvKey = null;
            this.pubKey = null;
        }
    }
}

