/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.shift;

import com.sshtools.shift.DirectoryListingTableModel;
import java.awt.Component;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class FileSizeTableCellRenderer
extends DefaultTableCellRenderer {
    private static final NumberFormat KB_FILE_SIZE_FORMAT = new DecimalFormat();
    private static final NumberFormat MB_FILE_SIZE_FORMAT = new DecimalFormat();

    public FileSizeTableCellRenderer() {
        this.setHorizontalAlignment(4);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        long size = ((DirectoryListingTableModel)table.getModel()).getFileSize(row);
        this.setText(FileSizeTableCellRenderer.formatFileSize(size));
        return this;
    }

    public static String formatFileSize(long size) {
        double bytes = size;
        if (bytes < 1024.0) {
            return String.valueOf((int)bytes) + " bytes";
        }
        if (bytes < 1048576.0) {
            return KB_FILE_SIZE_FORMAT.format(bytes / 1024.0) + " KB";
        }
        return MB_FILE_SIZE_FORMAT.format(bytes / 1024.0 / 1024.0) + " MB";
    }

    static {
        KB_FILE_SIZE_FORMAT.setMinimumFractionDigits(0);
        KB_FILE_SIZE_FORMAT.setMaximumFractionDigits(0);
        MB_FILE_SIZE_FORMAT.setMinimumFractionDigits(0);
        MB_FILE_SIZE_FORMAT.setMaximumFractionDigits(2);
    }
}

