/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.shift;

import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.j2ssh.SftpClient;
import com.sshtools.j2ssh.sftp.FileAttributes;
import com.sshtools.shift.DirectoryListingTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class PropertiesDialog
extends JDialog {
    private static final NumberFormat KB_FILE_SIZE_FORMAT = new DecimalFormat();
    private static final NumberFormat MB_FILE_SIZE_FORMAT = new DecimalFormat();
    JTabbedPane jTabbedPane1 = new JTabbedPane();
    JPanel mainpanel = new JPanel();
    JPanel headerPanel = new JPanel();
    JPanel navigate = new JPanel();
    BorderLayout b = new BorderLayout();
    JButton ok = new JButton("OK");
    JButton cancel = new JButton("Cancel");
    JCheckBox ownerRead = new JCheckBox("Read");
    JCheckBox ownerWrite = new JCheckBox("Write");
    JCheckBox ownerExec = new JCheckBox("Exec");
    JCheckBox groupRead = new JCheckBox("Read");
    JCheckBox groupWrite = new JCheckBox("Write");
    JCheckBox groupExec = new JCheckBox("Exec");
    JCheckBox otherRead = new JCheckBox("Read");
    JCheckBox otherWrite = new JCheckBox("Write");
    JCheckBox otherExec = new JCheckBox("Exec");
    JPanel paneldesc = new JPanel();
    JPanel panelone = new JPanel();
    JPanel paneltwo = new JPanel();
    JPanel panelthree = new JPanel();
    JTextField filename = new JTextField();
    JTextField size = new JTextField();
    JTextField location = new JTextField();
    JTextField kind = new JTextField();
    JTextField owner = new JTextField();
    JTextField group = new JTextField();
    JTextField modified = new JTextField();
    JLabel iconLabel = new JLabel();
    JPanel permissions = new JPanel();
    DirectoryListingTableModel model;
    FileAttributes attrib;
    String locationStr;
    String fileName;
    boolean editable;
    private SftpClient sftp;

    public PropertiesDialog(FileAttributes attrib, SftpClient sftp, String fileName, DirectoryListingTableModel model) {
        try {
            this.attrib = attrib;
            this.fileName = fileName;
            this.sftp = sftp;
            this.locationStr = sftp.pwd();
            this.model = model;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.b.setHgap(10);
        this.setModal(true);
        this.getContentPane().setLayout(this.b);
        this.getContentPane().add((Component)this.jTabbedPane1, "Center");
        ResourceIcon fileIcon = new ResourceIcon(PropertiesDialog.class, "largefile.png");
        this.iconLabel.setIcon(fileIcon);
        this.headerPanel.setLayout(new BorderLayout());
        this.mainpanel.setLayout(new GridBagLayout());
        this.jTabbedPane1.addTab("Properties", this.mainpanel);
        Insets ins = new Insets(2, 30, 2, 10);
        Insets ins2 = new Insets(2, 7, 2, 30);
        this.filename.setBorder(BorderFactory.createLoweredBevelBorder());
        this.size.setBorder(BorderFactory.createLoweredBevelBorder());
        this.location.setBorder(BorderFactory.createLoweredBevelBorder());
        this.kind.setBorder(BorderFactory.createLoweredBevelBorder());
        this.owner.setBorder(BorderFactory.createLoweredBevelBorder());
        this.group.setBorder(BorderFactory.createLoweredBevelBorder());
        this.modified.setBorder(BorderFactory.createLoweredBevelBorder());
        this.paneldesc.setLayout(new GridLayout(3, 1));
        this.paneldesc.add(new JLabel("Owner"));
        this.paneldesc.add(new JLabel("Group"));
        this.paneldesc.add(new JLabel("Others"));
        this.panelone.setLayout(new GridLayout(3, 1));
        this.panelone.add(this.ownerRead);
        this.panelone.add(this.groupRead);
        this.panelone.add(this.otherRead);
        this.paneltwo.setLayout(new GridLayout(3, 1));
        this.paneltwo.add(this.ownerWrite);
        this.paneltwo.add(this.groupWrite);
        this.paneltwo.add(this.otherWrite);
        this.panelthree.setLayout(new GridLayout(3, 1));
        this.panelthree.add(this.ownerExec);
        this.panelthree.add(this.groupExec);
        this.panelthree.add(this.otherExec);
        this.permissions.setLayout(new GridLayout(1, 4));
        this.permissions.add(this.paneldesc);
        this.permissions.add(this.panelone);
        this.permissions.add(this.paneltwo);
        this.permissions.add(this.panelthree);
        this.filename.setFont(new Font("SansSerif", 1, 11));
        this.size.setFont(new Font("SansSerif", 0, 10));
        this.location.setFont(new Font("SansSerif", 0, 10));
        this.kind.setFont(new Font("SansSerif", 0, 10));
        this.owner.setFont(new Font("SansSerif", 0, 10));
        this.group.setFont(new Font("SansSerif", 0, 10));
        this.modified.setFont(new Font("SansSerif", 0, 10));
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.fill = 2;
        gbc1.anchor = 11;
        gbc1.weightx = 0.0;
        gbc1.insets = new Insets(2, 38, 12, 5);
        UIUtil.jGridBagAdd(this.mainpanel, this.iconLabel, gbc1, -1);
        gbc1.weightx = 1.0;
        gbc1.insets = new Insets(9, 7, 2, 30);
        UIUtil.jGridBagAdd(this.mainpanel, this.filename, gbc1, 0);
        gbc1.weightx = 0.0;
        gbc1.insets = ins;
        UIUtil.jGridBagAdd(this.mainpanel, new JLabel("Size"), gbc1, -1);
        gbc1.weightx = 1.0;
        gbc1.insets = ins2;
        UIUtil.jGridBagAdd(this.mainpanel, this.size, gbc1, 0);
        gbc1.weightx = 0.0;
        gbc1.insets = ins;
        UIUtil.jGridBagAdd(this.mainpanel, new JLabel("Where"), gbc1, -1);
        gbc1.weightx = 1.0;
        gbc1.insets = ins2;
        UIUtil.jGridBagAdd(this.mainpanel, this.location, gbc1, 0);
        gbc1.weightx = 0.0;
        gbc1.insets = ins;
        UIUtil.jGridBagAdd(this.mainpanel, new JLabel("Kind"), gbc1, -1);
        gbc1.weightx = 1.0;
        gbc1.insets = ins2;
        UIUtil.jGridBagAdd(this.mainpanel, this.kind, gbc1, 0);
        gbc1.weightx = 0.0;
        gbc1.insets = ins;
        UIUtil.jGridBagAdd(this.mainpanel, new JLabel("Owner"), gbc1, -1);
        gbc1.weightx = 1.0;
        gbc1.insets = ins2;
        UIUtil.jGridBagAdd(this.mainpanel, this.owner, gbc1, 0);
        gbc1.weightx = 0.0;
        gbc1.insets = ins;
        UIUtil.jGridBagAdd(this.mainpanel, new JLabel("Group"), gbc1, -1);
        gbc1.weightx = 1.0;
        gbc1.insets = ins2;
        UIUtil.jGridBagAdd(this.mainpanel, this.group, gbc1, 0);
        gbc1.weightx = 0.0;
        gbc1.insets = ins;
        UIUtil.jGridBagAdd(this.mainpanel, new JLabel("Modified"), gbc1, -1);
        gbc1.weightx = 1.0;
        gbc1.insets = ins2;
        UIUtil.jGridBagAdd(this.mainpanel, this.modified, gbc1, 0);
        gbc1.insets = new Insets(5, 5, 5, 5);
        UIUtil.jGridBagAdd(this.mainpanel, this.permissions, gbc1, 0);
        this.navigate.setBounds(new Rectangle(7, this.getHeight(), this.getWidth(), 29));
        FlowLayout flow = new FlowLayout();
        flow.setAlignment(2);
        this.navigate.setLayout(flow);
        this.getContentPane().add((Component)this.navigate, "South");
        this.navigate.add(this.ok);
        this.navigate.add(this.cancel);
        this.ok.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PropertiesDialog.this.applyProperties();
                PropertiesDialog.this.dispose();
            }
        });
        this.cancel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PropertiesDialog.this.dispose();
            }
        });
        this.setSize(280, 380);
        this.setResizable(false);
        this.populate();
        UIUtil.positionComponent(0, this);
    }

    private void applyProperties() {
        int perm;
        int permcompare = perm = this.attrib.getPermissions().intValue();
        if (this.ownerRead.isSelected() && (this.attrib.getPermissions().intValue() & 0x100) != 256) {
            perm |= 0x100;
        } else if (!this.ownerRead.isSelected() && (this.attrib.getPermissions().intValue() & 0x100) == 256) {
            perm ^= 0x100;
        }
        if (this.ownerWrite.isSelected() && (this.attrib.getPermissions().intValue() & 0x80) != 128) {
            perm |= 0x80;
        } else if (!this.ownerWrite.isSelected() && (this.attrib.getPermissions().intValue() & 0x80) == 128) {
            perm ^= 0x80;
        }
        if (this.ownerExec.isSelected() && (this.attrib.getPermissions().intValue() & 0x40) != 64) {
            perm |= 0x40;
        } else if (!this.ownerExec.isSelected() && (this.attrib.getPermissions().intValue() & 0x40) == 64) {
            perm ^= 0x40;
        }
        if (this.groupRead.isSelected() && (this.attrib.getPermissions().intValue() & 0x20) != 32) {
            perm |= 0x20;
        } else if (!this.groupRead.isSelected() && (this.attrib.getPermissions().intValue() & 0x20) == 32) {
            perm ^= 0x20;
        }
        if (this.groupWrite.isSelected() && (this.attrib.getPermissions().intValue() & 0x10) != 16) {
            perm |= 0x10;
        } else if (!this.groupWrite.isSelected() && (this.attrib.getPermissions().intValue() & 0x10) == 16) {
            perm ^= 0x10;
        }
        if (this.groupExec.isSelected() && (this.attrib.getPermissions().intValue() & 8) != 8) {
            perm |= 8;
        } else if (!this.groupExec.isSelected() && (this.attrib.getPermissions().intValue() & 8) == 8) {
            perm ^= 8;
        }
        if (this.otherRead.isSelected() && (this.attrib.getPermissions().intValue() & 4) != 4) {
            perm |= 4;
        } else if (!this.otherRead.isSelected() && (this.attrib.getPermissions().intValue() & 4) == 4) {
            perm ^= 4;
        }
        if (this.otherWrite.isSelected() && (this.attrib.getPermissions().intValue() & 2) != 2) {
            perm |= 2;
        } else if (!this.otherWrite.isSelected() && (this.attrib.getPermissions().intValue() & 2) == 2) {
            perm ^= 2;
        }
        if (this.otherExec.isSelected() && (this.attrib.getPermissions().intValue() & 1) != 1) {
            perm |= 1;
        } else if (!this.otherExec.isSelected() && (this.attrib.getPermissions().intValue() & 1) == 1) {
            perm ^= 1;
        }
        try {
            Integer i;
            if (permcompare != perm) {
                this.sftp.chmod(perm, this.fileName);
            }
            if (!this.owner.getText().equals(String.valueOf(this.attrib.getUID().longValue())) && !this.owner.getText().trim().equals("")) {
                i = new Integer(this.owner.getText());
                this.sftp.chown(i, this.fileName);
            }
            if (!this.group.getText().equals(String.valueOf(this.attrib.getGID().longValue())) && !this.group.getText().trim().equals("")) {
                i = new Integer(this.group.getText());
                this.sftp.chgrp(i, this.fileName);
            }
            if (!this.filename.getText().equals(this.fileName) && !this.filename.getText().trim().equals("")) {
                this.sftp.rename(this.fileName, this.filename.getText());
            }
            this.hide();
            this.model.refresh();
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Error occurred whilst applying the properties");
        }
    }

    private void populate() {
        this.location.setText(this.locationStr);
        this.modified.setText(this.attrib.getModTimeString());
        this.owner.setText(String.valueOf(this.attrib.getUID().longValue()));
        this.group.setText(String.valueOf(this.attrib.getGID().longValue()));
        this.filename.setText(this.fileName);
        this.permissions.setBorder(BorderFactory.createTitledBorder("Permissions | " + this.attrib.getPermissionsString()));
        if ((this.attrib.getPermissions().intValue() & 0x100) == 256) {
            this.ownerRead.setSelected(true);
        }
        if ((this.attrib.getPermissions().intValue() & 0x20) == 32) {
            this.groupRead.setSelected(true);
        }
        if ((this.attrib.getPermissions().intValue() & 4) == 4) {
            this.otherRead.setSelected(true);
        }
        if ((this.attrib.getPermissions().intValue() & 0x80) == 128) {
            this.ownerWrite.setSelected(true);
        }
        if ((this.attrib.getPermissions().intValue() & 0x10) == 16) {
            this.groupWrite.setSelected(true);
        }
        if ((this.attrib.getPermissions().intValue() & 2) == 2) {
            this.otherWrite.setSelected(true);
        }
        if ((this.attrib.getPermissions().intValue() & 0x40) == 64) {
            this.ownerExec.setSelected(true);
        }
        if ((this.attrib.getPermissions().intValue() & 8) == 8) {
            this.groupExec.setSelected(true);
        }
        if ((this.attrib.getPermissions().intValue() & 1) == 1) {
            this.otherExec.setSelected(true);
        }
        if (this.attrib.isDirectory()) {
            this.kind.setText("Folder");
        } else {
            this.kind.setText("File");
        }
        double bytes = this.attrib.getSize().longValue();
        if (bytes < 1024.0) {
            this.size.setText(String.valueOf((int)bytes) + " bytes");
        } else if (bytes < 1048576.0) {
            this.size.setText(KB_FILE_SIZE_FORMAT.format(bytes / 1024.0) + " KB");
        } else {
            this.size.setText(MB_FILE_SIZE_FORMAT.format(bytes / 1024.0 / 1024.0) + " MB");
        }
        this.size.setEditable(false);
        this.location.setEditable(false);
        this.kind.setEditable(false);
        this.owner.setEditable(true);
        this.group.setEditable(true);
        this.modified.setEditable(false);
        this.filename.setEditable(true);
    }

    static {
        KB_FILE_SIZE_FORMAT.setMinimumFractionDigits(0);
        KB_FILE_SIZE_FORMAT.setMaximumFractionDigits(0);
        MB_FILE_SIZE_FORMAT.setMinimumFractionDigits(0);
        MB_FILE_SIZE_FORMAT.setMaximumFractionDigits(2);
    }
}

