/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sshterm;

import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.SshToolsApplication;
import com.sshtools.common.ui.SshToolsApplicationContainer;
import com.sshtools.common.ui.SshToolsApplicationException;
import com.sshtools.common.ui.SshToolsApplicationFrame;
import com.sshtools.common.ui.SshToolsApplicationPanel;
import com.sshtools.common.ui.StandardAction;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.sshterm.FullScreenAction;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshTermFrame
extends SshToolsApplicationFrame {
    protected static Log log = LogFactory.getLog(SshTermFrame.class);
    private StandardAction fullScreenAction;

    public SshTermFrame() {
        this.setIconImage(new ResourceIcon("/com/sshtools/sshterm/sshframeicon.gif").getImage());
    }

    @Override
    public void init(SshToolsApplication application, SshToolsApplicationPanel panel) throws SshToolsApplicationException {
        super.init(application, panel);
        GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        log.debug("Testing if " + device.getIDstring() + " can go full screen");
        try {
            Method m = device.getClass().getMethod("isFullScreenSupported", new Class[0]);
            if (((Boolean)m.invoke((Object)device, new Object[0])).booleanValue() || ConfigurationLoader.checkAndGetProperty("sshterm.enableFullScreen", "true").equals("true")) {
                log.info(device.getIDstring() + " can go full screen");
                this.addFullScreenActions();
            }
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
    }

    private void addFullScreenActions() {
        this.fullScreenAction = new FullScreenActionImpl(this.getApplication(), this);
        this.getApplicationPanel().registerAction(this.fullScreenAction);
        this.getApplicationPanel().rebuildActionComponents();
    }

    @Override
    public void closeContainer() {
        this.getApplicationPanel().deregisterAction(this.fullScreenAction);
        super.closeContainer();
    }

    class FullScreenActionImpl
    extends FullScreenAction {
        public FullScreenActionImpl(SshToolsApplication application, SshToolsApplicationContainer container) {
            super(application, container);
            this.putValue("onContextMenu", Boolean.TRUE);
            this.putValue("contextMenuGroup", new Integer(50));
            this.putValue("contextMenuWeight", new Integer(30));
        }
    }
}

