/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sshterm;

import com.sshtools.common.configuration.InvalidProfileFileException;
import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.common.keygen.Main;
import com.sshtools.common.mru.MRUAction;
import com.sshtools.common.mru.MRUListModel;
import com.sshtools.common.mru.MRUMenu;
import com.sshtools.common.ui.AdvancedAction;
import com.sshtools.common.ui.BeginnerAction;
import com.sshtools.common.ui.CloseAction;
import com.sshtools.common.ui.ConnectionPropertiesAction;
import com.sshtools.common.ui.DataNotificationListener;
import com.sshtools.common.ui.EditAction;
import com.sshtools.common.ui.FAQAction;
import com.sshtools.common.ui.OpenAction;
import com.sshtools.common.ui.Option;
import com.sshtools.common.ui.OptionsDialog;
import com.sshtools.common.ui.PreferencesStore;
import com.sshtools.common.ui.PrintPreview;
import com.sshtools.common.ui.RecordAction;
import com.sshtools.common.ui.RefreshAction;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.SaveAction;
import com.sshtools.common.ui.SaveAsAction;
import com.sshtools.common.ui.SessionProvider;
import com.sshtools.common.ui.SessionProviderAction;
import com.sshtools.common.ui.SessionProviderFactory;
import com.sshtools.common.ui.SessionProviderFrame;
import com.sshtools.common.ui.SshToolsApplication;
import com.sshtools.common.ui.SshToolsApplicationClientPanel;
import com.sshtools.common.ui.SshToolsApplicationContainer;
import com.sshtools.common.ui.SshToolsApplicationException;
import com.sshtools.common.ui.SshToolsApplicationPanel;
import com.sshtools.common.ui.SshToolsConnectionKerberosTab;
import com.sshtools.common.ui.SshToolsConnectionPanel;
import com.sshtools.common.ui.SshToolsConnectionTab;
import com.sshtools.common.ui.StandardAction;
import com.sshtools.common.ui.StatusBar;
import com.sshtools.common.ui.StopAction;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.common.util.X11Util;
import com.sshtools.j2ssh.SshEventAdapter;
import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelEventAdapter;
import com.sshtools.j2ssh.forwarding.XDisplay;
import com.sshtools.j2ssh.session.SessionChannelClient;
import com.sshtools.j2ssh.transport.TransportProtocol;
import com.sshtools.sshterm.ClearAction;
import com.sshtools.sshterm.CopyAction;
import com.sshtools.sshterm.GSIAuthTab;
import com.sshtools.sshterm.GlobusOnlineToolAction;
import com.sshtools.sshterm.KeygenAction;
import com.sshtools.sshterm.MyProxyToolAction;
import com.sshtools.sshterm.NewAction;
import com.sshtools.sshterm.PasteAction;
import com.sshtools.sshterm.PlayAction;
import com.sshtools.sshterm.PrintAction;
import com.sshtools.sshterm.PrintPreviewAction;
import com.sshtools.sshterm.ProxyDestroyAction;
import com.sshtools.sshterm.ProxyHelper;
import com.sshtools.sshterm.ProxyInfoAction;
import com.sshtools.sshterm.SshTerm;
import com.sshtools.sshterm.SshTermCommandTab;
import com.sshtools.sshterm.SshTermFrame;
import com.sshtools.sshterm.SshTermFullScreenWindowContainer;
import com.sshtools.sshterm.SshTermTerminalTab;
import com.sshtools.sshterm.VOManagementToolAction;
import com.sshtools.sshterm.XForwardingTab;
import com.sshtools.sshterm.emulation.TerminalEmulation;
import com.sshtools.sshterm.emulation.TerminalListener;
import com.sshtools.sshterm.emulation.TerminalPanel;
import java.awt.AWTEvent;
import java.awt.AWTPermission;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.SocketException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshTerminalPanel
extends SshToolsApplicationClientPanel
implements ActionListener,
ClipboardOwner,
TerminalListener,
MouseMotionListener {
    public static final String PREF_SHIFT_GEOMETRY = "sshterm.shift.geometry";
    public static final String PREF_PORT_FORWARDING_GEOMETRY = "sshterm.portForwarding.geometry";
    public static final String PREF_PORT_FORWARDING_DIVIDER_LOCATION = "sshterm.portForwarding.dividerLocation";
    public static final String PREF_PORT_FORWARDING_FORWARDS_TABLE_METRICS = "sshterm.portForwarding.forwards.tableMetrics";
    public static final String PREF_PORT_FORWARDING_ACTIVE_TABLE_METRICS = "sshterm.portForwarding.active.tableMetrics";
    public static final String PREF_PAGE_FORMAT_IMAGEABLE_X = "sshterm.pageFormat.imageable.x";
    public static final String PREF_PAGE_FORMAT_IMAGEABLE_Y = "sshterm.pageFormat.imageable.y";
    public static final String PREF_PAGE_FORMAT_IMAGEABLE_W = "sshterm.pageFormat.imageable.w";
    public static final String PREF_PAGE_FORMAT_IMAGEABLE_H = "sshterm.pageFormat.imageable.h";
    public static final String PREF_PAGE_FORMAT_SIZE_W = "sshterm.pageFormat.size.w";
    public static final String PREF_PAGE_FORMAT_SIZE_H = "sshterm.pageFormat.size.h";
    public static final String PREF_PAGE_FORMAT_ORIENTATION = "sshterm.pageFormat.orientation";
    public static final String PREF_X11_FORWARDING = "sshterm.xForwarding";
    public static final String PREF_X11_FORWARDING_LOCAL_DISPLAY = "sshterm.xForwarding.localDisplay";
    public static final String PREF_X11_FORWARDING_REMOTE_DISPLAY_NUMBER = "sshterm.xForwarding.remoteDisplayNumber";
    public static final String PREF_MOUSE_WHEEL_INCREMENT = "sshterm.mouseWheelIncrement";
    public static final String PREF_DELEGATION_TYPE = "sshterm.delegationType";
    public static final String PREF_PROXY_TYPE = "sshterm.proxyType";
    public static final String PREF_PROXY_LENGTH = "sshterm.proxyLength";
    public static final String PREF_DEFAULT_MYPROXY_HOSTNAME = "sshterm.myproxy.defaults.hostname";
    public static final String PREF_MYPROXY_PORT = "sshterm.myproxy.defaults.port";
    public static final String PREF_MYPROXY_UNAME = "sshterm.myproxy.defaults.username";
    public static final String PREF_MYPROXY_VONAME = "sshterm.myproxy.voname";
    public static final String PREF_MYPROXY_CACERT_URL = "sshterm.myproxy.cacert.url";
    public static final String PREF_VOMS_CONFIG_URL = "sshterm.voms.config.url";
    public static final String PREF_VOMS_LOCATION = "sshterm.voms.location";
    public static final String PREF_VOMS_PROXYTYPE = "sshterm.voms.proxyType";
    public static final String PREF_GO_USERNAME = "sshterm.go.username";
    public static final String PREF_DEFAULT_SIMPLE_PORT = "sshterm.simple.connection.port";
    public static final String PREF_LAST_MYPROXY_USERNAME = "sshterm.myproxy.last.username";
    public static final String PREF_KRB5_MYPROXY_HOSTNAME = "sshterm.krb5myproxy.hostname";
    public static final String PREF_KRB5_MYPROXY_PORT = "sshterm.krb5myproxy.port";
    public static final String PREF_KRB5_MYPROXY_USERNAME = "sshterm.krb5myproxy.username";
    public static final String PREF_KRB5_MYPROXY_REALM = "sshterm.krb5myproxy.relam";
    public static final String PREF_KRB5_MYPROXY_KDC = "sshterm.krb5myproxy.kdc";
    public static final String PREF_KRB5_MYPROXY_USE = "sshterm.krb5myproxy.enabled";
    public static boolean PREF_KRB5_MYPROXY_ENABLED = false;
    public static final String PREF_SAVE_MYPROXY_PROXY = "sshterm.proxy.save.myproxy";
    public static final String PREF_SAVE_GRID_PROXY_INIT_PROXY = "sshterm.proxy.save.gridproxyinit";
    public static final String PREF_SAVE_PKCS12_PROXY = "sshterm.proxy.save.pkcs12";
    public static final String PREF_SAVE_BROWSER_PROXY = "sshterm.proxy.save.browser";
    public static final String PREF_SAVE_PROXY = "sshterm.proxy.save";
    public static final String PREF_PKCS12_DEFAULT_FILE = "sshterm.pkcs12.defaults.file";
    public static final String PREF_BROWSER_PROFILE = "sshterm.browser.profile";
    public static final String PREF_BROWSER_DN = "sshterm.browser.dn";
    public static final String PREF_AUTH_ORDER = "sshterm.auth.order";
    public static final String PREF_TERMINAL_TERM = "sshterm.terminal.term";
    public static final String PREF_VOMS_SUPPORT = "sshterm.voms.support";
    public static final String PROFILE_PROPERTY_TERMINAL = "TERM";
    public static final String PROFILE_PROPERTY_EOL = "EOL";
    public static final String PROFILE_PROPERTY_SCREEN_SIZE = "TERM_SCREEN_SIZE";
    public static final String PROFILE_PROPERTY_RESIZE_STRATEGY = "RESIZE_STRATEGY";
    public static final String PROFILE_PROPERTY_ANTIALIAS = "ANTIALIAS";
    public static final String PROFILE_PROPERTY_FONT_SIZE = "FONT_SIZE";
    public static final String PROFILE_PROPERTY_BACKGROUND_COLOR = "BACKGROUND_COLOR";
    public static final String PROFILE_PROPERTY_FOREGROUND_COLOR = "FOREGROUND_COLOR";
    public static final String PROFILE_PROPERTY_COLOR_PRINTING = "COLOR_PRINTING";
    public static final int PROFILE_SCREEN_640_480 = 0;
    public static final int PROFILE_SCREEN_800_600 = 1;
    public static final int PROFILE_SCREEN_1024_768 = 2;
    private static final long VDU_EVENTS = 252L;
    static final String ABOUT_ICON = "/com/sshtools/sshterm/largessh.png";
    protected static Log log = LogFactory.getLog(SshTerminalPanel.class);
    private JScrollBar scrollBar;
    private SessionChannelClient session;
    private int eol;
    public boolean disconnecting = false;
    private TerminalPanel terminal;
    private Main keygenFrame;
    private com.sshtools.common.myproxytool.Main myproxytoolFrame;
    private com.sshtools.common.globusonlinetool.Main gotoolFrame;
    private com.sshtools.common.vomanagementtool.Main votoolFrame;
    private Vector actionMenus;
    private DataNotificationListener dataListener;
    private Vector sessionFrames = new Vector();
    private HashMap sessionActions = new HashMap();
    private NewAction newAction;
    private PrintPreviewAction printPreviewAction;
    private PrintAction printAction;
    private CloseAction closeAction;
    private CopyAction copyAction;
    private PasteAction pasteAction;
    private KeygenAction keygenAction;
    private MyProxyToolAction myproxytoolAction;
    private GlobusOnlineToolAction gotoolAction;
    private VOManagementToolAction votoolAction;
    private ClearAction clearAction;
    private RefreshAction refreshAction;
    private PlayAction playAction;
    private StopAction stopAction;
    private RecordAction recordAction;
    private StandardAction shiftAction;
    private StandardAction tunnelingAction;
    private Vector actions;
    private PageFormat pageFormat;
    private OpenAction openAction;
    private EditAction editAction;
    private SaveAction saveAction;
    private SaveAsAction saveAsAction;
    private ProxyInfoAction proxyInfoAction;
    private ProxyDestroyAction proxyDestroyAction;
    private MRUActionImpl mruAction;
    private ConnectionPropertiesAction connectionPropertiesAction;
    private FAQAction faqAction;
    private BeginnerAction beginnerAction;
    private AdvancedAction advancedAction;
    private JSeparator toolSeparator;
    JPanel contentPane;
    private OutputStream recordingOutputStream;
    private File recordingFile;
    private StatusBar statusBar;
    private TitledBorder titledBorder1;
    private BorderLayout borderLayout1 = new BorderLayout();
    private boolean anyHost = true;
    private boolean anyUser = true;
    private boolean anyPort = true;
    private boolean dialogActionsEnabled;
    private boolean fullScreenMode;
    private boolean autoHideTools;
    private SshToolsConnectionTab[] additionalTabs;
    public static final ResourceIcon SSHTERM_ICON = new ResourceIcon(SshTerminalPanel.class, "sshframeicon.gif");

    @Override
    public void init(SshToolsApplication application) throws SshToolsApplicationException {
        super.init(application);
        boolean kerb_support = false;
        if (PreferencesStore.get(PREF_KRB5_MYPROXY_USE, "NONE").indexOf("true") >= 0) {
            kerb_support = true;
        }
        if (kerb_support) {
            this.additionalTabs = new SshToolsConnectionTab[]{new SshTermCommandTab(), new SshTermTerminalTab(), new GSIAuthTab(), new XForwardingTab(), new SshToolsConnectionKerberosTab()};
            PREF_KRB5_MYPROXY_ENABLED = true;
        } else {
            this.additionalTabs = new SshToolsConnectionTab[]{new SshTermCommandTab(), new SshTermTerminalTab(), new GSIAuthTab(), new XForwardingTab()};
            PREF_KRB5_MYPROXY_ENABLED = false;
        }
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new RuntimePermission("queuePrintJob"));
            }
            try {
                PrinterJob job = PrinterJob.getPrinterJob();
                if (job == null) {
                    throw new IOException("Could not get print page format.");
                }
                this.pageFormat = job.defaultPage();
                if (PreferencesStore.preferenceExists(PREF_PAGE_FORMAT_ORIENTATION)) {
                    this.pageFormat.setOrientation(PreferencesStore.getInt(PREF_PAGE_FORMAT_ORIENTATION, 0));
                    Paper paper = new Paper();
                    paper.setImageableArea(PreferencesStore.getDouble(PREF_PAGE_FORMAT_IMAGEABLE_X, 0.0), PreferencesStore.getDouble(PREF_PAGE_FORMAT_IMAGEABLE_Y, 0.0), PreferencesStore.getDouble(PREF_PAGE_FORMAT_IMAGEABLE_W, 0.0), PreferencesStore.getDouble(PREF_PAGE_FORMAT_IMAGEABLE_H, 0.0));
                    paper.setSize(PreferencesStore.getDouble(PREF_PAGE_FORMAT_SIZE_W, 0.0), PreferencesStore.getDouble(PREF_PAGE_FORMAT_SIZE_H, 0.0));
                    this.pageFormat.setPaper(paper);
                }
            }
            catch (Exception e) {
                this.showExceptionMessage("Error", e.getMessage());
            }
        }
        catch (AccessControlException ace) {
            ace.printStackTrace();
        }
        this.enableEvents(252L);
        this.initActions();
        this.statusBar = new StatusBar();
        this.dataListener = new DataNotificationListener(this.statusBar);
        try {
            this.emulation = this.createEmulation();
        }
        catch (IOException ioe) {
            throw new SshToolsApplicationException(ioe);
        }
        this.emulation.addTerminalListener(this);
        this.scrollBar = new JScrollBar(1);
        this.emulation.setBufferSize(1000);
        this.terminal = new TerminalPanel(this.emulation){

            @Override
            public void processEvent(AWTEvent evt) {
                if (evt instanceof MouseEvent && evt.getID() == 507) {
                    try {
                        Method m = evt.getClass().getMethod("getWheelRotation", new Class[0]);
                        SshTerminalPanel.this.scrollBar.setValue(SshTerminalPanel.this.scrollBar.getValue() + SshTerminalPanel.this.scrollBar.getUnitIncrement() * (Integer)m.invoke((Object)evt, new Object[0]) * PreferencesStore.getInt(SshTerminalPanel.PREF_MOUSE_WHEEL_INCREMENT, 1));
                    }
                    catch (Throwable throwable) {}
                } else {
                    super.processEvent(evt);
                }
            }

            @Override
            public void copyNotify() {
                SshTerminalPanel.this.copyAction.actionPerformed(null);
            }
        };
        this.terminal.requestFocus();
        this.terminal.setScrollbar(this.scrollBar);
        this.terminal.addMouseMotionListener(this);
        JPanel center = new JPanel(new BorderLayout());
        center.setBackground(Color.red);
        center.add((Component)this.terminal, "Center");
        center.add((Component)this.scrollBar, "East");
        this.terminal.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if ((evt.getModifiers() & 4) > 0) {
                    SshTerminalPanel.this.getContextMenu().setLabel(SshTerminalPanel.this.getCurrentConnectionFile() == null ? SshTerminalPanel.this.getApplication().getApplicationName() : SshTerminalPanel.this.getCurrentConnectionFile().getName());
                    SshTerminalPanel.this.getContextMenu().show(SshTerminalPanel.this.terminal, evt.getX(), evt.getY());
                } else if ((evt.getModifiers() & 8) > 0) {
                    SshTerminalPanel.this.pasteAction.actionPerformed(null);
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)center, "Center");
        this.terminal.requestFocus();
    }

    @Override
    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    public boolean setAutoHideTools(boolean autoHideTools) {
        if (this.autoHideTools != autoHideTools) {
            this.setToolBarVisible(!autoHideTools);
            this.setMenuBarVisible(!autoHideTools);
            this.setStatusBarVisible(!autoHideTools);
            this.setScrollBarVisible(!autoHideTools);
            this.autoHideTools = autoHideTools;
            return true;
        }
        return false;
    }

    public boolean isAutoHideTools() {
        return this.autoHideTools;
    }

    public boolean isScrollBarVisible() {
        return this.scrollBar != null && this.scrollBar.isVisible();
    }

    public void setScrollBarVisible(boolean visible) {
        if (this.scrollBar != null && this.scrollBar.isVisible() != visible) {
            this.scrollBar.setVisible(visible);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.isAutoHideTools()) {
            if (!this.isToolsVisible() && e.getY() < 4) {
                this.setToolsVisible(true);
            } else if (this.isToolsVisible() && e.getY() > 12) {
                this.setToolsVisible(false);
            }
            if (!this.scrollBar.isVisible() && e.getX() > this.getWidth() - 4) {
                this.setScrollBarVisible(true);
            } else if (this.scrollBar.isVisible() && e.getX() < this.getWidth() - 12) {
                this.setScrollBarVisible(false);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
    }

    public void setFullScreenMode(boolean full) {
        if (this.fullScreenMode != full) {
            try {
                if (!full) {
                    this.application.convertContainer(this.getContainer(), SshTermFrame.class);
                } else {
                    this.application.convertContainer(this.getContainer(), SshTermFullScreenWindowContainer.class);
                }
                this.requestFocus();
                this.fullScreenMode = full;
            }
            catch (SshToolsApplicationException sshte) {
                sshte.printStackTrace();
                log.error(sshte);
            }
            this.setAvailableActions();
        }
    }

    @Override
    public ResourceIcon getIcon() {
        return SSHTERM_ICON;
    }

    public boolean isFullScreenMode() {
        return this.fullScreenMode;
    }

    @Override
    public void requestFocus() {
        this.terminal.requestFocus();
    }

    @Override
    public void registerAction(StandardAction action) {
        super.registerAction(action);
        action.addActionListener(this);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public void setAnyHost(boolean anyHost) {
        this.anyHost = anyHost;
    }

    public void setAnyUser(boolean anyUser) {
        this.anyUser = anyUser;
    }

    public void setAnyPort(boolean anyPort) {
        this.anyPort = anyPort;
    }

    @Override
    public void screenResized(int w, int h) {
        try {
            if (this.session != null) {
                this.session.changeTerminalDimensions(this.emulation);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setToolsVisible(boolean visible) {
        super.setToolsVisible(visible);
        this.setScrollBarVisible(visible);
    }

    public void openConnectionDialog() {
        SshToolsConnectionProfile p = SshToolsConnectionPanel.showConnectionDialog(this, this.getCurrentConnectionProfile(), this.getAdditionalConnectionTabs());
        if (p != null) {
            this.currentConnectionProfile = p;
            this.setContainerTitle(null);
            this.setNeedSave(true);
            this.connect(p, true);
        } else {
            log.info("New connection cancelled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        JFileChooser fileDialog;
        String command = event.getActionCommand();
        if (this.sessionActions.containsKey(event.getActionCommand())) {
            SessionProviderAction action = (SessionProviderAction)this.sessionActions.get(event.getActionCommand());
            for (SessionProviderFrame frame : this.sessionFrames) {
                if (!action.getProvider().getProviderClass().isInstance(frame.getSessionPanel()) || !frame.getSessionPanel().singleFrame()) continue;
                frame.show();
                return;
            }
            try {
                SessionProviderFrame frame;
                frame = new SessionProviderFrame(this.getCurrentConnectionProfile(), this.ssh, action.getProvider());
                if (frame.initFrame(this.getApplication())) {
                    frame.show();
                    this.sessionFrames.add(frame);
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        if (this.stopAction != null && command.equals(this.stopAction.getActionCommand())) {
            this.stopRecording();
        }
        if (this.recordAction != null && command.equals(this.recordAction.getActionCommand())) {
            this.setFullScreenMode(false);
            fileDialog = new JFileChooser(System.getProperty("user.home"));
            int ret = fileDialog.showSaveDialog(this);
            if (ret == 0) {
                this.recordingFile = fileDialog.getSelectedFile();
                if (this.recordingFile.exists() && JOptionPane.showConfirmDialog(this, "File exists. Are you sure?", "File exists", 0, 2) == 1) {
                    return;
                }
                try {
                    this.recordingOutputStream = new FileOutputStream(this.recordingFile);
                    this.statusBar.setStatusText("Recording to " + this.recordingFile.getName());
                    this.setAvailableActions();
                }
                catch (IOException ioe) {
                    this.showExceptionMessage("Error", "Could not open file for recording\n\n" + ioe.getMessage());
                }
            }
        }
        if (this.playAction != null && command.equals(this.playAction.getActionCommand())) {
            this.setFullScreenMode(false);
            fileDialog = new JFileChooser(System.getProperty("user.home"));
            int ret = fileDialog.showOpenDialog(this);
            if (ret == 0) {
                File playingFile = fileDialog.getSelectedFile();
                InputStream in = null;
                try {
                    this.statusBar.setStatusText("Playing from " + playingFile.getName());
                    in = new FileInputStream(playingFile);
                    byte[] b = null;
                    int a = 0;
                    while ((a = in.available()) != -1) {
                        if (a == 0) {
                            a = 1;
                        }
                        if ((a = in.read(b = new byte[a])) == -1) break;
                        this.emulation.getOutputStream().write(b);
                    }
                    this.statusBar.setStatusText("Finished playing " + playingFile.getName());
                    this.setAvailableActions();
                }
                catch (IOException ioe) {
                    this.statusBar.setStatusText("Error playing " + playingFile.getName());
                    this.showExceptionMessage("Error", "Could not open file for playback\n\n" + ioe.getMessage());
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ioe) {
                            log.error(ioe);
                        }
                    }
                }
            }
        }
        if (this.newAction != null && command.equals(this.newAction.getActionCommand())) {
            this.setFullScreenMode(false);
            this.emulation.clearScreen();
            this.emulation.setCursorPosition(0, 0);
            this.terminal.refresh();
            this.openConnectionDialog();
            return;
        }
        if (this.closeAction != null && command.equals(this.closeAction.getActionCommand()) && this.ssh != null && this.performVerifiedDisconnect(true)) {
            this.disconnecting = true;
            this.ssh.disconnect();
        }
        if (this.openAction != null && command.equals(this.openAction.getActionCommand())) {
            this.open();
        }
        if (this.saveAction != null && command.equals(this.saveAction.getActionCommand())) {
            this.saveConnection(false);
        }
        if (this.saveAsAction != null && command.equals(this.saveAsAction.getActionCommand())) {
            this.saveConnection(true);
        }
        if (this.keygenAction != null && event.getActionCommand().equals(this.keygenAction.getActionCommand())) {
            if (this.keygenFrame == null) {
                this.keygenFrame = new Main();
                this.keygenFrame.setDefaultCloseOperation(1);
                this.keygenFrame.pack();
                UIUtil.positionComponent(0, this.keygenFrame);
            }
            if (!this.keygenFrame.isVisible()) {
                this.setFullScreenMode(false);
            }
            this.keygenFrame.setVisible(!this.keygenFrame.isVisible());
        }
        if (this.myproxytoolAction != null && event.getActionCommand().equals(this.myproxytoolAction.getActionCommand())) {
            if (this.myproxytoolFrame == null) {
                this.myproxytoolFrame = new com.sshtools.common.myproxytool.Main();
                this.myproxytoolFrame.setDefaultCloseOperation(1);
                this.myproxytoolFrame.pack();
                UIUtil.positionComponent(0, this.myproxytoolFrame);
            }
            if (!this.myproxytoolFrame.isVisible()) {
                this.setFullScreenMode(false);
            }
            this.myproxytoolFrame.setVisible(!this.myproxytoolFrame.isVisible());
        }
        if (this.votoolAction != null && event.getActionCommand().equals(this.votoolAction.getActionCommand())) {
            if (this.votoolFrame == null) {
                this.votoolFrame = new com.sshtools.common.vomanagementtool.Main();
                this.votoolFrame.setDefaultCloseOperation(2);
                this.votoolFrame.pack();
                UIUtil.positionComponent(0, this.votoolFrame);
                this.votoolFrame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        SshTerminalPanel.this.votoolFrame = null;
                    }
                });
            }
            if (!this.votoolFrame.isVisible()) {
                this.setFullScreenMode(false);
            }
            this.votoolFrame.setVisible(!this.votoolFrame.isVisible());
        }
        if (this.proxyInfoAction != null && command.equals(this.proxyInfoAction.getActionCommand())) {
            ProxyHelper.showProxyInfo(this.getContainer().getWindow());
        }
        if (this.proxyDestroyAction != null && command.equals(this.proxyDestroyAction.getActionCommand())) {
            ProxyHelper.destroyProxy();
            this.setAvailableActions();
        }
    }

    private boolean performVerifiedDisconnect(boolean force) {
        SshToolsConnectionProfile profile = this.getCurrentConnectionProfile();
        if (profile.disconnectOnSessionClose()) {
            if (this.ssh.getForwardingClient().hasActiveConfigurations()) {
                return JOptionPane.showConfirmDialog(this, "There are currently active forwarding channels!\n\nThe profile is configured to disconnect when the session is closed. Closing\nthe connection will terminate these forwarding channels with unexpected results.\n\nDo you want to disconnect now?", "Auto disconnect", 0) == 0;
            }
            return true;
        }
        return force;
    }

    @Override
    public void open() {
        this.setFullScreenMode(false);
        super.open();
    }

    @Override
    public void open(File f) {
        if (log.isDebugEnabled()) {
            log.debug("Opening connection file " + f);
        }
        if (this.isConnected()) {
            Option optNew = new Option("New", "New create a new terminal", 110);
            Option optClose = new Option("Close", "Close current connection", 108);
            Option optCancel = new Option("Cancel", "Cancel the opening of this connection", 99);
            OptionsDialog dialog = OptionsDialog.createOptionDialog(this, new Option[]{optNew, optClose, optCancel}, "You already have a connection open. Select\nClose to close the current connection, New\nto create a new terminal or Cancel to abort.", "Existing connection", optNew, null, UIManager.getIcon("OptionPane.warningIcon"));
            UIUtil.positionComponent(0, dialog);
            dialog.setVisible(true);
            Option opt = dialog.getSelectedOption();
            if (opt == null || opt == optCancel) {
                return;
            }
            if (opt == optNew) {
                try {
                    SshToolsApplicationContainer c = this.application.newContainer();
                    SshTerminalPanel term = (SshTerminalPanel)c.getApplicationPanel();
                    term.open(f);
                    return;
                }
                catch (SshToolsApplicationException stae) {
                    log.error(stae);
                }
            } else {
                this.closeConnection(true);
            }
        }
        if (this.getApplication() instanceof SshTerm && ((SshTerm)this.getApplication()).getMRUModel() != null) {
            ((SshTerm)this.getApplication()).getMRUModel().add(f);
        }
        if (f != null) {
            SshToolsConnectionProfile profile = new SshToolsConnectionProfile();
            try {
                profile.open(f.getAbsolutePath());
                this.setNeedSave(false);
                this.setCurrentConnectionFile(f);
                this.connect(profile, false);
            }
            catch (InvalidProfileFileException fnfe) {
                this.showExceptionMessage("Open Connection", fnfe.getMessage());
            }
            catch (SshException e) {
                e.printStackTrace();
                this.showExceptionMessage("Open Connection", "An unexpected error occured!");
            }
        } else {
            this.showExceptionMessage("Open Connection", "Invalid file specified");
        }
    }

    public void stopRecording() {
        try {
            this.recordingOutputStream.flush();
            this.recordingOutputStream.close();
            this.statusBar.setStatusText("Stopped recording to " + this.recordingFile.getName());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.recordingOutputStream = null;
        this.setAvailableActions();
    }

    @Override
    public boolean isConnected() {
        return this.session != null && super.isConnected();
    }

    @Override
    public void closeConnection(boolean doDisconnect) {
        if (this.isConnected()) {
            super.closeConnection(doDisconnect);
        }
        if (doDisconnect) {
            try {
                if (this.session != null) {
                    this.session.close();
                }
                if (this.ssh != null && this.ssh.isConnected()) {
                    this.ssh.disconnect();
                }
            }
            catch (Exception se) {
                se.printStackTrace();
                this.showExceptionMessage("Disconnect", "An unexpected error occured!\n\n" + se.getMessage());
            }
        }
        if (this.recordingOutputStream != null) {
            this.stopRecording();
        }
        this.emulation.reset();
        this.setAvailableActions();
        this.statusBar.setStatusText("Disconnected");
        this.statusBar.setHost("");
        this.statusBar.setUser("");
        this.statusBar.setRemoteId("");
        this.statusBar.setConnected(false);
        this.ssh = null;
        this.session = null;
        Iterator it = this.sessionFrames.iterator();
        while (it.hasNext()) {
            try {
                SessionProviderFrame browserFrame = (SessionProviderFrame)it.next();
                browserFrame.exit();
                browserFrame.dispose();
            }
            catch (Throwable ex) {}
        }
        this.sessionFrames.clear();
        this.setNeedSave(false);
        this.setCurrentConnectionFile(null);
        this.setContainerTitle(null);
    }

    @Override
    public File saveConnection(boolean saveAs, File file, SshToolsConnectionProfile profile) {
        if (profile != null && (file == null || saveAs)) {
            this.setFullScreenMode(false);
        }
        return super.saveConnection(saveAs, file, profile);
    }

    private void saveConnection(boolean saveAs) {
        File f = this.saveConnection(saveAs, this.getCurrentConnectionFile(), this.getCurrentConnectionProfile());
        if (f != null) {
            ((SshTerm)this.getApplication()).getMRUModel().add(f);
            this.setCurrentConnectionFile(f);
        }
    }

    @Override
    public SshToolsConnectionTab[] getAdditionalConnectionTabs() {
        return this.additionalTabs;
    }

    @Override
    public void editConnection() {
        this.setFullScreenMode(false);
        super.editConnection();
    }

    @Override
    public boolean canClose() {
        if (this.session != null) {
            this.setFullScreenMode(false);
            if (JOptionPane.showConfirmDialog(this, "Close the current session and exit?", "Exit Application", 0, 3) == 1) {
                return false;
            }
        }
        return true;
    }

    public void printScreen() {
        try {
            PrinterJob job = PrinterJob.getPrinterJob();
            job.setPrintable(this.terminal, this.pageFormat);
            if (job.printDialog()) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                job.print();
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        catch (PrinterException pe) {
            JOptionPane.showMessageDialog(this, pe.getMessage(), "Error", 0);
        }
    }

    @Override
    public void connect(SshToolsConnectionProfile profile, boolean newProfile) {
        this.emulation.clearScreen();
        this.emulation.setCursorPosition(0, 0);
        this.terminal.refresh();
        this.disconnecting = false;
        this.setTerminalProperties(profile);
        super.connect(profile, newProfile, new SshEventAdapter(){

            @Override
            public void onDisconnect(TransportProtocol transport) {
                IOException e;
                if (transport.getState().getValue() != 5) {
                    transport.getState().setLastError(null);
                    transport.getState().setDisconnectReason(null);
                    return;
                }
                log.info("The connection has disconnected cleaning up");
                if (SshTerminalPanel.this.thread != null) {
                    try {
                        SshTerminalPanel.this.thread.stop();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                if ((e = transport.getState().getLastError()) != null && e instanceof EOFException && e.getMessage().indexOf("remote host has closed the connection") >= 0) {
                    if (!SshTerminalPanel.this.disconnecting) {
                        SshToolsApplicationPanel.showErrorMessage(SshTerminalPanel.this, "The remote host closed the connection!\n", "GSI-SSHTerm", e);
                    }
                } else if (e != null && e instanceof SocketException) {
                    if (!SshTerminalPanel.this.disconnecting) {
                        SshToolsApplicationPanel.showErrorMessage(SshTerminalPanel.this, "There was a problem with the connection, it was closed by the operating system.", "GSI-SSHTerm", e);
                    }
                } else if (transport.getState().getDisconnectReason() != null && !transport.getState().getDisconnectReason().equals("") && !transport.getState().getDisconnectReason().equals("Terminating connection")) {
                    if (!SshTerminalPanel.this.disconnecting) {
                        SshTerminalPanel.this.showExceptionMessage("GSI-SSHTerm", "The remote host has closed the connection:\n" + transport.getState().getDisconnectReason());
                    }
                } else if (e != null && !SshTerminalPanel.this.disconnecting) {
                    if (e.getMessage() != null && e.getMessage().indexOf("GSSException") >= 0) {
                        SshToolsApplicationPanel.showErrorMessage(SshTerminalPanel.this, "There was a problem while authenticating with the remote host", "GSI-SSHTerm", e);
                    } else if (e.getMessage().indexOf("Canceled by user") < 0) {
                        SshToolsApplicationPanel.showErrorMessage(SshTerminalPanel.this, "There was a problem with the connection or with authenticating", "GSI-SSHTerm", e);
                    } else {
                        SshToolsApplicationPanel.showErrorMessage(SshTerminalPanel.this, "There was a problem with the connection or with authenticating", "GSI-SSHTerm", e);
                    }
                }
                SshTerminalPanel.this.closeConnection(false);
            }
        });
    }

    @Override
    public boolean postConnection() {
        Window w = (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
        if (w != null) {
            w.toFront();
        }
        this.terminal.requestFocus();
        return true;
    }

    @Override
    public void authenticationComplete(boolean newProfile) throws SshException, IOException {
        try {
            SshToolsConnectionProfile profile = this.getCurrentConnectionProfile();
            this.setContainerTitle(this.getCurrentConnectionProfile().getHost());
            this.statusBar.setStatusText("Connected");
            this.statusBar.setConnected(true);
            this.setAvailableActions();
            this.terminal.requestFocus();
            if (this.eol == 0) {
                if (this.ssh.getRemoteEOL() == 1) {
                    this.emulation.setEOL(1);
                } else {
                    this.emulation.setEOL(2);
                }
            }
            if (profile.getOnceAuthenticatedCommand() != 1) {
                if (profile.getOnceAuthenticatedCommand() == 3) {
                    String cmd;
                    BufferedReader reader = new BufferedReader(new StringReader(profile.getCommandsToExecute() + "\n"));
                    while ((cmd = reader.readLine()) != null) {
                        if (cmd.trim().length() <= 0) continue;
                        log.info("Executing " + cmd);
                        this.session = this.createNewSession(false);
                        if (!this.session.executeCommand(cmd)) continue;
                        this.session.bindInputStream(this.emulation.getTerminalInputStream());
                        this.session.bindOutputStream(this.emulation.getTerminalOutputStream());
                        try {
                            this.session.getState().waitForState(3);
                        }
                        catch (InterruptedException ex) {
                            JOptionPane.showMessageDialog(this, "The command was interrupted!", "Interrupted Exception", 0);
                        }
                    }
                    if (profile.disconnectOnSessionClose()) {
                        this.ssh.disconnect();
                    }
                } else {
                    this.session = this.createNewSession(true);
                    if (this.session.startShell()) {
                        this.session.bindInputStream(this.emulation.getTerminalInputStream());
                        this.session.bindOutputStream(this.emulation.getTerminalOutputStream());
                    }
                }
            }
            log.info("Authentication complete and startup actions performed.");
        }
        catch (SshException se) {
            log.error("authenticationComplete passing on error: " + se);
            throw se;
        }
        catch (IOException ioe) {
            log.error("authenticationComplete passing on error: " + ioe);
            throw ioe;
        }
        catch (Throwable t) {
            log.error("authenticationComplete passing on error: " + t);
            throw new RuntimeException(t);
        }
    }

    private SessionChannelClient createNewSession(boolean addEventListener) throws IOException {
        SessionChannelClient session = this.ssh.openSessionChannel();
        session.addEventListener(this.dataListener);
        if (addEventListener) {
            session.addEventListener(new ChannelEventAdapter(){

                @Override
                public void onChannelClose(Channel channel) {
                    if (SshTerminalPanel.this.ssh != null && SshTerminalPanel.this.performVerifiedDisconnect(false)) {
                        SshTerminalPanel.this.ssh.disconnect();
                    }
                }
            });
        }
        if (this.getCurrentConnectionProfile().getApplicationPropertyBoolean(PREF_X11_FORWARDING, true)) {
            XDisplay display;
            int displayNumber = this.getCurrentConnectionProfile().getApplicationPropertyInt(PREF_X11_FORWARDING_LOCAL_DISPLAY, 0);
            String d = this.getCurrentConnectionProfile().getApplicationProperty(PREF_X11_FORWARDING_LOCAL_DISPLAY, "");
            if (d.equals("")) {
                d = ConfigurationLoader.checkAndGetProperty(PREF_X11_FORWARDING_LOCAL_DISPLAY, null);
            }
            try {
                display = d == null ? new XDisplay() : new XDisplay(d);
            }
            catch (IllegalArgumentException e) {
                display = new XDisplay("localhost:0.0");
            }
            X11Util.X11Cookie cookie = X11Util.getCookie(display);
            if (!session.requestX11Forwarding(displayNumber, cookie)) {
                JOptionPane.showMessageDialog(this, "The server refused to start start X11 forwarding!", "Start X11 Forwarding", 0);
            }
            this.ssh.getForwardingClient().enableX11Forwarding(display, cookie);
        }
        if (this.getCurrentConnectionProfile().getAllowAgentForwarding() && !session.requestAgentForwarding()) {
            JOptionPane.showMessageDialog(this, "The server failed to open an agent listener", "Allow Agent Forwarding", 0, (Icon)UIManager.get("OptionPane.informationIcon"));
        }
        if (this.getCurrentConnectionProfile().requiresPseudoTerminal() && !session.requestPseudoTerminal(this.emulation)) {
            JOptionPane.showMessageDialog(this, "The server refused to allocate a pseudo terminal!", "Request Pseudo Terminal", 0);
        }
        return session;
    }

    private void setTerminalProperties(SshToolsConnectionProfile profile) {
        this.eol = profile.getApplicationPropertyInt(PROFILE_PROPERTY_EOL, 0);
        if (this.eol != 0) {
            this.emulation.setEOL(this.eol);
        }
        this.emulation.setTerminalType(profile.getApplicationProperty(PROFILE_PROPERTY_TERMINAL, "vt100"));
        this.terminal.setBackground(profile.getApplicationPropertyColor(PROFILE_PROPERTY_BACKGROUND_COLOR, Color.black));
        this.terminal.setForeground(profile.getApplicationPropertyColor(PROFILE_PROPERTY_FOREGROUND_COLOR, Color.white));
        this.terminal.setColorPrinting(profile.getApplicationPropertyBoolean(PROFILE_PROPERTY_COLOR_PRINTING, true));
        this.terminal.setAntialias(profile.getApplicationPropertyBoolean(PROFILE_PROPERTY_ANTIALIAS, false));
        int rsz = profile.getApplicationPropertyInt(PROFILE_PROPERTY_RESIZE_STRATEGY, 2);
        this.terminal.setResizeStrategy(rsz);
        if (rsz == 2) {
            this.terminal.setFont(this.terminal.getFont().deriveFont((float)profile.getApplicationPropertyInt(PROFILE_PROPERTY_FONT_SIZE, 12)));
        }
    }

    private void initActions() {
        this.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("File", "File", 102, 0));
        this.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("Edit", "Edit", 101, 10));
        this.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("View", "View", 118, 20));
        this.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("Proxy", "Proxy", 112, 80));
        this.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("Help", "Help", 104, 90));
        this.actions = new Vector();
        this.faqAction = new FAQAction();
        this.registerAction(this.faqAction);
        this.beginnerAction = new BeginnerAction();
        this.registerAction(this.beginnerAction);
        this.advancedAction = new AdvancedAction();
        this.registerAction(this.advancedAction);
        if (this.getApplication().getMRUModel() != null) {
            this.mruAction = new MRUActionImpl(this.getApplication().getMRUModel());
            this.registerAction(this.mruAction);
        }
        this.connectionPropertiesAction = new ConnectionPropertiesActionImpl();
        this.registerAction(this.connectionPropertiesAction);
        this.newAction = new NewAction();
        this.registerAction(this.newAction);
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new FilePermission("<<ALL FILES>>", "read"));
            }
            this.openAction = new OpenAction();
            this.registerAction(this.openAction);
            this.playAction = new PlayAction();
            this.registerAction(this.playAction);
        }
        catch (AccessControlException ace) {
            log.warn("File reading actions are not available");
        }
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new FilePermission("<<ALL FILES>>", "write"));
            }
            this.saveAction = new SaveAction();
            this.registerAction(this.saveAction);
            this.saveAsAction = new SaveAsAction();
            this.registerAction(this.saveAsAction);
            this.recordAction = new RecordAction();
            this.registerAction(this.recordAction);
            this.stopAction = new StopAction();
            this.registerAction(this.stopAction);
        }
        catch (AccessControlException ace) {
            log.warn("File write actions are not available");
        }
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new FilePermission("<<ALL FILES>>", "write"));
            }
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new FilePermission("<<ALL FILES>>", "read"));
            }
            this.editAction = new EditActionImpl();
            this.registerAction(this.editAction);
        }
        catch (AccessControlException ace) {
            log.warn("Read / write actions are not available");
        }
        if (this.pageFormat != null) {
            try {
                if (System.getSecurityManager() != null) {
                    AccessController.checkPermission(new RuntimePermission("queuePrintJob"));
                }
                this.printAction = new PrintActionImpl();
                this.registerAction(this.printAction);
                this.printPreviewAction = new PrintPreviewActionImpl();
                this.registerAction(this.printPreviewAction);
            }
            catch (AccessControlException ace) {
                log.warn("Print actions are not available");
            }
        }
        this.refreshAction = new RefreshActionImpl();
        this.registerAction(this.refreshAction);
        this.closeAction = new CloseAction();
        this.registerAction(this.closeAction);
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new AWTPermission("accessClipboard"));
            }
            this.copyAction = new CopyActionImpl();
            this.registerAction(this.copyAction);
            this.pasteAction = new PasteActionImpl();
            this.registerAction(this.pasteAction);
        }
        catch (AccessControlException ace) {
            // empty catch block
        }
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new FilePermission("<<ALL FILES>>", "write"));
            }
            this.keygenAction = new KeygenAction();
            this.registerAction(this.keygenAction);
        }
        catch (AccessControlException ace) {
            log.warn("Keygen actions is not available");
        }
        try {
            this.myproxytoolAction = new MyProxyToolAction();
            this.registerAction(this.myproxytoolAction);
        }
        catch (AccessControlException ace) {
            log.warn("MyProxy Tool action is not available");
        }
        try {
            this.gotoolAction = new GlobusOnlineToolAction();
            this.registerAction(this.gotoolAction);
        }
        catch (AccessControlException ace) {
            log.warn("Globus Online Tool action is not available");
        }
        try {
            this.votoolAction = new VOManagementToolAction();
            this.registerAction(this.votoolAction);
        }
        catch (AccessControlException ace) {
            log.warn("VO Management Tool action is not available");
        }
        this.clearAction = new ClearActionImpl();
        this.registerAction(this.clearAction);
        this.proxyInfoAction = new ProxyInfoAction();
        this.registerAction(this.proxyInfoAction);
        this.proxyDestroyAction = new ProxyDestroyAction();
        this.registerAction(this.proxyDestroyAction);
        List providers = SessionProviderFactory.getInstance().getSessionProviders();
        for (SessionProvider provider : providers) {
            SessionProviderAction action = new SessionProviderAction(provider);
            this.sessionActions.put(action.getActionCommand(), action);
            this.registerAction(action);
        }
    }

    public void setDialogActionsEnabled(boolean enable) {
        this.dialogActionsEnabled = enable;
        this.setAvailableActions();
    }

    @Override
    public void setAvailableActions() {
        boolean connected = this.isConnected();
        for (SessionProviderAction action : this.sessionActions.values()) {
            action.setEnabled(connected);
        }
        if (this.newAction != null) {
            this.newAction.setEnabled(!connected);
        }
        if (this.openAction != null) {
            this.openAction.setEnabled(true);
        }
        if (this.connectionPropertiesAction != null) {
            this.connectionPropertiesAction.setEnabled(connected);
        }
        if (this.closeAction != null) {
            this.closeAction.setEnabled(connected);
        }
        if (this.saveAction != null) {
            this.saveAction.setEnabled(connected && this.isNeedSave());
        }
        if (this.saveAsAction != null) {
            this.saveAsAction.setEnabled(connected);
        }
        if (this.recordAction != null) {
            this.recordAction.setEnabled(connected && this.recordingOutputStream == null);
        }
        if (this.recordAction != null) {
            this.playAction.setEnabled(connected);
        }
        if (this.recordAction != null) {
            this.stopAction.setEnabled(this.recordingOutputStream != null);
        }
        if (this.shiftAction != null) {
            this.shiftAction.setEnabled(connected);
        }
        if (this.tunnelingAction != null) {
            this.tunnelingAction.setEnabled(connected);
        }
        if (this.proxyInfoAction != null) {
            this.proxyInfoAction.setEnabled(true);
        }
        if (this.proxyDestroyAction != null) {
            this.proxyDestroyAction.setEnabled(ProxyHelper.proxyExists());
        }
        if (this.faqAction != null) {
            this.faqAction.setEnabled(true);
        }
        if (this.beginnerAction != null) {
            this.beginnerAction.setEnabled(true);
        }
        if (this.advancedAction != null) {
            this.advancedAction.setEnabled(true);
        }
    }

    private TerminalEmulation createEmulation() throws IOException {
        return new TerminalEmulation("vt320");
    }

    @Override
    public void showExceptionMessage(String title, String message) {
        this.setFullScreenMode(false);
        super.showExceptionMessage(title, message);
    }

    @Override
    public void close() {
        this.disconnecting = true;
        if (this.pageFormat != null) {
            PreferencesStore.putDouble(PREF_PAGE_FORMAT_IMAGEABLE_X, this.pageFormat.getImageableX());
            PreferencesStore.putDouble(PREF_PAGE_FORMAT_IMAGEABLE_Y, this.pageFormat.getImageableY());
            PreferencesStore.putDouble(PREF_PAGE_FORMAT_IMAGEABLE_W, this.pageFormat.getImageableWidth());
            PreferencesStore.putDouble(PREF_PAGE_FORMAT_IMAGEABLE_H, this.pageFormat.getImageableHeight());
            PreferencesStore.putDouble(PREF_PAGE_FORMAT_SIZE_W, this.pageFormat.getWidth());
            PreferencesStore.putDouble(PREF_PAGE_FORMAT_SIZE_H, this.pageFormat.getHeight());
            PreferencesStore.putInt(PREF_PAGE_FORMAT_ORIENTATION, this.pageFormat.getOrientation());
        }
        if (this.mruAction != null) {
            this.mruAction.cleanUp();
        }
        if (this.ssh != null && this.ssh.isConnected()) {
            this.ssh.disconnect();
        }
    }

    class RefreshActionImpl
    extends RefreshAction {
        RefreshActionImpl() {
            this.putValue("onContextMenu", Boolean.TRUE);
            this.putValue("contextMenuGroup", new Integer(50));
            this.putValue("contextMenuWeight", new Integer(20));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ((SshTerminalPanel)SshTerminalPanel.this).emulation.update[0] = true;
            SshTerminalPanel.this.terminal.redraw();
        }
    }

    class ClearActionImpl
    extends ClearAction {
        ClearActionImpl() {
            this.putValue("onContextMenu", Boolean.TRUE);
            this.putValue("contextMenuGroup", new Integer(20));
            this.putValue("contextMenuWeight", new Integer(0));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            SshTerminalPanel.this.emulation.clearScreen();
            SshTerminalPanel.this.emulation.setCursorPosition(0, 0);
            SshTerminalPanel.this.terminal.refresh();
        }
    }

    class PasteActionImpl
    extends PasteAction {
        PasteActionImpl() {
            this.putValue("onContextMenu", Boolean.TRUE);
            this.putValue("contextMenuGroup", new Integer(10));
            this.putValue("contextMenuWeight", new Integer(10));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(SshTerminalPanel.this);
            if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    SshTerminalPanel.this.emulation.getOutputStream().write(t.getTransferData(DataFlavor.stringFlavor).toString().getBytes());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    class CopyActionImpl
    extends CopyAction {
        CopyActionImpl() {
            this.putValue("onContextMenu", Boolean.TRUE);
            this.putValue("contextMenuGroup", new Integer(10));
            this.putValue("contextMenuWeight", new Integer(0));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(SshTerminalPanel.this.terminal.getSelection()), SshTerminalPanel.this);
        }
    }

    class ConnectionPropertiesActionImpl
    extends ConnectionPropertiesAction {
        public ConnectionPropertiesActionImpl() {
            this.putValue("onContextMenu", Boolean.TRUE);
            this.putValue("contextMenuGroup", new Integer(50));
            this.putValue("contextMenuWeight", new Integer(45));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (SshTerminalPanel.this.editConnection(SshTerminalPanel.this.getCurrentConnectionProfile())) {
                SshTerminalPanel.this.setTerminalProperties(SshTerminalPanel.this.getCurrentConnectionProfile());
            }
        }
    }

    class EditActionImpl
    extends EditAction {
        EditActionImpl() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            SshTerminalPanel.this.editConnection();
        }
    }

    class PrintActionImpl
    extends PrintAction {
        PrintActionImpl() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            SshTerminalPanel.this.printScreen();
        }
    }

    class MRUActionImpl
    extends MRUAction {
        public MRUActionImpl(MRUListModel model) {
            super(model);
        }

        public void cleanUp() {
            ((MRUMenu)this.getValue("menu")).cleanUp();
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            SshTerminalPanel.this.open(new File(evt.getActionCommand()));
        }
    }

    class PrintPreviewActionImpl
    extends PrintPreviewAction {
        PrintPreviewActionImpl() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            PrintPreview pv = new PrintPreview(SshTerminalPanel.this.terminal, SshTerminalPanel.this.pageFormat);
            Option print = new Option("Print", "Print the screen", 112);
            Option close = new Option("Close", "Close this dialog", 99);
            OptionsDialog od = OptionsDialog.createOptionDialog(SshTerminalPanel.this, new Option[]{print, close}, pv, "Print Preview", close, null, null);
            od.pack();
            UIUtil.positionComponent(0, od);
            od.setVisible(true);
            if (od.getSelectedOption() == print) {
                SshTerminalPanel.this.printScreen();
            }
        }
    }
}

