/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sshvnc;

import com.sshtools.common.configuration.SshToolsConnectionProfile;

public class SshVNCOptions
implements Cloneable {
    private int[] encodings = new int[20];
    private int nEncodings;
    private int preferredEncoding;
    private int compressLevel;
    private int cursorUpdates;
    private int jpegQuality;
    private int screenSizePolicy;
    private boolean useCopyRect;
    private boolean eightBitColors;
    private boolean requestCursorUpdates;
    private boolean ignoreCursorUpdates;
    private boolean reverseMouseButtons2And3;
    private boolean viewOnly;
    private boolean shareDesktop;
    private String encryptedPassword;

    public SshVNCOptions() {
        this(null);
    }

    public SshVNCOptions(SshToolsConnectionProfile profile) {
        this.setFromProfile(profile);
    }

    public boolean isReverseMouseButtons2And3() {
        return this.reverseMouseButtons2And3;
    }

    public boolean isViewOnly() {
        return this.viewOnly;
    }

    public boolean isShareDesktop() {
        return this.shareDesktop;
    }

    public String getEncryptedPassword() {
        return this.encryptedPassword;
    }

    public int[] getEncodings() {
        return this.encodings;
    }

    public int getNumberOfEncodings() {
        return this.nEncodings;
    }

    public int getCompressLevel() {
        return this.compressLevel;
    }

    public int getJPEGQuality() {
        return this.jpegQuality;
    }

    public boolean isUseCopyRect() {
        return this.useCopyRect;
    }

    public void setEightBitColors(boolean eightBitColors) {
        this.eightBitColors = eightBitColors;
    }

    public boolean isEightBitColors() {
        return this.eightBitColors;
    }

    public boolean isRequestCursorUpdates() {
        return this.requestCursorUpdates;
    }

    public void setRequestCursorUpdates(boolean requestCursorUpdates) {
        this.requestCursorUpdates = requestCursorUpdates;
    }

    public boolean isIgnoreCursorUpdates() {
        return this.ignoreCursorUpdates;
    }

    public int getScreenSizePolicy() {
        return this.screenSizePolicy;
    }

    public void setEncodings() {
        this.nEncodings = 0;
        if (this.useCopyRect) {
            this.encodings[this.nEncodings++] = 1;
        }
        boolean enableCompressLevel = this.preferredEncoding == 6 || this.preferredEncoding == 7;
        this.encodings[this.nEncodings++] = this.preferredEncoding;
        if (this.preferredEncoding != 5) {
            this.encodings[this.nEncodings++] = 5;
        }
        if (this.preferredEncoding != 7) {
            this.encodings[this.nEncodings++] = 7;
        }
        if (this.preferredEncoding != 6) {
            this.encodings[this.nEncodings++] = 6;
        }
        if (this.preferredEncoding != 4) {
            this.encodings[this.nEncodings++] = 4;
        }
        if (this.preferredEncoding != 2) {
            this.encodings[this.nEncodings++] = 2;
        }
        if (enableCompressLevel) {
            if (this.compressLevel >= 1 && this.compressLevel <= 9) {
                this.encodings[this.nEncodings++] = -256 + this.compressLevel;
            } else {
                this.compressLevel = -1;
            }
        }
        if (this.preferredEncoding == 7 && !this.eightBitColors) {
            if (this.jpegQuality >= 0 && this.jpegQuality <= 9) {
                this.encodings[this.nEncodings++] = -32 + this.jpegQuality;
            } else {
                this.jpegQuality = -1;
            }
        }
        boolean bl = this.requestCursorUpdates = this.cursorUpdates != 2;
        if (this.requestCursorUpdates) {
            this.encodings[this.nEncodings++] = -240;
            this.encodings[this.nEncodings++] = -239;
            boolean bl2 = this.ignoreCursorUpdates = this.cursorUpdates == 1;
            if (!this.ignoreCursorUpdates) {
                this.encodings[this.nEncodings++] = -232;
            }
        }
        this.encodings[this.nEncodings++] = -224;
        this.encodings[this.nEncodings++] = -223;
    }

    public void setFromProfile(SshToolsConnectionProfile profile) {
        this.preferredEncoding = profile == null ? 7 : profile.getApplicationPropertyInt("PREFERRED_ENCODING", 7);
        this.useCopyRect = profile == null ? true : profile.getApplicationPropertyBoolean("USE_COPY_RECT", true);
        this.compressLevel = profile == null ? 0 : profile.getApplicationPropertyInt("COMPRESS_LEVEL", 0);
        this.jpegQuality = profile == null ? 7 : profile.getApplicationPropertyInt("JPEG_QUALITY", 7);
        this.cursorUpdates = profile == null ? 0 : profile.getApplicationPropertyInt("CURSOR_UPDATES", 0);
        this.screenSizePolicy = profile == null ? 0 : profile.getApplicationPropertyInt("VNC_SCREEN_SIZE", 0);
        this.eightBitColors = profile == null ? false : profile.getApplicationPropertyBoolean("EIGHT_BIT_COLORS", false);
        this.reverseMouseButtons2And3 = profile == null ? false : profile.getApplicationPropertyBoolean("REVERSE_MOUSE_BUTTONS_2_AND_3", false);
        this.viewOnly = profile == null ? false : profile.getApplicationPropertyBoolean("VIEW_ONLY", false);
        this.shareDesktop = profile == null ? false : profile.getApplicationPropertyBoolean("SHARE_DESKTOP", false);
        this.encryptedPassword = profile == null ? "" : profile.getApplicationProperty("ENCRYPTED_VNC_PASSWORD", "");
        this.setEncodings();
    }

    public Object clone() {
        SshVNCOptions opt = new SshVNCOptions();
        opt.encodings = this.encodings;
        opt.nEncodings = this.nEncodings;
        opt.preferredEncoding = this.preferredEncoding;
        opt.compressLevel = this.compressLevel;
        opt.cursorUpdates = this.cursorUpdates;
        opt.jpegQuality = this.jpegQuality;
        opt.useCopyRect = this.useCopyRect;
        opt.eightBitColors = this.eightBitColors;
        opt.requestCursorUpdates = this.requestCursorUpdates;
        opt.ignoreCursorUpdates = this.ignoreCursorUpdates;
        opt.reverseMouseButtons2And3 = this.reverseMouseButtons2And3;
        opt.viewOnly = this.viewOnly;
        opt.shareDesktop = this.shareDesktop;
        opt.screenSizePolicy = this.screenSizePolicy;
        return opt;
    }
}

