/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sshvnc;

import com.sshtools.common.configuration.InvalidProfileFileException;
import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.SshToolsConnectionTab;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class VNCAdvancedTab
extends JPanel
implements SshToolsConnectionTab,
ActionListener {
    static final ResourceIcon vncicon = new ResourceIcon(VNCAdvancedTab.class, "largevnc.png");
    static final String[] ENCODINGS = new String[]{"Raw", "RRE", "CoRRE", "Hextile", "Zlib", "Tight"};
    static final String[] COMPRESSION_LEVEL = new String[]{"Default", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    static final String[] JPEG_QUALITY = new String[]{"JPEG off", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    static final String[] CURSOR_UPDATES = new String[]{"Enable", "Ignore", "Disable"};
    protected SshToolsConnectionProfile profile;
    protected JComboBox encoding;
    protected JComboBox compressionLevel;
    protected JComboBox jpegQuality;
    protected JComboBox cursorUpdates;
    protected JComboBox bandwidth;
    protected JCheckBox useCopyRect;
    protected JCheckBox restrictedColors;
    protected JCheckBox reverseMouseButtons2And3;
    protected JCheckBox viewOnly;
    protected JCheckBox shareDesktop;

    public VNCAdvancedTab() {
        Insets ins = new Insets(2, 24, 2, 2);
        JPanel s = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.insets = ins;
        gbc.weighty = 1.0;
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.fill = 2;
        gbc2.anchor = 11;
        gbc2.insets = new Insets(2, 16, 2, 2);
        JPanel a = new JPanel(new GridBagLayout());
        a.setBorder(BorderFactory.createTitledBorder("Advanced Settings"));
        gbc2.fill = 2;
        gbc2.anchor = 11;
        gbc2.insets = ins;
        gbc2.weightx = 0.0;
        UIUtil.jGridBagAdd(a, new JLabel("Bandwidth Setting"), gbc2, -1);
        gbc2.weightx = 1.0;
        gbc2.insets = new Insets(2, 2, 2, 2);
        this.bandwidth = new JComboBox();
        this.loadOptimizedProfiles();
        this.bandwidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SshToolsConnectionProfile settingsprofile = new SshToolsConnectionProfile();
                try {
                    settingsprofile.open(ConfigurationLoader.getConfigurationDirectory() + VNCAdvancedTab.this.bandwidth.getSelectedItem().toString() + ".opt");
                    VNCAdvancedTab.this.profile.setApplicationProperty("PREFERRED_ENCODING", settingsprofile.getApplicationProperty("PREFERRED_ENCODING", null));
                    VNCAdvancedTab.this.encoding.setSelectedIndex(settingsprofile.getApplicationPropertyInt("PREFERRED_ENCODING", 1));
                    VNCAdvancedTab.this.profile.setApplicationProperty("COMPRESS_LEVEL", settingsprofile.getApplicationProperty("COMPRESS_LEVEL", null));
                    VNCAdvancedTab.this.compressionLevel.setSelectedIndex(settingsprofile.getApplicationPropertyInt("COMPRESS_LEVEL", 1));
                    VNCAdvancedTab.this.profile.setApplicationProperty("JPEG_QUALITY", settingsprofile.getApplicationProperty("JPEG_QUALITY", null));
                    VNCAdvancedTab.this.jpegQuality.setSelectedIndex(settingsprofile.getApplicationPropertyInt("JPEG_QUALITY", 1) + 1);
                    VNCAdvancedTab.this.profile.setApplicationProperty("EIGHT_BIT_COLORS", settingsprofile.getApplicationProperty("EIGHT_BIT_COLORS", null));
                    VNCAdvancedTab.this.restrictedColors.setSelected(settingsprofile.getApplicationPropertyBoolean("EIGHT_BIT_COLORS", false));
                    VNCAdvancedTab.this.profile.setApplicationProperty("USE_COPY_RECT", settingsprofile.getApplicationProperty("USE_COPY_RECT", null));
                    VNCAdvancedTab.this.useCopyRect.setSelected(settingsprofile.getApplicationPropertyBoolean("USE_COPY_RECT", false));
                    VNCAdvancedTab.this.setAvailableActions();
                }
                catch (InvalidProfileFileException invalidProfileFileException) {
                    // empty catch block
                }
            }
        });
        UIUtil.jGridBagAdd(a, this.bandwidth, gbc2, 0);
        gbc2.insets = new Insets(2, 24, 2, 2);
        UIUtil.jGridBagAdd(a, new JLabel("Encodings "), gbc2, -1);
        gbc2.weightx = 1.0;
        gbc2.insets = new Insets(2, 2, 2, 2);
        this.encoding = new JComboBox<String>(ENCODINGS);
        this.encoding.addActionListener(this);
        UIUtil.jGridBagAdd(a, this.encoding, gbc2, 0);
        gbc2.weightx = 0.0;
        gbc2.insets = new Insets(2, 24, 2, 2);
        UIUtil.jGridBagAdd(a, new JLabel("Compression "), gbc2, -1);
        gbc2.weightx = 1.0;
        gbc2.insets = new Insets(2, 2, 2, 2);
        this.compressionLevel = new JComboBox<String>(COMPRESSION_LEVEL);
        this.compressionLevel.addActionListener(this);
        UIUtil.jGridBagAdd(a, this.compressionLevel, gbc2, 0);
        gbc2.weightx = 0.0;
        gbc2.insets = new Insets(2, 24, 2, 2);
        UIUtil.jGridBagAdd(a, new JLabel("JPEG Quality "), gbc2, -1);
        gbc2.weightx = 1.0;
        gbc2.insets = new Insets(2, 2, 2, 2);
        this.jpegQuality = new JComboBox<String>(JPEG_QUALITY);
        this.jpegQuality.addActionListener(this);
        UIUtil.jGridBagAdd(a, this.jpegQuality, gbc2, 0);
        gbc2.weightx = 0.0;
        gbc2.insets = new Insets(2, 24, 2, 2);
        UIUtil.jGridBagAdd(a, new JLabel("Cursor shape updates "), gbc2, -1);
        gbc2.weightx = 1.0;
        gbc2.insets = new Insets(2, 2, 2, 2);
        this.cursorUpdates = new JComboBox<String>(CURSOR_UPDATES);
        this.cursorUpdates.addActionListener(this);
        UIUtil.jGridBagAdd(a, this.cursorUpdates, gbc2, 0);
        gbc2.weightx = 0.0;
        gbc2.insets = new Insets(2, 24, 2, 2);
        gbc2.weightx = 2.0;
        gbc2.insets = new Insets(8, 24, 2, 2);
        this.useCopyRect = new JCheckBox("Use CopyRect");
        this.useCopyRect.addActionListener(this);
        UIUtil.jGridBagAdd(a, this.useCopyRect, gbc2, -1);
        gbc2.insets = new Insets(8, 10, 2, 2);
        this.restrictedColors = new JCheckBox("Restricted Colors");
        this.restrictedColors.addActionListener(this);
        UIUtil.jGridBagAdd(a, this.restrictedColors, gbc2, 0);
        gbc2.insets = new Insets(4, 24, 2, 2);
        this.reverseMouseButtons2And3 = new JCheckBox("Reverse mouse buttons");
        this.reverseMouseButtons2And3.addActionListener(this);
        UIUtil.jGridBagAdd(a, this.reverseMouseButtons2And3, gbc2, -1);
        gbc2.insets = new Insets(4, 10, 2, 2);
        this.viewOnly = new JCheckBox("View only");
        this.viewOnly.addActionListener(this);
        UIUtil.jGridBagAdd(a, this.viewOnly, gbc2, 0);
        gbc2.insets = new Insets(4, 24, 2, 2);
        this.shareDesktop = new JCheckBox("Share desktop");
        this.shareDesktop.addActionListener(this);
        UIUtil.jGridBagAdd(a, this.shareDesktop, gbc2, 0);
        JPanel z = new JPanel(new BorderLayout());
        z.add((Component)a, "North");
        IconWrapperPanel w = new IconWrapperPanel(vncicon, z);
        this.setLayout(new BorderLayout());
        this.add((Component)w, "Center");
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.setConnectionProfile(null);
    }

    @Override
    public void setConnectionProfile(SshToolsConnectionProfile profile) {
        this.profile = profile;
        if (profile != null) {
            int idx = profile == null ? 7 : profile.getApplicationPropertyInt("PREFERRED_ENCODING", 7);
            switch (idx) {
                case 2: {
                    this.encoding.setSelectedIndex(1);
                    break;
                }
                case 4: {
                    this.encoding.setSelectedIndex(2);
                    break;
                }
                case 5: {
                    this.encoding.setSelectedIndex(3);
                    break;
                }
                case 6: {
                    this.encoding.setSelectedIndex(4);
                    break;
                }
                case 7: {
                    this.encoding.setSelectedIndex(5);
                    break;
                }
                default: {
                    this.encoding.setSelectedIndex(0);
                }
            }
            this.useCopyRect.setSelected(profile == null ? true : profile.getApplicationPropertyBoolean("USE_COPY_RECT", true));
            this.compressionLevel.setSelectedIndex(profile == null ? 0 : profile.getApplicationPropertyInt("COMPRESS_LEVEL", 0));
            this.jpegQuality.setSelectedIndex(profile == null ? 7 : profile.getApplicationPropertyInt("JPEG_QUALITY", 7));
            this.cursorUpdates.setSelectedIndex(profile == null ? 0 : profile.getApplicationPropertyInt("CURSOR_UPDATES", 0));
            this.restrictedColors.setSelected(profile == null ? false : profile.getApplicationPropertyBoolean("EIGHT_BIT_COLORS", false));
            this.reverseMouseButtons2And3.setSelected(profile == null ? false : profile.getApplicationPropertyBoolean("REVERSE_MOUSE_BUTTONS_2_AND_3", false));
            this.viewOnly.setSelected(profile == null ? false : profile.getApplicationPropertyBoolean("VIEW_ONLY", false));
            this.shareDesktop.setSelected(profile == null ? false : profile.getApplicationPropertyBoolean("SHARE_DESKTOP", false));
        }
        this.setAvailableActions();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.setAvailableActions();
    }

    private void setAvailableActions() {
        this.compressionLevel.setEnabled(this.encoding.getSelectedIndex() == 4 || this.encoding.getSelectedIndex() == 5);
        this.jpegQuality.setEnabled(this.encoding.getSelectedIndex() == 5 && !this.restrictedColors.isSelected());
    }

    @Override
    public SshToolsConnectionProfile getConnectionProfile() {
        return this.profile;
    }

    @Override
    public String getTabContext() {
        return "Connection";
    }

    @Override
    public Icon getTabIcon() {
        return null;
    }

    @Override
    public String getTabTitle() {
        return "VNC Advanced";
    }

    @Override
    public String getTabToolTipText() {
        return "Here you may select advanced VNC settings such as the encoding method, bandwidth settings and other miscellaneous options";
    }

    @Override
    public int getTabMnemonic() {
        return 97;
    }

    @Override
    public Component getTabComponent() {
        return this;
    }

    @Override
    public boolean validateTab() {
        return true;
    }

    @Override
    public void applyTab() {
        int idx = 0;
        switch (this.encoding.getSelectedIndex()) {
            case 1: {
                idx = 2;
                break;
            }
            case 2: {
                idx = 4;
                break;
            }
            case 3: {
                idx = 5;
                break;
            }
            case 4: {
                idx = 6;
                break;
            }
            case 5: {
                idx = 7;
            }
        }
        this.profile.setApplicationProperty("PREFERRED_ENCODING", idx);
        this.profile.setApplicationProperty("USE_COPY_RECT", this.useCopyRect.isSelected());
        this.profile.setApplicationProperty("COMPRESS_LEVEL", this.compressionLevel.getSelectedIndex());
        this.profile.setApplicationProperty("JPEG_QUALITY", this.jpegQuality.getSelectedIndex());
        this.profile.setApplicationProperty("CURSOR_UPDATES", this.cursorUpdates.getSelectedIndex());
        this.profile.setApplicationProperty("EIGHT_BIT_COLORS", this.restrictedColors.isSelected());
        this.profile.setApplicationProperty("REVERSE_MOUSE_BUTTONS_2_AND_3", this.reverseMouseButtons2And3.isSelected());
        this.profile.setApplicationProperty("VIEW_ONLY", this.viewOnly.isSelected());
        this.profile.setApplicationProperty("SHARE_DESKTOP", this.shareDesktop.isSelected());
    }

    @Override
    public void tabSelected() {
    }

    private void loadOptimizedProfiles() {
        File[] optimizedprofiles = this.recurseDir(new File(ConfigurationLoader.getConfigurationDirectory()));
        if (optimizedprofiles != null) {
            for (int j = 0; j < optimizedprofiles.length; ++j) {
                try {
                    SshToolsConnectionProfile profile = new SshToolsConnectionProfile();
                    profile.open(optimizedprofiles[j].getAbsolutePath());
                    if (profile == null) continue;
                    this.bandwidth.addItem(profile.getApplicationProperty("PROFILE_NAME", null));
                    continue;
                }
                catch (InvalidProfileFileException invalidProfileFileException) {
                    // empty catch block
                }
            }
        }
        if (this.bandwidth.getModel().getSize() == 0) {
            this.bandwidth.addItem("None found");
            this.bandwidth.setSelectedIndex(0);
            this.bandwidth.setEnabled(false);
        }
    }

    private File[] recurseDir(File directory) {
        return directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".opt");
            }
        });
    }
}

