/*
 * Decompiled with CFR 0.152.
 */
package edu.caltech.hep.dcapj.util;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Server
implements Runnable {
    private static final Logger logger = Logger.getLogger(Server.class.getName());
    protected boolean accept;
    protected ServerSocket _server = null;
    protected int timeout = 300000;
    private Thread serverThread = null;
    private boolean secure = true;

    public Server() throws IOException {
        this(0);
    }

    public Server(int port) throws IOException {
        this.init(port);
    }

    protected void init(int port) throws IOException {
        this._server = new ServerSocket(port);
        System.out.println("Server initialized");
        logger.log(Level.INFO, "Server initialzed to listen on port " + this._server.getLocalPort());
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void shutdown() {
        this.accept = false;
        try {
            this._server.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.serverThread.join();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        this.serverThread = null;
        this._server = null;
    }

    protected void start() {
        if (this.serverThread == null) {
            this.accept = true;
            this.serverThread = new Thread(this);
            this.serverThread.setName("Server");
            this.serverThread.start();
        }
    }

    public int getPort() {
        return this._server.getLocalPort();
    }

    @Override
    public void run() {
        Socket socket = null;
        while (this.accept) {
            try {
                socket = this._server.accept();
                if (!this.accept) break;
                socket.setSoTimeout(this.getTimeout());
            }
            catch (IOException e) {
                if (!this.accept) break;
                logger.log(Level.WARNING, "Server died: " + e.getMessage(), e);
                break;
            }
            this.handleConnection(socket);
        }
    }

    protected abstract void handleConnection(Socket var1);
}

