/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.esf;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1EncodableVector;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1Sequence;
import edu.illinois.ncsa.bouncycastle.asn1.DEREncodable;
import edu.illinois.ncsa.bouncycastle.asn1.DERObject;
import edu.illinois.ncsa.bouncycastle.asn1.DERSequence;
import edu.illinois.ncsa.bouncycastle.asn1.x509.DisplayText;
import edu.illinois.ncsa.bouncycastle.asn1.x509.NoticeReference;
import java.util.Enumeration;

public class SPUserNotice {
    private NoticeReference noticeRef;
    private DisplayText explicitText;

    public static SPUserNotice getInstance(Object object) {
        if (object == null || object instanceof SPUserNotice) {
            return (SPUserNotice)object;
        }
        if (object instanceof ASN1Sequence) {
            return new SPUserNotice((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in 'SPUserNotice' factory : " + object.getClass().getName() + ".");
    }

    public SPUserNotice(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            DEREncodable dEREncodable = (DEREncodable)enumeration.nextElement();
            if (dEREncodable instanceof NoticeReference) {
                this.noticeRef = NoticeReference.getInstance(dEREncodable);
                continue;
            }
            if (dEREncodable instanceof DisplayText) {
                this.explicitText = DisplayText.getInstance(dEREncodable);
                continue;
            }
            throw new IllegalArgumentException("Invalid element in 'SPUserNotice'.");
        }
    }

    public SPUserNotice(NoticeReference noticeReference, DisplayText displayText) {
        this.noticeRef = noticeReference;
        this.explicitText = displayText;
    }

    public NoticeReference getNoticeRef() {
        return this.noticeRef;
    }

    public DisplayText getExplicitText() {
        return this.explicitText;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.noticeRef != null) {
            aSN1EncodableVector.add(this.noticeRef);
        }
        if (this.explicitText != null) {
            aSN1EncodableVector.add(this.explicitText);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

