/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1InputStream;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1Sequence;
import edu.illinois.ncsa.bouncycastle.asn1.DERObjectIdentifier;
import edu.illinois.ncsa.bouncycastle.asn1.DERSequence;
import edu.illinois.ncsa.bouncycastle.asn1.isismtt.x509.AdmissionSyntax;
import edu.illinois.ncsa.bouncycastle.asn1.isismtt.x509.Admissions;
import edu.illinois.ncsa.bouncycastle.asn1.isismtt.x509.NamingAuthority;
import edu.illinois.ncsa.bouncycastle.asn1.isismtt.x509.ProfessionInfo;
import edu.illinois.ncsa.bouncycastle.asn1.test.ASN1UnitTest;
import edu.illinois.ncsa.bouncycastle.asn1.x500.DirectoryString;
import edu.illinois.ncsa.bouncycastle.asn1.x509.GeneralName;
import edu.illinois.ncsa.bouncycastle.asn1.x509.X509Name;
import java.io.IOException;

public class AdmissionSyntaxUnitTest
extends ASN1UnitTest {
    public String getName() {
        return "AdmissionSyntax";
    }

    public void performTest() throws Exception {
        GeneralName generalName = new GeneralName(new X509Name("CN=hello world"));
        DERSequence dERSequence = new DERSequence(new Admissions(generalName, new NamingAuthority(new DERObjectIdentifier("1.2.3"), "url", new DirectoryString("fred")), new ProfessionInfo[0]));
        AdmissionSyntax admissionSyntax = new AdmissionSyntax(generalName, dERSequence);
        this.checkConstruction(admissionSyntax, generalName, dERSequence);
        admissionSyntax = AdmissionSyntax.getInstance(null);
        if (admissionSyntax != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            AdmissionSyntax.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(AdmissionSyntax admissionSyntax, GeneralName generalName, ASN1Sequence aSN1Sequence) throws IOException {
        this.checkValues(admissionSyntax, generalName, aSN1Sequence);
        admissionSyntax = AdmissionSyntax.getInstance(admissionSyntax);
        this.checkValues(admissionSyntax, generalName, aSN1Sequence);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(admissionSyntax.toASN1Object().getEncoded());
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1InputStream.readObject();
        admissionSyntax = AdmissionSyntax.getInstance(aSN1Sequence2);
        this.checkValues(admissionSyntax, generalName, aSN1Sequence);
    }

    private void checkValues(AdmissionSyntax admissionSyntax, GeneralName generalName, ASN1Sequence aSN1Sequence) {
        this.checkMandatoryField("admissionAuthority", generalName, admissionSyntax.getAdmissionAuthority());
        Admissions[] admissionsArray = admissionSyntax.getContentsOfAdmissions();
        if (admissionsArray.length != 1 || !admissionsArray[0].equals(aSN1Sequence.getObjectAt(0))) {
            this.fail("admissions check failed");
        }
    }

    public static void main(String[] stringArray) {
        AdmissionSyntaxUnitTest.runTest(new AdmissionSyntaxUnitTest());
    }
}

