/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1InputStream;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1Object;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1TaggedObject;
import edu.illinois.ncsa.bouncycastle.asn1.DERApplicationSpecific;
import edu.illinois.ncsa.bouncycastle.util.encoders.Base64;
import edu.illinois.ncsa.bouncycastle.util.encoders.Hex;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTest;
import java.io.IOException;
import java.security.SecureRandom;

public class TagTest
extends SimpleTest {
    byte[] longTagged = Base64.decode("ZSRzIp8gEEZFRENCQTk4NzY1NDMyMTCfIQwyMDA2MDQwMTEyMzSUCCAFERVzA4kCAHEXGBkalAggBRcYGRqUCCAFZS6QAkRFkQlURUNITklLRVKSBQECAwQFkxAREhMUFRYXGBkalAggBREVcwOJAgBxFxgZGpQIIAUXGBkalAggBWUukAJERZEJVEVDSE5JS0VSkgUBAgMEBZMQERITFBUWFxgZGpQIIAURFXMDiQIAcRcYGRqUCCAFFxgZGpQIIAVlLpACREWRCVRFQ0hOSUtFUpIFAQIDBAWTEBESExQVFhcYGRqUCCAFERVzA4kCAHEXGBkalAggBRcYGRqUCCAFFxgZGpQIIAUXGBkalAg=");
    byte[] longAppSpecificTag = Hex.decode("5F610101");

    public String getName() {
        return "Tag";
    }

    public void performTest() throws IOException {
        ASN1InputStream aSN1InputStream = new ASN1InputStream(this.longTagged);
        DERApplicationSpecific dERApplicationSpecific = (DERApplicationSpecific)aSN1InputStream.readObject();
        aSN1InputStream = new ASN1InputStream(dERApplicationSpecific.getContents());
        dERApplicationSpecific = (DERApplicationSpecific)aSN1InputStream.readObject();
        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)(aSN1InputStream = new ASN1InputStream(dERApplicationSpecific.getContents())).readObject();
        if (aSN1TaggedObject.getTagNo() != 32) {
            this.fail("unexpected tag value found - not 32");
        }
        if ((aSN1TaggedObject = (ASN1TaggedObject)ASN1Object.fromByteArray(aSN1TaggedObject.getEncoded())).getTagNo() != 32) {
            this.fail("unexpected tag value found on recode - not 32");
        }
        if ((aSN1TaggedObject = (ASN1TaggedObject)aSN1InputStream.readObject()).getTagNo() != 33) {
            this.fail("unexpected tag value found - not 33");
        }
        if ((aSN1TaggedObject = (ASN1TaggedObject)ASN1Object.fromByteArray(aSN1TaggedObject.getEncoded())).getTagNo() != 33) {
            this.fail("unexpected tag value found on recode - not 33");
        }
        if ((dERApplicationSpecific = (DERApplicationSpecific)(aSN1InputStream = new ASN1InputStream(this.longAppSpecificTag)).readObject()).getApplicationTag() != 97) {
            this.fail("incorrect tag number read");
        }
        if ((dERApplicationSpecific = (DERApplicationSpecific)ASN1Object.fromByteArray(dERApplicationSpecific.getEncoded())).getApplicationTag() != 97) {
            this.fail("incorrect tag number read on recode");
        }
        SecureRandom secureRandom = new SecureRandom();
        for (int i = 0; i < 100; ++i) {
            int n = secureRandom.nextInt() >>> 1 + (secureRandom.nextInt() >>> 1) % 26;
            dERApplicationSpecific = new DERApplicationSpecific(n, new byte[]{1});
            if ((dERApplicationSpecific = (DERApplicationSpecific)ASN1Object.fromByteArray(dERApplicationSpecific.getEncoded())).getApplicationTag() == n) continue;
            this.fail("incorrect tag number read on recode (random test value: " + n + ")");
        }
    }

    public static void main(String[] stringArray) {
        TagTest.runTest(new TagTest());
    }
}

