/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.generators;

import edu.illinois.ncsa.bouncycastle.crypto.AsymmetricCipherKeyPair;
import edu.illinois.ncsa.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import edu.illinois.ncsa.bouncycastle.crypto.KeyGenerationParameters;
import edu.illinois.ncsa.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import edu.illinois.ncsa.bouncycastle.crypto.params.DHParameters;
import edu.illinois.ncsa.bouncycastle.crypto.params.ElGamalKeyGenerationParameters;
import edu.illinois.ncsa.bouncycastle.crypto.params.ElGamalParameters;
import edu.illinois.ncsa.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import edu.illinois.ncsa.bouncycastle.crypto.params.ElGamalPublicKeyParameters;
import java.math.BigInteger;

public class ElGamalKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private ElGamalKeyGenerationParameters param;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (ElGamalKeyGenerationParameters)keyGenerationParameters;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper dHKeyGeneratorHelper = DHKeyGeneratorHelper.INSTANCE;
        ElGamalParameters elGamalParameters = this.param.getParameters();
        DHParameters dHParameters = new DHParameters(elGamalParameters.getP(), elGamalParameters.getG(), null, elGamalParameters.getL());
        BigInteger bigInteger = dHKeyGeneratorHelper.calculatePrivate(dHParameters, this.param.getRandom());
        BigInteger bigInteger2 = dHKeyGeneratorHelper.calculatePublic(dHParameters, bigInteger);
        return new AsymmetricCipherKeyPair(new ElGamalPublicKeyParameters(bigInteger2, elGamalParameters), new ElGamalPrivateKeyParameters(bigInteger, elGamalParameters));
    }
}

