/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.util.encoders;

import edu.illinois.ncsa.bouncycastle.util.encoders.Encoder;
import edu.illinois.ncsa.bouncycastle.util.encoders.UrlBase64Encoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class UrlBase64 {
    private static final Encoder encoder = new UrlBase64Encoder();

    public static byte[] encode(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            encoder.encode(byArray, 0, byArray.length, byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException("exception encoding URL safe base64 string: " + iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static int encode(byte[] byArray, OutputStream outputStream) throws IOException {
        return encoder.encode(byArray, 0, byArray.length, outputStream);
    }

    public static byte[] decode(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            encoder.decode(byArray, 0, byArray.length, byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException("exception decoding URL safe base64 string: " + iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static int decode(byte[] byArray, OutputStream outputStream) throws IOException {
        return encoder.decode(byArray, 0, byArray.length, outputStream);
    }

    public static byte[] decode(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            encoder.decode(string, byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException("exception decoding URL safe base64 string: " + iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static int decode(String string, OutputStream outputStream) throws IOException {
        return encoder.decode(string, outputStream);
    }
}

