/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.pkipath;

import eu.emi.security.authn.x509.ValidationError;
import eu.emi.security.authn.x509.ValidationErrorCode;
import eu.emi.security.authn.x509.helpers.pkipath.ValidationErrorException;
import eu.emi.security.authn.x509.helpers.pkipath.bc.CertPathValidatorUtilities;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.impl.FormatMode;
import java.security.cert.CertPath;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.bouncycastle.jce.provider.AnnotatedException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.ExtendedPKIXBuilderParameters;

public class NonValidatingCertPathBuilder {
    private ValidationErrorException certPathException;
    private List<CertPath> result;

    public List<CertPath> buildPath(ExtendedPKIXBuilderParameters pkixParams, X509Certificate target, X509Certificate[] origChain) throws ValidationErrorException {
        ArrayList<X509Certificate> certPathList = new ArrayList<X509Certificate>();
        this.result = new ArrayList<CertPath>();
        this.build(target, pkixParams, certPathList, origChain);
        if (this.result.size() == 0 && this.certPathException != null) {
            throw this.certPathException;
        }
        if (this.result.size() == 0) {
            throw new ValidationErrorException(new ValidationError(origChain, -1, ValidationErrorCode.noTrustAnchorFound, new Object[0]));
        }
        return this.result;
    }

    protected void build(X509Certificate tbvCert, ExtendedPKIXBuilderParameters pkixParams, List<X509Certificate> tbvPath, X509Certificate[] origChain) {
        CertificateFactory cFact;
        if (tbvPath.contains(tbvCert)) {
            return;
        }
        if (pkixParams.getExcludedCerts().contains(tbvCert)) {
            return;
        }
        if (pkixParams.getMaxPathLength() != -1 && tbvPath.size() - 1 > pkixParams.getMaxPathLength()) {
            return;
        }
        tbvPath.add(tbvCert);
        try {
            cFact = CertificateFactory.getInstance("X.509", BouncyCastleProvider.PROVIDER_NAME);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception creating support classes.");
        }
        try {
            TrustAnchor ta;
            try {
                ta = CertPathValidatorUtilities.findTrustAnchor2(tbvCert, pkixParams.getTrustAnchors(), pkixParams.getSigProvider());
            }
            catch (AnnotatedException e1) {
                throw new ValidationErrorException(new ValidationError(origChain, -1, ValidationErrorCode.noTrustAnchorFound, new Object[0]));
            }
            if (ta != null) {
                try {
                    CertPath generated = cFact.generateCertPath(tbvPath);
                    this.result.add(generated);
                    tbvPath.remove(tbvCert);
                    return;
                }
                catch (Exception e) {
                    throw new ValidationErrorException(new ValidationError(origChain, -1, ValidationErrorCode.unknownMsg, "Certification path could not be constructed from certificate list: " + e));
                }
            }
            try {
                CertPathValidatorUtilities.addAdditionalStoresFromAltNames(tbvCert, pkixParams);
            }
            catch (CertificateParsingException e) {
                throw new ValidationErrorException(new ValidationError(origChain, -1, ValidationErrorCode.inputError, "No additiontal X.509 stores can be added from certificate locations as issuer alternative name extension can not be parsed: " + e.toString()));
            }
            HashSet issuers = new HashSet();
            try {
                issuers.addAll(CertPathValidatorUtilities.findIssuerCerts(tbvCert, pkixParams));
            }
            catch (AnnotatedException e) {
                throw new ValidationErrorException(new ValidationError(origChain, -1, ValidationErrorCode.unknownMsg, "Low level error occured: Cannot find issuer certificate for certificate in certification path: " + e));
            }
            if (issuers.isEmpty()) {
                throw new ValidationErrorException(new ValidationError(origChain, -1, ValidationErrorCode.invalidCertificatePath, CertificateUtils.format(tbvCert, FormatMode.COMPACT_ONE_LINE)));
            }
            for (X509Certificate issuer : issuers) {
                this.build(issuer, pkixParams, tbvPath, origChain);
            }
        }
        catch (ValidationErrorException e) {
            if (this.certPathException == null) {
                this.certPathException = new ValidationErrorException();
            }
            this.certPathException.addErrors(e.getErrors());
        }
        tbvPath.remove(tbvCert);
    }
}

