/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.impl;

import eu.emi.security.authn.x509.helpers.CertificateHelpers;
import eu.emi.security.authn.x509.helpers.DNComparator;
import eu.emi.security.authn.x509.helpers.JavaAndBCStyle;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;

public class X500NameUtils {
    public static boolean equal(String rfc2253dn1, String rfc2253dn2) throws IllegalArgumentException {
        String rfcA = DNComparator.preNormalize(rfc2253dn1);
        String rfcB = DNComparator.preNormalize(rfc2253dn2);
        return new X500Principal(rfcA).equals(new X500Principal(rfcB));
    }

    public static boolean equal(X500Principal dn, String rfc2253dn2) throws IllegalArgumentException {
        String dn1Str = dn.getName();
        return X500NameUtils.equal(dn1Str, rfc2253dn2);
    }

    public static boolean rfc3280Equal(X500Principal dn, X500Principal dn2) {
        return dn.equals(dn2);
    }

    public static String getReadableForm(String srcDn) throws IllegalArgumentException {
        JavaAndBCStyle style = new JavaAndBCStyle();
        X500Name x500Name = new X500Name((X500NameStyle)style, srcDn);
        return style.toStringFull(x500Name);
    }

    public static String getReadableForm(X500Principal srcDn) {
        return X500NameUtils.getReadableForm(srcDn.getName());
    }

    public static String getPortableRFC2253Form(String srcDn) {
        String preNorm = DNComparator.preNormalize(srcDn);
        return new X500Principal(preNorm).getName();
    }

    public static String getComparableForm(String srcDn) {
        String preNorm = DNComparator.preNormalize(srcDn);
        return new X500Principal(preNorm).getName("CANONICAL");
    }

    public static String[] getAttributeValues(String srcDn, ASN1ObjectIdentifier attribute) throws IllegalArgumentException {
        JavaAndBCStyle style = new JavaAndBCStyle();
        X500Name x500Name = new X500Name((X500NameStyle)style, srcDn);
        return X500NameUtils.getAttributeValues(x500Name, attribute);
    }

    public static String[] getAttributeValues(X500Principal srcDn, ASN1ObjectIdentifier attribute) {
        X500Name dn = CertificateHelpers.toX500Name(srcDn);
        return X500NameUtils.getAttributeValues(dn, attribute);
    }

    private static String[] getAttributeValues(X500Name x500Name, ASN1ObjectIdentifier attribute) {
        RDN[] rdns;
        ArrayList<String> ret = new ArrayList<String>();
        for (RDN rdn : rdns = x500Name.getRDNs()) {
            AttributeTypeAndValue[] atvs;
            for (AttributeTypeAndValue atv : atvs = rdn.getTypesAndValues()) {
                if (!atv.getType().equals(attribute)) continue;
                ret.add(IETFUtils.valueToString(atv.getValue()));
            }
        }
        return ret.toArray(new String[ret.size()]);
    }

    public static Set<ASN1ObjectIdentifier> getAttributeNames(String srcDn) {
        JavaAndBCStyle style = new JavaAndBCStyle();
        X500Name x500Name = new X500Name((X500NameStyle)style, srcDn);
        return X500NameUtils.getAttributeNames(x500Name);
    }

    public static Set<ASN1ObjectIdentifier> getAttributeNames(X500Principal srcDn) {
        X500Name dn = CertificateHelpers.toX500Name(srcDn);
        return X500NameUtils.getAttributeNames(dn);
    }

    private static Set<ASN1ObjectIdentifier> getAttributeNames(X500Name dn) {
        RDN[] rdns = dn.getRDNs();
        HashSet<ASN1ObjectIdentifier> ret = new HashSet<ASN1ObjectIdentifier>();
        for (RDN rdn : rdns) {
            for (AttributeTypeAndValue ava : rdn.getTypesAndValues()) {
                ret.add(ava.getType());
            }
        }
        return ret;
    }

    public static X500Principal getX500Principal(String rfcDn) throws IOException {
        JavaAndBCStyle style = new JavaAndBCStyle();
        X500Name x500Name = new X500Name((X500NameStyle)style, rfcDn);
        RDN[] rdns = x500Name.getRDNs();
        for (int i = 0; i < rdns.length / 2; ++i) {
            RDN bak = rdns[i];
            rdns[i] = rdns[rdns.length - 1 - i];
            rdns[rdns.length - 1 - i] = bak;
        }
        X500Name x500Name2 = new X500Name(rdns);
        byte[] encoded = x500Name2.getDEREncoded();
        return new X500Principal(encoded);
    }

    static {
        CertificateUtils.configureSecProvider();
    }
}

