/*
 * Decompiled with CFR 0.152.
 */
package lia.gsi;

import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import lia.gsi.GSIServer;
import lia.util.net.copy.FDTSessionManager;
import lia.util.net.copy.transport.ControlChannel;
import lia.util.net.copy.transport.ControlChannelNotifier;
import org.ietf.jgss.GSSCredential;

public class FDTGSIServer
extends GSIServer {
    private static final FDTSessionManager fdtSessionManager = FDTSessionManager.getInstance();
    private static final Logger logger = Logger.getLogger(FDTGSIServer.class.getName());

    public FDTGSIServer() throws Exception {
    }

    public FDTGSIServer(int port) throws Exception {
        this(null, null, port);
    }

    public FDTGSIServer(GSSCredential cred, int port) throws Exception {
        super(cred, port);
    }

    public FDTGSIServer(String serverKey, String serverCert, int port) throws Exception {
        super(FDTGSIServer.generateGSSCredential(serverKey, serverCert), port);
    }

    @Override
    public void start() {
        super.start();
    }

    @Override
    protected void handleConversation(GSIServer parent, Socket client, Subject peerSubject) {
        ControlChannel ct = null;
        try {
            ct = new ControlChannel(parent, client, peerSubject, (ControlChannelNotifier)fdtSessionManager);
            fdtSessionManager.addFDTClientSession(ct);
        }
        catch (Throwable t) {
            ct = null;
            throw new IllegalStateException("[ FDTGSIServer ] Cannot instantiate ControlChannel for client: " + client, t);
        }
        if (ct != null) {
            new Thread((Runnable)ct, "ControlChannel thread for [ " + client.getInetAddress() + ":" + client.getPort() + " ]").start();
        }
        logger.log(Level.INFO, "[ FDTGSIServer ] ControlChannel for client: " + client + " started!");
    }
}

