/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.common;

import java.nio.ByteBuffer;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import lia.util.net.common.Utils;

public abstract class AbstractBPool {
    private static final transient Logger logger = Logger.getLogger(AbstractBPool.class.getName());
    protected final int bufferSize;
    protected final int maxPollIter;
    protected final BlockingQueue<ByteBuffer> thePool;
    protected final AtomicBoolean limitReached = new AtomicBoolean(false);
    protected final AtomicInteger poolSize = new AtomicInteger(0);
    protected final boolean randomGen;
    private final boolean trackAllocations;
    private final IdentityHashMap<ByteBuffer, AtomicBoolean> mapTrack = new IdentityHashMap();

    public AbstractBPool(int bufferSize, int maxPollIter) {
        this(bufferSize, maxPollIter, false);
    }

    public AbstractBPool(int bufferSize, int maxPollIter, boolean trackAllocations) {
        this(bufferSize, maxPollIter, trackAllocations, false);
    }

    public AbstractBPool(int bufferSize, int maxPollIter, boolean trackAllocations, boolean randomGen) {
        this.bufferSize = bufferSize;
        this.maxPollIter = maxPollIter;
        this.thePool = new LinkedBlockingQueue<ByteBuffer>();
        this.trackAllocations = trackAllocations;
        this.randomGen = randomGen;
        for (int i = 0; i < Runtime.getRuntime().availableProcessors(); ++i) {
            ByteBuffer bb = this.tryAllocateBuffer();
            if (bb == null) continue;
            this.thePool.offer(bb);
        }
        if (this.poolSize.get() == 0) {
            logger.log(Level.WARNING, " \n\n\n\n !!!! Unable to allocate any buffers to the pool .... FDT will not work .... !!!! \n\n\n\n ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer tryAllocateBuffer() {
        ByteBuffer retBuffer = null;
        try {
            retBuffer = ByteBuffer.allocateDirect(this.bufferSize);
            if (this.randomGen && retBuffer != null) {
                try {
                    logger.log(Level.INFO, "BuffFill START generating data to fill the buffer: " + Utils.buffToString(retBuffer));
                    Random r = new Random();
                    byte[] bBuf = new byte[retBuffer.capacity()];
                    r.nextBytes(bBuf);
                    retBuffer.clear();
                    retBuffer.put(bBuf);
                    logger.log(Level.INFO, "BuffFill END generating data to fill the buffer: " + Utils.buffToString(retBuffer));
                }
                catch (Throwable t) {
                    logger.log(Level.WARNING, "Unable to generate data to fill the buffer", t);
                }
            }
        }
        catch (OutOfMemoryError oom) {
            if (this.limitReached.compareAndSet(false, true)) {
                logger.log(Level.WARNING, "\n\n !! Direct ByteBuffer memory pool reached max limit. Allocated: " + (this.totalAllocated() + this.totalAllocated()) / 0x100000L + " MB.\n FDT reuses the existing buffers, but the copy may be slow!!\n You may consider to increase the default value used by the JVM ( e.g. -XX:MaxDirectMemorySize=256m ),\n or decrease either the buffer size( -bs param) or the number of workers (-P param) \n\n\n");
            }
            retBuffer = null;
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, " Got general exception trying to allocate the mem. Please notify the developers! ", t);
            retBuffer = null;
        }
        finally {
            if (retBuffer != null) {
                this.poolSize.incrementAndGet();
                if (this.trackAllocations) {
                    IdentityHashMap<ByteBuffer, AtomicBoolean> oom = this.mapTrack;
                    synchronized (oom) {
                        this.mapTrack.put(retBuffer, new AtomicBoolean(false));
                    }
                }
            }
        }
        return retBuffer;
    }

    public final long totalAllocated() {
        return this.poolSize.get() * this.bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer take() throws InterruptedException {
        boolean logFinest = logger.isLoggable(Level.FINEST);
        boolean logFiner = logFinest || logger.isLoggable(Level.FINER);
        ByteBuffer retBuff = (ByteBuffer)this.thePool.poll();
        try {
            if (retBuff != null) {
                ByteBuffer byteBuffer = retBuff;
                return byteBuffer;
            }
            retBuff = this.tryAllocateBuffer();
            if (retBuff == null) {
                for (int i = 0; i < this.maxPollIter && (retBuff = (ByteBuffer)this.thePool.poll()) == null; ++i) {
                }
            }
            if (retBuff != null) {
                ByteBuffer byteBuffer = retBuff;
                return byteBuffer;
            }
            ByteBuffer byteBuffer = retBuff = this.thePool.take();
            return byteBuffer;
        }
        finally {
            if (retBuff != null) {
                retBuff.clear();
            }
            if (logFiner) {
                StringBuilder sb = new StringBuilder();
                sb.append("<ByteBufferPool> TAKE FROM POOL in poll(): buffer: ").append(Utils.buffToString(retBuff));
                sb.append("; qSize: ").append(this.thePool.size()).append(" allocSize: ").append(this.poolSize.get());
                if (logFinest) {
                    sb.append(" Trace: ");
                    logger.log(Level.INFO, sb.toString(), new Throwable());
                } else {
                    logger.log(Level.INFO, sb.toString());
                }
            }
            if (this.trackAllocations && retBuff != null && !this.checkBuffer(retBuff, false, true)) {
                logger.log(Level.WARNING, " \n\n  <ByteBufferPool> trackAllocations ASSERTION FAILURE. retBuf = " + Utils.buffToString(retBuff) + "; TAKE FROM POOL! expect: false update: true", new Exception("ASSERTION_FAILURE"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean checkBuffer(ByteBuffer bb, boolean expect, boolean update) {
        IdentityHashMap<ByteBuffer, AtomicBoolean> identityHashMap = this.mapTrack;
        synchronized (identityHashMap) {
            AtomicBoolean inUse = this.mapTrack.get(bb);
            if (inUse == null) {
                return false;
            }
            return inUse.compareAndSet(expect, update);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer poll() {
        boolean logFinest = logger.isLoggable(Level.FINEST);
        boolean logFiner = logFinest || logger.isLoggable(Level.FINER);
        ByteBuffer retBuff = (ByteBuffer)this.thePool.poll();
        try {
            if (retBuff != null) {
                ByteBuffer byteBuffer = retBuff;
                return byteBuffer;
            }
            retBuff = this.tryAllocateBuffer();
            if (retBuff != null) {
                ByteBuffer byteBuffer = retBuff;
                return byteBuffer;
            }
            ByteBuffer byteBuffer = retBuff = (ByteBuffer)this.thePool.poll();
            return byteBuffer;
        }
        finally {
            if (retBuff != null) {
                retBuff.clear();
            }
            if (logFiner) {
                StringBuilder sb = new StringBuilder();
                sb.append("<ByteBufferPool> TAKE FROM POOL in poll(): buffer: ").append(Utils.buffToString(retBuff));
                sb.append("; qSize: ").append(this.thePool.size()).append(" allocSize: ").append(this.poolSize.get());
                if (logFinest) {
                    sb.append(" Trace: ");
                    logger.log(Level.INFO, sb.toString(), new Throwable());
                } else {
                    logger.log(Level.INFO, sb.toString());
                }
            }
            if (this.trackAllocations && retBuff != null && !this.checkBuffer(retBuff, false, true)) {
                logger.log(Level.WARNING, " \n\n  <ByteBufferPool> trackAllocations ASSERTION FAILURE. retBuf = " + Utils.buffToString(retBuff) + "; TAKE FROM POOL! expect: false update: true", new Exception("ASSERTION_FAILURE"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer poll(long timeout, TimeUnit unit) throws InterruptedException {
        boolean logFinest = logger.isLoggable(Level.FINEST);
        boolean logFiner = logFinest || logger.isLoggable(Level.FINER);
        ByteBuffer retBuff = (ByteBuffer)this.thePool.poll();
        try {
            if (retBuff != null) {
                ByteBuffer byteBuffer = retBuff;
                return byteBuffer;
            }
            retBuff = this.tryAllocateBuffer();
            if (retBuff != null) {
                ByteBuffer byteBuffer = retBuff;
                return byteBuffer;
            }
            ByteBuffer byteBuffer = retBuff = this.thePool.poll(timeout, unit);
            return byteBuffer;
        }
        finally {
            if (retBuff != null) {
                retBuff.clear();
            }
            if (logFiner) {
                StringBuilder sb = new StringBuilder();
                sb.append("<ByteBufferPool> TAKE FROM POOL: buffer: ").append(Utils.buffToString(retBuff));
                sb.append("; qSize: ").append(this.thePool.size()).append(" allocSize: ").append(this.poolSize.get());
                if (logFinest) {
                    sb.append(" Trace: ");
                    logger.log(Level.INFO, sb.toString(), new Throwable());
                } else {
                    logger.log(Level.INFO, sb.toString());
                }
            }
            if (this.trackAllocations && retBuff != null && !this.checkBuffer(retBuff, false, true)) {
                logger.log(Level.WARNING, " \n\n  <ByteBufferPool> trackAllocations ASSERTION FAILURE. retBuf = " + Utils.buffToString(retBuff) + "; TAKE FROM POOL! expect: false update: true", new Exception("ASSERTION_FAILURE"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(ByteBuffer buff) {
        boolean logFiner;
        boolean logFinest = logger.isLoggable(Level.FINEST);
        boolean bl = logFiner = logFinest || logger.isLoggable(Level.FINER);
        if (logFiner) {
            StringBuilder sb = new StringBuilder();
            sb.append("<ByteBufferPool> PUT BACK TO POOL: buffer: ").append(Utils.buffToString(buff));
            sb.append("; qSize: ").append(this.thePool.size()).append(" allocSize: ").append(this.poolSize.get());
            if (logFinest) {
                sb.append(" Trace: ");
                logger.log(Level.INFO, sb.toString(), new Throwable());
            } else {
                logger.log(Level.INFO, sb.toString());
            }
        }
        if (buff == null) {
            return false;
        }
        if (this.trackAllocations && !this.checkBuffer(buff, true, false)) {
            logger.log(Level.WARNING, " \n\n  <ByteBufferPool> trackAllocations ASSERTION FAILURE. retBuf = " + Utils.buffToString(buff) + "; RETURN TO POOL! expect: true update: false", new Exception("ASSERTION_FAILURE"));
            return false;
        }
        while (true) {
            boolean isInterrupted = Thread.interrupted();
            try {
                boolean returned = this.thePool.offer(buff);
                if (!returned) continue;
                boolean bl2 = true;
                return bl2;
            }
            finally {
                if (!isInterrupted) continue;
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int getSize() {
        return this.thePool.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String identityMapStats() {
        StringBuilder sb = new StringBuilder();
        IdentityHashMap<ByteBuffer, AtomicBoolean> identityHashMap = this.mapTrack;
        synchronized (identityHashMap) {
            for (Map.Entry<ByteBuffer, AtomicBoolean> entry : this.mapTrack.entrySet()) {
                sb.append("\n").append(Utils.buffToString(entry.getKey())).append(" -> inUse: ").append(entry.getValue().get());
            }
        }
        return sb.toString();
    }

    public int getCapacity() {
        return this.poolSize.get();
    }
}

