/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.common;

import ch.ethz.ssh2.StreamGobbler;
import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.session.SessionChannelClient;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import lia.gsi.ssh.GSIAuthenticationClient;
import lia.util.net.common.ControlStream;
import org.ietf.jgss.GSSException;

public class GSISSHControlStream
implements ControlStream {
    private final String hostname;
    private final String username;
    private final int port;
    private SshClient conn;
    private SessionChannelClient sess;
    private String cmd;

    public GSISSHControlStream(String hostname, String username) {
        this(hostname, username, 22);
    }

    public GSISSHControlStream(String hostname, String username, int port) {
        this.hostname = hostname;
        this.username = username;
        this.port = port;
    }

    public static void main(String[] args) throws IOException {
        String line;
        GSISSHControlStream cs = new GSISSHControlStream(args[0], args[1]);
        cs.startProgram(args[2]);
        StreamGobbler stdout = new StreamGobbler(cs.getProgramStdOut());
        BufferedReader br = new BufferedReader(new InputStreamReader(stdout));
        while ((line = br.readLine()) != null) {
            System.out.println(line);
        }
        System.out.println("ExitCode:" + cs.getExitCode());
        cs.close();
    }

    @Override
    public void connect() throws IOException {
        GSIAuthenticationClient gsiAuth = null;
        try {
            gsiAuth = new GSIAuthenticationClient();
            gsiAuth.setUsername(this.username);
        }
        catch (GSSException e) {
            throw new IOException("Cannot load grid credentials.");
        }
        this.conn = new SshClient();
        SshToolsConnectionProfile properties = new SshToolsConnectionProfile();
        properties.setPort(this.port);
        properties.setForwardingAutoStartMode(false);
        properties.setHost(this.hostname);
        properties.setUsername(this.username);
        this.conn.setUseDefaultForwarding(false);
        this.conn.connect(properties);
        try {
            int result = this.conn.authenticate(gsiAuth, this.hostname);
            if (result != 4) {
                throw new IOException("GSI authentication failed");
            }
            this.sess = this.conn.openSessionChannel();
            this.sess.requestPseudoTerminal("javash", 0, 0, 0, 0, "");
        }
        catch (Throwable t) {
            throw new IOException(t.getMessage());
        }
    }

    @Override
    public void startProgram(String cmd) throws IOException {
        this.cmd = "/bin/bash --login -c '" + cmd + " 2>&1'";
        this.sess.executeCommand(this.cmd);
    }

    @Override
    public InputStream getProgramStdOut() {
        return this.sess.getInputStream();
    }

    @Override
    public InputStream getProgramStdErr() throws IOException {
        return this.sess.getStderrInputStream();
    }

    @Override
    public void waitForControlMessage(String expect, boolean allowEOF, boolean grabRemainingLog) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(this.getProgramStdOut()));
        String outputPrefix = "[" + this.hostname + "]$ ";
        do {
            if ((line = br.readLine()) == null) {
                if (allowEOF) {
                    return;
                }
                throw new IOException("[" + this.cmd + "] exited. No control message received]");
            }
            System.err.println(outputPrefix + line);
        } while (!line.trim().equalsIgnoreCase(expect));
        LogWriter lw = grabRemainingLog ? new LogWriter(br, "fdt_" + this.hostname + ".log") : new LogWriter(br);
        lw.setDaemon(true);
        lw.start();
    }

    @Override
    public void waitForControlMessage(String expect, boolean allowEOF) throws IOException {
        this.waitForControlMessage(expect, allowEOF, false);
    }

    @Override
    public void waitForControlMessage(String expect) throws IOException {
        this.waitForControlMessage(expect, false, true);
    }

    @Override
    public void saveStdErr() throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(this.getProgramStdErr()));
        LogWriter lw = new LogWriter(br, "fdt_" + this.hostname + ".err");
        lw.setDaemon(true);
        lw.start();
    }

    @Override
    public int getExitCode() {
        return this.sess.getExitCode();
    }

    @Override
    public void close() {
        try {
            if (this.sess != null) {
                this.sess.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.conn != null) {
            this.conn.disconnect();
        }
    }

    static class LogWriter
    extends Thread {
        BufferedReader br;
        String logFile;

        public LogWriter(BufferedReader br) {
            this.br = br;
            this.logFile = null;
        }

        public LogWriter(BufferedReader br, String fileName) {
            this.br = br;
            this.logFile = fileName;
        }

        @Override
        public void run() {
            BufferedWriter out = null;
            try {
                if (this.logFile != null) {
                    out = new BufferedWriter(new FileWriter(this.logFile, false));
                    Date date = new Date();
                    out.write("==============" + new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss Z").format(date) + "================\n");
                }
                while (true) {
                    String line;
                    if ((line = this.br.readLine()) == null) {
                        if (out != null) {
                            out.close();
                        }
                        return;
                    }
                    if (out == null) continue;
                    out.write(line + "\n");
                    out.flush();
                }
            }
            catch (IOException e) {
                System.err.println("Cannot write remote log:" + this.logFile);
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
        }
    }
}

