/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.common;

import apmon.ApMon;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import lia.gsi.FDTGSIServer;
import lia.util.net.common.AcceptableTask;
import lia.util.net.common.Config;
import lia.util.net.common.DirectByteBufferPool;
import lia.util.net.common.FDTCloseable;
import lia.util.net.common.FDTVersion;
import lia.util.net.common.HeaderBufferPool;
import lia.util.net.copy.FDT;
import lia.util.net.copy.FDTServer;
import lia.util.net.copy.FDTSessionManager;
import lia.util.net.copy.FileBlock;
import lia.util.net.copy.transport.ControlChannel;
import lia.util.net.copy.transport.ControlChannelNotifier;
import lia.util.net.copy.transport.CtrlMsg;
import lia.util.net.copy.transport.internal.FDTSelectionKey;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class Utils {
    public static final char ZERO = '0';
    public static final int VALUE_2_STRING_NO_UNIT = 1;
    public static final int VALUE_2_STRING_UNIT = 2;
    public static final int VALUE_2_STRING_SHORT_UNIT = 3;
    private static final Logger logger = Logger.getLogger(Utils.class.getName());
    private static final ScheduledThreadPoolExecutor scheduledExecutor = Utils.getSchedExecService("FDT Monitoring ThPool", 5, 1);
    private static final int AV_PROCS;
    private static final long KILO_BIT = 1000L;
    public static final long MEGA_BIT = 1000000L;
    private static final long GIGA_BIT = 1000000000L;
    private static final long TERA_BIT = 1000000000000L;
    private static final long PETA_BIT = 1000000000000000L;
    private static final long KILO_BYTE = 1024L;
    public static final long MEGA_BYTE = 0x100000L;
    private static final long GIGA_BYTE = 0x40000000L;
    private static final long TERA_BYTE = 0x10000000000L;
    private static final long PETA_BYTE = 0x4000000000000L;
    private static final long[] BYTE_MULTIPLIERS;
    private static final String[] BYTE_SUFIXES;
    private static final long[] BIT_MULTIPLIERS;
    private static final String[] BIT_SUFIXES;
    private static final int URL_CONNECTION_TIMEOUT = 20000;
    private static final Object lock;
    private static final long SECONDS_IN_MINUTE;
    private static final long SECONDS_IN_HOUR;
    private static final long SECONDS_IN_DAY;
    private static final String[] SELECTION_KEY_OPS_NAMES;
    private static final int[] SELECTION_KEY_OPS_VALUES;
    private static ApMon apmon;
    private static boolean apmonInitied;

    public static String getStackTrace(Throwable t) {
        if (t == null) {
            return "Stack trace unavailable";
        }
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static ScheduledThreadPoolExecutor getSchedExecService(final String name, int corePoolSize, final int threadPriority) {
        return new ScheduledThreadPoolExecutor(corePoolSize, new ThreadFactory(){
            AtomicLong l = new AtomicLong(0L);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, name + " - WorkerTask " + this.l.getAndIncrement());
                t.setPriority(threadPriority);
                t.setDaemon(true);
                return t;
            }
        }, new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                try {
                    long SLEEP_TIME;
                    block5: {
                        if (executor.isShutdown() || executor.isTerminated() || executor.isTerminating()) {
                            return;
                        }
                        SLEEP_TIME = Math.round(Math.random() * 1000.0 + 1.0);
                        try {
                            Thread.sleep(SLEEP_TIME);
                        }
                        catch (Throwable ignore) {
                            if (!logger.isLoggable(Level.FINER)) break block5;
                            ignore.printStackTrace();
                        }
                    }
                    System.err.println("\n\n [ RejectedExecutionHandler ] for " + name + " WorkerTask slept for " + SLEEP_TIME);
                    executor.execute(r);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        });
    }

    public static ExecutorService getStandardExecService(final String name, int corePoolSize, int maxPoolSize, BlockingQueue<Runnable> taskQueue, final int threadPriority) {
        ThreadPoolExecutor texecutor = new ThreadPoolExecutor(corePoolSize, maxPoolSize, 120L, TimeUnit.SECONDS, taskQueue, new ThreadFactory(){
            final AtomicLong l = new AtomicLong(0L);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, name + " - WorkerTask " + this.l.getAndIncrement());
                t.setPriority(threadPriority);
                t.setDaemon(true);
                return t;
            }
        });
        texecutor.setRejectedExecutionHandler(new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                try {
                    long SLEEP_TIME;
                    block5: {
                        if (executor.isShutdown() || executor.isTerminated() || executor.isTerminating()) {
                            return;
                        }
                        SLEEP_TIME = Math.round(Math.random() * 400.0 + 1.0);
                        try {
                            Thread.sleep(SLEEP_TIME);
                        }
                        catch (Throwable ignore) {
                            if (!logger.isLoggable(Level.FINER)) break block5;
                            ignore.printStackTrace();
                        }
                    }
                    System.err.println("\n\n [ RejectedExecutionHandler ] [ Full Throttle ] for " + name + " WorkerTask slept for " + SLEEP_TIME);
                    executor.getQueue().put(r);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        });
        texecutor.allowCoreThreadTimeOut(true);
        texecutor.prestartAllCoreThreads();
        return texecutor;
    }

    public static ExecutorService getStandardExecService(String name, int corePoolSize, int maxPoolSize, int threadPriority) {
        return Utils.getStandardExecService(name, corePoolSize, maxPoolSize, new SynchronousQueue<Runnable>(), threadPriority);
    }

    public static String formatWithByteFactor(double number, long factor, String append) {
        String appendUM = "";
        double fNo = number;
        boolean bFound = false;
        if (factor == 0L) {
            for (int i = BYTE_MULTIPLIERS.length - 1; i >= 0; --i) {
                if (!(number > (double)BYTE_MULTIPLIERS[i])) continue;
                fNo /= (double)BYTE_MULTIPLIERS[i];
                appendUM = BYTE_SUFIXES[i];
                bFound = true;
                break;
            }
        } else {
            for (int i = BYTE_MULTIPLIERS.length - 1; i >= 0; --i) {
                if (factor != BYTE_MULTIPLIERS[i]) continue;
                fNo /= (double)BYTE_MULTIPLIERS[i];
                appendUM = BYTE_SUFIXES[i];
                bFound = true;
                break;
            }
        }
        if (!bFound) {
            appendUM = "B";
        }
        appendUM = appendUM + append;
        return Utils.speedDecimalFormat(fNo) + ' ' + appendUM;
    }

    public static String formatWithBitFactor(double number, long factor, String append) {
        String appendUM = "";
        double fNo = number;
        boolean bFound = false;
        if (factor == 0L) {
            for (int i = BIT_MULTIPLIERS.length - 1; i >= 0; --i) {
                if (!(number > (double)BIT_MULTIPLIERS[i])) continue;
                fNo /= (double)BIT_MULTIPLIERS[i];
                appendUM = BIT_SUFIXES[i];
                bFound = true;
                break;
            }
        } else {
            for (int i = BIT_MULTIPLIERS.length - 1; i >= 0; --i) {
                if (factor != BIT_MULTIPLIERS[i]) continue;
                fNo /= (double)BIT_MULTIPLIERS[i];
                appendUM = BIT_SUFIXES[i];
                bFound = true;
                break;
            }
        }
        if (!bFound) {
            appendUM = "b";
        }
        appendUM = appendUM + append;
        return Utils.speedDecimalFormat(fNo) + ' ' + appendUM;
    }

    private static String speedDecimalFormat(double no) {
        DecimalFormat SPEED_DECIMAL_FORMAT = (DecimalFormat)DecimalFormat.getNumberInstance();
        SPEED_DECIMAL_FORMAT.applyPattern("##0.000");
        return SPEED_DECIMAL_FORMAT.format(no);
    }

    public static String percentDecimalFormat(double no) {
        DecimalFormat PERCENT_DECIMAL_FORMAT = (DecimalFormat)DecimalFormat.getNumberInstance();
        PERCENT_DECIMAL_FORMAT.applyPattern("00.00");
        return PERCENT_DECIMAL_FORMAT.format(no);
    }

    public static String getETA(long seconds) {
        long hours;
        long delta = seconds;
        StringBuilder sb = new StringBuilder();
        long days = seconds / SECONDS_IN_DAY;
        if (days > 0L) {
            if (days < 10L) {
                sb.append('0');
            }
            sb.append(days).append("d ");
            delta -= days * SECONDS_IN_DAY;
        }
        if ((hours = delta / SECONDS_IN_HOUR) > 0L) {
            delta -= hours * SECONDS_IN_HOUR;
            if (hours < 10L) {
                sb.append('0');
            }
            sb.append(hours).append("h ");
        }
        if (days > 0L) {
            return sb.toString();
        }
        long minutes = delta / SECONDS_IN_MINUTE;
        if (minutes > 0L) {
            if (minutes < 10L) {
                sb.append('0');
            }
            sb.append(minutes).append("m ");
            delta -= minutes * SECONDS_IN_MINUTE;
        }
        if (hours > 0L) {
            return sb.toString();
        }
        if (delta < 10L) {
            sb.append('0');
        }
        sb.append(delta).append('s');
        return sb.toString();
    }

    public static String getETA(long value, TimeUnit unit) {
        long hours;
        long delta = value;
        StringBuilder sb = new StringBuilder();
        long days = TimeUnit.DAYS.convert(delta, unit);
        if (days > 0L) {
            if (days < 10L) {
                sb.append('0');
            }
            sb.append(days).append("d ");
            delta -= unit.convert(days, TimeUnit.DAYS);
        }
        if ((hours = TimeUnit.HOURS.convert(delta, unit)) > 0L) {
            delta -= unit.convert(hours, TimeUnit.HOURS);
            if (hours < 10L) {
                sb.append('0');
            }
            sb.append(hours).append("h ");
        }
        if (days > 0L) {
            return sb.toString();
        }
        long minutes = TimeUnit.MINUTES.convert(delta, unit);
        if (minutes > 0L) {
            if (minutes < 10L) {
                sb.append('0');
            }
            sb.append(minutes).append("m ");
            delta -= unit.convert(minutes, TimeUnit.MINUTES);
        }
        if (hours > 0L) {
            return sb.toString();
        }
        if (delta < 10L) {
            sb.append('0');
        }
        sb.append(delta).append('s');
        return sb.toString();
    }

    public static ScheduledThreadPoolExecutor getMonitoringExecService() {
        return scheduledExecutor;
    }

    public static DirectByteBufferPool getDirectBufferPool() {
        return DirectByteBufferPool.getInstance();
    }

    public static int availableProcessors() {
        return AV_PROCS;
    }

    public static HeaderBufferPool getHeaderBufferPool() {
        return HeaderBufferPool.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initApMonInstance(ApMon apmon) throws Exception {
        Class<Utils> clazz = Utils.class;
        synchronized (Utils.class) {
            if (apmonInitied) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            Utils.apmon = apmon;
            apmonInitied = true;
            Utils.class.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApMon getApMon() {
        Class<Utils> clazz = Utils.class;
        synchronized (Utils.class) {
            Config config = Config.getInstance();
            if (config.getApMonHosts() == null) {
                if (!config.getMonitor().equals("OPENTSDB")) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return null;
                }
            }
            while (!apmonInitied) {
                try {
                    Utils.class.wait();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return apmon;
        }
    }

    public static boolean isCustomLog() {
        String trimLower;
        String customLogProperty = System.getProperty("CustomLog");
        boolean bCustomLog = false;
        if (customLogProperty != null && !(trimLower = customLogProperty.trim().toLowerCase()).isEmpty()) {
            bCustomLog = trimLower.startsWith("t") || trimLower.startsWith("1") || trimLower.startsWith("on");
        }
        return bCustomLog;
    }

    public static String buffToString(ByteBuffer bb) {
        if (bb == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder(512);
        sb.append(bb).append(" id=").append(System.identityHashCode(bb)).append(' ');
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, Object> parseArguments(String[] args, String[] singleArgs) {
        int sshHostsNo;
        List<String> sArgs = Arrays.asList(singleArgs);
        HashMap<String, Object> rHM = new HashMap<String, Object>();
        if (args == null || args.length == 0) {
            return rHM;
        }
        ArrayList<String> lParams = new ArrayList<String>();
        ArrayList<String> sshUsers = new ArrayList<String>();
        ArrayList<String> sshHosts = new ArrayList<String>();
        ArrayList<String> sshFiles = new ArrayList<String>();
        int i = 0;
        for (i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if (i == args.length - 1 || args[i + 1].startsWith("-") || sArgs.contains(args[i])) {
                    rHM.put(args[i], "");
                    continue;
                }
                if (sshUsers.size() > 0 && (args[i].equals("-c") || args[i].equals("-d"))) {
                    throw new IllegalArgumentException("Illegal syntax! You can use either either Client/Server (-c/-d) syntax, either SCP syntax");
                }
                rHM.put(args[i], args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].contains(":")) {
                int idx = args[i].indexOf(58);
                if (File.separatorChar == '\\') {
                    if (idx + 1 == args[i].length() && idx - 1 == 0 && new File(args[i].charAt(0) + ":").exists()) {
                        if (sshUsers.size() > 0) {
                            rHM.put("destinationDir", args[i]);
                            rHM.put("-d", rHM.get("destinationDir"));
                            break;
                        }
                        lParams.add(args[i]);
                        continue;
                    }
                    if (idx + 1 < args[i].length() && args[i].charAt(idx + 1) == File.separatorChar) {
                        if (sshUsers.size() > 0) {
                            rHM.put("destinationDir", args[i]);
                            rHM.put("-d", rHM.get("destinationDir"));
                            break;
                        }
                        lParams.add(args[i]);
                        continue;
                    }
                }
                if (sshUsers.size() == 0 && (rHM.get("-d") != null || rHM.get("-c") != null)) {
                    throw new IllegalArgumentException("Illegal syntax! You can use either Client/Server (-c/-d) syntax, either SCP syntax");
                }
                String userHost = null;
                if (idx > 0) {
                    userHost = args[i].substring(0, idx);
                }
                String user = null;
                String host = null;
                String path = null;
                if (userHost != null) {
                    int idx1 = userHost.indexOf("@");
                    if (idx1 >= 0) {
                        if (idx1 == 0) {
                            throw new IllegalArgumentException("Invalid scp syntax for " + args[i]);
                        }
                        user = userHost.substring(0, idx1);
                        if (idx1 + 1 >= userHost.length()) throw new IllegalArgumentException("Invalid scp syntax for " + args[i]);
                        host = userHost.substring(idx1 + 1);
                    } else {
                        host = userHost;
                    }
                }
                path = idx + 1 == args[i].length() ? "." : args[i].substring(idx + 1);
                sshUsers.add(user);
                sshHosts.add(host);
                sshFiles.add(path);
                continue;
            }
            if (sshUsers.size() > 0) {
                rHM.put("destinationDir", args[i]);
                rHM.put("-d", rHM.get("destinationDir"));
                break;
            }
            lParams.add(args[i]);
        }
        if ((sshHostsNo = sshUsers.size()) > 0) {
            rHM.put("SCPSyntaxUsed", Boolean.TRUE);
            if (rHM.get("destinationDir") == null) {
                rHM.put("destinationUser", sshUsers.get(sshHostsNo - 1));
                rHM.put("destinationHost", sshHosts.get(sshHostsNo - 1));
                rHM.put("destinationDir", sshFiles.get(sshHostsNo - 1));
                rHM.put("-d", rHM.get("destinationDir"));
                rHM.put("-c", rHM.get("destinationHost"));
                sshUsers.remove(sshHostsNo - 1);
                sshHosts.remove(sshHostsNo - 1);
                sshFiles.remove(sshHostsNo - 1);
            }
            if ((sshHostsNo = sshUsers.size()) > 0) {
                String[] sUsers = sshUsers.toArray(new String[sshHostsNo]);
                String[] sHosts = sshHosts.toArray(new String[sshHostsNo]);
                String[] sFiles = sshFiles.toArray(new String[sshHostsNo]);
                rHM.put("sourceUsers", sUsers);
                rHM.put("sourceHosts", sHosts);
                rHM.put("sourceFiles", sFiles);
                rHM.put("Files", rHM.get("sourceFiles"));
            }
        }
        rHM.put("LastParams", lParams);
        return rHM;
    }

    static String getStringValue(Map<String, Object> configMap, String key, String DEFAULT_VALUE) {
        Object obj = configMap.get(key);
        if (obj == null) {
            return DEFAULT_VALUE;
        }
        return obj.toString();
    }

    public static long getLongValue(Map<String, Object> configMap, String key, long DEFAULT_VALUE) {
        long rVal;
        Object obj = configMap.get(key);
        if (obj == null) {
            rVal = DEFAULT_VALUE;
        } else {
            String cVal = obj.toString();
            if (cVal.length() == 0) {
                rVal = DEFAULT_VALUE;
            } else {
                try {
                    long factor = 1L;
                    if (cVal.endsWith("K") || cVal.endsWith("k")) {
                        factor = 1024L;
                        cVal = cVal.substring(0, cVal.length() - 1);
                    } else if (cVal.endsWith("M") || cVal.endsWith("m")) {
                        factor = 0x100000L;
                        cVal = cVal.substring(0, cVal.length() - 1);
                    } else if (cVal.endsWith("G") || cVal.endsWith("g")) {
                        factor = 0x40000000L;
                        cVal = cVal.substring(0, cVal.length() - 1);
                    }
                    rVal = Long.parseLong(cVal) * factor;
                }
                catch (Throwable t) {
                    rVal = DEFAULT_VALUE;
                }
            }
        }
        return rVal;
    }

    public static double getDoubleValue(Map<String, Object> configMap, String key, double DEFAULT_VALUE) {
        double rVal;
        Object obj = configMap.get(key);
        if (obj == null) {
            rVal = DEFAULT_VALUE;
        } else {
            String cVal = obj.toString();
            if (cVal.length() == 0) {
                rVal = DEFAULT_VALUE;
            } else {
                try {
                    double factor = 1.0;
                    if (cVal.endsWith("K") || cVal.endsWith("k")) {
                        factor = 1024.0;
                        cVal = cVal.substring(0, cVal.length() - 1);
                    } else if (cVal.endsWith("M") || cVal.endsWith("m")) {
                        factor = 1048576.0;
                        cVal = cVal.substring(0, cVal.length() - 1);
                    } else if (cVal.endsWith("G") || cVal.endsWith("g")) {
                        factor = 1.073741824E9;
                        cVal = cVal.substring(0, cVal.length() - 1);
                    }
                    rVal = Double.parseDouble(cVal) * factor;
                }
                catch (Throwable t) {
                    rVal = DEFAULT_VALUE;
                }
            }
        }
        return rVal;
    }

    public static int getIntValue(Map<String, Object> configMap, String key, int DEFAULT_VALUE) {
        int rVal;
        Object obj = configMap.get(key);
        if (obj == null) {
            rVal = DEFAULT_VALUE;
        } else {
            String cVal = obj.toString();
            if (cVal.length() == 0) {
                rVal = DEFAULT_VALUE;
            } else {
                try {
                    long factor = 1L;
                    if (cVal.endsWith("K") || cVal.endsWith("k")) {
                        factor = 1024L;
                        cVal = cVal.substring(0, cVal.length() - 1);
                    } else if (cVal.endsWith("M") || cVal.endsWith("m")) {
                        factor = 0x100000L;
                        cVal = cVal.substring(0, cVal.length() - 1);
                    } else if (cVal.endsWith("G") || cVal.endsWith("g")) {
                        factor = 0x40000000L;
                        cVal = cVal.substring(0, cVal.length() - 1);
                    }
                    rVal = Integer.parseInt(cVal) * (int)factor;
                }
                catch (Throwable t) {
                    rVal = DEFAULT_VALUE;
                }
            }
        }
        return rVal;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File createOrGetRWFile(String parentDirName, String fileName) {
        File parentDir = new File(parentDirName);
        File file = new File(parentDirName + File.separator + fileName);
        if (!parentDir.exists() && parentDir.mkdirs()) {
            return null;
        }
        try {
            if (!file.exists()) {
                if (!file.createNewFile()) {
                    if (!logger.isLoggable(Level.FINE)) return null;
                    logger.log(Level.FINE, "Cannot create update conf file:" + file);
                    return null;
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Created update conf file:" + file);
                }
            } else if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "File: " + file + "exists. ");
            }
            if (!file.canRead()) {
                if (!logger.isLoggable(Level.FINER)) return null;
                logger.log(Level.FINER, "File: " + file + " can not be read.");
                return null;
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "File: " + file + " can be read.");
            }
            if (file.canWrite()) {
                if (!logger.isLoggable(Level.FINER)) return file;
                logger.log(Level.FINER, "File: " + file + " can be written.");
                return file;
            }
            if (!logger.isLoggable(Level.FINER)) return null;
            logger.log(Level.FINER, "File: " + file + " can not be written.");
            return null;
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Cannot create " + file, t);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updatePropertyAndStore(String dirName, String fileName, String property, String value) {
        Object object = lock;
        synchronized (object) {
            File file = Utils.createOrGetRWFile(dirName, fileName);
            if (file != null) {
                FileInputStream fis = null;
                FileOutputStream fos = null;
                try {
                    Properties props = new Properties();
                    fis = new FileInputStream(file);
                    props.load(fis);
                    props.put(property, value);
                    fos = new FileOutputStream(file);
                    props.store(fos, null);
                    fos.flush();
                }
                catch (Throwable t) {
                    block8: {
                        try {
                            if (!logger.isLoggable(Level.FINE)) break block8;
                            logger.log(Level.FINE, "Cannot update " + file, t);
                        }
                        catch (Throwable throwable) {
                            Utils.closeIgnoringExceptions(fis);
                            Utils.closeIgnoringExceptions(fos);
                            throw throwable;
                        }
                    }
                    Utils.closeIgnoringExceptions(fis);
                    Utils.closeIgnoringExceptions(fos);
                }
                Utils.closeIgnoringExceptions(fis);
                Utils.closeIgnoringExceptions(fos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getFDTUpdateProperties() {
        String parentFDTConfDirName = System.getProperty("user.home") + File.separator + ".fdt";
        String fdtUpdateConfFileName = "update.properties";
        Properties updateProperties = new Properties();
        File confFile = Utils.createOrGetRWFile(parentFDTConfDirName, "update.properties");
        if (confFile != null) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(confFile);
                updateProperties.load(fis);
            }
            catch (Throwable t) {
                block5: {
                    try {
                        if (!logger.isLoggable(Level.FINE)) break block5;
                        logger.log(Level.FINE, "Unable to read properties file: " + confFile, t);
                    }
                    catch (Throwable throwable) {
                        Utils.closeIgnoringExceptions(fis);
                        throw throwable;
                    }
                }
                Utils.closeIgnoringExceptions(fis);
            }
            Utils.closeIgnoringExceptions(fis);
        }
        return updateProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean updateTotalCounter(long total, String property) {
        String parentFDTConfDirName = System.getProperty("user.home") + File.separator + ".fdt";
        String fdtUpdateConfFileName = "update.properties";
        File confFile = Utils.createOrGetRWFile(parentFDTConfDirName, "update.properties");
        if (confFile != null) {
            Properties updateProperties = new Properties();
            FileInputStream fis = null;
            FileOutputStream fos = null;
            try {
                fis = new FileInputStream(confFile);
                updateProperties.load(fis);
                Utils.closeIgnoringExceptions(fis);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, " [ Utils ] [ updateTotalContor ] loaded properties: {0}", updateProperties);
                }
                String contorStringValue = (String)updateProperties.get(property);
                String rstStringValue = (String)updateProperties.get(property + "_rst");
                long lastContor = 0L;
                long rstContor = 0L;
                if (contorStringValue != null) {
                    try {
                        lastContor = Long.parseLong(contorStringValue);
                        rstContor = Long.parseLong(rstStringValue);
                    }
                    catch (Throwable t) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "Got exception parsing " + property + " param", t);
                        }
                        lastContor = 0L;
                        rstContor = 0L;
                    }
                }
                if ((lastContor += total) < 0L) {
                    ++rstContor;
                }
                updateProperties.put(property, String.valueOf(lastContor));
                updateProperties.put(property + "_rst", String.valueOf(rstContor));
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, " [ Utils ] [ updateTotalContor ] store new properties: {0}", updateProperties);
                }
                Utils.checkAndSetInstanceID(updateProperties);
                fos = new FileOutputStream(confFile);
                updateProperties.store(fos, null);
                fos.flush();
            }
            catch (Throwable t) {
                boolean bl;
                try {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Unable to update properties file for property: " + property + " contor: " + total + " file: " + confFile, t);
                    }
                    bl = false;
                }
                catch (Throwable throwable) {
                    Utils.closeIgnoringExceptions(fis);
                    Utils.closeIgnoringExceptions(fos);
                    throw throwable;
                }
                Utils.closeIgnoringExceptions(fis);
                Utils.closeIgnoringExceptions(fos);
                return bl;
            }
            Utils.closeIgnoringExceptions(fis);
            Utils.closeIgnoringExceptions(fos);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkAndSetInstanceID(Properties props) {
        block8: {
            if (props == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, " [ Utils ] [ checkAndSetInstanceID ] Null properties ... nothing to check/set");
                }
                return;
            }
            try {
                String instID = props.getProperty("instanceID");
                if (instID != null && !instID.trim().isEmpty()) break block8;
                instID = UUID.randomUUID().toString();
                props.put("instanceID", instID);
                String parentFDTConfDirName = System.getProperty("user.home") + File.separator + ".fdt";
                String fdtUpdateConfFileName = "update.properties";
                File confFile = Utils.createOrGetRWFile(parentFDTConfDirName, "update.properties");
                FileOutputStream fos = null;
                if (confFile == null) break block8;
                try {
                    fos = new FileOutputStream(confFile);
                    props.store(fos, null);
                    fos.flush();
                }
                catch (Throwable ignore) {
                    block9: {
                        try {
                            if (!logger.isLoggable(Level.FINEST)) break block9;
                            ignore.printStackTrace();
                        }
                        catch (Throwable throwable) {
                            Utils.closeIgnoringExceptions(fos);
                            throw throwable;
                        }
                    }
                    Utils.closeIgnoringExceptions(fos);
                    break block8;
                }
                Utils.closeIgnoringExceptions(fos);
            }
            catch (Throwable ignore) {
                if (!logger.isLoggable(Level.FINE)) break block8;
                logger.log(Level.FINE, " [ Utils ] [ checkAndSetInstanceID ] Unable to get/set instanceID", ignore);
            }
        }
    }

    public static boolean updateTotalReadCounter(long totalRead) throws Exception {
        return Utils.updateTotalCounter(totalRead, "totalRead");
    }

    public static boolean updateTotalWriteCounter(long totalWrite) throws Exception {
        return Utils.updateTotalCounter(totalWrite, "totalWrite");
    }

    /*
     * Loose catch block
     */
    public static int drainFileBlockQueue(Queue<FileBlock> fileBlockQueue) {
        DirectByteBufferPool bPool;
        int status;
        boolean isInterrupted;
        block14: {
            int n;
            block15: {
                isInterrupted = Thread.interrupted();
                status = 0;
                bPool = DirectByteBufferPool.getInstance();
                if (fileBlockQueue != null) break block14;
                n = status;
                if (!isInterrupted) break block15;
                try {
                    Thread.currentThread().interrupt();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return n;
        }
        while (true) {
            FileBlock fb;
            block16: {
                int n;
                block17: {
                    fb = fileBlockQueue.poll();
                    if (fb != null) break block16;
                    n = status;
                    if (!isInterrupted) break block17;
                    try {
                        Thread.currentThread().interrupt();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return n;
            }
            try {
                bPool.put(fb.buff);
                ++status;
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, " Got exception draining fileBlockQueue", t);
            }
            continue;
            break;
        }
        catch (Throwable throwable) {
            if (isInterrupted) {
                try {
                    Thread.currentThread().interrupt();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkForUpdate(String currentVersion, String updateURL, boolean noLock) throws Exception {
        block20: {
            try {
                String parentFDTConfDirName;
                block22: {
                    boolean bHaveUpdates;
                    long now;
                    FileOutputStream fos;
                    Properties updateProperties;
                    File confFile;
                    block21: {
                        FileInputStream fis;
                        long lastCheck;
                        block19: {
                            parentFDTConfDirName = System.getProperty("user.home") + File.separator + ".fdt";
                            String fdtUpdateConfFileName = "update.properties";
                            confFile = Utils.createOrGetRWFile(parentFDTConfDirName, "update.properties");
                            if (confFile == null) break block22;
                            lastCheck = 0L;
                            updateProperties = new Properties();
                            fis = null;
                            fos = null;
                            try {
                                fis = new FileInputStream(confFile);
                                updateProperties.load(fis);
                                String lastCheckProp = (String)updateProperties.get("LastCheck");
                                lastCheck = 0L;
                                if (lastCheckProp == null) break block19;
                                try {
                                    lastCheck = Long.parseLong(lastCheckProp);
                                }
                                catch (Throwable t) {
                                    if (logger.isLoggable(Level.FINE)) {
                                        logger.log(Level.FINE, "Got exception parsing LastCheck param", t);
                                    }
                                    lastCheck = 0L;
                                }
                            }
                            catch (Throwable t) {
                                try {
                                    logger.log(Level.WARNING, "Cannot load update properties file: " + confFile, t);
                                }
                                catch (Throwable throwable) {
                                    Utils.closeIgnoringExceptions(fis);
                                    throw throwable;
                                }
                                Utils.closeIgnoringExceptions(fis);
                            }
                        }
                        Utils.closeIgnoringExceptions(fis);
                        now = System.currentTimeMillis();
                        bHaveUpdates = false;
                        Utils.checkAndSetInstanceID(updateProperties);
                        if (lastCheck + 172800000L >= now) break block20;
                        try {
                            System.out.println("\n\nChecking for remote updates ... This may be disabled using -noupdates flag.");
                            bHaveUpdates = Utils.updateFDT(currentVersion, updateURL, false, noLock);
                            if (bHaveUpdates) {
                                logger.info("FDT may be updated using: java -jar fdt.jar -update");
                            } else if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, "No updates available");
                            }
                        }
                        catch (Throwable t) {
                            if (!logger.isLoggable(Level.FINE)) break block21;
                            logger.log(Level.WARNING, "Got exception", t);
                        }
                    }
                    updateProperties.put("LastCheck", String.valueOf(now));
                    try {
                        fos = new FileOutputStream(confFile);
                        updateProperties.store(fos, null);
                    }
                    catch (Throwable t1) {
                        try {
                            logger.log(Level.WARNING, "Cannot store update properties file", t1);
                        }
                        catch (Throwable throwable) {
                            Utils.closeIgnoringExceptions(fos);
                            throw throwable;
                        }
                        Utils.closeIgnoringExceptions(fos);
                    }
                    Utils.closeIgnoringExceptions(fos);
                    return bHaveUpdates;
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, " [ checkForUpdate ] Cannot read or write the update conf file: " + parentFDTConfDirName + File.separator + "update.properties");
                }
                return false;
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Got exception checking for updates", t);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static boolean updateFDT(String currentVersion, String updateURL, boolean shouldUpdate, boolean noLock) throws Exception {
        block37: {
            block35: {
                block36: {
                    block34: {
                        Utils.logger.info("Checking remote fdt.jar at URL: " + updateURL);
                        p = Utils.getFDTUpdateProperties();
                        if (p.getProperty("totalRead") == null) {
                            p.put("totalRead", "0");
                        }
                        if (p.getProperty("totalWrite") == null) {
                            p.put("totalWrite", "0");
                        }
                        Utils.checkAndSetInstanceID(p);
                        if (p.getProperty("totalRead_rst") != null) {
                            p.remove("totalRead_rst");
                        }
                        if (p.getProperty("totalWrite_rst") != null) {
                            p.remove("totalWrite_rst");
                        }
                        if ((finalPath = new URI(FDT.class.getProtectionDomain().getCodeSource().getLocation().toString()).getPath()) == null || finalPath.length() == 0) {
                            throw new IOException("Cannot determine the path to current fdt jar");
                        }
                        currentJar = new File(finalPath);
                        if (!currentJar.exists()) {
                            throw new IOException("Current fdt.jar path seems to be [ " + finalPath + " ] but the JVM cannot access it!");
                        }
                        if (!currentJar.isFile() || !currentJar.canWrite()) {
                            throw new IOException("Current fdt.jar path seems to be [ " + finalPath + " ] but it does not have write access!");
                        }
                        Utils.logger.info("\nCurrent fdt.jar path is: " + finalPath);
                        tmpUpdateFile = null;
                        fos = null;
                        connInputStream = null;
                        try {
                            tmpUpdateFile = File.createTempFile("fdt_update_tmp", ".jar");
                            tmpUpdateFile.deleteOnExit();
                            fos = new FileOutputStream(tmpUpdateFile);
                            if (!updateURL.equals(FDT.UPDATE_URL)) ** GOTO lbl68
                            connInputStream = Utils.connectTo(updateURL);
                            Utils.logger.info("OK");
                            jsonObject = Utils.getJsonInfo(connInputStream);
                            tagName = Utils.getTagName(jsonObject);
                            currentVersionString = currentVersion.substring(0, tagName.length());
                            Utils.logger.info("Current version: " + currentVersionString + " Latest version: " + tagName);
                            if (!currentVersionString.equals(tagName)) break block34;
                            Utils.logger.info("No need to update");
                            var14_13 = false;
                        }
                        catch (Throwable var19_26) {
                            Utils.closeIgnoringExceptions(connInputStream);
                            Utils.closeIgnoringExceptions(fos);
                            if (tmpUpdateFile != null) {
                                try {
                                    tmpUpdateFile.delete();
                                }
                                catch (Throwable var20_27) {
                                    // empty catch block
                                }
                            }
                            throw var19_26;
                        }
                        Utils.closeIgnoringExceptions(connInputStream);
                        Utils.closeIgnoringExceptions(fos);
                        if (tmpUpdateFile != null) {
                            try {
                                tmpUpdateFile.delete();
                            }
                            catch (Throwable var15_18) {
                                // empty catch block
                            }
                        }
                        return var14_13;
                    }
                    Utils.logAdditionalInfo(jsonObject);
                    downloadUrl = Utils.getDownloadURL(jsonObject);
                    Utils.downloadFDT(fos, downloadUrl);
                    break block36;
lbl68:
                    // 1 sources

                    Utils.downloadFDT(fos, updateURL);
                }
                jf = new JarFile(tmpUpdateFile);
                mf = jf.getManifest();
                attr = mf.getMainAttributes();
                remoteVersion = attr.getValue("Implementation-Version");
                if (Boolean.getBoolean("skip.version.check")) ** GOTO lbl93
                if (remoteVersion == null || remoteVersion.trim().length() == 0) {
                    throw new Exception("Cannot read the version from the downloaded jar...Cannot compare versions! You can skip version checking by using system property: skip.version.check");
                }
                if (!currentVersion.equals(remoteVersion.trim())) break block35;
                downloadUrl = false;
                Utils.closeIgnoringExceptions(connInputStream);
                Utils.closeIgnoringExceptions(fos);
                if (tmpUpdateFile != null) {
                    try {
                        tmpUpdateFile.delete();
                    }
                    catch (Throwable var15_19) {
                        // empty catch block
                    }
                }
                return downloadUrl;
            }
            Utils.logger.info("Remote FDT version: " + remoteVersion + " Local FDT version: " + currentVersion + ". Update available.");
            break block37;
lbl93:
            // 1 sources

            Utils.logger.info("Skipped version checking.");
        }
        if (shouldUpdate) {
            try {
                parent = currentJar.getParent();
                if (parent == null) {
                    throw new IOException("Unable to determine parent dir for: " + currentJar);
                }
                parentDir = new File(parent);
                if (!parentDir.canWrite()) {
                    Utils.logger.log(Level.WARNING, "[ WARNING CHECK ] The OS reported that is unable to write in parent dir: " + parentDir + " continue anyway; the call might be broken.");
                }
                if (bDel = (bkpJar = new File(parentDir.getPath() + File.separator + "fdt_" + "0.26.3" + ".jar")).exists()) {
                    bDel = bkpJar.delete();
                    if (!bDel) {
                        Utils.logger.info("[ WARNING ] Unable to delete backup jar with the same version: " + bkpJar + " ... will continue");
                    } else {
                        Utils.logger.info("[ INFO ] Backup jar (same version as the update) " + bkpJar + " delete it.");
                    }
                }
                if (!(renameSucced = currentJar.renameTo(bkpJar))) {
                    Utils.logger.log(Level.WARNING, "Unable to create backup: " + bkpJar + " for current FDT before update.");
                } else {
                    Utils.logger.info("Backing up old FDT succeeded: " + bkpJar);
                }
            }
            catch (Throwable t) {
                Utils.logger.log(Level.WARNING, "Unable to create a backup for current FDT before update. Exception: ", t);
            }
            Utils.copyFile2File(tmpUpdateFile, currentJar, noLock);
        }
        var14_17 = true;
        Utils.closeIgnoringExceptions(connInputStream);
        Utils.closeIgnoringExceptions(fos);
        if (tmpUpdateFile != null) {
            try {
                tmpUpdateFile.delete();
            }
            catch (Throwable var15_21) {
                // empty catch block
            }
        }
        return var14_17;
    }

    private static void downloadFDT(FileOutputStream fos, String downloadURL) throws IOException {
        int count;
        if (!downloadURL.endsWith("fdt.jar")) {
            downloadURL = !downloadURL.endsWith("/") ? downloadURL + "/fdt.jar" : downloadURL + "fdt.jar";
        }
        logger.info("Trying to download update from " + downloadURL);
        InputStream downInputStream = Utils.connectTo(downloadURL);
        logger.info("OK");
        byte[] buff = new byte[8192];
        while ((count = downInputStream.read(buff)) > 0) {
            fos.write(buff, 0, count);
        }
        fos.flush();
    }

    private static void logAdditionalInfo(JSONObject jsonObject) throws JSONException {
        Utils.logReleaseName(jsonObject);
        Utils.logPublishDate(jsonObject);
        Utils.logReleaseNotes(jsonObject);
    }

    private static void logReleaseName(JSONObject jsonObject) throws JSONException {
        String name = (String)jsonObject.get("name");
        logger.info("Name: " + name);
    }

    private static void logReleaseNotes(JSONObject jsonObject) throws JSONException {
        String body = (String)jsonObject.get("body");
        logger.info("Release notes: " + body);
    }

    private static String getDownloadURL(JSONObject jsonObject) throws JSONException {
        JSONArray assets = (JSONArray)jsonObject.get("assets");
        JSONObject asset = new JSONObject(assets.get(0).toString());
        String downloadUrl = (String)asset.get("browser_download_url");
        logger.info("FDT download url: " + downloadUrl);
        return downloadUrl;
    }

    private static String logPublishDate(JSONObject jsonObject) throws JSONException {
        String publishedAt = (String)jsonObject.get("published_at");
        logger.info("Publish date: " + publishedAt);
        return publishedAt;
    }

    private static JSONObject getJsonInfo(InputStream connInputStream) throws IOException, JSONException {
        String inputStr;
        BufferedReader streamReader = new BufferedReader(new InputStreamReader(connInputStream, "UTF-8"));
        StringBuilder responseStrBuilder = new StringBuilder(10);
        while ((inputStr = streamReader.readLine()) != null) {
            responseStrBuilder.append(inputStr);
        }
        String response = responseStrBuilder.toString();
        response = Utils.getJsonString(response);
        return new JSONObject(response);
    }

    private static String getTagName(JSONObject jsonObject) throws JSONException {
        String tag_name = (String)jsonObject.get("tag_name");
        logger.info("Latest available version: " + tag_name);
        return tag_name;
    }

    private static String getJsonString(String response) {
        if (response.startsWith("[")) {
            response = response.substring(1);
        }
        if (response.endsWith("]")) {
            response = response.substring(0, response.length() - 1);
        }
        return response;
    }

    private static InputStream connectTo(String updateURL) throws IOException {
        URLConnection urlConnection = new URL(updateURL).openConnection();
        urlConnection.setDefaultUseCaches(false);
        urlConnection.setUseCaches(false);
        urlConnection.setConnectTimeout(20000);
        urlConnection.setReadTimeout(20000);
        logger.info("Connecting ... ");
        urlConnection.connect();
        return urlConnection.getInputStream();
    }

    public static String getUsage() {
        String newline = System.getProperty("line.separator");
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(Utils.class.getResourceAsStream("usage")));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line).append(newline);
            }
            return sb.toString();
        }
        catch (Throwable t) {
            return "Unable to load help msg.";
        }
    }

    public static String md5ToString(byte[] md5sum) {
        StringBuilder sb = new StringBuilder();
        for (byte element : md5sum) {
            sb.append(Integer.toString((element & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile2File(File s, File d, boolean noLock) throws IOException {
        FileChannel srcChannel = null;
        FileChannel dstChannel = null;
        RandomAccessFile raf = null;
        FileOutputStream fos = null;
        try {
            raf = new RandomAccessFile(s, "rw");
            srcChannel = raf.getChannel();
            fos = new FileOutputStream(d);
            dstChannel = fos.getChannel();
            try {
                if (!noLock) {
                    srcChannel.lock();
                } else if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, " [ Utils ] [ copyFile2File ] not taking locks for: " + s);
                }
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Unable to take source file (" + s + ") lock. Will continue without lock taken. Cause: ", t);
            }
            try {
                if (!noLock) {
                    dstChannel.lock();
                } else if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, " [ Utils ] [ copyFile2File ] not taking locks for: " + d);
                }
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Unable to take destination file (" + d + ") lock. Will continue without lock taken. Cause: ", t);
            }
            long tr = dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
            long ss = srcChannel.size();
            long ds = dstChannel.size();
            if (ss != ds || ss != tr) {
                throw new IOException("Different size for sourceFile [ " + s + " ] DestinationFileSize [ " + d + " ] Transferred [ " + tr + " ] ");
            }
        }
        catch (Throwable throwable) {
            Utils.closeIgnoringExceptions(srcChannel);
            Utils.closeIgnoringExceptions(dstChannel);
            Utils.closeIgnoringExceptions(raf);
            Utils.closeIgnoringExceptions(fos);
            throw throwable;
        }
        Utils.closeIgnoringExceptions(srcChannel);
        Utils.closeIgnoringExceptions(dstChannel);
        Utils.closeIgnoringExceptions(raf);
        Utils.closeIgnoringExceptions(fos);
    }

    public static void getRecursiveFiles(String fileName, String remappedFileName, List<String> allFiles, List<String> allRemappedFiles) throws Exception {
        if (allFiles == null) {
            throw new NullPointerException("File list is null");
        }
        File file = new File(fileName);
        if (file.exists() && file.canRead()) {
            if (file.isFile()) {
                allFiles.add(fileName);
                allRemappedFiles.add(remappedFileName);
            } else if (file.isDirectory()) {
                String[] listContents = file.list();
                if (listContents != null && listContents.length > 0) {
                    for (String subFile : listContents) {
                        if (remappedFileName != null) {
                            Utils.getRecursiveFiles(fileName + File.separator + subFile, remappedFileName + File.separator + subFile, allFiles, allRemappedFiles);
                            continue;
                        }
                        Utils.getRecursiveFiles(fileName + File.separator + subFile, null, allFiles, allRemappedFiles);
                    }
                }
            } else {
                allFiles.add(fileName);
                allRemappedFiles.add(remappedFileName);
            }
        }
    }

    public static void closeIgnoringExceptions(FDTCloseable closeable, String downMessage, Throwable downCause) {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close(downMessage, downCause);
                }
                catch (Throwable ign) {
                    if (!logger.isLoggable(Level.FINER)) break block3;
                    logger.log(Level.FINER, "Exceptions closing FDTCloseable '" + closeable + "'. Cause: ", ign);
                }
            }
        }
    }

    public static void closeIgnoringExceptions(Closeable closeable) {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (Throwable ign) {
                    if (!logger.isLoggable(Level.FINER)) break block3;
                    logger.log(Level.FINER, "Exceptions closing Closeable '" + closeable + "'. Cause: ", ign);
                }
            }
        }
    }

    public static void closeIgnoringExceptions(Selector selector) {
        block3: {
            if (selector != null) {
                try {
                    selector.close();
                }
                catch (Throwable ign) {
                    if (!logger.isLoggable(Level.FINER)) break block3;
                    logger.log(Level.FINER, "Exceptions closing Selector '" + selector + "'. Cause: ", ign);
                }
            }
        }
    }

    public static void closeIgnoringExceptions(Socket socket) {
        block3: {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Throwable ign) {
                    if (!logger.isLoggable(Level.FINER)) break block3;
                    logger.log(Level.FINER, "Exceptions closing Socket '" + socket + "'. Cause: ", ign);
                }
            }
        }
    }

    public static void cancelFutureIgnoringException(Future<?> f, boolean mayInterruptIfRunning) {
        block3: {
            if (f != null) {
                try {
                    f.cancel(mayInterruptIfRunning);
                }
                catch (Throwable ign) {
                    if (!logger.isLoggable(Level.FINER)) break block3;
                    logger.log(Level.FINER, "Exceptions canceling Future '" + f + "'. Cause: ", ign);
                }
            }
        }
    }

    public static void closeIgnoringExceptions(ServerSocket serverSocket) {
        block3: {
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (Throwable ign) {
                    if (!logger.isLoggable(Level.FINER)) break block3;
                    logger.log(Level.FINER, "Exceptions closing ServerSocket '" + serverSocket + "'. Cause: ", ign);
                }
            }
        }
    }

    public static String toStringSelectionKey(FDTSelectionKey fsk) {
        if (fsk == null) {
            return " Null FDTSelectionKey ! ";
        }
        StringBuilder sb = new StringBuilder("Socket ");
        try {
            SocketChannel sc = fsk.channel();
            Selector sel = fsk.selector();
            if (sc == null) {
                sb.append(" NULL! ");
            } else {
                sb.append(sc.socket());
                if (sel == null) {
                    sb.append(" NULL SELECTOR! ");
                } else {
                    SelectionKey sk = sc.keyFor(sel);
                    if (sk == null) {
                        sb.append(" no such SelectionKey for selector! ");
                    } else {
                        sb.append(' ').append(Utils.toStringSelectionKey(sk));
                    }
                }
            }
        }
        catch (Throwable t) {
            sb.append(" [ toStringSelectionKey ] Exception ").append(t);
        }
        return sb.toString();
    }

    private static String toStringSelectionKey(SelectionKey sk) {
        StringBuilder sb = new StringBuilder("SelectionKey [ ");
        if (sk.isValid()) {
            sb.append("INVALID");
        } else {
            sb.append("VALID");
            sb.append(" :- interestOps ").append(Utils.toStringSelectionKeyOps(sk.interestOps()));
            sb.append(" :- readyOps").append(Utils.toStringSelectionKeyOps(sk.readyOps()));
        }
        sb.append(" ]");
        return sb.toString();
    }

    public static int compareVersions(String versionString1, String versionString2) {
        if (versionString1 == null && versionString2 == null) {
            return 0;
        }
        if (versionString1 == null || versionString2 == null) {
            if (versionString1 == null) {
                throw new NullPointerException("versionString1 is null");
            }
            if (versionString2 == null) {
                throw new NullPointerException("versionString2 is null");
            }
        }
        return FDTVersion.fromVersionString(versionString1).compareTo(FDTVersion.fromVersionString(versionString2));
    }

    private static String toStringSelectionKeyOps(int keyOps) {
        StringBuilder sb = new StringBuilder("{");
        boolean bAdded = false;
        for (int i = 0; i < SELECTION_KEY_OPS_VALUES.length; ++i) {
            if ((keyOps & SELECTION_KEY_OPS_VALUES[i]) != SELECTION_KEY_OPS_VALUES[i]) continue;
            if (bAdded) {
                sb.append('|');
            } else {
                bAdded = true;
            }
            sb.append(' ').append(SELECTION_KEY_OPS_NAMES[i]).append(' ');
        }
        sb.append('}');
        return sb.toString();
    }

    static String joinString(CharSequence delimiter, CharSequence ... elements) {
        StringBuilder sb = new StringBuilder();
        if (elements.length > 0) {
            sb.append(elements[0]);
        }
        for (int i = 1; i < elements.length; ++i) {
            sb.append(delimiter).append(elements[i]);
        }
        return sb.toString();
    }

    static InetAddress getLoopbackAddress() {
        InetAddress localhost = null;
        try {
            byte[] address = new byte[]{127, 0, 0, 1};
            localhost = InetAddress.getByAddress("localhost", address);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return localhost;
    }

    public static ArrayBlockingQueue<Integer> getTransportPortsValue(Map<String, Object> configMap, String key, int defaultPortNo) {
        ArrayBlockingQueue<Integer> transportPorts = new ArrayBlockingQueue<Integer>(10);
        int i = 0;
        Object obj = configMap.get(key);
        if (obj == null || obj.toString().isEmpty()) {
            transportPorts.add(defaultPortNo);
            return transportPorts;
        }
        String tp = obj.toString();
        StringTokenizer stk = new StringTokenizer(tp, ",");
        String[] s = new String[10];
        while (stk.hasMoreTokens()) {
            s[i] = stk.nextToken();
            transportPorts.add(Integer.parseInt(s[i]));
            ++i;
        }
        return transportPorts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initLocalProps(String level, Properties localProps) {
        FileInputStream fis = null;
        File confFile = null;
        try {
            confFile = new File(System.getProperty("user.home") + File.separator + ".fdt" + File.separator + "fdt.properties");
            if (level.contains("FINE")) {
                logger.info("Using local properties file: " + confFile);
            }
            if (confFile.exists() && confFile.canRead()) {
                fis = new FileInputStream(confFile);
                localProps.load(fis);
            }
        }
        catch (Throwable t) {
            if (confFile != null && level.contains("FINE")) {
                System.err.println("Unable to read local configuration file " + confFile);
                t.printStackTrace();
            }
        }
        finally {
            Utils.closeIgnoringExceptions(fis);
        }
        if (level.contains("FINE")) {
            if (localProps.size() > 0) {
                if (level.contains("FINER")) {
                    logger.info(" LocalProperties loaded: " + localProps);
                }
            } else {
                logger.info("No local properties defined");
            }
        }
    }

    public static void initLogger(String level, File logFile, Properties localProps) {
        Utils.initLocalProps(level, localProps);
        Properties loggingProps = new Properties();
        loggingProps.putAll((Map<?, ?>)localProps);
        try {
            if (!loggingProps.containsKey("handlers")) {
                loggingProps.put("handlers", "java.util.logging.ConsoleHandler");
                loggingProps.put("java.util.logging.ConsoleHandler.level", "FINEST");
                loggingProps.put("java.util.logging.ConsoleHandler.formatter", "java.util.logging.SimpleFormatter");
                loggingProps.put("java.util.logging.SimpleFormatter.format", "%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS %4$s %2$s %5$s%6$s%n");
            }
            if (logFile != null) {
                if (loggingProps.contains("handlers")) {
                    loggingProps.remove("handlers");
                }
                loggingProps.put("handlers", "java.util.logging.FileHandler,java.util.logging.ConsoleHandler");
                loggingProps.put("java.util.logging.ConsoleHandler.level", "FINEST");
                loggingProps.put("java.util.logging.ConsoleHandler.formatter", "java.util.logging.SimpleFormatter");
                loggingProps.put("java.util.logging.SimpleFormatter.format", "%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS %4$s %2$s %5$s%6$s%n");
                loggingProps.put("java.util.logging.FileHandler.level", "FINEST");
                loggingProps.put("java.util.logging.FileHandler.formatter", "java.util.logging.SimpleFormatter");
                loggingProps.put("java.util.logging.FileHandler.pattern", "" + logFile);
                loggingProps.put("java.util.logging.FileHandler.append", "true");
                System.setProperty("CustomLog", "true");
            }
            if (!loggingProps.containsKey(".level")) {
                loggingProps.put(".level", level);
            }
            if (level.contains("FINER")) {
                logger.info("\n Logging props: " + loggingProps);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            loggingProps.store(baos, null);
            LogManager.getLogManager().reset();
            LogManager.getLogManager().readConfiguration(new ByteArrayInputStream(baos.toByteArray()));
        }
        catch (Throwable t) {
            System.err.println(" Got exception setting the logging level ");
            t.printStackTrace();
        }
    }

    public static void waitAndWork(ExecutorService executor, ServerSocket ss, Selector sel, Config config) throws Exception {
        if (config.isGSIModeEnabled()) {
            FDTGSIServer gsiServer = new FDTGSIServer(config.getGSIPort());
            gsiServer.start();
            logger.log(Level.INFO, "FDT started in GSI mode on port: " + config.getGSIPort());
        }
        Utils.waitForTask(executor, ss, sel);
        int transferPort = Utils.getFDTTransferPort(config);
        if (transferPort > 0) {
            FDTServer theServer = new FDTServer(transferPort);
            theServer.doWork();
        } else {
            logger.warning("There are no free transfer ports at this moment, please try again later");
            Utils.waitForTask(executor, ss, sel);
        }
    }

    public static int getFDTTransferPort(Config config) throws Exception {
        ControlChannel cc = new ControlChannel(config.getHostName(), config.getPort(), UUID.randomUUID(), (ControlChannelNotifier)FDTSessionManager.getInstance());
        int transferPort = cc.sendTransferPortMessage(new CtrlMsg(15, "rtp"));
        logger.log(Level.INFO, "Got transfer port: " + config.getHostName() + ":" + transferPort);
        return transferPort;
    }

    /*
     * Unable to fully structure code
     */
    private static void waitForTask(ExecutorService executor, ServerSocket ss, Selector sel) throws Exception {
        try {
            block4: while (true) {
                if ((count = sel.select(2000L)) == 0) {
                    continue;
                }
                it = sel.selectedKeys().iterator();
                while (true) {
                    if (it.hasNext()) ** break;
                    continue block4;
                    sk = it.next();
                    it.remove();
                    if (!sk.isValid() || !sk.isAcceptable()) continue;
                    ssc = (ServerSocketChannel)sk.channel();
                    sc = ssc.accept();
                    try {
                        executor.execute(new AcceptableTask(sc));
                    }
                    catch (Throwable t) {
                        sb = new StringBuilder();
                        sb.append("[ FDT ] [ waitForTask ] got exception in while sumbiting the AcceptableTask for SocketChannel: ").append(sc);
                        if (sc != null) {
                            sb.append(" Socket: ").append(sc.socket());
                        }
                        sb.append(" Cause: ");
                        Utils.logger.log(Level.WARNING, sb.toString(), t);
                    }
                }
                break;
            }
        }
        catch (Throwable t) {
            Utils.logger.log(Level.WARNING, "[FDT] [ waitForTask ] Exception in main loop!", t);
            throw new Exception(t);
        }
    }

    public static boolean isTransferPort(int localPort) {
        return Config.getInstance().getRemoteTransferPorts().contains(localPort);
    }

    static {
        BYTE_MULTIPLIERS = new long[]{1024L, 0x100000L, 0x40000000L, 0x10000000000L, 0x4000000000000L};
        BYTE_SUFIXES = new String[]{"KB", "MB", "GB", "TB", "PB"};
        BIT_MULTIPLIERS = new long[]{1000L, 1000000L, 1000000000L, 1000000000000L, 1000000000000000L};
        BIT_SUFIXES = new String[]{"Kb", "Mb", "Gb", "Tb", "Pb"};
        lock = new Object();
        SECONDS_IN_MINUTE = TimeUnit.MINUTES.toSeconds(1L);
        SECONDS_IN_HOUR = TimeUnit.HOURS.toSeconds(1L);
        SECONDS_IN_DAY = TimeUnit.DAYS.toSeconds(1L);
        SELECTION_KEY_OPS_NAMES = new String[]{"OP_ACCEPT", "OP_CONNECT", "OP_READ", "OP_WRITE"};
        SELECTION_KEY_OPS_VALUES = new int[]{16, 8, 1, 4};
        apmon = null;
        apmonInitied = false;
        int avProcs = Runtime.getRuntime().availableProcessors();
        if (avProcs <= 0) {
            avProcs = 1;
        }
        AV_PROCS = avProcs;
    }
}

