/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import lia.util.net.common.Utils;

public class PartitionMap {
    public static final String osname = System.getProperty("os.name");
    private static final Logger logger = Logger.getLogger(PartitionMap.class.getName());
    private static ConcurrentHashMap<String, Integer> hLocations = new ConcurrentHashMap();

    public static final int getPartition(String fileName) {
        block7: {
            String fLine;
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, " OSName in getPartition ( " + fileName + " ) is " + osname);
            }
            Object[] command = null;
            if (osname.indexOf("Linux") != -1 || osname.indexOf("SunOS") != -1) {
                command = new String[]{"stat", "-L", "-c", "%d", fileName};
            } else if (osname.indexOf("Win") == -1 && osname.indexOf("Mac") != -1) {
                command = new String[]{"stat", "-L", "-f", "%Hd", fileName};
            }
            if (command != null && (fLine = PartitionMap.runICommand(command)) != null) {
                try {
                    return Integer.parseInt(fLine);
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(Level.FINE)) break block7;
                    logger.log(Level.FINE, " [ PartitionMap ] exception parsing line: " + fLine + " for cmd: " + Arrays.toString(command));
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String runICommand(String[] cmd) {
        block15: {
            InputStreamReader esr;
            InputStreamReader isr;
            InputStream es;
            InputStream is;
            BufferedReader err;
            BufferedReader br;
            block14: {
                String string;
                Process pro;
                block13: {
                    String exehome;
                    br = null;
                    err = null;
                    is = null;
                    es = null;
                    isr = null;
                    esr = null;
                    pro = null;
                    if (osname.startsWith("Linux") || osname.startsWith("Mac") || osname.startsWith("SunOS")) {
                        pro = Runtime.getRuntime().exec(cmd, new String[]{"PATH=/bin:/usr/bin:/sbin:/usr/sbin:/usr/local/bin:/usr/local/sbin"});
                    } else if (osname.startsWith("Windows")) {
                        exehome = System.getProperty("user.home");
                        pro = Runtime.getRuntime().exec(exehome + cmd);
                    }
                    if (pro != null) break block13;
                    exehome = null;
                    Utils.closeIgnoringExceptions(err);
                    Utils.closeIgnoringExceptions(br);
                    Utils.closeIgnoringExceptions(isr);
                    Utils.closeIgnoringExceptions(esr);
                    Utils.closeIgnoringExceptions(is);
                    Utils.closeIgnoringExceptions(es);
                    return exehome;
                }
                try {
                    is = pro.getInputStream();
                    es = pro.getErrorStream();
                    isr = new InputStreamReader(is);
                    esr = new InputStreamReader(es);
                    br = new BufferedReader(isr);
                    err = new BufferedReader(esr);
                    String line = null;
                    StringBuilder ret = new StringBuilder();
                    while ((line = err.readLine()) != null) {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.log(Level.FINER, " [ PartitionMap ] [ runICommand ] for cmd: " + Arrays.toString(cmd) + " got smth: " + line + " on stderr ... will ignore stdin");
                        }
                        ret.append(line).append("\n");
                    }
                    if (ret.length() != 0) break block14;
                    String retLine = br.readLine();
                    if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, " [ PartitionMap ] [ runICommand ] for cmd: " + Arrays.toString(cmd) + " read from stdout: " + retLine);
                    }
                    string = retLine;
                }
                catch (Throwable t) {
                    try {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, " [ PartitionMap ] [ runICommand ] got exception for cmd: " + Arrays.toString(cmd), t);
                        }
                        break block15;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        Utils.closeIgnoringExceptions(err);
                        Utils.closeIgnoringExceptions(br);
                        Utils.closeIgnoringExceptions(isr);
                        Utils.closeIgnoringExceptions(esr);
                        Utils.closeIgnoringExceptions(is);
                        Utils.closeIgnoringExceptions(es);
                    }
                }
                Utils.closeIgnoringExceptions(err);
                Utils.closeIgnoringExceptions(br);
                Utils.closeIgnoringExceptions(isr);
                Utils.closeIgnoringExceptions(esr);
                Utils.closeIgnoringExceptions(is);
                Utils.closeIgnoringExceptions(es);
                return string;
            }
            Utils.closeIgnoringExceptions(err);
            Utils.closeIgnoringExceptions(br);
            Utils.closeIgnoringExceptions(isr);
            Utils.closeIgnoringExceptions(esr);
            Utils.closeIgnoringExceptions(is);
            Utils.closeIgnoringExceptions(es);
        }
        return null;
    }

    public static int getPartitionFromCache(File file) {
        String dirPath = "";
        String fileName = file.getAbsolutePath();
        boolean isDir = false;
        if (!file.isDirectory()) {
            int lastIndex = fileName.lastIndexOf(File.separatorChar);
            dirPath = lastIndex != -1 ? fileName.substring(0, lastIndex) : "";
        } else {
            isDir = true;
            dirPath = file.getAbsolutePath();
        }
        Integer value = hLocations.get(isDir ? dirPath : fileName);
        if (value != null) {
            return value;
        }
        int val = PartitionMap.getPartition(fileName);
        hLocations.put(dirPath, val);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, " [ PartitionMap ] [ getPartitionFromCache ] fileName: " + fileName + " partitionID: " + val);
        }
        return val;
    }
}

