/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import lia.util.net.copy.FDT;

public class AboutDialog
extends JDialog {
    private static final Object basicServiceObject = AboutDialog.getBasicServiceObject();
    private static final Class basicServiceClass = AboutDialog.getBasicServiceClass();
    private ImageIcon caltechIcon;

    public AboutDialog(JFrame parent) {
        super(parent, "About...", true);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JLabel l1 = new JLabel("<html><p align=center>FDT - Fast Data Transfer</p></html>", 0);
        JPanel p1 = new JPanel();
        p1.setLayout(new BorderLayout());
        p1.add((Component)l1, "Center");
        this.getContentPane().add(p1);
        l1 = new JLabel("<html><p align=center><font color=#ff0000>http://monalisa.cern.ch/FDT</font></p></html>", 0);
        l1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    URL u = new URL("http://monalisa.cern.ch/FDT");
                    AboutDialog.showDocument(u);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        });
        p1 = new JPanel();
        p1.setLayout(new BorderLayout());
        p1.add((Component)l1, "Center");
        this.getContentPane().add(p1);
        l1 = new JLabel("<html><p align=center>Version <font color=#ff0000>" + FDT.FDT_FULL_VERSION + "</font></p></html>", 0);
        p1 = new JPanel();
        p1.setLayout(new BorderLayout());
        p1.add((Component)l1, "Center");
        this.getContentPane().add(p1);
        l1 = new JLabel(this.getCaltechIcon());
        p1 = new JPanel();
        p1.add((Component)l1, "Center");
        this.getContentPane().add(p1);
        this.setVisible(false);
        this.setSize(200, 100);
        this.setBackground(new Color(0xEFEFEF));
        this.setResizable(false);
        JButton okButton = new JButton("OK");
        okButton.setMinimumSize(new Dimension(190, 22));
        okButton.setPreferredSize(new Dimension(190, 22));
        p1 = new JPanel();
        p1.setLayout(new BorderLayout());
        p1.add((Component)okButton, "Center");
        this.getContentPane().add(p1);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.setVisible(false);
            }
        });
        this.pack();
    }

    public static boolean showDocument(URL url) {
        if (basicServiceObject == null) {
            return false;
        }
        try {
            Method method = basicServiceClass.getMethod("showDocument", URL.class);
            Boolean resultBoolean = (Boolean)method.invoke(basicServiceObject, url);
            return resultBoolean;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex.getMessage());
        }
    }

    private static Object getBasicServiceObject() {
        try {
            Class<?> serviceManagerClass = Class.forName("javax.jnlp.ServiceManager");
            Method lookupMethod = serviceManagerClass.getMethod("lookup", String.class);
            return lookupMethod.invoke(null, "javax.jnlp.BasicService");
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static Class getBasicServiceClass() {
        try {
            return Class.forName("javax.jnlp.BasicService");
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            Dimension bounds = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension abounds = this.getSize();
            this.setLocation((bounds.width - abounds.width) / 2, (bounds.height - abounds.height) / 3);
        }
        super.setVisible(b);
    }

    public Icon getCaltechIcon() {
        if (this.caltechIcon != null) {
            return this.caltechIcon;
        }
        try {
            URL url = this.getClass().getResource("icons/caltech.gif");
            this.caltechIcon = new ImageIcon(url);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.caltechIcon;
    }
}

