/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.NumberFormat;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import lia.util.net.copy.gui.EnhancedJPanel;
import lia.util.net.copy.gui.PreferencesHandler;

public class FDTPropsDialog
extends JDialog
implements KeyListener {
    private static final NumberFormat nf = NumberFormat.getInstance();
    final JFrame parent;
    final JDialog dialog;
    public boolean bDialogOK = false;
    private int sockBufSize = -1;
    private int sockNum = 4;
    private long rateLimit = -1L;
    private int readersCount = 1;
    private int writersCount = 1;
    private int maxPartitionsCount = 100;
    private boolean bComputeMD5 = false;
    private boolean bUseFixedBlocks = false;
    private double transferLimit = -1.0;
    private JTextField textSockBufSize = new JTextField();
    private JTextField textSockNum = new JTextField();
    private JTextField textRateLimit = new JTextField();
    private JTextField textReadersCount = new JTextField();
    private JTextField textWritersCount = new JTextField();
    private JTextField textMaxPartitionsCount = new JTextField();
    private JTextField textComputeMD5 = new JTextField();
    private JTextField textTransferLimit = new JTextField();

    public FDTPropsDialog(JFrame f) {
        super(f, "Connection preferences", true);
        this.dialog = this;
        final EnhancedJPanel mainPanel = new EnhancedJPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        try {
            this.loadPrefs();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.parent = f;
        JPanel sockBufSizePanel = new JPanel();
        sockBufSizePanel.setOpaque(false);
        sockBufSizePanel.setLayout(new BoxLayout(sockBufSizePanel, 0));
        mainPanel.add(sockBufSizePanel);
        sockBufSizePanel.add(new JLabel("SockBufSize: "));
        this.textSockBufSize.setText("" + this.sockBufSize);
        this.textSockBufSize.addKeyListener(this);
        sockBufSizePanel.add(this.textSockBufSize);
        JPanel sockNumPanel = new JPanel();
        sockNumPanel.setOpaque(false);
        sockNumPanel.setLayout(new BoxLayout(sockNumPanel, 0));
        mainPanel.add(sockNumPanel);
        sockNumPanel.add(new JLabel("NoOfStreams: "));
        this.textSockNum.setText("" + this.sockNum);
        this.textSockNum.addKeyListener(this);
        sockNumPanel.add(this.textSockNum);
        JPanel transferLimitPanel = new JPanel();
        transferLimitPanel.setOpaque(false);
        transferLimitPanel.setLayout(new BoxLayout(transferLimitPanel, 0));
        mainPanel.add(transferLimitPanel);
        transferLimitPanel.add(new JLabel("TransferLimit:"));
        this.textTransferLimit.setText(nf.format(this.transferLimit));
        this.textTransferLimit.addKeyListener(this);
        transferLimitPanel.add(this.textTransferLimit);
        final JPanel rateLimitPanel = new JPanel();
        rateLimitPanel.setOpaque(false);
        rateLimitPanel.setLayout(new BoxLayout(rateLimitPanel, 0));
        rateLimitPanel.add(new JLabel("RateLimit: "));
        this.textRateLimit.setText("" + this.rateLimit);
        this.textRateLimit.addKeyListener(this);
        rateLimitPanel.add(this.textRateLimit);
        final JPanel readersCountPanel = new JPanel();
        readersCountPanel.setOpaque(false);
        readersCountPanel.setLayout(new BoxLayout(readersCountPanel, 0));
        readersCountPanel.add(new JLabel("ReadersCount:"));
        this.textReadersCount.setText("" + this.readersCount);
        this.textReadersCount.addKeyListener(this);
        readersCountPanel.add(this.textReadersCount);
        final JPanel writersCountPanel = new JPanel();
        writersCountPanel.setOpaque(false);
        writersCountPanel.setLayout(new BoxLayout(writersCountPanel, 0));
        writersCountPanel.add(new JLabel("WritersCount:"));
        this.textWritersCount.setText("" + this.writersCount);
        this.textWritersCount.addKeyListener(this);
        writersCountPanel.add(this.textWritersCount);
        final JPanel maxPartitionsPanel = new JPanel();
        maxPartitionsPanel.setOpaque(false);
        maxPartitionsPanel.setLayout(new BoxLayout(maxPartitionsPanel, 0));
        maxPartitionsPanel.add(new JLabel("MaxPartitionsCount:"));
        this.textMaxPartitionsCount.setText("" + this.maxPartitionsCount);
        this.textMaxPartitionsCount.addKeyListener(this);
        maxPartitionsPanel.add(this.textMaxPartitionsCount);
        final JPanel computeMD5Panel = new JPanel();
        computeMD5Panel.setOpaque(false);
        computeMD5Panel.setLayout(new BoxLayout(computeMD5Panel, 0));
        computeMD5Panel.add(new JLabel("ComputeMD5:"));
        this.textComputeMD5.setText("" + this.bComputeMD5);
        this.textComputeMD5.addKeyListener(this);
        computeMD5Panel.add(this.textComputeMD5);
        final JPanel advancedPanel = new JPanel();
        advancedPanel.setOpaque(false);
        advancedPanel.setLayout(new BorderLayout());
        mainPanel.add(advancedPanel);
        final JButton advanced = new JButton("Advanced options");
        advancedPanel.add(advanced);
        final JPanel buttonPanel = new JPanel();
        buttonPanel.setOpaque(false);
        buttonPanel.setLayout(new GridLayout(0, 2));
        mainPanel.add(buttonPanel);
        JButton bOK = new JButton("OK");
        bOK.addKeyListener(this);
        bOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!FDTPropsDialog.this.checkParams()) {
                    return;
                }
                FDTPropsDialog.this.bDialogOK = true;
                FDTPropsDialog.this.setVisible(false);
            }
        });
        buttonPanel.add(bOK);
        JButton bCancel = new JButton("Cancel");
        bCancel.addKeyListener(this);
        bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FDTPropsDialog.this.bDialogOK = false;
                FDTPropsDialog.this.setVisible(false);
            }
        });
        buttonPanel.add(bCancel);
        advanced.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (advanced.getText().equals("Advanced options")) {
                    advanced.setText("Basic options");
                    mainPanel.remove(advancedPanel);
                    mainPanel.remove(buttonPanel);
                    mainPanel.add(rateLimitPanel);
                    mainPanel.add(readersCountPanel);
                    mainPanel.add(writersCountPanel);
                    mainPanel.add(maxPartitionsPanel);
                    mainPanel.add(computeMD5Panel);
                    mainPanel.add(advancedPanel);
                    mainPanel.add(buttonPanel);
                    FDTPropsDialog.this.dialog.pack();
                } else {
                    advanced.setText("Advanced options");
                    mainPanel.remove(rateLimitPanel);
                    mainPanel.remove(readersCountPanel);
                    mainPanel.remove(writersCountPanel);
                    mainPanel.remove(maxPartitionsPanel);
                    mainPanel.remove(computeMD5Panel);
                    FDTPropsDialog.this.dialog.pack();
                }
            }
        });
        this.getContentPane().setLayout(new BorderLayout(2, 2));
        this.getContentPane().add((Component)mainPanel, "Center");
        this.setDefaultCloseOperation(0);
        this.setSize(330, 330);
        this.setLocationRelativeTo(this.parent);
        this.pack();
    }

    private final boolean checkParams() {
        int tmpSockBufSize = this.sockBufSize;
        int tmpSockNum = this.sockNum;
        long tmpRateLimit = this.rateLimit;
        int tmpReadersCount = this.readersCount;
        int tmpWritersCount = this.writersCount;
        int tmpMaxPartitionsCount = this.maxPartitionsCount;
        boolean tmpBComputeMD5 = this.bComputeMD5;
        double tmpTransferLimit = this.transferLimit;
        String s = this.textSockBufSize.getText();
        if (s != null && s.length() != 0) {
            try {
                tmpSockBufSize = Integer.parseInt(s);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.parent, "You must enter a valid value for SockBufSize");
                return false;
            }
        }
        if ((s = this.textSockNum.getText()) != null && s.length() != 0) {
            try {
                tmpSockNum = Integer.parseInt(s);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.parent, "You must enter a valid value for NoOfStreams");
                return false;
            }
        }
        if ((s = this.textRateLimit.getText()) != null && s.length() != 0) {
            try {
                tmpRateLimit = Long.parseLong(s);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.parent, "You must enter a valid value for RateLimit");
                return false;
            }
        }
        if ((s = this.textReadersCount.getText()) != null && s.length() != 0) {
            try {
                tmpReadersCount = Integer.parseInt(s);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.parent, "You must enter a valid value for ReadersCount");
                return false;
            }
        }
        if ((s = this.textWritersCount.getText()) != null && s.length() != 0) {
            try {
                tmpWritersCount = Integer.parseInt(s);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.parent, "You must enter a valid value for WritersCount");
                return false;
            }
        }
        if ((s = this.textMaxPartitionsCount.getText()) != null && s.length() != 0) {
            try {
                tmpMaxPartitionsCount = Integer.parseInt(s);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.parent, "You must enter a valid value for MaxPartitionsCount");
                return false;
            }
        }
        if ((s = this.textComputeMD5.getText()) != null && s.length() != 0) {
            try {
                tmpBComputeMD5 = Boolean.valueOf(s);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.parent, "You must entera vald value for ComputeMD5");
                return false;
            }
        }
        if ((s = this.textTransferLimit.getText()) != null && s.length() != 0) {
            try {
                tmpTransferLimit = Double.valueOf(s);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.parent, "You must enter a valid value for TransferLimit");
                return false;
            }
        }
        this.sockBufSize = tmpSockBufSize;
        this.sockNum = tmpSockNum;
        this.rateLimit = tmpRateLimit;
        this.readersCount = tmpReadersCount;
        this.writersCount = tmpWritersCount;
        this.maxPartitionsCount = tmpMaxPartitionsCount;
        this.bComputeMD5 = tmpBComputeMD5;
        this.transferLimit = tmpTransferLimit;
        this.savePrefs();
        return true;
    }

    private final void loadPrefs() {
        String s = PreferencesHandler.get("sockBufSize", "" + this.sockBufSize);
        try {
            this.sockBufSize = Integer.parseInt(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        s = PreferencesHandler.get("sockNum", "" + this.sockNum);
        try {
            this.sockNum = Integer.parseInt(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        s = PreferencesHandler.get("rateLimit", "" + this.rateLimit);
        try {
            this.rateLimit = Long.parseLong(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        s = PreferencesHandler.get("readersCount", "" + this.readersCount);
        try {
            this.readersCount = Integer.parseInt(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        s = PreferencesHandler.get("writersCount", "" + this.writersCount);
        try {
            this.writersCount = Integer.parseInt(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        s = PreferencesHandler.get("maxPartitionsCount", "" + this.maxPartitionsCount);
        try {
            this.maxPartitionsCount = Integer.parseInt(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.bComputeMD5 = PreferencesHandler.getBoolean("computeMD5", this.bComputeMD5);
        s = PreferencesHandler.get("transferLimit", nf.format(this.transferLimit));
        try {
            this.transferLimit = Double.parseDouble(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void savePrefs() {
        PreferencesHandler.put("sockBufSize", "" + this.sockBufSize);
        PreferencesHandler.put("sockNum", "" + this.sockNum);
        PreferencesHandler.put("rateLimit", "" + this.rateLimit);
        PreferencesHandler.put("readersCount", "" + this.readersCount);
        PreferencesHandler.put("writersCount", "" + this.writersCount);
        PreferencesHandler.put("maxPartitionsCount", "" + this.maxPartitionsCount);
        PreferencesHandler.putBoolean("computeMD5", this.bComputeMD5);
        PreferencesHandler.put("transferLimit", nf.format(this.transferLimit));
        PreferencesHandler.save();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.bDialogOK = false;
            this.setVisible(false);
            return;
        }
        if (e.getKeyCode() == 10) {
            if (!this.checkParams()) {
                return;
            }
            this.bDialogOK = true;
            this.setVisible(false);
            return;
        }
    }

    @Override
    public void setVisible(boolean v) {
        if (v) {
            this.setLocationRelativeTo(this.parent);
            this.pack();
        }
        super.setVisible(v);
    }

    public boolean isBComputeMD5() {
        return this.bComputeMD5;
    }

    public boolean isBUseFixedBlocks() {
        return this.bUseFixedBlocks;
    }

    public int getMaxPartitionsCount() {
        return this.maxPartitionsCount;
    }

    public long getRateLimit() {
        return this.rateLimit;
    }

    public int getReadersCount() {
        return this.readersCount;
    }

    public int getSockNum() {
        return this.sockNum;
    }

    public int getSockBufSize() {
        return this.sockBufSize;
    }

    public double getTransferLimit() {
        return this.transferLimit;
    }

    public int getWritersCount() {
        return this.writersCount;
    }

    static {
        nf.setMaximumFractionDigits(2);
    }
}

