/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import lia.util.net.copy.gui.FolderFrame;
import lia.util.net.copy.gui.RemoteSessionManager;
import lia.util.net.copy.gui.StatusBar;
import lia.util.net.copy.gui.TransferMonitor;
import lia.util.net.copy.gui.session.LocalSession;
import lia.util.net.copy.gui.session.Session;

public class FolderTable
extends JPanel {
    public static final Color cg = new Color(217, 217, 217);
    public static final Color cm = new JPanel().getBackground();
    static final ExecutorService exec = Executors.newCachedThreadPool();
    private static final String[] colNames = new String[]{"Icon", "Name", "Modified", "Size", "##"};
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yy HH:mm:ss");
    private static final NumberFormat nf = NumberFormat.getInstance(Locale.US);
    private static final Color c1 = new Color(128, 179, 230);
    private static final Color c2 = new Color(220, 234, 248);
    private static final Color c22 = new Color(226, 241, 255);
    private static final Color c3 = new Color(200, 200, 200);
    private static final Color c4 = new Color(245, 255, 255);
    private static final Color c44 = new Color(255, 255, 255);
    public static TransferMonitor transferMonitor = null;
    final FolderTable ft;
    private final Vector<String> columns = new Vector();
    private final String pack = "/" + this.getClass().getPackage().getName().replace(".", "/");
    private final StatusBar statusBar;
    private final Vector<FileHandler> rows = new Vector();
    private final MyTableHeaderRenderer headerRenderer = new MyTableHeaderRenderer();
    private final MyTableCellRenderer cellRenderer = new MyTableCellRenderer();
    private final RemoteSessionManager manager;
    public JComboBox roots;
    public JLabel freeSpace;
    public JLabel parentDir;
    public JLabel rootDir;
    public JLabel homeDir;
    public JLabel refreshDir;
    public JLabel openDir;
    public JLabel separator;
    public JLabel mkdir;
    public JLabel remove;
    public JMenu visibleColumns;
    public JMenu command;
    public JScrollPane scroll;
    public Session session;
    long lastTimeKeyPressed = System.currentTimeMillis();
    String currentKeys = "";
    ImageIcon upDirIcon;
    ImageIcon rootIcon;
    ImageIcon copyIcon;
    ImageIcon exitIcon;
    ImageIcon openDirIcon;
    ImageIcon refreshIcon;
    ImageIcon openHomeIcon;
    ImageIcon selectIcon;
    ImageIcon sortAIcon;
    ImageIcon sortDIcon;
    ImageIcon mkdirIcon;
    ImageIcon removeIcon;
    ImageIcon connIcon;
    ImageIcon verticalIcon;
    private JTable table;
    private JPopupMenu popup;
    private boolean showIcon = true;
    private boolean showLength = true;
    private boolean showModif = true;
    private boolean showAttrib = true;
    private String sortColumn = "Name";
    private boolean sortAsc = true;
    private JMenuItem showIconItem;
    private JMenuItem showLengthItem;
    private JMenuItem showModifItem;
    private JMenuItem showAttribItem;
    private JMenuItem copy;
    private JMenuItem exit;
    private JPanel connectPanel;
    private JPanel tablePanel;
    private boolean showSelection = true;
    private String currentDir = null;
    private String lastDir = null;
    private String selectedDir = null;
    private FolderFrame frame;
    private long lastClick = 0L;
    private int lastRow = -1;

    public FolderTable(final Session session, final RemoteSessionManager manager, StatusBar statusBar, FolderFrame focusListener) {
        this.ft = this;
        this.frame = focusListener;
        this.statusBar = statusBar;
        this.manager = manager;
        this.session = session;
        this.popup = this.createPopup();
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new BorderLayout());
        this.tablePanel.setOpaque(false);
        this.setLayout(new BorderLayout());
        MyTableModel model = new MyTableModel();
        this.table = new JTable(model);
        this.table.setAutoResizeMode(2);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        JTableHeader header = this.table.getTableHeader();
        header.addMouseListener(new ColumnHeaderListener());
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 0x10) != 0) {
                    FolderTable.this.table.requestFocusInWindow();
                    if (!FolderTable.this.isDoubleClick(e)) {
                        return;
                    }
                    int row = FolderTable.this.table.getSelectedRow();
                    if (row < 0 || row >= FolderTable.this.rows.size()) {
                        return;
                    }
                    final FileHandler fh = (FileHandler)FolderTable.this.rows.get(row);
                    if (fh.getSizeL() > 0L) {
                        return;
                    }
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            FolderTable.this.ft.setEnabled(false);
                            try {
                                if (fh.getName().equals("..")) {
                                    FolderTable.this.lastDir = session.getWorkingDir();
                                    if (FolderTable.this.lastDir.contains(session.getFileSeparator())) {
                                        FolderTable.this.lastDir = FolderTable.this.lastDir.substring(FolderTable.this.lastDir.lastIndexOf(session.getFileSeparator()) + 1);
                                    }
                                    session.setUpDir();
                                } else {
                                    session.setRelativeDir(fh.getName());
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            FolderTable.this.updateTable();
                            FolderTable.this.ft.setEnabled(true);
                        }
                    };
                    exec.execute(r);
                    e.consume();
                    return;
                }
                if ((e.getModifiers() & 4) != 0) {
                    FolderTable.this.table.requestFocusInWindow();
                    FolderTable.this.popup.show(e.getComponent(), e.getX(), e.getY());
                    FolderTable.this.table.requestFocusInWindow();
                    return;
                }
            }
        };
        this.table.addMouseListener(mouseListener);
        this.table.addFocusListener(focusListener);
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int key = e.getKeyCode();
                if (key == 10) {
                    if (FolderTable.this.table.getSelectedRowCount() > 1) {
                        FolderTable.this.setStatus("Unable to cd... more than one files selected");
                        return;
                    }
                    int row = FolderTable.this.table.getSelectedRow();
                    if (row < 0 || row >= FolderTable.this.rows.size()) {
                        return;
                    }
                    final FileHandler fh = (FileHandler)FolderTable.this.rows.get(row);
                    if (fh.getSizeL() > 0L) {
                        FolderTable.this.setStatus("Unable to cd... normal file selected");
                        return;
                    }
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            FolderTable.this.ft.setEnabled(false);
                            if (fh.getName().equals("..")) {
                                FolderTable.this.lastDir = session.getWorkingDir();
                                if (FolderTable.this.lastDir.contains(session.getFileSeparator())) {
                                    FolderTable.this.lastDir = FolderTable.this.lastDir.substring(FolderTable.this.lastDir.lastIndexOf(session.getFileSeparator()) + 1);
                                }
                                try {
                                    session.setUpDir();
                                }
                                catch (Exception e) {
                                    JOptionPane.showMessageDialog(FolderTable.this.ft, e.toString());
                                }
                            } else {
                                try {
                                    session.setRelativeDir(fh.getName());
                                }
                                catch (Exception e) {
                                    JOptionPane.showMessageDialog(FolderTable.this.ft, e.toString());
                                }
                            }
                            FolderTable.this.updateTable();
                            FolderTable.this.ft.setEnabled(true);
                        }
                    };
                    exec.execute(r);
                    e.consume();
                    return;
                }
                if (key == 116) {
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            FolderTable.this.copy();
                        }
                    };
                    exec.execute(r);
                    e.consume();
                    return;
                }
                if (key == 118) {
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            FolderTable.this.makeDir();
                        }
                    };
                    exec.execute(r);
                    e.consume();
                    return;
                }
                if (key == 119 || key == 127) {
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            FolderTable.this.removeFiles();
                        }
                    };
                    exec.execute(r);
                    e.consume();
                    return;
                }
                if (key == 121) {
                    System.exit(0);
                }
                if (key == 9) {
                    if (FolderTable.this.command == null) {
                        if (manager.getLocalTable().table != null) {
                            manager.getLocalTable().table.requestFocusInWindow();
                        }
                    } else if (manager.getRemoteTable().table != null) {
                        manager.getRemoteTable().table.requestFocusInWindow();
                    }
                    e.consume();
                    return;
                }
                char c = e.getKeyChar();
                if (Character.isDefined(c)) {
                    long now = System.currentTimeMillis();
                    FolderTable.this.currentKeys = now - FolderTable.this.lastTimeKeyPressed < 1300L ? FolderTable.this.currentKeys + c : "" + c;
                    FolderTable.this.lastTimeKeyPressed = now;
                    FolderTable.this.selectStartWith(FolderTable.this.currentKeys);
                }
            }
        });
        this.table.setShowGrid(false);
        this.table.setShowVerticalLines(false);
        this.tablePanel.addMouseListener(mouseListener);
        this.tablePanel.add((Component)this.table.getTableHeader(), "North");
        this.scroll = new JScrollPane(this.table);
        this.scroll.addMouseListener(mouseListener);
        this.tablePanel.add((Component)this.scroll, "Center");
        String[] rs = null;
        try {
            rs = session.getRoots();
        }
        catch (Exception e) {
            rs = new String[]{};
            JOptionPane.showMessageDialog(this.ft, e.toString());
        }
        this.roots = new JComboBox<String>(rs);
        this.roots.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                final String root = (String)FolderTable.this.roots.getSelectedItem();
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        FolderTable.this.ft.setEnabled(false);
                        FolderTable.this.table.requestFocusInWindow();
                        try {
                            session.setAbsoluteDir(root);
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(FolderTable.this.ft, e.toString());
                        }
                        FolderTable.this.updateTable();
                        FolderTable.this.ft.setEnabled(true);
                    }
                };
                exec.execute(r);
            }
        });
        this.parentDir = new JLabel("");
        this.parentDir.setIcon(this.getUpDirIcon());
        this.parentDir.setToolTipText("Parent directory");
        this.parentDir.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        FolderTable.this.ft.setEnabled(false);
                        FolderTable.this.table.requestFocusInWindow();
                        FolderTable.this.lastDir = session.getWorkingDir();
                        if (FolderTable.this.lastDir.contains(session.getFileSeparator())) {
                            FolderTable.this.lastDir = FolderTable.this.lastDir.substring(FolderTable.this.lastDir.lastIndexOf(session.getFileSeparator()) + 1);
                        }
                        try {
                            session.setUpDir();
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(FolderTable.this.ft, e.toString());
                        }
                        FolderTable.this.updateTable();
                        FolderTable.this.ft.setEnabled(true);
                    }
                };
                exec.execute(r);
            }
        });
        this.freeSpace = new JLabel("");
        this.freeSpace.setToolTipText("Amount of available space on the current partition");
        this.rootDir = new JLabel("");
        this.rootDir.setIcon(this.getRootIcon());
        this.rootDir.setToolTipText("Root directory");
        this.rootDir.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        FolderTable.this.table.requestFocusInWindow();
                        String item = (String)FolderTable.this.roots.getSelectedItem();
                        if (item == null) {
                            return;
                        }
                        FolderTable.this.ft.setEnabled(false);
                        String r = null;
                        r = session.getOSName().toLowerCase(Locale.US).contains("linux") ? "/" : session.getShortRootName(item);
                        if (r == null) {
                            FolderTable.this.ft.setEnabled(true);
                            return;
                        }
                        try {
                            session.setAbsoluteDir(r);
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(FolderTable.this.ft, e.toString());
                        }
                        FolderTable.this.updateTable();
                        FolderTable.this.ft.setEnabled(true);
                    }
                };
                exec.execute(r);
            }
        });
        this.homeDir = new JLabel("");
        this.homeDir.setIcon(this.getHomeIcon());
        this.homeDir.setToolTipText("Open home directory");
        this.homeDir.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        FolderTable.this.table.requestFocusInWindow();
                        String userDir = session.getUserDir();
                        if (userDir == null) {
                            return;
                        }
                        FolderTable.this.ft.setEnabled(false);
                        try {
                            session.setAbsoluteDir(userDir);
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(FolderTable.this.ft, e.toString());
                        }
                        FolderTable.this.updateTable();
                        FolderTable.this.ft.setEnabled(true);
                    }
                };
                exec.execute(r);
            }
        });
        this.openDir = new JLabel("");
        this.openDir.setIcon(this.getOpenDirIcon());
        this.openDir.setToolTipText("Open directory");
        this.openDir.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                final String root = JOptionPane.showInputDialog(FolderTable.this.roots, "Open folder:", session.getWorkingDir());
                if (root == null) {
                    return;
                }
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        FolderTable.this.table.requestFocusInWindow();
                        FolderTable.this.ft.setEnabled(false);
                        try {
                            session.setAbsoluteDir(root);
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(FolderTable.this.ft, e.toString());
                        }
                        FolderTable.this.updateTable();
                        FolderTable.this.ft.setEnabled(true);
                    }
                };
                exec.execute(r);
            }
        });
        this.refreshDir = new JLabel("");
        this.refreshDir.setIcon(this.getRefreshIcon());
        this.refreshDir.setToolTipText("Refresh");
        this.refreshDir.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        FolderTable.this.table.requestFocusInWindow();
                        FolderTable.this.ft.setEnabled(false);
                        String[] str = null;
                        try {
                            str = session.getRoots();
                        }
                        catch (Exception e) {
                            str = new String[]{};
                            JOptionPane.showMessageDialog(FolderTable.this.ft, e.toString());
                        }
                        ActionListener listener = null;
                        if (FolderTable.this.roots.getActionListeners() != null && FolderTable.this.roots.getActionListeners().length != 0) {
                            listener = FolderTable.this.roots.getActionListeners()[0];
                            FolderTable.this.roots.removeActionListener(listener);
                        }
                        FolderTable.this.roots.removeAllItems();
                        if (str != null) {
                            for (int i = 0; i < str.length; ++i) {
                                FolderTable.this.roots.addItem(str[i]);
                            }
                        }
                        if (listener != null) {
                            FolderTable.this.roots.addActionListener(listener);
                        }
                        try {
                            session.setAbsoluteDir(session.getWorkingDir());
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(FolderTable.this.ft, e.toString());
                        }
                        FolderTable.this.updateTable();
                        FolderTable.this.ft.setEnabled(true);
                    }
                };
                exec.execute(r);
            }
        });
        this.separator = new JLabel("");
        this.separator.setIcon(this.getVertIcon());
        this.mkdir = new JLabel("");
        this.mkdir.setIcon(this.getMkDirIcon());
        this.mkdir.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        FolderTable.this.table.requestFocusInWindow();
                        FolderTable.this.makeDir();
                    }
                };
                exec.execute(r);
            }
        });
        this.mkdir.setToolTipText("Create directory");
        this.remove = new JLabel("");
        this.remove.setIcon(this.getRemoveIcon());
        this.remove.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        FolderTable.this.table.requestFocusInWindow();
                        FolderTable.this.removeFiles();
                    }
                };
                exec.execute(r);
            }
        });
        this.remove.setToolTipText("Delete");
        this.visibleColumns = new JMenu("Display columns");
        this.showIconItem = new JMenuItem("Icon");
        this.showIconItem.setIcon(this.getSelectIcon());
        this.setSelectedItem(this.showIconItem, true);
        this.showIconItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        FolderTable.this.table.requestFocusInWindow();
                        FolderTable.this.setShowIcon(!FolderTable.this.showIcon);
                        if (!FolderTable.this.showIcon) {
                            FolderTable.this.showIconItem.setIcon(null);
                            FolderTable.this.setSelectedItem(FolderTable.this.showIconItem, false);
                        } else {
                            FolderTable.this.showIconItem.setIcon(FolderTable.this.getSelectIcon());
                            FolderTable.this.setSelectedItem(FolderTable.this.showIconItem, true);
                        }
                    }
                };
                exec.execute(r);
            }
        });
        this.visibleColumns.add(this.showIconItem);
        this.showLengthItem = new JMenuItem("Size");
        this.showLengthItem.setIcon(this.getSelectIcon());
        this.setSelectedItem(this.showLengthItem, true);
        this.showLengthItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        FolderTable.this.table.requestFocusInWindow();
                        FolderTable.this.setShowLength(!FolderTable.this.showLength);
                        if (!FolderTable.this.showLength) {
                            FolderTable.this.showLengthItem.setIcon(null);
                            FolderTable.this.setSelectedItem(FolderTable.this.showLengthItem, false);
                        } else {
                            FolderTable.this.showLengthItem.setIcon(FolderTable.this.getSelectIcon());
                            FolderTable.this.setSelectedItem(FolderTable.this.showLengthItem, true);
                        }
                    }
                };
                exec.execute(r);
            }
        });
        this.visibleColumns.add(this.showLengthItem);
        this.showModifItem = new JMenuItem("Modified");
        this.showModifItem.setIcon(this.getSelectIcon());
        this.setSelectedItem(this.showModifItem, true);
        this.showModifItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        FolderTable.this.table.requestFocusInWindow();
                        FolderTable.this.setShowModif(!FolderTable.this.showModif);
                        if (!FolderTable.this.showModif) {
                            FolderTable.this.showModifItem.setIcon(null);
                            FolderTable.this.setSelectedItem(FolderTable.this.showModifItem, false);
                        } else {
                            FolderTable.this.showModifItem.setIcon(FolderTable.this.getSelectIcon());
                            FolderTable.this.setSelectedItem(FolderTable.this.showModifItem, true);
                        }
                    }
                };
                exec.execute(r);
            }
        });
        this.visibleColumns.add(this.showModifItem);
        this.showAttribItem = new JMenuItem("Attributes");
        this.showAttribItem.setIcon(this.getSelectIcon());
        this.setSelectedItem(this.showAttribItem, true);
        this.showAttribItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        FolderTable.this.table.requestFocusInWindow();
                        FolderTable.this.setShowAttrib(!FolderTable.this.showAttrib);
                        if (!FolderTable.this.showAttrib) {
                            FolderTable.this.showAttribItem.setIcon(null);
                            FolderTable.this.setSelectedItem(FolderTable.this.showAttribItem, false);
                        } else {
                            FolderTable.this.showAttribItem.setIcon(FolderTable.this.getSelectIcon());
                            FolderTable.this.setSelectedItem(FolderTable.this.showAttribItem, true);
                        }
                    }
                };
                exec.execute(r);
            }
        });
        this.visibleColumns.add(this.showAttribItem);
        if (session instanceof LocalSession) {
            this.command = new JMenu("Command");
            this.copy = new JMenuItem("F5 Copy");
            this.copy.setIcon(this.getCopyIcon());
            this.copy.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            FolderTable.this.copy();
                        }
                    };
                    exec.execute(r);
                }
            });
            this.command.add(this.copy);
            this.exit = new JMenuItem("F10 Exit");
            this.exit.setIcon(this.getExitIcon());
            this.exit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    System.exit(0);
                }
            });
            this.command.addSeparator();
            this.command.add(this.exit);
            this.updateTable();
        }
        this.updateColumns();
        this.createConnectPanel();
        if (session instanceof LocalSession) {
            this.add((Component)this.tablePanel, "Center");
        } else {
            this.setConnected(false);
        }
    }

    private void removeCurrentDir() {
        if (this.currentDir != null) {
            ActionListener listener = null;
            if (this.roots.getActionListeners() != null && this.roots.getActionListeners().length != 0) {
                listener = this.roots.getActionListeners()[0];
                this.roots.removeActionListener(listener);
            }
            for (int i = 0; i < this.roots.getItemCount(); ++i) {
                if (!this.roots.getItemAt(i).toString().equals(this.currentDir)) continue;
                this.roots.removeItemAt(i);
                break;
            }
            if (listener != null) {
                this.roots.addActionListener(listener);
            }
            this.currentDir = null;
        }
    }

    private final boolean isDoubleClick(MouseEvent e) {
        long diff;
        int row = this.table.getSelectedRow();
        if (this.table.getSelectedRowCount() > 1) {
            return false;
        }
        if (e.getClickCount() >= 2) {
            this.lastClick = 0L;
            this.lastRow = row;
            return true;
        }
        if (this.lastClick > 0L && (diff = System.currentTimeMillis() - this.lastClick) < 500L) {
            this.lastClick = 0L;
            boolean ret = row == this.lastRow;
            this.lastRow = row;
            return ret;
        }
        this.lastClick = System.currentTimeMillis();
        this.lastRow = row;
        return false;
    }

    public boolean focus() {
        return this.table.hasFocus();
    }

    private void createConnectPanel() {
        this.connectPanel = new JPanel();
        this.connectPanel.setLayout(new BoxLayout(this.connectPanel, 0));
        JPanel pp1 = new JPanel();
        pp1.setLayout(new GridLayout(0, 1));
        this.connectPanel.add(pp1);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        JLabel l = new JLabel("<html><p align=justify>Please specify connection preferences</p></html>");
        p.add(Box.createVerticalGlue());
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout());
        p1.add(l);
        p.add(p1);
        pp1.add(p);
        JButton connect = new JButton("Connect");
        connect.setIcon(this.getConnIcon());
        connect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((FolderTable)FolderTable.this).frame.connect.setVisible(true);
                ((FolderTable)FolderTable.this).frame.connect.toFront();
                if (((FolderTable)FolderTable.this).frame.connect.bDialogOK) {
                    ((FolderTable)FolderTable.this).frame.manager.initiated = false;
                    int port = 54321;
                    try {
                        port = Integer.valueOf(((FolderTable)FolderTable.this).frame.connect.sPort);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    ((FolderTable)FolderTable.this).frame.manager.connect(((FolderTable)FolderTable.this).frame.connect.sHost, ((FolderTable)FolderTable.this).frame.connect.sUser, port);
                } else {
                    ((FolderTable)FolderTable.this).frame.manager.initiated = true;
                }
            }
        });
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p1 = new JPanel();
        p1.setLayout(new FlowLayout());
        p1.add(connect);
        p.add(p1);
        p.add(Box.createVerticalGlue());
        pp1.add(p);
    }

    private JPopupMenu createPopup() {
        this.popup = new JPopupMenu();
        JMenuItem copy = new JMenuItem("Copy");
        copy.setIcon(this.getCopyIcon());
        copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        FolderTable.this.copy();
                    }
                };
                exec.execute(r);
            }
        });
        copy.setToolTipText("Copy");
        this.popup.add(copy);
        JMenuItem mkdir = new JMenuItem("Make dir");
        mkdir.setIcon(this.getMkDirIcon());
        mkdir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        FolderTable.this.makeDir();
                    }
                };
                exec.execute(r);
            }
        });
        mkdir.setToolTipText("Create directory");
        this.popup.add(mkdir);
        JMenuItem remove = new JMenuItem("Remove");
        remove.setIcon(this.getRemoveIcon());
        remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        FolderTable.this.removeFiles();
                    }
                };
                exec.execute(r);
            }
        });
        remove.setToolTipText("Delete");
        this.popup.add(remove);
        this.popup.addSeparator();
        JMenuItem quit = new JMenuItem("Quit");
        quit.setIcon(this.getExitIcon());
        quit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        System.exit(0);
                    }
                };
                exec.execute(r);
            }
        });
        quit.setToolTipText("Exit");
        this.popup.add(quit);
        return this.popup;
    }

    protected void removeFiles() {
        int i;
        int[] rs = this.table.getSelectedRows();
        if (rs == null || rs.length == 0) {
            return;
        }
        this.ft.setEnabled(false);
        Vector<FileHandler> v = new Vector<FileHandler>();
        for (i = 0; i < rs.length; ++i) {
            if (rs[i] < 0 || rs[i] >= this.rows.size()) continue;
            FileHandler fh = this.rows.get(rs[i]);
            v.add(fh);
        }
        if (v.size() == 0) {
            this.ft.setEnabled(true);
            return;
        }
        for (i = 0; i < v.size(); ++i) {
            String fName = ((FileHandler)v.get(i)).getName();
            if (!fName.equals("..") && !fName.equals(".")) continue;
            v.remove(i);
            --i;
        }
        if (v.size() == 0) {
            this.ft.setEnabled(true);
            return;
        }
        String[] files = new String[v.size()];
        String delim = this.session.getFileSeparator();
        if (delim == null) {
            return;
        }
        String cp = this.session.getWorkingDir();
        if (cp == null) {
            return;
        }
        if (!cp.endsWith(delim)) {
            cp = cp + delim;
        }
        StringBuffer buf = new StringBuffer();
        System.out.println("About to delete:");
        buf.append("<html>Delete file").append(files.length > 1 ? "s" : "").append("<br>");
        for (int i2 = 0; i2 < files.length; ++i2) {
            files[i2] = cp + ((FileHandler)v.get(i2)).getName();
            if (i2 >= 7) continue;
            System.out.println("\t" + files[i2]);
            buf.append("&nbsp;&nbsp;<font color=#ff0000>").append(((FileHandler)v.get(i2)).getName()).append("</font>");
            if (i2 >= files.length - 1 || i2 >= 6) continue;
            buf.append("<br>");
        }
        if (files.length > 7) {
            System.out.println("... " + (files.length - 7) + " more");
            buf.append("<br>...").append(files.length - 7).append(" more ?");
        } else {
            buf.append(" ?");
        }
        int ret = JOptionPane.showConfirmDialog(this.ft, buf.toString(), "Confirm", 0);
        if (ret == 0) {
            try {
                this.session.removeFiles(files);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.ft, e.toString());
            }
        }
        this.setConnected(true);
        this.ft.setEnabled(true);
    }

    protected void makeDir() {
        this.ft.setEnabled(false);
        String name = JOptionPane.showInputDialog(this.ft, (Object)"Enter the name of the directory");
        if (name != null && name.length() > 0 && this.session != null) {
            String delim = this.session.getFileSeparator();
            if (delim == null) {
                return;
            }
            String cp = this.session.getWorkingDir();
            if (cp == null) {
                return;
            }
            if (!cp.endsWith(delim)) {
                cp = cp + delim;
            }
            try {
                this.session.createDir(cp + name);
                this.selectedDir = name;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.ft, e.toString());
            }
            this.setConnected(true);
        }
        this.ft.setEnabled(true);
        this.selectedDir = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copy() {
        NumberFormat numberFormat = nf;
        synchronized (numberFormat) {
            if (transferMonitor == null) {
                transferMonitor = new TransferMonitor(this.ft, this.command != null, this.manager);
            }
        }
        if (this.manager == null) {
            return;
        }
        if (!this.manager.isConnected()) {
            JOptionPane.showMessageDialog(this.ft, "Please connect first to the remote server");
            return;
        }
        if (!transferMonitor.finished()) {
            return;
        }
        int[] rs = this.table.getSelectedRows();
        if (rs == null || rs.length == 0) {
            this.setStatus("Unable to cp... no file is selected");
            return;
        }
        this.ft.setEnabled(false);
        Vector<FileHandler> v = new Vector<FileHandler>();
        for (int i = 0; i < rs.length; ++i) {
            if (rs[i] < 0 || rs[i] >= this.rows.size()) continue;
            FileHandler fh = this.rows.get(rs[i]);
            v.add(fh);
        }
        if (v.size() == 0) {
            this.ft.setEnabled(true);
            this.setStatus("Unable to cp... no file is selected");
            return;
        }
        String[] files = new String[v.size()];
        boolean isRecursive = false;
        this.setStatus("Copying...");
        String delim = this.session.getFileSeparator();
        String cp = this.session.getWorkingDir();
        if (!cp.endsWith(delim)) {
            cp = cp + delim;
        }
        for (int i = 0; i < files.length; ++i) {
            files[i] = cp + ((FileHandler)v.get(i)).getName();
            this.setStatus(files[i]);
            isRecursive |= ((FileHandler)v.get(i)).isDir();
        }
        this.setStatus(".");
        String ret = null;
        transferMonitor.restart(this.ft, this.command != null);
        ret = this.manager.initiateTransfer(files, this.command != null, isRecursive);
        if (ret != null) {
            transferMonitor.start();
            this.ft.setEnabled(true);
            JOptionPane.showMessageDialog(this.ft, "Cannot copy: " + ret);
            return;
        }
        transferMonitor.start();
        this.ft.setEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void selectStartWith(String prefix) {
        Object object = this.getTreeLock();
        synchronized (object) {
            ListSelectionModel model = this.table.getSelectionModel();
            for (int i = 0; i < this.rows.size(); ++i) {
                FileHandler h = this.rows.get(i);
                if (!h.getName().startsWith(prefix)) continue;
                model.setSelectionInterval(i, i);
                if (!(this.table.getParent() instanceof JViewport)) {
                    return;
                }
                JViewport view = (JViewport)this.table.getParent();
                Rectangle rect = this.table.getCellRect(i, 0, true);
                Point pt = view.getViewPosition();
                rect.setLocation(rect.x - pt.x, rect.y - pt.y);
                view.scrollRectToVisible(rect);
                return;
            }
        }
    }

    public void hideSelection() {
        this.showSelection = false;
        this.table.repaint();
    }

    public void showSelection() {
        this.showSelection = true;
        ListSelectionModel model = this.table.getSelectionModel();
        if (this.table.getSelectedRowCount() < 1) {
            model.setSelectionInterval(0, 0);
            if (!(this.table.getParent() instanceof JViewport)) {
                return;
            }
            JViewport view = (JViewport)this.table.getParent();
            Rectangle rect = this.table.getCellRect(0, 0, true);
            Point pt = view.getViewPosition();
            rect.setLocation(rect.x - pt.x, rect.y - pt.y);
            view.scrollRectToVisible(rect);
            this.table.revalidate();
            this.table.repaint();
        } else {
            this.table.repaint();
        }
    }

    private final void setSelectedItem(JMenuItem item, boolean selected) {
        if (!selected) {
            item.setBorder(BorderFactory.createRaisedBevelBorder());
        } else {
            item.setBorder(BorderFactory.createLoweredBevelBorder());
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.headerRenderer.setEnabled(enabled);
        this.headerRenderer.repaint();
        this.cellRenderer.setEnabled(enabled);
        this.cellRenderer.repaint();
        this.table.revalidate();
        this.table.repaint();
        this.showIconItem.setEnabled(enabled);
        this.showLengthItem.setEnabled(enabled);
        this.showModifItem.setEnabled(enabled);
        this.showAttribItem.setEnabled(enabled);
        if (this.command != null) {
            this.copy.setEnabled(enabled);
            this.exit.setEnabled(enabled);
        }
    }

    public void setShowIcon(boolean show) {
        this.showIcon = show;
        this.updateColumns();
    }

    public void setShowLength(boolean show) {
        this.showLength = show;
        this.updateColumns();
    }

    public void setShowModif(boolean show) {
        this.showModif = show;
        this.updateColumns();
    }

    public void setShowAttrib(boolean show) {
        this.showAttrib = show;
        this.updateColumns();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateColumns() {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.columns.clear();
            if (this.showIcon) {
                this.columns.add(colNames[0]);
            }
            this.columns.add(colNames[1]);
            if (this.showModif) {
                this.columns.add(colNames[2]);
            }
            if (this.showLength) {
                this.columns.add(colNames[3]);
            }
            if (this.showAttrib) {
                this.columns.add(colNames[4]);
            }
        }
        ((AbstractTableModel)this.table.getModel()).fireTableStructureChanged();
        JTableHeader header = this.table.getTableHeader();
        Enumeration<TableColumn> en = header.getColumnModel().getColumns();
        if (en != null) {
            while (en.hasMoreElements()) {
                TableColumn column = en.nextElement();
                if (column == null) continue;
                String colName = column.getHeaderValue().toString();
                if (colName.equals(colNames[0]) || colName.length() == 0) {
                    column.setPreferredWidth(25);
                }
                if (colName.equals(colNames[1])) {
                    column.setPreferredWidth(1000);
                }
                if (colName.equals(colNames[2])) {
                    column.setPreferredWidth(160);
                }
                if (colName.equals(colNames[3])) {
                    column.setPreferredWidth(100);
                }
                if (!colName.equals(colNames[4])) continue;
                column.setPreferredWidth(30);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTable() {
        Object object = this.getTreeLock();
        synchronized (object) {
            FileHandler h;
            this.removeCurrentDir();
            this.rows.clear();
            if (!this.session.isRoot()) {
                FileHandler h2 = new FileHandler("..", this.getUpDirIcon(), -1L, -1L, "", true);
                this.rows.add(h2);
                this.parentDir.setEnabled(true);
                this.rootDir.setEnabled(true);
            } else {
                this.parentDir.setEnabled(false);
                this.rootDir.setEnabled(false);
            }
            for (String d : this.session.dirs) {
                h = new FileHandler(d, this.session.icons.get(d), this.session.modif.get(d), -1L, this.constructAttrib(d), true);
                this.rows.add(h);
            }
            for (String f : this.session.length.keySet()) {
                try {
                    h = new FileHandler(f, this.session.icons.get(f), this.session.modif.get(f), this.session.length.get(f), this.constructAttrib(f), false);
                    this.rows.add(h);
                }
                catch (Throwable h3) {}
            }
            if (this.sortColumn != null) {
                this.sortTable();
            } else {
                ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
            }
        }
        String freeSpace = this.session.freeSpace();
        if (freeSpace != null && freeSpace.length() != 0) {
            this.freeSpace.setText("<html>Free space: <font color=#ff0000>" + freeSpace + "</font></html");
            this.freeSpace.setBorder(BorderFactory.createEtchedBorder());
        } else {
            this.freeSpace.setText("");
            this.freeSpace.setBorder(null);
        }
        int max = -1;
        int poz = -1;
        boolean found = false;
        String currentDir = this.session.getWorkingDir();
        for (int i = 0; i < this.roots.getItemCount(); ++i) {
            String r;
            String item = (String)this.roots.getItemAt(i);
            if (item == null || (r = this.session.getShortRootName(item)) == null || (r = r.toLowerCase(Locale.US)) == null || currentDir == null || !currentDir.toLowerCase(Locale.US).startsWith(r)) continue;
            if (max < r.length()) {
                poz = i;
                max = r.length();
            }
            if (!currentDir.equals(item)) continue;
            found = true;
        }
        if (!found) {
            int i;
            this.currentDir = currentDir;
            ActionListener listener = null;
            if (this.roots.getActionListeners() != null && this.roots.getActionListeners().length != 0) {
                listener = this.roots.getActionListeners()[0];
                this.roots.removeActionListener(listener);
            }
            Object[] o = new Object[this.roots.getItemCount()];
            for (i = 0; i < o.length; ++i) {
                o[i] = this.roots.getItemAt(i);
            }
            this.roots.removeAllItems();
            this.roots.addItem(currentDir);
            for (i = 0; i < o.length; ++i) {
                this.roots.addItem(o[i]);
            }
            this.roots.setSelectedIndex(0);
            this.roots.repaint();
            this.roots.revalidate();
            if (listener != null) {
                this.roots.addActionListener(listener);
            }
        } else if (max > 0 && this.roots.getSelectedIndex() != poz) {
            ActionListener listener = null;
            if (this.roots.getActionListeners() != null && this.roots.getActionListeners().length != 0) {
                listener = this.roots.getActionListeners()[0];
                this.roots.removeActionListener(listener);
            }
            this.roots.setSelectedIndex(poz);
            this.roots.repaint();
            this.roots.revalidate();
            if (listener != null) {
                this.roots.addActionListener(listener);
            }
        }
        if (max < 0 && found) {
            this.rootDir.setEnabled(false);
        }
        if (this.command == null) {
            this.setStatus("Current remote dir = " + this.session.getWorkingDir());
        } else {
            this.setStatus("Current local dir = " + this.session.getWorkingDir());
        }
        this.table.revalidate();
        this.table.repaint();
        this.table.getTableHeader().repaint();
        this.table.getTableHeader().revalidate();
        if (this.lastDir != null) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Object object2 = this.getTreeLock();
            synchronized (object2) {
                for (int i = 0; i < this.rows.size(); ++i) {
                    FileHandler h = this.rows.get(i);
                    if (!h.getName().equals(this.lastDir)) continue;
                    this.table.setRowSelectionInterval(i, i);
                    if (!(this.table.getParent() instanceof JViewport)) break;
                    JViewport view = (JViewport)this.table.getParent();
                    Rectangle rect = this.table.getCellRect(i, 0, true);
                    Point pt = view.getViewPosition();
                    rect.setLocation(rect.x - pt.x, rect.y - pt.y);
                    view.scrollRectToVisible(rect);
                    this.table.scrollRectToVisible(rect);
                    break;
                }
            }
            this.lastDir = null;
        } else if (this.selectedDir != null) {
            Object object3 = this.getTreeLock();
            synchronized (object3) {
                for (int i = 0; i < this.rows.size(); ++i) {
                    FileHandler h = this.rows.get(i);
                    if (!h.getName().equals(this.selectedDir)) continue;
                    this.table.setRowSelectionInterval(i, i);
                    if (!(this.table.getParent() instanceof JViewport)) break;
                    JViewport view = (JViewport)this.table.getParent();
                    Rectangle rect = this.table.getCellRect(i, 0, true);
                    Point pt = view.getViewPosition();
                    rect.setLocation(rect.x - pt.x, rect.y - pt.y);
                    view.scrollRectToVisible(rect);
                    this.table.scrollRectToVisible(rect);
                    break;
                }
            }
            this.selectedDir = null;
        } else {
            this.table.setRowSelectionInterval(0, 0);
        }
    }

    private void sortTable() {
        Collections.sort(this.rows, new ColumnSorter());
        ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
        this.table.getTableHeader().repaint();
    }

    private String constructAttrib(String fileName) {
        StringBuffer buf = new StringBuffer();
        if (this.session.read.containsKey(fileName) && this.session.read.get(fileName).booleanValue()) {
            buf.append("r");
        } else {
            buf.append("-");
        }
        if (this.session.write.containsKey(fileName) && this.session.write.get(fileName).booleanValue()) {
            buf.append("w");
        } else {
            buf.append("-");
        }
        return buf.toString();
    }

    private Icon getUpDirIcon() {
        if (this.upDirIcon != null) {
            return this.upDirIcon;
        }
        try {
            URL r = this.getClass().getResource(this.pack + "/icons/up_dir.png");
            this.upDirIcon = new ImageIcon(r);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.upDirIcon;
    }

    private Icon getRootIcon() {
        if (this.rootIcon != null) {
            return this.rootIcon;
        }
        try {
            URL r = this.getClass().getResource(this.pack + "/icons/rootIcon.png");
            this.rootIcon = new ImageIcon(r);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.rootIcon;
    }

    private Icon getCopyIcon() {
        if (this.copyIcon != null) {
            return this.copyIcon;
        }
        try {
            URL r = this.getClass().getResource(this.pack + "/icons/copy.png");
            this.copyIcon = new ImageIcon(r);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.copyIcon;
    }

    private Icon getExitIcon() {
        if (this.exitIcon != null) {
            return this.exitIcon;
        }
        try {
            URL r = this.getClass().getResource(this.pack + "/icons/exit.jpg");
            this.exitIcon = new ImageIcon(r);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.exitIcon;
    }

    private Icon getOpenDirIcon() {
        if (this.openDirIcon != null) {
            return this.openDirIcon;
        }
        try {
            URL url = this.getClass().getResource(this.pack + "/icons/openfolder.png");
            this.openDirIcon = new ImageIcon(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.openDirIcon;
    }

    private Icon getRefreshIcon() {
        if (this.refreshIcon != null) {
            return this.refreshIcon;
        }
        try {
            URL url = this.getClass().getResource(this.pack + "/icons/refresh.gif");
            this.refreshIcon = new ImageIcon(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.refreshIcon;
    }

    private Icon getHomeIcon() {
        if (this.openHomeIcon != null) {
            return this.openHomeIcon;
        }
        try {
            URL url = this.getClass().getResource(this.pack + "/icons/home_icon.png");
            this.openHomeIcon = new ImageIcon(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.openHomeIcon;
    }

    private Icon getSelectIcon() {
        if (this.selectIcon != null) {
            return this.selectIcon;
        }
        try {
            URL url = this.getClass().getResource(this.pack + "/icons/select.gif");
            this.selectIcon = new ImageIcon(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.selectIcon;
    }

    private Icon getSortAIcon() {
        if (this.sortAIcon != null) {
            return this.sortAIcon;
        }
        try {
            URL url = this.getClass().getResource(this.pack + "/icons/sort_up.gif");
            this.sortAIcon = new ImageIcon(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.sortAIcon;
    }

    private Icon getSortDIcon() {
        if (this.sortDIcon != null) {
            return this.sortDIcon;
        }
        try {
            URL url = this.getClass().getResource(this.pack + "/icons/sort_down.gif");
            this.sortDIcon = new ImageIcon(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.sortDIcon;
    }

    public void setConnected(boolean connected) {
        if (!connected) {
            this.removeAll();
            this.add((Component)this.connectPanel, "Center");
            this.setEnabled(false);
            this.revalidate();
            this.repaint();
        } else {
            this.removeAll();
            this.add((Component)this.tablePanel, "Center");
            this.setEnabled(true);
            this.revalidate();
            this.repaint();
            this.ft.setEnabled(false);
            String[] str = null;
            try {
                str = this.session.getRoots();
            }
            catch (Exception e) {
                str = new String[]{};
                JOptionPane.showMessageDialog(this.ft, e.toString());
            }
            ActionListener listener = null;
            if (this.roots.getActionListeners() != null && this.roots.getActionListeners().length != 0) {
                listener = this.roots.getActionListeners()[0];
                this.roots.removeActionListener(listener);
            }
            this.roots.removeAllItems();
            if (str != null) {
                for (int i = 0; i < str.length; ++i) {
                    this.roots.addItem(str[i]);
                }
            }
            if (listener != null) {
                this.roots.addActionListener(listener);
            }
            try {
                this.session.setAbsoluteDir(this.session.getWorkingDir());
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.ft, e.toString());
            }
            this.updateTable();
            this.ft.setEnabled(true);
            this.table.requestFocusInWindow();
        }
    }

    public void setStatus(String status) {
        if (this.statusBar == null) {
            return;
        }
        status = status.replace("<", "[").replace(">", "]");
        this.statusBar.addText(status + "\n");
    }

    public final JTable getTable() {
        return this.table;
    }

    private Icon getMkDirIcon() {
        if (this.mkdirIcon != null) {
            return this.mkdirIcon;
        }
        try {
            URL r = this.getClass().getResource("icons/mkdir.png");
            this.mkdirIcon = new ImageIcon(r);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mkdirIcon;
    }

    private Icon getRemoveIcon() {
        if (this.removeIcon != null) {
            return this.removeIcon;
        }
        try {
            URL r = this.getClass().getResource("icons/delete.png");
            this.removeIcon = new ImageIcon(r);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.removeIcon;
    }

    private Icon getConnIcon() {
        if (this.connIcon != null) {
            return this.connIcon;
        }
        try {
            URL r = this.getClass().getResource("icons/connect2.gif");
            this.connIcon = new ImageIcon(r);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.connIcon;
    }

    private Icon getVertIcon() {
        if (this.verticalIcon != null) {
            return this.verticalIcon;
        }
        try {
            URL r = this.getClass().getResource("icons/vertical.jpg");
            this.verticalIcon = new ImageIcon(r);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.verticalIcon;
    }

    static {
        nf.setMaximumFractionDigits(2);
    }

    public class MyTableCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, rowIndex, vColIndex);
            String col = (String)FolderTable.this.columns.get(vColIndex);
            if (isSelected && FolderTable.this.showSelection) {
                if (col.equals(colNames[0]) || col.equals(colNames[2]) || col.equals(colNames[4])) {
                    c.setBackground(c3);
                } else {
                    c.setBackground(c1);
                }
            } else if (col.equals(colNames[0]) || col.equals(colNames[2]) || col.equals(colNames[4])) {
                c.setBackground(FolderTable.this.focus() ? c44 : cg);
            } else {
                c.setBackground(FolderTable.this.focus() ? c2 : cg);
            }
            if (value instanceof Icon) {
                ((JLabel)c).setIcon((Icon)value);
                ((JLabel)c).setText(null);
            } else {
                ((JLabel)c).setText((String)value);
                ((JLabel)c).setIcon(null);
            }
            ((JLabel)c).setBorder(null);
            return c;
        }
    }

    public class ColumnSorter
    implements Comparator {
        ColumnSorter() {
        }

        public int compare(Object a, Object b) {
            FileHandler fh1 = (FileHandler)a;
            FileHandler fh2 = (FileHandler)b;
            if (fh1.getName().equals("..")) {
                return -1;
            }
            if (fh2.getName().equals("..")) {
                return 1;
            }
            if (fh1.isDir() && !fh2.isDir()) {
                return -1;
            }
            if (!fh1.isDir() && fh2.isDir()) {
                return 1;
            }
            if (FolderTable.this.sortColumn.equals(colNames[0])) {
                if (fh1.getIcon() == null && fh2.getIcon() == null) {
                    return 0;
                }
                if (fh1.getIcon() == null) {
                    return 1;
                }
                if (fh2.getIcon() == null) {
                    return -1;
                }
                if (FolderTable.this.sortAsc) {
                    return fh1.getIcon().toString().compareTo(fh2.getIcon().toString());
                }
                return fh2.getIcon().toString().compareTo(fh1.getIcon().toString());
            }
            if (FolderTable.this.sortColumn.equals(colNames[2])) {
                if (fh1.getModifL() < fh2.getModifL()) {
                    return FolderTable.this.sortAsc ? 1 : -1;
                }
                if (fh1.getModifL() == fh2.getModifL()) {
                    return 0;
                }
                return FolderTable.this.sortAsc ? -1 : 1;
            }
            if (FolderTable.this.sortColumn.equals(colNames[3])) {
                if (fh1.getSizeL() < fh2.getSizeL()) {
                    return FolderTable.this.sortAsc ? 1 : -1;
                }
                if (fh1.getSizeL() == fh2.getSizeL()) {
                    return 0;
                }
                return FolderTable.this.sortAsc ? -1 : 1;
            }
            if (FolderTable.this.sortColumn.equals(colNames[4])) {
                if (FolderTable.this.sortAsc) {
                    return fh1.getAttrib().compareTo(fh2.getAttrib());
                }
                return fh2.getAttrib().compareTo(fh1.getAttrib());
            }
            if (FolderTable.this.sortAsc) {
                return fh1.getName().compareTo(fh2.getName());
            }
            return fh2.getName().compareTo(fh1.getName());
        }
    }

    private class ColumnHeaderListener
    extends MouseAdapter {
        private ColumnHeaderListener() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            JTable table = ((JTableHeader)evt.getSource()).getTable();
            TableColumnModel colModel = table.getColumnModel();
            int vColIndex = colModel.getColumnIndexAtX(evt.getX());
            if (vColIndex == -1) {
                return;
            }
            String col = (String)FolderTable.this.columns.get(vColIndex);
            if (FolderTable.this.sortColumn == null) {
                FolderTable.this.sortColumn = col;
                FolderTable.this.sortAsc = true;
            } else if (FolderTable.this.sortColumn.equals(col)) {
                FolderTable.this.sortAsc = !FolderTable.this.sortAsc;
            } else {
                FolderTable.this.sortColumn = col;
                FolderTable.this.sortAsc = true;
            }
            FolderTable.this.sortTable();
        }
    }

    public class MyTableHeaderRenderer
    extends JLabel
    implements TableCellRenderer {
        private Border border = BorderFactory.createRaisedBevelBorder();

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
            this.setText(value.toString());
            this.setForeground(Color.red);
            this.setToolTipText((String)value);
            this.setBorder(this.border);
            if (FolderTable.this.sortColumn != null && FolderTable.this.sortColumn.equals(value.toString())) {
                if (FolderTable.this.sortAsc) {
                    this.setIcon(FolderTable.this.getSortAIcon());
                } else {
                    this.setIcon(FolderTable.this.getSortDIcon());
                }
            } else if (FolderTable.this.sortColumn != null && FolderTable.this.sortColumn.equals(colNames[0]) && vColIndex == 0) {
                if (FolderTable.this.sortAsc) {
                    this.setIcon(FolderTable.this.getSortAIcon());
                } else {
                    this.setIcon(FolderTable.this.getSortDIcon());
                }
            } else {
                this.setIcon(null);
            }
            return this;
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }

    private class MyTableModel
    extends AbstractTableModel {
        private MyTableModel() {
        }

        @Override
        public int getRowCount() {
            return FolderTable.this.rows.size();
        }

        @Override
        public int getColumnCount() {
            return FolderTable.this.columns.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column < 0 || column >= FolderTable.this.columns.size()) {
                return "";
            }
            String colName = (String)FolderTable.this.columns.get(column);
            if (colName.equals(colNames[0])) {
                return "";
            }
            return colName;
        }

        @Override
        public boolean isCellEditable(int arg0, int arg1) {
            return false;
        }

        public Class getColumnClass(int c) {
            String col = (String)FolderTable.this.columns.get(c);
            if (col.equals(colNames[0])) {
                return Icon.class;
            }
            return String.class;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getValueAt(int row, int col) {
            FileHandler h = null;
            Vector vector = FolderTable.this.rows;
            synchronized (vector) {
                if (row < 0 || row >= FolderTable.this.rows.size()) {
                    return null;
                }
                h = (FileHandler)FolderTable.this.rows.get(row);
            }
            String colName = null;
            Vector vector2 = FolderTable.this.columns;
            synchronized (vector2) {
                if (col < 0 || col >= FolderTable.this.columns.size()) {
                    return null;
                }
                colName = (String)FolderTable.this.columns.get(col);
            }
            FolderTable.this.table.getColumnModel().getColumn(col).setResizable(true);
            if (colName.equals(colNames[0])) {
                FolderTable.this.table.getColumnModel().getColumn(col).setHeaderRenderer(FolderTable.this.headerRenderer);
                FolderTable.this.table.getColumnModel().getColumn(col).setCellRenderer(FolderTable.this.cellRenderer);
                return h.getIcon();
            }
            if (colName.equals(colNames[1])) {
                FolderTable.this.table.getColumnModel().getColumn(col).setHeaderRenderer(FolderTable.this.headerRenderer);
                FolderTable.this.table.getColumnModel().getColumn(col).setCellRenderer(FolderTable.this.cellRenderer);
                return h.getName();
            }
            if (colName.equals(colNames[2])) {
                FolderTable.this.table.getColumnModel().getColumn(col).setHeaderRenderer(FolderTable.this.headerRenderer);
                FolderTable.this.table.getColumnModel().getColumn(col).setCellRenderer(FolderTable.this.cellRenderer);
                return h.getModif();
            }
            if (colName.equals(colNames[3])) {
                FolderTable.this.table.getColumnModel().getColumn(col).setHeaderRenderer(FolderTable.this.headerRenderer);
                FolderTable.this.table.getColumnModel().getColumn(col).setCellRenderer(FolderTable.this.cellRenderer);
                return h.getSize();
            }
            if (colName.equals(colNames[4])) {
                FolderTable.this.table.getColumnModel().getColumn(col).setHeaderRenderer(FolderTable.this.headerRenderer);
                FolderTable.this.table.getColumnModel().getColumn(col).setCellRenderer(FolderTable.this.cellRenderer);
                return h.getAttrib();
            }
            return null;
        }
    }

    private final class FileHandler {
        private final String name;
        private final Icon icon;
        private final long modif;
        private final long size;
        private final String attrib;
        private final boolean isDir;

        public FileHandler(String name, Icon icon, long modif, long size, String attrib, boolean isDir) {
            this.name = name;
            this.icon = icon;
            this.modif = modif;
            this.size = size;
            this.attrib = attrib;
            this.isDir = isDir;
        }

        public final String getName() {
            if (this.name == null) {
                return " ";
            }
            return this.name;
        }

        public final Icon getIcon() {
            return this.icon;
        }

        public final String getModif() {
            if (this.modif <= 0L) {
                return " ";
            }
            return " " + dateFormat.format(new Date(this.modif));
        }

        public final long getModifL() {
            return this.modif;
        }

        public final String getSize() {
            if (this.size <= 0L) {
                return " ";
            }
            double s = this.size;
            if (s > 1024.0) {
                s /= 1024.0;
            } else {
                return " " + nf.format(s) + " B";
            }
            if (s > 1024.0) {
                s /= 1024.0;
            } else {
                return " " + nf.format(s) + " KB";
            }
            if (s > 1024.0) {
            } else {
                return " " + nf.format(s) + " MB";
            }
            if (!((s /= 1024.0) > 1024.0)) {
                return " " + nf.format(s) + " GB";
            }
            return " " + nf.format(s /= 1024.0) + " PB";
        }

        public final long getSizeL() {
            return this.size;
        }

        public final String getAttrib() {
            if (this.attrib == null) {
                return " ";
            }
            return " " + this.attrib;
        }

        public final boolean isDir() {
            return this.isDir;
        }
    }
}

