/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.gui;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.Utilities;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;

public class StatusBar
extends JTextPane
implements ClipboardOwner,
Runnable {
    private static final Object lock = new Object();
    static String nl = "\n";
    private final LinkedList<String> currentLines = new LinkedList();
    private final StatusBar _instance;
    private String lastLine = "";
    private JScrollPane pane;
    private JTextPane p1;
    private boolean redoCalled = false;

    public StatusBar(JScrollPane pane) {
        this.pane = pane;
        pane.setVerticalScrollBarPolicy(22);
        this.setOpaque(true);
        this.setToolTipText("Status bar");
        this.setBackground(Color.white);
        this.setContentType("text/html");
        this.p1 = new JTextPane();
        this.p1.setOpaque(true);
        this.p1.setToolTipText("Status bar");
        this.p1.setBackground(Color.white);
        this.p1.setContentType("text/html");
        final StatusBar textArea = this;
        textArea.addMouseListener(new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    try {
                        int offset = StatusBar.this.viewToModel(e.getPoint());
                        int rowStart = Utilities.getRowStart(textArea, offset);
                        int rowEnd = Utilities.getRowEnd(textArea, offset);
                        Object object = StatusBar.this.getTreeLock();
                        synchronized (object) {
                            textArea.select(rowStart, rowEnd);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        textArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 67 && e.isControlDown()) {
                    StatusBar.this.setClipboardContents(textArea.getSelectedText());
                }
            }
        });
        this._instance = this;
        new Thread(this).start();
    }

    public void setClipboardContents(String aString) {
        StringSelection stringSelection = new StringSelection(aString);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addText(String text) {
        if (text == null) {
            return;
        }
        Object object = this.currentLines;
        synchronized (object) {
            int index;
            while ((index = text.indexOf(nl)) >= 0) {
                String str = text.substring(0, index);
                if (this.lastLine.length() != 0) {
                    str = this.lastLine + str;
                    this.lastLine = "";
                }
                this.currentLines.addLast(str);
                if (this.currentLines.size() > 100) {
                    this.currentLines.removeFirst();
                }
                text = text.substring(index + nl.length());
            }
            if (text.length() != 0) {
                this.lastLine = this.lastLine + text;
            }
        }
        object = lock;
        synchronized (object) {
            this.redoCalled = true;
            lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setName("[FDT StatusThread]");
        while (true) {
            Object object = lock;
            synchronized (object) {
                while (!this.redoCalled) {
                    try {
                        lock.wait();
                    }
                    catch (Exception exception) {}
                }
                this.redoCalled = false;
            }
            this.redo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redo() {
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        Object object = this.currentLines;
        synchronized (object) {
            buf.append("<html>");
            for (String t : this.currentLines) {
                if (!first) {
                    buf.append("<br>");
                }
                buf.append(t);
                first = false;
            }
            if (this.lastLine.length() != 0) {
                if (!first) {
                    buf.append("<br>");
                }
                buf.append(this.lastLine);
            }
            buf.append("</html>");
        }
        this.p1.setText(buf.toString());
        object = this.getTreeLock();
        synchronized (object) {
            try {
                this.setEditorKit(this.p1.getEditorKit());
                this.setDocument(this.p1.getDocument());
                this.pane.getViewport().scrollRectToVisible(new Rectangle(0, this._instance.getPreferredSize().height, 0, 0));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this._instance.repaint();
        this.p1 = new JTextPane();
        this.p1.setOpaque(true);
        this.p1.setToolTipText("Status bar");
        this.p1.setBackground(Color.white);
        this.p1.setContentType("text/html");
    }

    @Override
    public void lostOwnership(Clipboard aClipboard, Transferable aContents) {
    }

    @Override
    public String getSelectedText() {
        return this.getSelectedHTMLAsText();
    }

    public String getSelectedHTMLAsText() {
        String text = super.getSelectedText();
        if (text == null || text.length() == 0) {
            return text;
        }
        int startPos = this.getSelectionStart();
        int endPos = this.getSelectionEnd();
        int selectedCharacters = endPos - startPos;
        StringBuffer buffer = new StringBuffer(selectedCharacters);
        boolean nbspCount = false;
        int i = 0;
        int j = startPos;
        while (i < selectedCharacters) {
            Element element1 = ((HTMLDocument)this.getDocument()).getCharacterElement(j);
            if (this.isReplaceWithNewLine(element1)) {
                buffer.append('\n');
            } else {
                buffer.append(text.charAt(i));
            }
            ++i;
            ++j;
        }
        return buffer.toString();
    }

    private boolean isReplaceWithNewLine(Element element1) {
        AttributeSet as1 = element1.getAttributes();
        Enumeration<?> attribEntriesOriginal1 = as1.getAttributeNames();
        while (attribEntriesOriginal1.hasMoreElements()) {
            Object entryKey = attribEntriesOriginal1.nextElement();
            Object entryValue = as1.getAttribute(entryKey);
            if (!(entryValue instanceof HTML.Tag) || entryValue != HTML.Tag.BR) continue;
            return true;
        }
        return false;
    }
}

