/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.monitoring;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import lia.util.net.copy.monitoring.DiskReaderManagerMonitoringTask;
import lia.util.net.copy.monitoring.lisa.LISAReportingTask;

public class ClientTransportMonitorTask
implements Runnable {
    private static final transient Logger logger = Logger.getLogger(ClientTransportMonitorTask.class.getName());
    private static final double THRESHOLD = 0.01;
    private static final int FAILED_ITERATIONS_THRESHOLD = 3;
    private static final LISAReportingTask lisaReportingTask = LISAReportingTask.getInstance();
    private final DiskReaderManagerMonitoringTask diskReaderMonitoringTask;
    double cRate = Double.MAX_VALUE;
    private boolean isTransportDown;
    private int failedIterations;

    public ClientTransportMonitorTask(DiskReaderManagerMonitoringTask diskReaderMonitoringTask) {
        logger.log(Level.INFO, "ClientTransportMonitorTask started! ");
        this.diskReaderMonitoringTask = diskReaderMonitoringTask;
        this.failedIterations = 0;
        this.isTransportDown = false;
    }

    private void notifyTransportDown() {
        logger.log(Level.WARNING, "\n\n [ ClientTransportMonitorTask ] Current Rate " + this.cRate + " & failedIterations: " + this.failedIterations + " notifying LISA Wrapper \n\n");
        this.isTransportDown = true;
        try {
            lisaReportingTask.sendClientNow("RESTARTME", new HashMap<String, Double>());
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "\n\n [ ClientTransportMonitorTask ]  failed to notify LISA !! \n\n", t);
        }
    }

    public boolean isTransportDown() {
        return this.isTransportDown;
    }

    @Override
    public void run() {
        this.cRate = this.diskReaderMonitoringTask.getTotalRate();
        this.failedIterations = this.diskReaderMonitoringTask.getTotalRate() < 0.01 ? ++this.failedIterations : 0;
        if (this.failedIterations > 3) {
            this.notifyTransportDown();
        } else {
            this.isTransportDown = false;
        }
    }
}

