/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.monitoring;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import lia.util.net.common.Config;
import lia.util.net.common.DirectByteBufferPool;
import lia.util.net.common.HeaderBufferPool;
import lia.util.net.common.Utils;
import lia.util.net.copy.disk.DiskReaderManager;
import lia.util.net.copy.disk.DiskWriterManager;
import lia.util.net.copy.disk.DiskWriterTask;

public class FDTInternalMonitoringTask
implements Runnable {
    private static final Logger logger = Logger.getLogger(FDTInternalMonitoringTask.class.getName());
    private static final DiskWriterManager diskWriterManager = DiskWriterManager.getInstance();
    private static final DiskReaderManager diskReaderManager = DiskReaderManager.getInstance();
    private static final FDTInternalMonitoringTask _theInstance;
    private static final Config config;
    private static final Level STATS_LEVEL;
    private static final String EOL;
    private static boolean initialized;
    int dbpool_total;
    int dbpool_free;
    int hpool_total;
    int hpool_free;
    int mon_queue_count;
    int fdt_wdisk_ses_count;
    int fdt_rdisk_ses_count;
    StringBuilder sb = new StringBuilder(2048);
    HashMap<Integer, HashMap<Integer, WriterAccountingContors>> hmWriters = new HashMap();

    private FDTInternalMonitoringTask() {
    }

    private static final String getNiceProcent(double value) {
        int aux = (int)(value * 100.0);
        if (value >= 1.0) {
            if (aux % 100 != 0) {
                return (float)aux / 100.0f + "%";
            }
            return (int)value + "%";
        }
        if (value < 1.0 && value > 0.0) {
            return (float)aux / 100.0f + "%";
        }
        return value + "%";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final FDTInternalMonitoringTask getInstance() {
        if (initialized) return _theInstance;
        Class<FDTInternalMonitoringTask> clazz = FDTInternalMonitoringTask.class;
        synchronized (FDTInternalMonitoringTask.class) {
            while (!initialized) {
                try {
                    FDTInternalMonitoringTask.class.wait();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _theInstance;
        }
    }

    private final void printStats() {
        this.sb.setLength(0);
        this.sb.append(EOL).append(EOL).append(" *** FDT Stats @ ").append(new Date()).append(" *** ").append(EOL).append(EOL);
        this.sb.append(" BuffPool [ ").append(this.dbpool_free).append(" / ").append(this.dbpool_total);
        this.sb.append(" ] HeaderBPool [ ").append(this.hpool_free).append(" / ").append(this.hpool_total).append(" ]").append(EOL);
        this.sb.append(EOL).append(EOL).append(" BuffPool Identity map stats").append(DirectByteBufferPool.getInstance().identityMapStats()).append(EOL);
        this.sb.append(EOL).append(EOL).append(" HeaderPool Identity map stats").append(HeaderBufferPool.getInstance().identityMapStats()).append(EOL);
        this.sb.append(" MonitoringQueue ").append(this.mon_queue_count).append(EOL);
        Map<Integer, List<DiskWriterTask>> writersMap = diskWriterManager.getWritersMap();
        this.sb.append(" PartitionIDs: ").append(writersMap.size());
        for (Map.Entry<Integer, List<DiskWriterTask>> entry : writersMap.entrySet()) {
            Integer partitionID = entry.getKey();
            this.sb.append(" [ partitionID: ").append(partitionID).append(" workers: ").append(writersMap.get(entry.getValue().size())).append(" qSize: ").append(diskWriterManager.getQueueSize(partitionID)).append(" ] ");
        }
        this.sb.append(EOL);
        this.sb.append(" Disk Writer Sessions: ").append(this.fdt_wdisk_ses_count).append(" Disk Reader Sessions: ").append(this.fdt_rdisk_ses_count);
        this.sb.append(EOL);
        for (Map.Entry<Integer, HashMap<Integer, WriterAccountingContors>> entry : this.hmWriters.entrySet()) {
            Integer id = entry.getKey();
            HashMap<Integer, WriterAccountingContors> iVal = entry.getValue();
            for (Map.Entry<Integer, WriterAccountingContors> iEntry : iVal.entrySet()) {
                Integer writerID = iEntry.getKey();
                WriterAccountingContors wac = iEntry.getValue();
                if (!wac.reportOk) continue;
                this.sb.append(EOL).append(" DiskWriterStat [ PartitionID: " + id + " writerID " + writerID + " ] WOnQueue ").append(FDTInternalMonitoringTask.getNiceProcent(wac.procTake));
                this.sb.append(" WaitOnWrite ").append(FDTInternalMonitoringTask.getNiceProcent(wac.procWrite));
                this.sb.append(" WaitOnFinish ").append(FDTInternalMonitoringTask.getNiceProcent(wac.procFinish));
                this.sb.append(" WaitOnOther ").append(FDTInternalMonitoringTask.getNiceProcent(wac.procOther));
            }
            this.sb.append(EOL);
        }
        this.sb.append(EOL).append(EOL).append(" *** ==== ***").append(EOL);
        logger.log(STATS_LEVEL, this.sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateWritersAccounting() {
        Map<Integer, List<DiskWriterTask>> currentWriters = diskWriterManager.getWritersMap();
        for (Map.Entry<Integer, List<DiskWriterTask>> entry : currentWriters.entrySet()) {
            Integer id = entry.getKey();
            List<DiskWriterTask> partitionWritersList = entry.getValue();
            for (DiskWriterTask writerTask : partitionWritersList) {
                WriterAccountingContors wac;
                long diffDtTotal = 0L;
                long diffDtWrite = 0L;
                long diffDtFinishSession = 0L;
                long diffDtTake = 0L;
                long diffDtOther = 0L;
                boolean init = false;
                HashMap<Integer, WriterAccountingContors> wacMap = this.hmWriters.get(id);
                if (wacMap == null) {
                    wacMap = new HashMap();
                    this.hmWriters.put(id, wacMap);
                }
                if ((wac = wacMap.get(writerTask.writerID())) == null) {
                    wac = new WriterAccountingContors(writerTask.getCountersRLock());
                    wacMap.put(writerTask.writerID(), wac);
                    init = true;
                }
                wac.reportOk = false;
                wac.countersRLock.lock();
                try {
                    if (wac.lastDtTotal != writerTask.dtTotal) {
                        wac.reportOk = true;
                        if (!init) {
                            diffDtTotal = writerTask.dtTotal - wac.lastDtTotal;
                            diffDtTake = writerTask.dtTake - wac.lastDtTake;
                            diffDtFinishSession = writerTask.dtFinishSession - wac.lastDtFinishSession;
                            diffDtWrite = writerTask.dtWrite - wac.lastDtWrite;
                            diffDtOther = diffDtTotal - (diffDtTake + diffDtFinishSession + diffDtWrite);
                        }
                        wac.lastDtTake = writerTask.dtTake;
                        wac.lastDtTotal = writerTask.dtTotal;
                        wac.lastDtWrite = writerTask.dtWrite;
                        wac.lastDtFinishSession = writerTask.dtFinishSession;
                    } else if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, " The writer seem idle same time [ " + wac.lastDtTotal + " ] as in previous iteration ");
                    }
                }
                finally {
                    wac.countersRLock.unlock();
                }
                if (diffDtTotal < 0L || diffDtTake < 0L || diffDtFinishSession < 0L || diffDtWrite < 0L) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, " Report NOK smth is decreasing " + " diffDtTotal = " + diffDtTotal + " diffDtTake = " + diffDtTake + " diffDtFinishSession = " + diffDtFinishSession + " diffDtWrite = " + diffDtWrite + " diffDtOther = " + diffDtOther);
                    }
                    wac.reportOk = false;
                }
                if (init || !wac.reportOk) continue;
                wac.procWrite = (double)diffDtWrite * 100.0 / (double)diffDtTotal;
                wac.procFinish = (double)diffDtFinishSession * 100.0 / (double)diffDtTotal;
                wac.procTake = (double)diffDtTake * 100.0 / (double)diffDtTotal;
                wac.procOther = 100.0 - (wac.procWrite + wac.procFinish + wac.procTake);
            }
        }
        Iterator<Integer> it = this.hmWriters.keySet().iterator();
        while (it.hasNext()) {
            Integer partitionID = it.next();
            if (currentWriters.containsKey(partitionID)) continue;
            it.remove();
        }
    }

    public HashMap<String, Double> getLisaParams() {
        HashMap<String, Double> fdtLisaParams = new HashMap<String, Double>();
        fdtLisaParams.put("dbpool_total", Double.valueOf(this.dbpool_total));
        fdtLisaParams.put("dbpool_free", Double.valueOf(this.dbpool_free));
        fdtLisaParams.put("hpool_total", Double.valueOf(this.hpool_total));
        fdtLisaParams.put("hpool_free", Double.valueOf(this.hpool_free));
        fdtLisaParams.put("mon_queue", Double.valueOf(this.mon_queue_count));
        fdtLisaParams.put("fdt_ses_wdisk", Double.valueOf(this.fdt_wdisk_ses_count));
        fdtLisaParams.put("fdt_ses_rdisk", Double.valueOf(this.fdt_rdisk_ses_count));
        for (Map.Entry<Integer, HashMap<Integer, WriterAccountingContors>> entry : this.hmWriters.entrySet()) {
            Integer pid = entry.getKey();
            HashMap<Integer, WriterAccountingContors> wacMap = entry.getValue();
            for (Map.Entry<Integer, WriterAccountingContors> ientry : wacMap.entrySet()) {
                Integer wID = ientry.getKey();
                WriterAccountingContors wac = ientry.getValue();
                if (!wac.reportOk) continue;
                String wPrefix = "pID_" + pid + "_wID_" + wID + "_";
                fdtLisaParams.put(wPrefix + "w_take", wac.procTake);
                fdtLisaParams.put(wPrefix + "w_write", wac.procWrite);
                fdtLisaParams.put(wPrefix + "w_finish", wac.procFinish);
                fdtLisaParams.put(wPrefix + "w_other", wac.procOther);
            }
        }
        return fdtLisaParams;
    }

    @Override
    public void run() {
        try {
            long sTime = System.nanoTime();
            this.dbpool_total = DirectByteBufferPool.getInstance().getCapacity();
            this.dbpool_free = DirectByteBufferPool.getInstance().getSize();
            this.hpool_total = HeaderBufferPool.getInstance().getCapacity();
            this.hpool_free = HeaderBufferPool.getInstance().getSize();
            this.mon_queue_count = Utils.getMonitoringExecService().getQueue().size();
            this.fdt_wdisk_ses_count = diskWriterManager.getSessions().size();
            this.fdt_rdisk_ses_count = diskReaderManager.getSessions().size();
            this.updateWritersAccounting();
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "FDTInternalMonitoring took: " + (double)(System.nanoTime() - sTime) / 1000000.0 + " ms");
            }
            if (STATS_LEVEL != null && logger.isLoggable(STATS_LEVEL)) {
                this.printStats();
            }
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, " [ InternalMonitoring ] Got Exception ", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        config = Config.getInstance();
        STATS_LEVEL = config.getStatsLevel();
        EOL = System.getProperty("line.separator", "\n");
        initialized = false;
        Class<FDTInternalMonitoringTask> clazz = FDTInternalMonitoringTask.class;
        synchronized (FDTInternalMonitoringTask.class) {
            _theInstance = new FDTInternalMonitoringTask();
            initialized = true;
            FDTInternalMonitoringTask.class.notifyAll();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static final class WriterAccountingContors {
        private final Lock countersRLock;
        boolean reportOk;
        long lastDtTake;
        long lastDtWrite;
        long lastDtFinishSession;
        long lastDtTotal;
        double procWrite = 0.0;
        double procFinish = 0.0;
        double procTake = 0.0;
        double procOther = 0.0;

        WriterAccountingContors(Lock lock) {
            this.countersRLock = lock;
            this.reportOk = false;
        }
    }
}

