/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.monitoring;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import lia.util.net.common.Utils;
import lia.util.net.copy.Accountable;
import lia.util.net.copy.FDTSession;
import lia.util.net.copy.monitoring.base.AbstractAccountableMonitoringTask;
import lia.util.net.copy.monitoring.lisa.CmdCheckerTask;
import lia.util.net.copy.monitoring.lisa.LISAReportingTask;

public class FDTSessionMonitoringTask
extends AbstractAccountableMonitoringTask {
    private final FDTSession fdtSession;
    private ScheduledFuture<?> cmdCheckerTaskFuture;

    public FDTSessionMonitoringTask(FDTSession fdtSession) {
        super(new Accountable[]{fdtSession});
        this.fdtSession = fdtSession;
    }

    public void startSession() {
        LISAReportingTask lisaReportingTask = LISAReportingTask.getInstanceNow();
        if (lisaReportingTask != null) {
            CmdCheckerTask cmdCheckerTask = new CmdCheckerTask(this.fdtSession, lisaReportingTask, this.fdtSession);
            this.cmdCheckerTaskFuture = Utils.getMonitoringExecService().scheduleWithFixedDelay(cmdCheckerTask, 5L, 2L, TimeUnit.SECONDS);
        }
    }

    public void finishSession() {
        LISAReportingTask lisaReportingTask = LISAReportingTask.getInstanceNow();
        if (lisaReportingTask != null) {
            lisaReportingTask.finishFDTSession(this.fdtSession);
            if (this.cmdCheckerTaskFuture != null) {
                this.cmdCheckerTaskFuture.cancel(true);
            }
        }
    }

    public double getTotalRate() {
        return this.getTotalRate(this.fdtSession);
    }

    @Override
    public void rateComputed() {
    }
}

