/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.monitoring.lisa;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import lia.util.net.common.Config;
import lia.util.net.copy.FDTReaderSession;
import lia.util.net.copy.FDTSession;
import lia.util.net.copy.FDTWriterSession;
import lia.util.net.copy.monitoring.FDTReportingTask;
import lia.util.net.copy.monitoring.FDTSessionMonitoringTask;
import lia.util.net.copy.monitoring.lisa.MonClient;

public class LISAReportingTask
extends FDTReportingTask {
    private static final Logger logger = Logger.getLogger(LISAReportingTask.class.getName());
    private static LISAReportingTask _thisInstance;
    private final String lisaHost;
    private final int lisaPort;
    public volatile MonClient lisaMon;
    private boolean errorReported = false;

    private LISAReportingTask(String lisaHost, int lisaPort) {
        this.lisaHost = lisaHost;
        this.lisaPort = lisaPort;
        this.setupMonClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final LISAReportingTask initInstance(String lisaHost, int lisaPort) {
        Class<LISAReportingTask> clazz = LISAReportingTask.class;
        synchronized (LISAReportingTask.class) {
            if (_thisInstance == null) {
                _thisInstance = new LISAReportingTask(lisaHost, lisaPort);
                LISAReportingTask.class.notifyAll();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return _thisInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final LISAReportingTask getInstanceNow() {
        Class<LISAReportingTask> clazz = LISAReportingTask.class;
        synchronized (LISAReportingTask.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return _thisInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final LISAReportingTask getInstance() {
        Class<LISAReportingTask> clazz = LISAReportingTask.class;
        synchronized (LISAReportingTask.class) {
            while (_thisInstance == null) {
                try {
                    LISAReportingTask.class.wait(5000L);
                    logger.log(Level.WARNING, " getInstace timeout on LISAReporting task ... ");
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _thisInstance;
        }
    }

    private void publishStartFinishParams(FDTSession fdtSession) {
        block19: {
            if (fdtSession != null) {
                try {
                    HashMap lisaParams = new HashMap();
                    HashMap<String, Double> fdtSessionParams = new HashMap<String, Double>();
                    FDTSessionMonitoringTask fdtSessionMTask = fdtSession.getMonitoringTask();
                    if (fdtSessionMTask != null) {
                        if (fdtSession instanceof FDTWriterSession) {
                            String monID;
                            double rate = fdtSessionMTask.getTotalRate() / 1048576.0;
                            fdtSessionParams.put("DISK_WRITE_MB", rate);
                            double tSize = (double)fdtSession.getSize() / 1048576.0;
                            double cSize = (double)fdtSession.getTotalBytes() / 1048576.0;
                            fdtSessionParams.put("TotalMBytes", tSize);
                            fdtSessionParams.put("TransferredMBytes", cSize);
                            fdtSessionParams.put("Status", Double.valueOf(fdtSession.getCurrentStatus()));
                            if (fdtSession.getSize() != 0L) {
                                fdtSessionParams.put("TransferRatio", cSize * 100.0 / tSize);
                            }
                            if ((monID = fdtSession.getMonID()) != null) {
                                lisaParams.put(monID, fdtSessionParams);
                            } else {
                                lisaParams.put(fdtSession.getRemoteAddress().getHostAddress() + ":" + fdtSession.getRemotePort(), fdtSessionParams);
                            }
                            if (lisaParams.size() > 0) {
                                if (logger.isLoggable(Level.FINE)) {
                                    logger.log(Level.FINE, " Sending to LISA :- Client Params: " + lisaParams);
                                }
                                for (Map.Entry entry : lisaParams.entrySet()) {
                                    HashMap hToSend = (HashMap)entry.getValue();
                                    if (hToSend.size() <= 0) continue;
                                    this.lisaMon.sendServerParameters((String)entry.getKey(), hToSend);
                                }
                            }
                            break block19;
                        }
                        if (fdtSession instanceof FDTReaderSession) {
                            double rate = fdtSessionMTask.getTotalRate() / 1048576.0;
                            fdtSessionParams.put("DISK_READ_MB", rate);
                            double tSize = (double)fdtSession.getSize() / 1048576.0;
                            double cSize = (double)fdtSession.getTotalBytes() / 1048576.0;
                            fdtSessionParams.put("TotalMBytes", tSize);
                            fdtSessionParams.put("TransferredMBytes", cSize);
                            if (fdtSession.getSize() != 0L) {
                                fdtSessionParams.put("TransferRatio", cSize * 100.0 / tSize);
                            }
                            fdtSessionParams.put("Status", Double.valueOf(fdtSession.getCurrentStatus()));
                            String monID = fdtSession.getMonID();
                            if (monID != null) {
                                lisaParams.put(monID, fdtSessionParams);
                            } else {
                                lisaParams.put(fdtSession.getRemoteAddress().getHostAddress() + ":" + fdtSession.getRemotePort(), fdtSessionParams);
                            }
                            if (lisaParams.size() > 0) {
                                if (logger.isLoggable(Level.FINE)) {
                                    logger.log(Level.FINE, " Sending to LISA :- Server Params: " + lisaParams);
                                }
                                for (Map.Entry entry : lisaParams.entrySet()) {
                                    HashMap hToSend = (HashMap)entry.getValue();
                                    if (hToSend.size() <= 0) continue;
                                    this.lisaMon.sendClientParameters((String)entry.getKey(), hToSend);
                                }
                            }
                            break block19;
                        }
                        logger.log(Level.WARNING, "[ERROR] FDT Session is not an \"instanceof\" FDTWriterSession or FDTReaderSession!!!");
                        return;
                    }
                    logger.log(Level.WARNING, "[ERROR] FDTSessionMonitoringTask is null in finishFDTSession(fdtSession)!!!");
                }
                catch (Throwable t) {
                    logger.log(Level.WARNING, "Got expcetion notifying last params for " + fdtSession.sessionID(), t);
                }
            } else {
                logger.log(Level.WARNING, "[ERROR] FDT Session is null in finishFDTSession(fdtSession)!!!");
            }
        }
    }

    @Override
    public void startFDTSession(FDTSession fdtSession) {
        this.publishStartFinishParams(fdtSession);
    }

    @Override
    public void finishFDTSession(FDTSession fdtSession) {
        this.publishStartFinishParams(fdtSession);
    }

    private void setupMonClient() {
        try {
            this.lisaMon = new MonClient(this.lisaHost, this.lisaPort);
        }
        catch (Throwable t) {
            if (!this.errorReported) {
                logger.log(Level.WARNING, " Cannot connect to lisa", t);
            } else {
                logger.log(Level.FINER, " Cannot connect to lisa", t);
            }
            this.errorReported = true;
        }
    }

    @Override
    public void run() {
        try {
            if (this.lisaMon == null) {
                this.setupMonClient();
            }
            if (this.lisaMon == null) {
                return;
            }
            this.errorReported = false;
            HashMap<String, HashMap<String, Double>> lisaParams = this.getReaderParams();
            if (lisaParams.size() > 0) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, " Sending to LISA :- Client Params: " + lisaParams);
                }
                for (Map.Entry<String, HashMap<String, Double>> entry : lisaParams.entrySet()) {
                    HashMap<String, Double> hToSend = entry.getValue();
                    if (hToSend.size() <= 0) continue;
                    this.lisaMon.sendClientParameters(entry.getKey(), hToSend);
                }
            }
            lisaParams = this.getWriterParams();
            double totalNet = 0.0;
            double totalDisk = 0.0;
            if (lisaParams.size() > 0) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, " Sending to LISA :- Server Params: " + lisaParams);
                }
                for (Map.Entry<String, HashMap<String, Double>> entry : lisaParams.entrySet()) {
                    HashMap<String, Double> hToSend = entry.getValue();
                    if (hToSend.size() <= 0) continue;
                    Double dToAdd = hToSend.get("NET_IN_Mb");
                    if (dToAdd != null) {
                        totalNet += dToAdd.doubleValue();
                    }
                    if ((dToAdd = hToSend.get("DISK_WRITE_MB")) != null) {
                        totalDisk += dToAdd.doubleValue();
                    }
                    this.lisaMon.sendServerParameters(entry.getKey(), hToSend);
                }
            }
            if (Config.getInstance().getHostName() == null) {
                HashMap<String, Double> localParams = new HashMap<String, Double>();
                localParams.put("CLIENTS_NO", Double.valueOf(lisaParams.size()));
                localParams.put("DISK_WRITE_MB", totalDisk);
                localParams.put("NET_IN_Mb", totalNet);
                this.lisaMon.sendServerParameters("FDT_PARAMS", localParams);
            }
        }
        catch (Throwable t) {
            logger.log(Level.INFO, " LISAReportingTask got exception:", t);
        }
    }

    public void sendClientNow(String key, HashMap<String, Double> params) throws Exception {
        this.lisaMon.sendClientParameters(key, params);
    }

    public void sendServerNow(String key, HashMap<String, Double> params) throws Exception {
        this.lisaMon.sendServerParameters(key, params);
    }
}

