/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.monitoring.lisa;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import lia.util.net.copy.monitoring.lisa.cmdExec;

public class ProcReader {
    static final NumberFormat nf = NumberFormat.getInstance();
    private static final String SYS_EXTENDED_BIN_PATH = "/bin,/sbin,/usr/bin,/usr/sbin,/usr/local/bin";
    public static String[] ResTypes;
    protected final Logger logger;
    private final cmdExec exec;
    private final LinkedList<String> devices = new LinkedList();
    private final HashMap<String, String> diskIOReadKB = new HashMap();
    private final HashMap<String, String> diskIOWriteKB = new HashMap();
    private final HashMap<String, String> dKBRead = new HashMap();
    private final HashMap<String, String> dKBWrite = new HashMap();
    private final Hashtable<String, String> netIn = new Hashtable();
    private final Hashtable<String, String> dnetIn = new Hashtable();
    private final Hashtable<String, String> netOut = new Hashtable();
    private final Hashtable<String, String> dnetOut = new Hashtable();
    protected String[] PROC_FILE_NAMES;
    protected FileReader[] fileReaders;
    protected BufferedReader[] bufferedReaders;
    String[] old;
    String[] cur;
    String[] xtmp;
    String[] diff;
    long last_time_diskIO;
    long last_time_cpu;
    long last_time_net;
    private boolean hasCommonCPUStats;
    private boolean hasCPUIOWaitStats;
    private boolean hasCPUIntStats;
    private boolean hasCPUStealStats;
    private boolean hasPageProcStat;
    private boolean hasSwapProcStat;
    private boolean hasPageProcVmStat;
    private boolean hasSwapProcVmStat;
    private boolean is64BitArch = false;
    private boolean alreadyInitCPU = false;
    private String diskIO = null;
    private String tps = null;
    private double diskTotal;
    private double diskUsed;
    private double diskFree;
    private double memUsage;
    private double memUsed;
    private double memFree;
    private double load1;
    private double load5;
    private double load15;
    private String[] netInterfaces = null;

    public ProcReader(Logger logger) {
        this.logger = logger;
        this.exec = cmdExec.getInstance();
    }

    public static void main(String[] args) {
        HashMap<String, Double> h;
        ProcReader reader = new ProcReader(Logger.getLogger("lisa"));
        System.out.println("***" + reader.getMACAddress());
        try {
            h = reader.getNet();
            System.out.println(h);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            h = reader.getNet();
            System.out.println(h);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final String getMACAddress() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface ni = en.nextElement();
                if (!ni.isLoopback()) {
                    try {
                        String hadr = this.getHexa(ni.getHardwareAddress());
                        if (hadr != null) {
                            return hadr;
                        }
                    }
                    catch (SocketException hadr) {
                        // empty catch block
                    }
                }
                Enumeration<NetworkInterface> en1 = ni.getSubInterfaces();
                while (en1.hasMoreElements()) {
                    ni = en1.nextElement();
                    if (ni.isLoopback()) continue;
                    try {
                        String hadr = this.getHexa(ni.getHardwareAddress());
                        if (hadr == null) continue;
                        return hadr;
                    }
                    catch (SocketException hadr) {
                    }
                }
            }
        }
        catch (Throwable se) {
            this.logger.log(Level.INFO, "Got error retrieving the network interfaces", se);
        }
        String path = this.getIfConfigPath();
        cmdExec.CommandResult cmdRes = this.exec.executeCommandReality("ifconfig -a", "b", path);
        String output = cmdRes.getOutput();
        if (cmdRes.failed()) {
            output = null;
        }
        if (output != null && output.length() != 0 && !output.contains("No such file or directory") && !output.contains("Segmentation fault")) {
            StringTokenizer st = new StringTokenizer(output);
            String line = st.nextToken("\n");
            while (line != null) {
                if (line != null && (line.startsWith(" ") || line.startsWith("\t"))) {
                    line = st.nextToken("\n");
                    continue;
                }
                if (line == null) break;
                StringTokenizer ast = new StringTokenizer(line);
                ast.nextToken(" \t\n");
                if (line.indexOf("HWaddr ") >= 0) {
                    return line.substring(line.indexOf("HWaddr ") + 7);
                }
                line = st.nextToken("\n");
            }
        }
        return null;
    }

    public final HashMap<String, Double> getCPUVM() throws Exception {
        String lin;
        boolean parsedCPU;
        this.initCPUReaders();
        if (this.cur == null) {
            this.cur = new String[ResTypes.length];
        }
        if (this.xtmp == null) {
            this.xtmp = new String[ResTypes.length];
        }
        if (this.diff == null) {
            this.diff = new String[ResTypes.length];
        }
        this.PROC_FILE_NAMES = this.hasSwapProcVmStat || this.hasPageProcVmStat ? new String[]{"/proc/stat", "/proc/vmstat"} : (this.hasCommonCPUStats || this.hasSwapProcStat || this.hasPageProcStat ? new String[]{"/proc/stat"} : null);
        this.createReaders();
        HashMap<String, Double> results = new HashMap<String, Double>();
        long sTime = System.currentTimeMillis();
        int len = ResTypes.length;
        BufferedReader br = this.bufferedReaders[0];
        int index = 0;
        boolean bl = parsedCPU = !this.hasCommonCPUStats;
        while ((lin = br.readLine()) != null) {
            if ((lin = lin.trim()).length() == 0) continue;
            StringTokenizer tz = new StringTokenizer(lin);
            String item = tz.nextToken().trim();
            if (!parsedCPU && this.hasCommonCPUStats && item.equals("cpu")) {
                parsedCPU = true;
                this.cur[index++] = tz.nextToken();
                this.cur[index++] = tz.nextToken();
                this.cur[index++] = tz.nextToken();
                this.cur[index++] = tz.nextToken();
                if (this.hasCPUIOWaitStats) {
                    this.cur[index++] = tz.nextToken();
                    if (this.hasCPUIntStats) {
                        this.cur[index++] = tz.nextToken();
                        this.cur[index++] = tz.nextToken();
                        if (this.hasCPUStealStats) {
                            this.cur[index++] = tz.nextToken();
                        }
                    }
                }
                if (!this.hasPageProcVmStat || !this.hasSwapProcVmStat) continue;
                break;
            }
            if (item.equals("page")) {
                this.cur[index++] = tz.nextToken();
                this.cur[index++] = tz.nextToken();
                continue;
            }
            if (!item.equals("swap")) continue;
            this.cur[index++] = tz.nextToken();
            this.cur[index++] = tz.nextToken();
        }
        if (this.hasSwapProcVmStat || this.hasPageProcVmStat) {
            br = this.bufferedReaders[1];
            int cCount = 0;
            String lin2 = br.readLine();
            while (cCount < 4 && lin2 != null) {
                if ((lin2 = lin2.trim()).startsWith("pgpgin")) {
                    this.cur[len - 4] = lin2.substring(7);
                    ++cCount;
                } else if (lin2.startsWith("pgpgout")) {
                    this.cur[len - 3] = lin2.substring(8);
                    ++cCount;
                } else if (lin2.startsWith("pswpin")) {
                    this.cur[len - 2] = lin2.substring(7);
                    ++cCount;
                } else if (lin2.startsWith("pswpout")) {
                    this.cur[len - 1] = lin2.substring(8);
                    ++cCount;
                }
                lin2 = br.readLine();
            }
        }
        if (this.old == null) {
            this.old = this.cur;
            this.cur = this.xtmp;
            this.last_time_cpu = System.currentTimeMillis();
        } else {
            double d;
            for (int i = 0; i < this.diff.length; ++i) {
                this.diff[i] = this.diffWithOverflowCheck(this.cur[i], this.old[i]);
            }
            String sum = this.addWithOverflowCheck(this.diff[0], this.diff[1]);
            sum = this.addWithOverflowCheck(sum, this.diff[2]);
            sum = this.addWithOverflowCheck(sum, this.diff[3]);
            if (this.hasCPUIOWaitStats) {
                sum = this.addWithOverflowCheck(sum, this.diff[4]);
                if (this.hasCPUIntStats) {
                    sum = this.addWithOverflowCheck(sum, this.diff[5]);
                    sum = this.addWithOverflowCheck(sum, this.diff[6]);
                    if (this.hasCPUStealStats) {
                        sum = this.addWithOverflowCheck(sum, this.diff[7]);
                    }
                }
            }
            index = 0;
            String str1 = this.divideWithOverflowCheck(this.diff[0], sum);
            double totalP = d = Double.parseDouble(str1) * 100.0;
            results.put(ResTypes[index++], d);
            str1 = this.divideWithOverflowCheck(this.diff[1], sum);
            d = Double.parseDouble(str1) * 100.0;
            totalP += d;
            results.put(ResTypes[index++], d);
            str1 = this.divideWithOverflowCheck(this.diff[2], sum);
            d = Double.parseDouble(str1) * 100.0;
            totalP += d;
            results.put(ResTypes[index++], d);
            if (this.hasCPUIOWaitStats) {
                str1 = this.divideWithOverflowCheck(this.diff[4], sum);
                d = Double.parseDouble(str1) * 100.0;
                totalP += d;
                results.put(ResTypes[index++], d);
                if (this.hasCPUIntStats) {
                    str1 = this.divideWithOverflowCheck(this.diff[5], sum);
                    d = Double.parseDouble(str1) * 100.0;
                    totalP += d;
                    results.put(ResTypes[index++], d);
                    str1 = this.divideWithOverflowCheck(this.diff[6], sum);
                    d = Double.parseDouble(str1) * 100.0;
                    totalP += d;
                    results.put(ResTypes[index++], d);
                    if (this.hasCPUStealStats) {
                        str1 = this.divideWithOverflowCheck(this.diff[7], sum);
                        d = Double.parseDouble(str1) * 100.0;
                        totalP += d;
                        results.put(ResTypes[index++], d);
                    }
                }
            }
            str1 = this.divideWithOverflowCheck(this.diff[3], sum);
            d = Double.parseDouble(str1) * 100.0;
            results.put(ResTypes[index++], d);
            if (Math.abs(totalP + d - 0.0) < 1.0E-4) {
                results.put("CPU_Usage", 1.0);
            } else {
                results.put("CPU_usage", totalP / (totalP + d));
            }
            double imp = (double)(sTime - this.last_time_cpu) / 1000.0 * 1024.0;
            results.put(ResTypes[len - 4], Double.valueOf(this.divideWithOverflowCheck(this.diff[len - 4], "" + imp)));
            results.put(ResTypes[len - 3], Double.valueOf(this.divideWithOverflowCheck(this.diff[len - 3], "" + imp)));
            results.put(ResTypes[len - 2], Double.valueOf(this.divideWithOverflowCheck(this.mulWithOverflowCheck(this.diff[len - 2], "4"), "" + imp)));
            results.put(ResTypes[len - 1], Double.valueOf(this.divideWithOverflowCheck(this.mulWithOverflowCheck(this.diff[len - 1], "4"), "" + imp)));
            this.last_time_cpu = sTime;
            this.xtmp = this.old;
            this.old = this.cur;
            this.cur = this.xtmp;
        }
        this.cleanup();
        return results;
    }

    public HashMap<String, Double> getMEM() throws Exception {
        BufferedReader in = new BufferedReader(new FileReader("/proc/meminfo"));
        String line = in.readLine();
        HashMap<String, Double> results = new HashMap<String, Double>();
        double dmemTotal = 0.0;
        double dmemFree = 0.0;
        while (line != null) {
            double d;
            StringTokenizer ast;
            if (line.startsWith("MemTotal:")) {
                String sMemTotal;
                line = line.substring(9);
                ast = new StringTokenizer(line);
                try {
                    sMemTotal = ast.nextToken();
                }
                catch (Exception e) {
                    sMemTotal = null;
                }
                d = 0.0;
                try {
                    d = Double.parseDouble(sMemTotal);
                }
                catch (Exception e) {
                    d = -1.0;
                }
                if (d >= 0.0) {
                    dmemTotal = d;
                }
            }
            if (line.startsWith("MemFree:")) {
                String sMemFree;
                line = line.substring(8);
                ast = new StringTokenizer(line);
                try {
                    sMemFree = ast.nextToken();
                }
                catch (Exception e) {
                    sMemFree = null;
                }
                d = 0.0;
                try {
                    d = Double.parseDouble(sMemFree);
                }
                catch (Exception e) {
                    d = -1.0;
                }
                if (d >= 0.0) {
                    dmemFree = d;
                }
            }
            line = in.readLine();
        }
        this.memFree = dmemFree / 1024.0;
        this.memUsed = (dmemTotal - dmemFree) / 1024.0;
        this.memUsage = 100.0 * (dmemTotal - dmemFree) / dmemTotal;
        results.put("MemUsage", this.memUsage);
        results.put("MemUsed", this.memUsed);
        results.put("MemFree", this.memFree);
        in.close();
        return results;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HashMap<String, Double> getDISK() throws Exception {
        String line;
        String output = this.executeIOStat();
        if (output == null || output.equals("")) return null;
        long now = System.currentTimeMillis();
        this.diskIO = "0.00";
        this.tps = "0.00";
        StringTokenizer st = new StringTokenizer(output);
        try {
            line = st.nextToken("\n");
        }
        catch (Exception e) {
            line = null;
        }
        double imp = (double)(now - this.last_time_diskIO) / 1000.0 * 1024.0;
        while (line != null && !line.contains("Device:")) {
            try {
                line = st.nextToken("\n");
            }
            catch (Exception e) {
                line = null;
            }
        }
        this.devices.clear();
        if (line != null) {
            String diff1 = null;
            String diff2 = null;
            while (true) {
                String str;
                try {
                    str = st.nextToken(" \t\n");
                }
                catch (Exception e) {
                    str = null;
                }
                if (str == null) break;
                String device = str;
                this.devices.addLast(device);
                try {
                    str = st.nextToken(" \t\n");
                }
                catch (Exception e) {
                    str = null;
                }
                this.tps = this.addWithOverflowCheck(str, this.tps);
                try {
                    str = st.nextToken(" \t\n");
                }
                catch (Exception e) {
                    str = null;
                }
                try {
                    str = st.nextToken(" \t\n");
                }
                catch (Exception e) {
                    str = null;
                }
                try {
                    str = st.nextToken(" \t\n");
                }
                catch (Exception e) {
                    str = null;
                }
                String dKBr = this.dKBRead.get(device);
                diff1 = this.diffWithOverflowCheck(str, dKBr == null ? str : dKBr);
                this.diskIO = this.addWithOverflowCheck(diff1, this.diskIO);
                if (this.dKBRead.containsKey(device)) {
                    String s = this.diffWithOverflowCheck(str, dKBr);
                    this.diskIOReadKB.put(device, this.divideWithOverflowCheck(s, "" + imp));
                }
                this.dKBRead.put(device, str);
                try {
                    str = st.nextToken(" \t\n");
                }
                catch (Exception e) {
                    str = null;
                }
                String dKBw = this.dKBWrite.get(device);
                diff2 = this.diffWithOverflowCheck(str, dKBw == null ? str : dKBw);
                this.diskIO = this.addWithOverflowCheck(diff2, this.diskIO);
                if (this.dKBWrite.containsKey(device)) {
                    String s = this.diffWithOverflowCheck(str, dKBw);
                    this.diskIOWriteKB.put(device, this.divideWithOverflowCheck(s, "" + imp));
                }
                this.dKBWrite.put(device, str);
            }
        }
        this.diskIO = this.divideWithOverflowCheck(this.diskIO, "" + imp);
        this.last_time_diskIO = now;
        HashMap<String, Double> results = new HashMap<String, Double>();
        LinkedList<String> toRemove = new LinkedList<String>();
        for (String d : this.dKBRead.keySet()) {
            if (this.devices.contains(d)) continue;
            toRemove.addLast(d);
        }
        for (String d : toRemove) {
            this.dKBRead.remove(d);
            this.dKBWrite.remove(d);
            this.diskIOReadKB.remove(d);
            this.diskIOWriteKB.remove(d);
        }
        output = this.executeDF();
        double size = 0.0;
        double used = 0.0;
        double available = 0.0;
        double usage = 0.0;
        if (output != null && output != "") {
            StringTokenizer st2 = new StringTokenizer(output);
            try {
                line = st2.nextToken(" \t\n");
            }
            catch (Exception e) {
                line = null;
            }
            int nr = 0;
            for (int i = 0; i < 6 && line != null; ++i) {
                try {
                    line = st2.nextToken(" \t\n");
                    continue;
                }
                catch (Exception e) {
                    line = null;
                }
            }
            do {
                try {
                    line = st2.nextToken(" \t\n");
                }
                catch (Exception e) {
                    line = null;
                }
                if (line == null) break;
                try {
                    line = st2.nextToken(" \t\n");
                }
                catch (Exception e) {
                    line = null;
                }
                double d = 0.0;
                try {
                    d = Double.parseDouble(line);
                }
                catch (Exception e) {
                    d = -1.0;
                }
                if (d < 0.0) break;
                size += d;
                try {
                    line = st2.nextToken(" \t\n");
                }
                catch (Exception e) {
                    line = null;
                }
                d = 0.0;
                try {
                    d = Double.parseDouble(line);
                }
                catch (Exception e) {
                    d = -1.0;
                }
                if (d < 0.0) break;
                used += d;
                try {
                    line = st2.nextToken(" \t\n");
                }
                catch (Exception e) {
                    line = null;
                }
                d = 0.0;
                try {
                    d = Double.parseDouble(line);
                }
                catch (Exception e) {
                    d = -1.0;
                }
                if (d < 0.0) break;
                available += d;
                try {
                    line = st2.nextToken(" \t\n");
                }
                catch (Exception e) {
                    line = null;
                }
                try {
                    line = line.substring(0, line.indexOf("%"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                d = 0.0;
                try {
                    d = Double.parseDouble(line);
                }
                catch (Exception e) {
                    d = -1.0;
                }
                if (d < 0.0) break;
                usage += d;
                ++nr;
                try {
                    line = st2.nextToken(" \t\n");
                }
                catch (Exception e) {
                    line = null;
                }
            } while (line != null);
            this.diskTotal = size / 1048576.0;
            this.diskUsed = used / 1048576.0;
            this.diskFree = available / 1048576.0;
        } else {
            String[] files = this.listFiles("/proc/ide");
            if (files != null && files.length != 0) {
                for (int i = 0; i < files.length; ++i) {
                    if (!files[i].startsWith("hd")) continue;
                    try {
                        BufferedReader in = new BufferedReader(new FileReader("/proc/ide/" + files[i] + "/capacity"));
                        line = in.readLine();
                        double d = 0.0;
                        try {
                            d = Double.parseDouble(line);
                        }
                        catch (Exception e) {
                            d = -1.0;
                        }
                        if (d >= 0.0) {
                            size += d;
                        }
                        in.close();
                        continue;
                    }
                    catch (Exception in) {
                        // empty catch block
                    }
                }
            }
            this.diskFree = this.diskTotal = size / 1048576.0;
        }
        try {
            results.put("DiskIO", Double.valueOf(this.diskIO));
        }
        catch (Exception e) {
            results.put("DiskIO", -1.0);
        }
        try {
            results.put("TPS", Double.valueOf(this.tps));
        }
        catch (Exception e) {
            results.put("TPS", -1.0);
        }
        if (this.devices != null) {
            for (String dev : this.devices) {
                if (this.diskIOReadKB.containsKey(dev)) {
                    try {
                        results.put("DiskIORead_" + dev, Double.valueOf(this.diskIOReadKB.get(dev)));
                    }
                    catch (Exception e) {
                        results.put("DiskIORead_" + dev, -1.0);
                    }
                }
                if (!this.diskIOWriteKB.containsKey(dev)) continue;
                try {
                    results.put("DiskIORead_" + dev, Double.valueOf(this.diskIOReadKB.get(dev)));
                }
                catch (Exception e) {
                    results.put("DiskIORead_" + dev, -1.0);
                }
            }
        }
        results.put("DiskTotal", this.diskTotal);
        results.put("DiskUsed", this.diskUsed);
        results.put("DiskFree", this.diskFree);
        results.put("DiskUsage", new Double(100.0 * this.diskUsed / (this.diskUsed + this.diskFree)));
        toRemove.clear();
        return results;
    }

    public int getProcesses() {
        String[] files = this.listFiles("/proc");
        if (files != null && files.length != 0) {
            int nr = 0;
            for (int i = 0; i < files.length; ++i) {
                char[] chars = files[i].toCharArray();
                boolean isProc = true;
                for (int j = 0; j < chars.length; ++j) {
                    if (Character.isDigit(chars[j])) continue;
                    isProc = false;
                    break;
                }
                if (!isProc) continue;
                ++nr;
            }
            return nr;
        }
        return -1;
    }

    public HashMap<String, Double> getLOAD() throws Exception {
        String line;
        BufferedReader in = new BufferedReader(new FileReader("/proc/loadavg"));
        String f = "";
        while ((line = in.readLine()) != null) {
            f = f + "\n" + line;
        }
        in.close();
        HashMap<String, Double> results = new HashMap<String, Double>();
        StringTokenizer st = new StringTokenizer(f);
        try {
            line = st.nextToken(" \t\n");
        }
        catch (Exception e) {
            line = null;
        }
        if (line != null) {
            double d = 0.0;
            try {
                d = Double.parseDouble(line);
            }
            catch (Exception e) {
                d = -1.0;
            }
            if (d >= 0.0) {
                this.load1 = d;
            }
            try {
                line = st.nextToken(" \t\n");
            }
            catch (Exception e) {
                line = null;
            }
            d = 0.0;
            try {
                d = Double.parseDouble(line);
            }
            catch (Exception e) {
                d = -1.0;
            }
            if (d >= 0.0) {
                this.load5 = d;
            }
            try {
                line = st.nextToken(" \t\n");
            }
            catch (Exception e) {
                line = null;
            }
            d = 0.0;
            try {
                d = Double.parseDouble(line);
            }
            catch (Exception e) {
                d = -1.0;
            }
            if (d >= 0.0) {
                this.load15 = d;
            }
        }
        results.put("Load1", this.load1);
        results.put("Load5", this.load5);
        results.put("Load15", this.load15);
        return results;
    }

    public HashMap<String, Double> getNet() throws Exception {
        long now;
        HashMap<String, Double> results;
        block58: {
            String line;
            BufferedReader in = new BufferedReader(new FileReader("/proc/net/dev"));
            String f = "";
            while ((line = in.readLine()) != null) {
                f = f + "\n" + line;
            }
            in.close();
            results = new HashMap<String, Double>();
            StringTokenizer st = new StringTokenizer(f);
            now = System.currentTimeMillis();
            if (this.netInterfaces == null) {
                while (true) {
                    try {
                        line = st.nextToken(":\n\t ");
                    }
                    catch (Exception e) {
                        line = null;
                    }
                    if (line == null) break block58;
                    if (!line.startsWith("eth") && !line.startsWith("lo")) continue;
                    this.addNetInterface(line);
                    String name = line;
                    try {
                        line = st.nextToken(" \t\n");
                    }
                    catch (Exception e) {
                        line = null;
                    }
                    if (this.dnetIn.containsKey(name)) {
                        String lastIn = this.dnetIn.get(name);
                        try {
                            double d = Double.parseDouble(this.diffWithOverflowCheck(line, lastIn));
                            d = d * 8.0 / (double)(now - this.last_time_net) / 1000.0;
                            this.netIn.put(name, "" + d);
                        }
                        catch (Exception d) {
                            // empty catch block
                        }
                        this.dnetIn.put(name, line);
                    } else {
                        this.netIn.put(name, line);
                        this.dnetIn.put(name, line);
                    }
                    for (int i = 0; i < 7; ++i) {
                        try {
                            line = st.nextToken(" \t\n");
                            continue;
                        }
                        catch (Exception e) {
                            line = null;
                        }
                    }
                    try {
                        line = st.nextToken(" \t\n");
                    }
                    catch (Exception e) {
                        line = null;
                    }
                    if (this.dnetOut.containsKey(name)) {
                        String lastOut = this.dnetOut.get(name);
                        try {
                            double d = Double.parseDouble(this.diffWithOverflowCheck(line, lastOut));
                            d = d * 8.0 / (double)(now - this.last_time_net) / 1000.0;
                            this.netOut.put(name, "" + d);
                        }
                        catch (Exception d) {
                            // empty catch block
                        }
                        this.dnetOut.put(name, line);
                        continue;
                    }
                    this.netOut.put(name, line);
                    this.dnetOut.put(name, line);
                }
            }
            while (true) {
                try {
                    line = st.nextToken(":\n\t ");
                }
                catch (Exception e) {
                    line = null;
                }
                if (line == null) break;
                boolean found = false;
                for (int i = 0; i < this.netInterfaces.length; ++i) {
                    if (!line.equals(this.netInterfaces[i])) continue;
                    found = true;
                    break;
                }
                if (found) {
                    String name = line;
                    try {
                        line = st.nextToken(" \t\n:");
                    }
                    catch (Exception e) {
                        line = null;
                    }
                    if (this.dnetIn.containsKey(name)) {
                        String lastIn = this.dnetIn.get(name);
                        try {
                            double d = Double.parseDouble(this.diffWithOverflowCheck(line, lastIn));
                            d = d * 8.0 / (double)(now - this.last_time_net) / 1000.0;
                            this.netIn.put(name, "" + d);
                        }
                        catch (Exception d) {
                            // empty catch block
                        }
                        this.dnetIn.put(name, line);
                    } else {
                        this.netIn.put(name, line);
                        this.dnetIn.put(name, line);
                    }
                    for (int i = 0; i < 7; ++i) {
                        try {
                            line = st.nextToken(" \t\n");
                            continue;
                        }
                        catch (Exception e) {
                            line = null;
                        }
                    }
                    try {
                        line = st.nextToken(" \t\n");
                    }
                    catch (Exception e) {
                        line = null;
                    }
                    if (this.dnetOut.containsKey(name)) {
                        String lastOut = this.dnetOut.get(name);
                        try {
                            double d = Double.parseDouble(this.diffWithOverflowCheck(line, lastOut));
                            d = d * 8.0 / (double)(now - this.last_time_net) / 1000.0;
                            this.netOut.put(name, "" + d);
                        }
                        catch (Exception d) {
                            // empty catch block
                        }
                        this.dnetOut.put(name, line);
                        continue;
                    }
                    this.netOut.put(name, line);
                    this.dnetOut.put(name, line);
                    continue;
                }
                if (!line.startsWith("eth") && !line.startsWith("lo")) continue;
                this.addNetInterface(line);
                String name = line;
                try {
                    line = st.nextToken(" \t\n");
                }
                catch (Exception e) {
                    line = null;
                }
                if (this.dnetIn.containsKey(name)) {
                    String lastIn = this.dnetIn.get(name);
                    try {
                        double d = Double.parseDouble(this.diffWithOverflowCheck(line, lastIn));
                        d = d * 8.0 / (double)(now - this.last_time_net) / 1000.0;
                        this.netIn.put(name, "" + d);
                    }
                    catch (Exception d) {
                        // empty catch block
                    }
                    this.dnetIn.put(name, line);
                } else {
                    this.netIn.put(name, line);
                    this.dnetIn.put(name, line);
                }
                for (int i = 0; i < 7; ++i) {
                    try {
                        line = st.nextToken(" \t\n");
                        continue;
                    }
                    catch (Exception e) {
                        line = null;
                    }
                }
                try {
                    line = st.nextToken(" \t\n");
                }
                catch (Exception e) {
                    line = null;
                }
                if (this.dnetOut.containsKey(name)) {
                    String lastOut = this.dnetOut.get(name);
                    try {
                        double d = Double.parseDouble(this.diffWithOverflowCheck(line, lastOut));
                        d = d * 8.0 / (double)(now - this.last_time_net) / 1000.0;
                        this.netOut.put(name, "" + d);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.dnetOut.put(name, line);
                    continue;
                }
                this.netOut.put(name, line);
                this.dnetOut.put(name, line);
            }
        }
        this.last_time_net = now;
        if (this.netInterfaces != null && this.netInterfaces.length != 0) {
            for (int i = 0; i < this.netInterfaces.length; ++i) {
                String ifName = this.netInterfaces[i];
                try {
                    results.put("In_" + ifName, Double.valueOf(this.netIn.get(ifName)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    results.put("Out_" + ifName, Double.valueOf(this.netOut.get(ifName)));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return results;
    }

    private final String getHexa(byte[] b) {
        if (b == null || b.length == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            int d1;
            byte value;
            int d2 = (value & 0xF0) >> 4;
            buf.append((char)(d2 += d2 < 10 ? 48 : 55)).append((char)(d1 += (d1 = (value = b[i]) & 0xF) < 10 ? 48 : 55));
            if (i >= b.length - 1) continue;
            buf.append(':');
        }
        return buf.toString();
    }

    private final synchronized String getIfConfigPath() {
        String path = SYS_EXTENDED_BIN_PATH;
        if (System.getProperty("ifconfig.path", null) != null) {
            path = System.getProperty("ifconfig.path");
        }
        if (path == null || path.length() == 0) {
            this.logger.warning("[Host - ifconfig can not be found in " + path + "]");
            return null;
        }
        return path.replace(',', ':').trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void initCPUReaders() {
        if (this.alreadyInitCPU) {
            return;
        }
        try {
            String line2;
            ArrayList<String> al = new ArrayList<String>(15);
            InputStreamReader fr = null;
            BufferedReader br = null;
            File procFile = null;
            try {
                procFile = new File("/proc/stat");
                if (procFile.exists() && procFile.canRead()) {
                    fr = new FileReader("/proc/stat");
                    br = new BufferedReader(fr);
                    line2 = br.readLine();
                    boolean parsedCPU = false;
                    while (line2 != null) {
                        line2 = line2.trim();
                        if (!parsedCPU && line2.startsWith("cpu")) {
                            parsedCPU = true;
                            String[] tokens = line2.split("(\\s)+");
                            int len = tokens.length;
                            if (len >= 5) {
                                al.add("CPU_usr");
                                al.add("CPU_nice");
                                al.add("CPU_sys");
                                this.hasCommonCPUStats = true;
                                if (len >= 6) {
                                    al.add("CPU_iowait");
                                    this.hasCPUIOWaitStats = true;
                                    if (len >= 8) {
                                        al.add("CPU_int");
                                        al.add("CPU_softint");
                                        this.hasCPUIntStats = true;
                                        if (len >= 9) {
                                            al.add("CPU_steal");
                                            this.hasCPUStealStats = true;
                                        }
                                    }
                                }
                                al.add("CPU_idle");
                            }
                        } else if (line2.startsWith("page")) {
                            this.hasPageProcStat = true;
                        } else if (line2.startsWith("swap")) {
                            this.hasSwapProcStat = true;
                        }
                        line2 = br.readLine();
                    }
                }
            }
            catch (Throwable pft) {
                this.logger.log(Level.WARNING, "Checking for /proc/stat yield a caught exception ", pft);
            }
            finally {
                try {
                    if (fr != null) {
                        fr.close();
                    }
                    if (br != null) {
                        br.close();
                    }
                }
                catch (Throwable line2) {}
                fr = null;
                br = null;
            }
            procFile = new File("/proc/vmstat");
            try {
                if (procFile.exists() && procFile.canRead()) {
                    fr = new FileReader("/proc/vmstat");
                    br = new BufferedReader(fr);
                    line2 = br.readLine();
                    while (line2 != null) {
                        if ((line2 = line2.trim()).startsWith("pgpgin")) {
                            this.hasPageProcVmStat = true;
                        } else if (line2.startsWith("pswpin")) {
                            this.hasSwapProcVmStat = true;
                        }
                        line2 = br.readLine();
                    }
                }
            }
            catch (Throwable pft) {
                this.logger.log(Level.WARNING, "Checking for /proc/vmstat yield a caught exception ", pft);
            }
            finally {
                try {
                    if (fr != null) {
                        fr.close();
                    }
                    if (br != null) {
                        br.close();
                    }
                }
                catch (Throwable line3) {}
                fr = null;
                br = null;
            }
            if (this.hasPageProcStat || this.hasPageProcVmStat) {
                al.add("Page_in");
                al.add("Page_out");
            }
            if (this.hasSwapProcStat || this.hasSwapProcVmStat) {
                al.add("Swap_in");
                al.add("Swap_out");
            }
            ResTypes = al.toArray(new String[al.size()]);
            this.alreadyInitCPU = true;
        }
        catch (Throwable t) {
            this.logger.log(Level.WARNING, "Got exception in init. The module will not be used for local monitoring ", t);
        }
    }

    protected void resetReaders() throws Exception {
        this.createReaders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        int i;
        if (this.bufferedReaders != null) {
            for (i = 0; i < this.bufferedReaders.length; ++i) {
                try {
                    if (this.bufferedReaders[i] == null) continue;
                    this.bufferedReaders[i].close();
                    continue;
                }
                catch (Throwable t) {
                    this.logger.log(Level.WARNING, "Got exception closing buffered reader [ " + i + " ] ", t);
                    continue;
                }
                finally {
                    this.bufferedReaders[i] = null;
                }
            }
        }
        if (this.fileReaders != null) {
            for (i = 0; i < this.fileReaders.length; ++i) {
                try {
                    if (this.fileReaders[i] == null) continue;
                    this.fileReaders[i].close();
                    continue;
                }
                catch (Throwable t) {
                    this.logger.log(Level.WARNING, "Got exception closing file reader [ " + i + " ] ", t);
                    continue;
                }
                finally {
                    this.fileReaders[i] = null;
                }
            }
        }
    }

    private void createReaders() throws Exception {
        this.cleanup();
        if (this.PROC_FILE_NAMES == null) {
            throw new Exception(" PROC_FILE_NAMES is null");
        }
        if (this.bufferedReaders == null || this.bufferedReaders.length != this.PROC_FILE_NAMES.length) {
            this.bufferedReaders = new BufferedReader[this.PROC_FILE_NAMES.length];
        }
        if (this.fileReaders == null || this.fileReaders.length != this.PROC_FILE_NAMES.length) {
            this.fileReaders = new FileReader[this.PROC_FILE_NAMES.length];
        }
        for (int i = 0; i < this.PROC_FILE_NAMES.length; ++i) {
            try {
                if (this.PROC_FILE_NAMES[i] != null) {
                    this.fileReaders[i] = new FileReader(this.PROC_FILE_NAMES[i]);
                    this.bufferedReaders[i] = new BufferedReader(this.fileReaders[i]);
                    continue;
                }
                this.logger.warning("PROC_FILE_NAMES[" + i + "] is null");
                continue;
            }
            catch (Throwable t) {
                this.logger.log(Level.WARNING, "Got exc creating Readers [ " + i + " ] :- " + this.PROC_FILE_NAMES[i] + " ", t);
            }
        }
    }

    private String addWithOverflowCheck(String newVal, String oldVal) throws NumberFormatException {
        if (newVal == null) {
            return oldVal;
        }
        if (oldVal == null) {
            return newVal;
        }
        if (this.is64BitArch) {
            String str = this.prepareString(newVal);
            BigDecimal newv = null;
            try {
                newv = new BigDecimal(str);
            }
            catch (Throwable t) {
                this.logger.log(Level.WARNING, "Got exception " + t + " for " + str);
            }
            str = this.prepareString(oldVal);
            BigDecimal oldv = null;
            try {
                oldv = new BigDecimal(str);
            }
            catch (Throwable t) {
                this.logger.log(Level.WARNING, "Got exception " + t + " for " + str);
            }
            return newv.add(oldv).toString();
        }
        double toCompare = 4.294967296E9;
        double newv = Double.parseDouble(newVal);
        double oldv = Double.parseDouble(oldVal);
        if (newv >= toCompare || oldv >= toCompare) {
            this.is64BitArch = true;
            return this.addWithOverflowCheck(newVal, oldVal);
        }
        return "" + (newv + oldv);
    }

    private String divideWithOverflowCheck(String newVal, String oldVal) throws NumberFormatException {
        if (this.is64BitArch) {
            String str = this.prepareString(newVal);
            BigDecimal newv = null;
            try {
                newv = new BigDecimal(str);
            }
            catch (Throwable t) {
                this.logger.log(Level.WARNING, "Got exception " + t + " for " + str);
            }
            str = this.prepareString(oldVal);
            BigDecimal oldv = null;
            try {
                oldv = new BigDecimal(str);
            }
            catch (Throwable t) {
                this.logger.log(Level.WARNING, "Got exception " + t + " for " + str);
            }
            return newv.divide(oldv, 3).toString();
        }
        double toCompare = 4.294967296E9;
        double newv = Double.parseDouble(newVal);
        double oldv = Double.parseDouble(oldVal);
        if (newv >= toCompare || oldv >= toCompare) {
            this.is64BitArch = true;
            return this.divideWithOverflowCheck(newVal, oldVal);
        }
        return "" + newv / oldv;
    }

    private String mulWithOverflowCheck(String newVal, String oldVal) throws NumberFormatException {
        if (this.is64BitArch) {
            String str = this.prepareString(newVal);
            BigDecimal newv = null;
            try {
                newv = new BigDecimal(str);
            }
            catch (Throwable t) {
                this.logger.log(Level.WARNING, "Got exception " + t + " for " + str);
            }
            str = this.prepareString(oldVal);
            BigDecimal oldv = null;
            try {
                oldv = new BigDecimal(str);
            }
            catch (Throwable t) {
                this.logger.log(Level.WARNING, "Got exception " + t + " for " + str);
            }
            return newv.multiply(oldv).toString();
        }
        double toCompare = 4.294967296E9;
        double newv = Double.parseDouble(newVal);
        double oldv = Double.parseDouble(oldVal);
        if (newv >= toCompare || oldv >= toCompare) {
            this.is64BitArch = true;
            return this.mulWithOverflowCheck(newVal, oldVal);
        }
        return "" + newv * oldv;
    }

    private String diffWithOverflowCheck(String newVal, String oldVal) throws NumberFormatException {
        if (this.is64BitArch) {
            String str = this.prepareString(newVal);
            BigDecimal newv = null;
            try {
                newv = new BigDecimal(str);
            }
            catch (Throwable t) {
                this.logger.log(Level.WARNING, "Got exception " + t + " for " + str);
            }
            str = this.prepareString(oldVal);
            BigDecimal oldv = null;
            try {
                oldv = new BigDecimal(str);
            }
            catch (Throwable t) {
                this.logger.log(Level.WARNING, "Got exception " + t + " for " + str);
            }
            if (newv.compareTo(oldv) >= 0) {
                return newv.subtract(oldv).toString();
            }
            BigInteger overflow = new BigInteger("1").shiftLeft(64);
            BigDecimal d = new BigDecimal(overflow.toString());
            return newv.add(d).subtract(oldv).toString();
        }
        double toCompare = 4.294967296E9;
        double newv = Double.parseDouble(newVal);
        double oldv = Double.parseDouble(oldVal);
        if (newv >= toCompare || oldv >= toCompare) {
            this.is64BitArch = true;
            return this.diffWithOverflowCheck(newVal, oldVal);
        }
        if (newv >= oldv) {
            return "" + (newv - oldv);
        }
        long vmax = 0x100000000L;
        return "" + (newv - oldv + (double)vmax);
    }

    private final String prepareString(String str) {
        try {
            double d = Double.parseDouble(str);
            if (!Double.isInfinite(d) && !Double.isNaN(d)) {
                String n = nf.format(d);
                n = n.replaceAll(",", "");
                return n;
            }
        }
        catch (Throwable d) {
            // empty catch block
        }
        if (!str.contains(".")) {
            return str + ".0000";
        }
        int nr = str.lastIndexOf(46) + 1;
        for (int i = nr = str.length() - nr; i < 4; ++i) {
            str = str + "0";
        }
        return str;
    }

    private final synchronized String executeIOStat() {
        String path = "/bin,/sbin,/usr/bin,/usr/sbin,/usr/local/bin," + System.getProperty("user.home");
        if (System.getProperty("iostat.path", null) != null) {
            path = System.getProperty("iostat.path");
        }
        if (path != null && path.length() != 0) {
            path = path.replace(',', ':').trim();
        }
        cmdExec.CommandResult cmdRes = this.exec.executeCommandReality("iostat -k", "L", path);
        String output = cmdRes.getOutput();
        if (!(cmdRes.failed() || output.length() == 0 || output.contains("No such file or directory") || output.contains("Segmentation fault"))) {
            return output;
        }
        return null;
    }

    private final synchronized String executeDF() {
        String path = SYS_EXTENDED_BIN_PATH;
        if (System.getProperty("df.path", null) != null) {
            path = System.getProperty("df.path");
        }
        if (path != null && path.length() != 0) {
            path = path.replace(",", ":").trim();
        }
        cmdExec.CommandResult cmdRes = this.exec.executeCommandReality("df -B 1024", "o", path);
        String output = cmdRes.getOutput();
        if (!(cmdRes.failed() || output.length() == 0 || output.contains("No such file or directory") || output.contains("Segmentation fault"))) {
            return output;
        }
        return null;
    }

    private String[] listFiles(String directory) {
        String[] fileList = null;
        try {
            File dir = new File(directory);
            if (!dir.isDirectory()) {
                return null;
            }
            File[] list = dir.listFiles();
            if (list == null) {
                return null;
            }
            fileList = new String[list.length];
            for (int i = 0; i < list.length; ++i) {
                fileList[i] = list[i].getName();
            }
        }
        catch (Exception e) {
            return null;
        }
        return fileList;
    }

    private void addNetInterface(String netInterface) {
        if (netInterface == null || netInterface.equals("")) {
            return;
        }
        netInterface = netInterface.trim();
        if (this.netInterfaces == null) {
            this.netInterfaces = new String[1];
            this.netInterfaces[0] = netInterface;
            return;
        }
        for (int i = 0; i < this.netInterfaces.length; ++i) {
            if (!netInterface.equals(this.netInterfaces[i])) continue;
            return;
        }
        String[] tmpNetInterfaces = new String[this.netInterfaces.length + 1];
        System.arraycopy(this.netInterfaces, 0, tmpNetInterfaces, 0, this.netInterfaces.length);
        tmpNetInterfaces[this.netInterfaces.length] = netInterface;
        this.netInterfaces = tmpNetInterfaces;
    }

    static {
        nf.setMaximumFractionDigits(4);
        nf.setMinimumFractionDigits(4);
    }
}

