/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.transport;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import lia.util.net.common.Utils;

public class PingDaemon {
    private static final Logger logger = Logger.getLogger("lia.util.net.copy.transport.PingDaemon");
    private static final int DEFAULT_CONNECT_DELAY = 20;
    private static final int DEFAULT_PING_DELAY = 20;
    private static final TimeUnit DEFAULT_PING_DELAY_TIME_UNIT = TimeUnit.SECONDS;
    private static final int DEFAULT_PACKET_SIZE = 1500;
    private static final int FDT_PING = 1;
    private static final int FDT_PING_REPLY = 2;
    private long pingDelay;
    private TimeUnit pingDelayTimeUnit;
    private SocketChannel sc;
    private int packetSize;
    private ByteBuffer header;
    private ByteBuffer payload;
    private long SEQ = 0L;
    private ByteBuffer[] toSend = new ByteBuffer[2];

    public PingDaemon(SocketChannel sc) throws Exception {
        sc.configureBlocking(true);
        this.sc = sc;
        this.initChannels();
        new PingServer().start();
    }

    public PingDaemon(InetAddress inetAddr, int port) throws Exception {
        this(inetAddr, port, 20, 20L, DEFAULT_PING_DELAY_TIME_UNIT, 1500);
    }

    public PingDaemon(InetAddress inetAddr, int port, long pingDelay, TimeUnit pingDelayTimeUnit, int packetSize) throws Exception {
        this(inetAddr, port, 20, pingDelay, pingDelayTimeUnit, packetSize);
    }

    public PingDaemon(InetAddress inetAddr, int port, int connectDelay, long pingDelay, TimeUnit pingDelayTimeUnit, int packetSize) throws Exception {
        this.packetSize = packetSize;
        this.pingDelay = pingDelay;
        this.pingDelayTimeUnit = pingDelayTimeUnit;
        this.sc = SocketChannel.open();
        this.sc.configureBlocking(true);
        this.sc.socket().connect(new InetSocketAddress(inetAddr, port), 30000);
        this.initChannels();
        this.payload = ByteBuffer.allocateDirect(1500 - this.header.capacity());
        this.header.putInt(1);
        this.header.putInt(1);
        this.header.putInt(this.payload.capacity());
        this.toSend[0] = this.header;
        this.toSend[1] = this.payload;
        Utils.getMonitoringExecService().scheduleWithFixedDelay(new PingerTask(), 5L, 20L, TimeUnit.SECONDS);
    }

    public static final void main(String[] args) throws Exception {
        try {
            if (args != null && args.length != 0) {
                if (args.length == 1) {
                    int port = Integer.parseInt(args[0]);
                    ServerSocketChannel ssc = ServerSocketChannel.open();
                    ssc.configureBlocking(true);
                    ssc.socket().bind(new InetSocketAddress(port));
                    try {
                        SocketChannel sc = ssc.accept();
                        new PingDaemon(sc);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                } else if (args.length == 2) {
                    InetAddress ia = InetAddress.getByName(args[0]);
                    int port = Integer.parseInt(args[1]);
                    new PingDaemon(ia, port);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
        while (true) {
            try {
                while (true) {
                    Thread.sleep(100000L);
                }
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    private void initChannels() throws Exception {
        this.header = ByteBuffer.allocateDirect(20);
    }

    public void setDelay(long pingDelay, TimeUnit pingDelayTimeUnit) {
        this.pingDelay = pingDelay;
        this.pingDelayTimeUnit = pingDelayTimeUnit;
    }

    public void setPacketSize(int packetSize) {
        this.packetSize = packetSize;
    }

    private final class PingerTask
    implements Runnable {
        private PingerTask() {
        }

        @Override
        public void run() {
            try {
                PingDaemon.this.header.position(12);
                PingDaemon.this.header.putLong(PingDaemon.this.SEQ++);
                PingDaemon.this.header.position(PingDaemon.this.header.capacity());
                PingDaemon.this.payload.position(PingDaemon.this.payload.capacity());
                PingDaemon.this.header.flip();
                PingDaemon.this.payload.flip();
                long sTime = System.nanoTime();
                System.out.println(" Written: " + PingDaemon.this.sc.write(PingDaemon.this.toSend));
                PingDaemon.this.header.clear();
                PingDaemon.this.payload.clear();
                PingDaemon.this.sc.read(PingDaemon.this.toSend);
                long finishTime = System.nanoTime();
                System.out.println(" DT = " + (double)(finishTime - sTime) / 1000000.0 + " ms");
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Got exception", t);
            }
        }
    }

    private final class PingServer
    extends Thread {
        public PingServer() {
            super(" (FDT) Ping Daemon");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            block2: while (true) {
                try {
                    while (PingDaemon.this.sc.isOpen() && !PingDaemon.this.sc.socket().isClosed()) {
                        PingDaemon.this.header.clear();
                        if (PingDaemon.this.sc.read(PingDaemon.this.header) == -1) break block2;
                        PingDaemon.this.header.flip();
                        int type = PingDaemon.this.header.getInt();
                        int version = PingDaemon.this.header.getInt();
                        int payloadSize = PingDaemon.this.header.getInt();
                        long seq = PingDaemon.this.header.getLong();
                        System.out.println("Read from client: [ SEQ: " + seq + " type: " + type + " version: " + version + " payloadSize: " + payloadSize + " ]");
                        if (PingDaemon.this.payload == null || PingDaemon.this.payload.capacity() != payloadSize) {
                            PingDaemon.this.payload = ByteBuffer.allocateDirect(payloadSize);
                            ((PingDaemon)PingDaemon.this).toSend[0] = PingDaemon.this.header;
                            ((PingDaemon)PingDaemon.this).toSend[1] = PingDaemon.this.payload;
                        }
                        PingDaemon.this.payload.clear();
                        PingDaemon.this.sc.read(PingDaemon.this.payload);
                        PingDaemon.this.header.flip();
                        PingDaemon.this.header.putInt(2);
                        PingDaemon.this.header.position(PingDaemon.this.header.capacity());
                        PingDaemon.this.payload.position(PingDaemon.this.payload.capacity());
                        PingDaemon.this.header.flip();
                        PingDaemon.this.payload.flip();
                        PingDaemon.this.sc.write(PingDaemon.this.toSend);
                    }
                }
                catch (Throwable t) {
                    logger.log(Level.WARNING, "Got exception ", t);
                    continue;
                }
                break;
            }
            System.out.println("Server exits!");
        }
    }
}

