/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.transport;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import lia.util.net.common.Config;
import lia.util.net.common.DirectByteBufferPool;
import lia.util.net.common.HeaderBufferPool;
import lia.util.net.common.Utils;
import lia.util.net.copy.FileBlock;
import lia.util.net.copy.FileBlockProducer;
import lia.util.net.copy.transport.FDTKeyAttachement;
import lia.util.net.copy.transport.FDTWriterKeyAttachement;
import lia.util.net.copy.transport.SocketTask;
import lia.util.net.copy.transport.TCPSessionWriter;
import lia.util.net.copy.transport.internal.FDTSelectionKey;

public class SocketWriterTask
extends SocketTask {
    private static final Logger logger = Logger.getLogger(SocketWriterTask.class.getName());
    private static final int BUFF_LEN_SIZE = Config.NETWORK_BUFF_LEN_SIZE;
    private final AtomicReference<FDTSelectionKey> fdtSelectionKeyRef = new AtomicReference<Object>(null);
    private final TCPSessionWriter master;
    private final FileBlockProducer fileBlockProducer;
    private final boolean isNetTest;

    SocketWriterTask(BlockingQueue<FDTSelectionKey> readyChannelsQueue, FileBlockProducer fileBlockProducer, TCPSessionWriter master) {
        super(readyChannelsQueue);
        this.fileBlockProducer = fileBlockProducer;
        this.master = master;
        this.isNetTest = master.isNetTest();
    }

    private long writeToChannel(SocketChannel sc, ByteBuffer[] buffsToWrite) throws IOException {
        ByteBuffer[] bToWrite = buffsToWrite;
        if (this.isNetTest) {
            for (ByteBuffer b : bToWrite) {
                b.position(0);
                b.limit(b.capacity());
            }
        }
        return sc.write(bToWrite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long writeData() throws IOException, InterruptedException {
        long count;
        FDTWriterKeyAttachement attach;
        block54: {
            boolean logFinest;
            FDTSelectionKey fdtSelectionKey = this.fdtSelectionKeyRef.get();
            attach = (FDTWriterKeyAttachement)fdtSelectionKey.attachment();
            boolean connectCookieSent = attach.connectCookieSent.get();
            count = -1L;
            SocketChannel sc = fdtSelectionKey.channel();
            int mss = fdtSelectionKey.getMSS();
            int bufferSize = BUFF_LEN_SIZE;
            mss = -1;
            if (mss > 0) {
                bufferSize = mss;
            }
            if (logFinest = logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Using MSS: " + bufferSize + " for socket channel: " + sc);
            }
            DirectByteBufferPool dbPool = DirectByteBufferPool.getInstance();
            HeaderBufferPool hbPool = HeaderBufferPool.getInstance();
            while (true) {
                count = -1L;
                if (!attach.hasBuffers()) {
                    if (this.isNetTest) {
                        ByteBuffer bb = null;
                        ByteBuffer hh = null;
                        try {
                            bb = dbPool.take();
                            hh = hbPool.take();
                        }
                        finally {
                            if (this.isClosed() || Thread.currentThread().isInterrupted()) {
                                if (bb != null) {
                                    dbPool.put(bb);
                                }
                                if (hh != null) {
                                    hbPool.put(hh);
                                }
                                return count;
                            }
                        }
                        if (hh == null || bb == null) {
                            if (bb != null) {
                                dbPool.put(bb);
                            }
                            if (hh != null) {
                                hbPool.put(hh);
                            }
                            attach.updateLastOperation();
                            this.readyChannelsQueue.offer(fdtSelectionKey);
                            if (logFinest) {
                                logger.log(Level.FINEST, " [ SocketWriterTask ] Empty FD queue. Added SK: " + fdtSelectionKey + " NEW Sel Queue: " + this.readyChannelsQueue);
                            }
                            return 0L;
                        }
                        bb.position(0);
                        bb.limit(bb.capacity());
                        hh.position(0);
                        hh.limit(hh.capacity());
                        attach.setBuffers(hh, bb);
                    } else {
                        FileBlock fb = this.fileBlockProducer.poll(5L, TimeUnit.SECONDS);
                        if (fb == null) {
                            attach.updateLastOperation();
                            this.readyChannelsQueue.offer(fdtSelectionKey);
                            if (logFinest) {
                                logger.log(Level.FINEST, " [ SocketWriterTask ] Empty FD queue. Added SK: " + fdtSelectionKey + " NEW Sel Queue: " + this.readyChannelsQueue);
                            }
                            return 0L;
                        }
                        boolean bRet = false;
                        try {
                            bRet = FDTWriterKeyAttachement.fromFileBlock(fb, attach);
                        }
                        finally {
                            if (!bRet) {
                                attach.recycleBuffers();
                                if (fb != null && fb.buff != null) {
                                    dbPool.put(fb.buff);
                                    fb = null;
                                }
                            }
                        }
                    }
                }
                count = -1L;
                int cPos = attach.payload().position();
                long canWrite = attach.payloadSize - cPos;
                if (canWrite > (long)bufferSize) {
                    canWrite = bufferSize;
                }
                if (this.master.getRateLimit() > 0L) {
                    long shouldWrite = this.master.awaitSend(canWrite);
                    if (shouldWrite < canWrite) {
                        canWrite = shouldWrite;
                    }
                    attach.payload().limit(cPos + (int)canWrite);
                }
                if (!connectCookieSent) {
                    ByteBuffer connectCookie = null;
                    try {
                        connectCookie = dbPool.take();
                        if (!this.isNetTest) {
                            connectCookie.limit(17);
                        } else {
                            connectCookie.limit(connectCookie.capacity());
                        }
                        connectCookie.put((byte)1).putLong(this.master.fdtSession.sessionID().getMostSignificantBits()).putLong(this.master.fdtSession.sessionID().getLeastSignificantBits());
                        if (this.isNetTest) {
                            connectCookie.position(connectCookie.capacity());
                        }
                        connectCookie.flip();
                        long tmpW = 0L;
                        while (connectCookie.hasRemaining()) {
                            count = sc.write(connectCookie);
                            if (!this.isNetTest || (tmpW += count) < 18L) continue;
                        }
                        attach.connectCookieSent.set(true);
                    }
                    finally {
                        if (connectCookie != null) {
                            dbPool.put(connectCookie);
                            if (!attach.connectCookieSent.get()) {
                                this.close("Unable to send connect cookie", new IOException("Unable to send connect cookie"));
                            }
                        }
                    }
                }
                while ((count = this.writeToChannel(sc, attach.asArray())) > 0L) {
                    if (this.isNetTest) {
                        fdtSelectionKey.opCount = 0;
                        this.addAndGetTotalBytes(count);
                        this.master.addAndGetTotalBytes(count);
                        continue;
                    }
                    attach.payload().limit(attach.payloadSize);
                    fdtSelectionKey.opCount = 0;
                    this.addAndGetTotalBytes(count);
                    this.master.addAndGetTotalBytes(count);
                    if (logFinest) {
                        logger.log(Level.FINEST, " [ SocketWriterTask ] Socket: " + sc.socket() + " written: " + count);
                    }
                    attach.updateLastOperation();
                    if (attach.isPayloadWritten()) {
                        long ladd = attach.payload().limit();
                        this.addAndGetUtilBytes(ladd);
                        this.master.addAndGetUtilBytes(ladd);
                        if (this.isNetTest) {
                            ByteBuffer h = attach.header();
                            h.position(0);
                            h.limit(h.capacity());
                            ByteBuffer p = attach.payload();
                            p.position(0);
                            p.limit(p.capacity());
                        } else {
                            attach.recycleBuffers();
                            FileBlock fb = this.fileBlockProducer.poll(5L, TimeUnit.SECONDS);
                            if (fb == null) {
                                attach.updateLastOperation();
                                this.readyChannelsQueue.offer(fdtSelectionKey);
                                return 0L;
                            }
                            boolean bRet = false;
                            try {
                                bRet = FDTWriterKeyAttachement.fromFileBlock(fb, attach);
                            }
                            finally {
                                if (!bRet) {
                                    attach.recycleBuffers();
                                    if (fb != null && fb.buff != null) {
                                        dbPool.put(fb.buff);
                                        fb = null;
                                    }
                                }
                            }
                        }
                    }
                    count = -1L;
                    canWrite = attach.payloadSize - attach.payload().position();
                    if (canWrite > (long)bufferSize) {
                        canWrite = bufferSize;
                    }
                    if (this.master.getRateLimit() <= 0L) continue;
                    long shouldWrite = this.master.awaitSend(canWrite);
                    if (shouldWrite < canWrite) {
                        canWrite = shouldWrite;
                    }
                    attach.payload().limit(attach.payload().position() + (int)canWrite);
                }
                if (count != 0L) break block54;
                if (!this.isNetTest || !isBlocking) break;
                ByteBuffer buff = attach.payload();
                buff.position(0);
                buff.limit(buff.capacity());
            }
            attach.payload().limit(attach.payloadSize);
            fdtSelectionKey.renewInterest();
            return count;
        }
        attach.payload().limit(attach.payloadSize);
        return count;
    }

    private void recycleBuffers() {
        try {
            FDTWriterKeyAttachement attach;
            FDTSelectionKey fdtSelectionKey = this.fdtSelectionKeyRef.getAndSet(null);
            if (fdtSelectionKey != null && (attach = (FDTWriterKeyAttachement)fdtSelectionKey.attachment()) != null) {
                attach.recycleBuffers();
            }
        }
        catch (Throwable t1) {
            logger.log(Level.WARNING, " Got exception trying to recover the buffers and returning them to pool", t1);
        }
    }

    @Override
    public void internalClose() {
        try {
            FDTSelectionKey fdtSelectionKey = this.fdtSelectionKeyRef.getAndSet(null);
            if (fdtSelectionKey != null) {
                fdtSelectionKey.cancel();
                FDTWriterKeyAttachement attach = (FDTWriterKeyAttachement)fdtSelectionKey.attachment();
                if (attach != null) {
                    attach.recycleBuffers();
                }
                SocketChannel sc = fdtSelectionKey.channel();
                try {
                    sc.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (fdtSelectionKey != null) {
                this.master.workerDown(fdtSelectionKey, this.downCause());
            } else {
                this.master.workerDown(null, this.downCause());
            }
            this.recycleBuffers();
        }
        catch (Throwable t1) {
            System.err.println("\n\n\n\n\\n ========================= \n\n\n");
            t1.printStackTrace();
            System.err.println("\n\n\n\n\\n ========================= \n\n\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        FDTSelectionKey fdtSelectionKey;
        try {
            while (true) {
                this.fdtSelectionKeyRef.set(null);
                FDTSelectionKey iSel = null;
                while (iSel == null) {
                    this.fdtSelectionKeyRef.getAndSet((FDTSelectionKey)this.readyChannelsQueue.poll(2L, TimeUnit.SECONDS));
                    iSel = this.fdtSelectionKeyRef.get();
                    if (!this.isClosed()) continue;
                }
                fdtSelectionKey = iSel;
                if (this.isClosed()) {
                    break;
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, " writeDate for SK: " + Utils.toStringSelectionKey(fdtSelectionKey) + " SQSize : " + this.readyChannelsQueue.size() + " SelQueue: " + this.readyChannelsQueue);
                }
                if (this.writeData() >= 0L && !this.master.isClosed()) continue;
                return;
            }
        }
        catch (Throwable t) {
            fdtSelectionKey = this.fdtSelectionKeyRef.get();
            this.master.workerDown(fdtSelectionKey, t);
            this.close("SocketWriterTask got exception ", t);
        }
        finally {
            FDTSelectionKey fdtSelectionKey2 = this.fdtSelectionKeyRef.getAndSet(null);
            try {
                FDTKeyAttachement attach;
                if (fdtSelectionKey2 != null && (attach = fdtSelectionKey2.attachment()) != null) {
                    attach.recycleBuffers();
                }
            }
            catch (Throwable t1) {
                logger.log(Level.WARNING, " Got exception trying to return buffers to the pool", t1);
            }
            this.master.workerDown(fdtSelectionKey2, null);
            this.close(null, null);
        }
    }
}

