/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.transport;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import lia.util.net.common.Utils;
import lia.util.net.copy.transport.SpeedLimiter;

public class SpeedLimitManager {
    private static final SpeedLimitManager _thisInstance = new SpeedLimitManager();
    private static final Logger logger = Logger.getLogger(SpeedLimitManager.class.getName());
    private final ScheduledThreadPoolExecutor executor = Utils.getSchedExecService("SpeedLimitManager", 2, 2);

    private SpeedLimitManager() {
    }

    public static final SpeedLimitManager getInstance() {
        return _thisInstance;
    }

    public ScheduledFuture<?> addLimiter(SpeedLimiter speedLimiter) throws Exception {
        long delay = speedLimiter.getNotifyDelay();
        logger.log(Level.INFO, " Adding SpeedLimiterTask for " + speedLimiter + " delay: " + delay + " ms");
        return this.executor.scheduleWithFixedDelay(new SpeedLimiterTask(speedLimiter), 0L, delay, TimeUnit.MILLISECONDS);
    }

    private static final class SpeedLimiterTask
    implements Runnable {
        final SpeedLimiter speedLimiter;
        long lastUpdate;

        private SpeedLimiterTask(SpeedLimiter speedLimiter) {
            this.speedLimiter = speedLimiter;
        }

        @Override
        public void run() {
            try {
                long now = System.currentTimeMillis();
                long rateLimit = this.speedLimiter.getRateLimit();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "[ SpeedLimitManagerTask ] " + this.speedLimiter + " rateLimit: " + rateLimit);
                }
                double newAvailable = this.lastUpdate == 0L ? (double)rateLimit : (double)rateLimit * ((double)(now - this.lastUpdate) / 1000.0);
                this.lastUpdate = now;
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "[ SpeedLimitManagerTask ] " + this.speedLimiter + " av: " + newAvailable);
                }
                this.speedLimiter.notifyAvailableBytes(Math.round(newAvailable));
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, " SpeedLimiterTask got exception notifying " + this.speedLimiter, t);
            }
        }
    }
}

