/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.jiperf;

import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ByteBufferPool {
    public static final int BUFFER_SIZE = 0x2000000;
    public static final int POOL_SIZE = 10;
    private static final transient Logger logger = Logger.getLogger(ByteBufferPool.class.getName());
    public static ByteBufferPool _theInstance;
    private static volatile boolean initialized;
    ArrayBlockingQueue<ByteBuffer> thePool = new ArrayBlockingQueue(10);

    private ByteBufferPool() {
        int i = 0;
        for (i = 0; i < 10; ++i) {
            try {
                if (this.thePool.offer(ByteBuffer.allocateDirect(0x2000000))) continue;
                logger.log(Level.WARNING, " Queue full ??? Should not happen ...");
                continue;
            }
            catch (OutOfMemoryError oom) {
                logger.log(Level.WARNING, " Please try to increase -XX:MaxDirectMemorySize=256m ", oom);
                break;
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, " Got general exception trying to allocate the mem", t);
                break;
            }
        }
        logger.log(Level.INFO, " Succesfully alocated " + i + " buffers");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final ByteBufferPool getInstance() {
        if (initialized) return _theInstance;
        Class<ByteBufferPool> clazz = ByteBufferPool.class;
        synchronized (ByteBufferPool.class) {
            if (initialized) return _theInstance;
            _theInstance = new ByteBufferPool();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _theInstance;
        }
    }

    public ByteBuffer get() {
        ByteBuffer retBuff = null;
        while (retBuff == null) {
            try {
                retBuff = this.thePool.poll(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ie) {
                logger.log(Level.WARNING, " The thread was interrupted trying to get a buffer from the pool", ie);
            }
            if (retBuff != null) continue;
            logger.log(Level.WARNING, " Timeot reached ... unable to get a buffer. You should increase the pool size");
        }
        return retBuff;
    }

    public void put(ByteBuffer buff) {
        buff.clear();
        this.thePool.offer(buff);
    }

    static {
        initialized = false;
    }
}

