/*
 * Decompiled with CFR 0.152.
 */
package org.globus.axis.handler;

import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.gssapi.jaas.GlobusPrincipal;
import org.globus.gsi.gssapi.jaas.UserNamePrincipal;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;

public class CredentialHandler
extends BasicHandler {
    private static Log log = LogFactory.getLog(CredentialHandler.class.getName());
    private static final String CALLER_SUBJECT = "callerSubject";

    public void invoke(MessageContext msgContext) throws AxisFault {
        log.debug("Enter: invoke");
        Object tmp = msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        if (tmp == null || !(tmp instanceof HttpServletRequest)) {
            return;
        }
        HttpServletRequest req = (HttpServletRequest)tmp;
        String url = req.getRequestURL().toString();
        tmp = msgContext.getProperty("transport.url");
        if (tmp == null && url != null) {
            msgContext.setProperty("transport.url", (Object)url);
        }
        Subject subject = this.getSubject(msgContext);
        tmp = req.getAttribute("org.globus.gsi.authorized.user.dn");
        if (tmp != null) {
            msgContext.setProperty("org.globus.gsi.authorized.user.dn", tmp);
            subject.getPrincipals().add(new GlobusPrincipal((String)tmp));
        }
        if ((tmp = req.getAttribute("org.globus.gsi.context")) != null) {
            msgContext.setProperty("org.globus.gsi.context", tmp);
            GSSContext ctx = (GSSContext)tmp;
            try {
                if (ctx.getDelegCred() != null) {
                    subject.getPrivateCredentials().add(ctx.getDelegCred());
                }
            }
            catch (GSSException e) {
                log.warn("Unable to obtain delegated credentials", e);
            }
        }
        if ((tmp = req.getAttribute("org.globus.gsi.credentials")) != null) {
            log.debug("Delegation performed. Setting credentials property.");
            msgContext.setProperty("org.globus.gsi.credentials", tmp);
            subject.getPrivateCredentials().add(tmp);
        } else {
            log.debug("Delegation not performed. Not setting credentials property.");
        }
        tmp = req.getAttribute("org.globus.gsi.authorized.user.name");
        if (tmp != null) {
            msgContext.setProperty("org.globus.gsi.authorized.user.name", tmp);
            subject.getPrincipals().add(new UserNamePrincipal((String)tmp));
        }
        log.debug("Exit: invoke");
    }

    protected Subject getSubject(MessageContext msgCtx) {
        Subject subject = (Subject)msgCtx.getProperty(CALLER_SUBJECT);
        if (subject == null) {
            subject = new Subject();
            msgCtx.setProperty(CALLER_SUBJECT, (Object)subject);
        }
        return subject;
    }
}

