/*
 * Decompiled with CFR 0.152.
 */
package org.globus.axis.transport.commons;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.params.HostParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.params.HttpParams;
import org.apache.commons.httpclient.util.IdleConnectionTimeoutThread;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.axis.transport.commons.ConnectionPool;
import org.globus.axis.transport.commons.ExtendedHostConfiguration;
import org.globus.axis.transport.commons.ExtendedHttpConnection;

public class CommonsHttpConnectionManager
implements HttpConnectionManager {
    private static final IdleConnectionTimeoutThread IDLE_THREAD = new IdleConnectionTimeoutThread();
    private static Log logger;
    private String[] hostConfigurationParams;
    private HashMap hostPoolMap;
    private long idleTime = 120000L;
    private boolean staleChecking = true;
    private HttpConnectionManagerParams params = new HttpConnectionManagerParams();

    public CommonsHttpConnectionManager(String[] hostConfigurationParams) {
        this.hostConfigurationParams = hostConfigurationParams;
        this.hostPoolMap = new HashMap();
        IDLE_THREAD.addConnectionManager((HttpConnectionManager)this);
    }

    public void setConnectionIdleTime(long time) {
        this.idleTime = time;
    }

    public long getConnectionIdleTime() {
        return this.idleTime;
    }

    public void setStaleCheckingEnabled(boolean staleChecking) {
        this.staleChecking = staleChecking;
    }

    public boolean isStaleCheckingEnabled() {
        return this.staleChecking;
    }

    public HttpConnection getConnection(HostConfiguration hostConfiguration) {
        return this.getConnectionWithTimeout(hostConfiguration, 0L);
    }

    public HttpConnection getConnection(HostConfiguration hostConfiguration, long timeout) {
        return this.getConnectionWithTimeout(hostConfiguration, timeout);
    }

    public HttpConnection getConnectionWithTimeout(HostConfiguration hostConfiguration, long timeout) {
        ExtendedHostConfiguration extendedHostConfiguration = new ExtendedHostConfiguration(hostConfiguration, this.hostConfigurationParams);
        ConnectionPool pool = this.getConnectionPool(extendedHostConfiguration);
        ExtendedHttpConnection httpConnection = pool.getPooledConnection();
        if (httpConnection == null) {
            httpConnection = this.getNewConnection(extendedHostConfiguration);
            httpConnection.setFromPool(false);
        } else {
            httpConnection.setFromPool(true);
        }
        if (this.staleChecking) {
            hostConfiguration.getParams().setParameter("http.method.retry-handler", (Object)httpConnection.getRetryHandler());
        }
        return httpConnection;
    }

    private ExtendedHttpConnection getNewConnection(HostConfiguration hostConfiguration) {
        ExtendedHttpConnection httpConnection = new ExtendedHttpConnection(hostConfiguration, this.staleChecking);
        httpConnection.setHttpConnectionManager(this);
        HttpConnectionParams connectionParams = httpConnection.getParams();
        connectionParams.setDefaults((HttpParams)this.params);
        if (this.hostConfigurationParams != null) {
            HostParams hostParams = hostConfiguration.getParams();
            for (int i = 0; i < this.hostConfigurationParams.length; ++i) {
                String key = this.hostConfigurationParams[i];
                Object value = hostParams.getParameter(key);
                if (value == null) continue;
                connectionParams.setParameter(key, value);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("got new connection: " + (Object)((Object)httpConnection));
        }
        return httpConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionPool getConnectionPool(HostConfiguration hostConfiguration) {
        ConnectionPool pool = null;
        HashMap hashMap = this.hostPoolMap;
        synchronized (hashMap) {
            pool = (ConnectionPool)this.hostPoolMap.get(hostConfiguration);
            if (pool == null) {
                pool = new ConnectionPool();
                pool.setIdleTime(this.idleTime);
                this.hostPoolMap.put(hostConfiguration, pool);
            }
        }
        return pool;
    }

    public void releaseConnection(HttpConnection conn) {
        if (conn.isOpen()) {
            ExtendedHttpConnection extendedHostConfiguration = (ExtendedHttpConnection)conn;
            HostConfiguration hostConfiguration = extendedHostConfiguration.getHostConfiguration();
            ConnectionPool pool = this.getConnectionPool(hostConfiguration);
            if (pool != null) {
                pool.releaseConnection(conn);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("not releasing closed connection: " + conn);
        }
    }

    public HttpConnectionManagerParams getParams() {
        return this.params;
    }

    public void setParams(HttpConnectionManagerParams params) {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        this.params = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeIdleConnections(long idleTimeout) {
        logger.debug("checking for idle connections");
        HashMap hashMap = this.hostPoolMap;
        synchronized (hashMap) {
            for (Map.Entry entry : this.hostPoolMap.entrySet()) {
                ((ConnectionPool)entry.getValue()).closeIdleConnections();
            }
        }
        logger.debug("done checking for idle connections");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        logger.debug("shutting down connections");
        HashMap hashMap = this.hostPoolMap;
        synchronized (hashMap) {
            for (Map.Entry entry : this.hostPoolMap.entrySet()) {
                ((ConnectionPool)entry.getValue()).shutdown();
            }
        }
        this.hostPoolMap.clear();
        logger.debug("done shutting down connections");
    }

    public static void setStaleCheckingEnabled(CommonsHttpConnectionManager manager) {
        String staleCheckProp = System.getProperty("org.globus.transport.stalecheck");
        if ("off".equalsIgnoreCase(staleCheckProp)) {
            logger.debug("no stale connection checking");
            manager.getParams().setStaleCheckingEnabled(false);
            manager.setStaleCheckingEnabled(false);
        } else if ("commons".equalsIgnoreCase(staleCheckProp)) {
            logger.debug("commons stale connection checking");
            manager.getParams().setStaleCheckingEnabled(true);
            manager.setStaleCheckingEnabled(false);
        } else {
            logger.debug("globus stale connection checking");
            manager.getParams().setStaleCheckingEnabled(false);
            manager.setStaleCheckingEnabled(true);
        }
    }

    public static void setConnectionIdleTime(CommonsHttpConnectionManager manager) {
        String idleTimeoutProp = System.getProperty("org.globus.transport.idleTime");
        if (idleTimeoutProp != null) {
            manager.setConnectionIdleTime(Long.parseLong(idleTimeoutProp));
        }
    }

    static {
        IDLE_THREAD.setTimeoutInterval(120000L);
        IDLE_THREAD.start();
        logger = LogFactory.getLog(CommonsHttpConnectionManager.class);
    }
}

