/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.dc;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ftp.DataSource;
import org.globus.ftp.dc.AbstractDataChannel;
import org.globus.ftp.dc.EBlockParallelTransferContext;
import org.globus.ftp.dc.LocalReply;
import org.globus.ftp.dc.ManagedSocketBox;
import org.globus.ftp.dc.SocketBox;
import org.globus.ftp.dc.SocketPool;
import org.globus.ftp.dc.TransferSourceThread;
import org.globus.ftp.dc.TransferThreadManager;
import org.globus.ftp.vanilla.BasicServerControlChannel;

public class GridFTPTransferSourceThread
extends TransferSourceThread {
    protected static Log logger = LogFactory.getLog(GridFTPTransferSourceThread.class.getName());
    protected EBlockParallelTransferContext eContext;

    public GridFTPTransferSourceThread(AbstractDataChannel dataChannel, SocketBox socketBox, DataSource source, BasicServerControlChannel localControlChannel, EBlockParallelTransferContext context) throws Exception {
        super(dataChannel, socketBox, source, localControlChannel, context);
        this.eContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startup() {
        TransferThreadManager threadManager = this.eContext.getTransferThreadManager();
        threadManager.transferThreadStarting();
        BasicServerControlChannel basicServerControlChannel = this.localControlChannel;
        synchronized (basicServerControlChannel) {
            if (this.localControlChannel.getReplyCount() == 0) {
                this.localControlChannel.write(new LocalReply(125));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object shutdown() throws IOException {
        Object quitToken;
        block12: {
            this.writer.endOfData();
            quitToken = this.context.getQuitToken();
            try {
                SocketPool pool = ((EBlockParallelTransferContext)this.context).getSocketPool();
                if (((ManagedSocketBox)this.socketBox).isReusable()) {
                    logger.debug("shutdown; leaving the socket open");
                    pool.checkIn(this.socketBox);
                    break block12;
                }
                logger.debug("shutdown; closing the socket");
                try {
                    this.writer.close();
                }
                finally {
                    try {
                        pool.remove(this.socketBox);
                    }
                    catch (IllegalArgumentException e) {
                        logger.warn(e);
                    }
                    this.socketBox.setSocket(null);
                }
            }
            finally {
                TransferThreadManager threadManager = this.eContext.getTransferThreadManager();
                threadManager.transferThreadTerminating();
                if (quitToken != null) {
                    logger.debug("closing the data source");
                    this.source.close();
                }
            }
        }
        return quitToken;
    }
}

