/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.gssapi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import javax.security.auth.x500.X500Principal;
import org.globus.common.CoGProperties;
import org.globus.gsi.gssapi.GlobusGSSException;
import org.globus.gsi.util.CertificateUtil;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class GlobusGSSName
implements GSSName,
Serializable {
    static final ReverseDNSCache reverseDNSCache = new ReverseDNSCache(CoGProperties.getDefault().getReveseDNSCacheLifetime());
    protected Oid nameType;
    protected X500Principal name;
    protected String globusID;
    protected String hostBasedServiceCN;

    static String queryHost(String name) throws UnknownHostException {
        InetAddress i = InetAddress.getByName(name);
        return InetAddress.getByName(i.getHostAddress()).getHostName();
    }

    public GlobusGSSName() {
        this.nameType = GSSName.NT_ANONYMOUS;
        this.name = null;
    }

    public GlobusGSSName(X500Principal name) {
        if (name == null) {
            this.nameType = GSSName.NT_ANONYMOUS;
        }
        this.name = name;
    }

    public GlobusGSSName(byte[] name) {
        if (name == null) {
            this.nameType = GSSName.NT_ANONYMOUS;
            this.name = null;
        } else {
            this.name = new X500Principal(name);
        }
    }

    public GlobusGSSName(String name) throws GSSException {
        if (name == null) {
            this.nameType = GSSName.NT_ANONYMOUS;
            this.name = null;
        } else {
            try {
                this.name = CertificateUtil.toPrincipal(name);
            }
            catch (Exception e) {
                throw new GlobusGSSException(3, (Throwable)e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GlobusGSSName(String name, Oid nameType) throws GSSException {
        if (name == null) {
            if (nameType != null && !nameType.equals(GSSName.NT_ANONYMOUS)) {
                throw new GSSException(4);
            }
            this.name = null;
            this.nameType = GSSName.NT_ANONYMOUS;
            return;
        }
        if (nameType != null) {
            if (!nameType.equals(GSSName.NT_HOSTBASED_SERVICE)) throw new GSSException(4);
            int atPos = name.indexOf(64);
            if (atPos == -1 || atPos + 1 >= name.length()) {
                throw new GlobusGSSException(11, 25, "badName00");
            }
            String host = name.substring(atPos + 1);
            try {
                host = CoGProperties.getDefault().getReverseDNSCacheType().equals("ThreadedCache") ? reverseDNSCache.resolve(host) : GlobusGSSName.queryHost(host);
            }
            catch (UnknownHostException e) {
                throw new GlobusGSSException(11, (Throwable)e);
            }
            this.hostBasedServiceCN = name.substring(0, atPos) + "/" + host;
            this.name = new X500Principal("CN=" + this.hostBasedServiceCN);
        } else {
            try {
                this.name = CertificateUtil.toPrincipal(name);
            }
            catch (Exception e) {
                throw new GlobusGSSException(3, (Throwable)e);
            }
        }
        this.nameType = nameType;
    }

    public boolean isAnonymous() {
        return this.name == null;
    }

    public boolean isMN() {
        return true;
    }

    public boolean equals(GSSName another) throws GSSException {
        if (another == null) {
            return false;
        }
        if (this.isAnonymous()) {
            return another.isAnonymous();
        }
        if (another.isAnonymous()) {
            return false;
        }
        if (!(another instanceof GlobusGSSName)) {
            throw new GSSException(11);
        }
        GlobusGSSName other = (GlobusGSSName)another;
        if (this.nameType != null && this.nameType.equals(GSSName.NT_HOSTBASED_SERVICE) || other.nameType != null && other.nameType.equals(GSSName.NT_HOSTBASED_SERVICE)) {
            int i2;
            String service2;
            String hp1 = this.getHostBasedServiceCN(true);
            String hp2 = other.getHostBasedServiceCN(true);
            if (hp1 == null || hp2 == null) {
                return false;
            }
            String service1 = GlobusGSSName.getService(hp1);
            if (!service1.equalsIgnoreCase(service2 = GlobusGSSName.getService(hp2))) {
                return false;
            }
            String host1 = GlobusGSSName.getHost(hp1);
            String host2 = GlobusGSSName.getHost(hp2);
            int i1 = 0;
            int s1 = host1.length();
            int s2 = host2.length();
            for (i2 = 0; i1 < s1 && i2 < s2; ++i1, ++i2) {
                char h2;
                char h1 = Character.toUpperCase(host1.charAt(i1));
                if (h1 == (h2 = Character.toUpperCase(host2.charAt(i2)))) {
                    if (h1 != '.') continue;
                    return host1.equalsIgnoreCase(host2);
                }
                if (h1 == '.' && h2 == '-') {
                    return GlobusGSSName.compareHost(host2, i2, host1, i1);
                }
                if (h1 == '-' && h2 == '.') {
                    return GlobusGSSName.compareHost(host1, i1, host2, i2);
                }
                return false;
            }
            return i1 == i2;
        }
        return this.toString().equalsIgnoreCase(another.toString());
    }

    public String toString() {
        if (this.name == null) {
            return "<anonymous>";
        }
        if (this.globusID == null) {
            this.globusID = CertificateUtil.toGlobusID(this.name);
        }
        return this.globusID;
    }

    protected String getHostBasedServiceCN(boolean last) {
        if (this.hostBasedServiceCN == null) {
            String dn = this.name.getName();
            int cnStart = last ? dn.lastIndexOf("CN=") + 3 : dn.indexOf("CN=") + 3;
            if (cnStart == -1) {
                return null;
            }
            int cnEnd = dn.indexOf(",", cnStart);
            if (cnEnd == -1) {
                int nextAtt = dn.indexOf("=", cnStart);
                if (nextAtt == -1) {
                    cnEnd = dn.length();
                } else {
                    return null;
                }
            }
            this.hostBasedServiceCN = this.name.getName().substring(cnStart, cnEnd);
        }
        return this.hostBasedServiceCN;
    }

    private static String getService(String name) {
        int pos = name.indexOf(47);
        return pos == -1 ? "host" : name.substring(0, pos);
    }

    private static String getHost(String name) {
        int pos = name.indexOf(47);
        return pos == -1 ? name : name.substring(pos + 1);
    }

    private static boolean compareHost(String host1, int i, String host2, int j) {
        if (host1.charAt(i) != '-') {
            throw new IllegalArgumentException();
        }
        int size = host1.length();
        while (i < size && host1.charAt(i) != '.') {
            ++i;
        }
        if (size - i == host2.length() - j) {
            return host1.regionMatches(i, host2, j, size - i);
        }
        return false;
    }

    public Oid getStringNameType() throws GSSException {
        throw new GSSException(16);
    }

    public byte[] export() throws GSSException {
        throw new GSSException(16);
    }

    public GSSName canonicalize(Oid mech) throws GSSException {
        throw new GSSException(16);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.nameType);
        oos.writeObject(this.name.getName());
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.nameType = (Oid)ois.readObject();
        this.name = new X500Principal((String)ois.readObject());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ReverseDNSCache {
        protected final Map<String, MapEntry> cache = new TreeMap<String, MapEntry>();
        final long duration;
        final ExecutorService threads = Executors.newCachedThreadPool(new ThreadFactory(){

            public Thread newThread(Runnable runnable) {
                Thread t = new Thread(runnable);
                t.setName("Reverse DNS request");
                t.setDaemon(true);
                return t;
            }
        });
        long oldest = System.currentTimeMillis();

        public ReverseDNSCache(long duration) {
            this.duration = duration;
        }

        protected void enforceConstraints() {
            if (this.oldest + this.duration < System.currentTimeMillis()) {
                long newOldest = System.currentTimeMillis();
                LinkedList<String> toClear = new LinkedList<String>();
                for (Map.Entry<String, MapEntry> e : this.cache.entrySet()) {
                    if (e.getValue().inserted + this.duration < System.currentTimeMillis()) {
                        toClear.add(e.getKey());
                        continue;
                    }
                    if (e.getValue().inserted >= newOldest) continue;
                    newOldest = e.getValue().inserted;
                }
                for (String k : toClear) {
                    this.cache.remove(k);
                }
                this.oldest = newOldest;
            }
        }

        protected synchronized Future<String> getCached(final String ip) {
            MapEntry inCache = this.cache.get(ip);
            if (inCache == null) {
                Future<String> name = this.threads.submit(new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return GlobusGSSName.queryHost(ip);
                    }
                });
                inCache = new MapEntry(name, System.currentTimeMillis());
                this.cache.put(ip, inCache);
            } else {
                inCache.inserted = System.currentTimeMillis();
            }
            this.enforceConstraints();
            return inCache.hostName;
        }

        public String resolve(String ip) throws UnknownHostException {
            try {
                return this.getCached(ip).get();
            }
            catch (InterruptedException e) {
                throw new UnknownHostException(e.getMessage());
            }
            catch (ExecutionException e) {
                throw new UnknownHostException(e.getMessage());
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class MapEntry {
            final Future<String> hostName;
            Long inserted;

            public MapEntry(Future<String> hostName, Long inserted) {
                this.hostName = hostName;
                this.inserted = inserted;
            }
        }
    }
}

