/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.stores;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.cert.X509CRL;
import org.globus.gsi.stores.AbstractResourceSecurityWrapper;
import org.globus.gsi.stores.ResourceStoreException;
import org.globus.gsi.util.CertificateLoadUtil;
import org.globus.util.GlobusResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceCRL
extends AbstractResourceSecurityWrapper<X509CRL> {
    public ResourceCRL(String fileName) throws ResourceStoreException {
        super(false);
        this.init(this.globusResolver.getResource(fileName));
    }

    public ResourceCRL(boolean inMemory, GlobusResource globusResource) throws ResourceStoreException {
        super(inMemory);
        this.init(globusResource);
    }

    public ResourceCRL(String fileName, X509CRL crl) throws ResourceStoreException {
        super(false);
        this.init(this.globusResolver.getResource(fileName), crl);
    }

    public X509CRL getCrl() throws ResourceStoreException {
        return (X509CRL)this.getSecurityObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected X509CRL create(GlobusResource resource) throws ResourceStoreException {
        X509CRL x509CRL;
        InputStream is = resource.getInputStream();
        try {
            x509CRL = CertificateLoadUtil.loadCrl(new BufferedInputStream(is));
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ResourceStoreException(e);
            }
            catch (GeneralSecurityException e) {
                throw new ResourceStoreException(e);
            }
        }
        try {
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return x509CRL;
    }

    @Override
    public void store() throws ResourceStoreException {
    }
}

