/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.trustmanager;

import java.security.cert.CertPathValidatorException;
import java.security.cert.X509Certificate;
import java.util.Set;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.proxy.ext.ProxyCertInfo;
import org.globus.gsi.trustmanager.CertificateChecker;
import org.globus.gsi.util.ProxyCertificateUtil;

public class UnsupportedCriticalExtensionChecker
implements CertificateChecker {
    public void invoke(X509Certificate cert, GSIConstants.CertificateType certType) throws CertPathValidatorException {
        Set<String> criticalExtensionOids = cert.getCriticalExtensionOIDs();
        if (criticalExtensionOids == null) {
            return;
        }
        for (String criticalExtensionOid : criticalExtensionOids) {
            this.isUnsupported(certType, criticalExtensionOid);
        }
    }

    private void isUnsupported(GSIConstants.CertificateType certType, String criticalExtensionOid) throws CertPathValidatorException {
        boolean unsupportedCritExtention = criticalExtensionOid.equals("2.5.29.19");
        unsupportedCritExtention = unsupportedCritExtention || criticalExtensionOid.equals("2.5.29.15");
        unsupportedCritExtention = unsupportedCritExtention || criticalExtensionOid.equals(ProxyCertInfo.OID.toString()) && ProxyCertificateUtil.isGsi4Proxy(certType);
        boolean bl = unsupportedCritExtention = unsupportedCritExtention || criticalExtensionOid.equals(ProxyCertInfo.OLD_OID.toString()) && ProxyCertificateUtil.isGsi3Proxy(certType);
        if (unsupportedCritExtention) {
            return;
        }
        throw new CertPathValidatorException("Critical extension with unsupported OID " + criticalExtensionOid);
    }
}

