/*
 * Decompiled with CFR 0.152.
 */
package org.globus.util;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;

public class Tail
implements Runnable {
    private static final int CHUNK_SIZE = 2048;
    private byte[] buffer = new byte[2048];
    private boolean _stop = false;
    private List list = Collections.synchronizedList(new LinkedList());
    private Thread _thread;
    private Log _logger;

    public void setLog(Log logger) {
        this._logger = logger;
    }

    public void start() {
        this._thread = new Thread(this);
        this._thread.start();
    }

    public void join() throws InterruptedException {
        this._thread.join();
    }

    public void addFile(File file, OutputStream out, int pos) throws IOException {
        this.list.add(new FileWatcher(file, out, pos));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this._logger.debug("[tail] running...");
        Iterator iter = null;
        FileWatcher watcher2 = null;
        try {
            for (FileWatcher watcher2 : this.list) {
                watcher2.init();
            }
            while (!this.isDone()) {
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (FileWatcher watcher2 : this.list) {
                    long len = watcher2.getDiff();
                    if (len <= 0L) continue;
                    while (len > 0L) {
                        int size = len > 2048L ? 2048 : (int)len;
                        watcher2.moveBuffer(this.buffer, size);
                        len -= (long)size;
                    }
                }
            }
        }
        catch (IOException e) {
            this._logger.debug("Unexpected error.", e);
        }
        finally {
            this.close();
        }
        this._logger.debug("[tail] done.");
    }

    private boolean isDone() throws IOException {
        if (!this._stop) {
            return false;
        }
        Iterator iter = null;
        FileWatcher watcher2 = null;
        for (FileWatcher watcher2 : this.list) {
            if (watcher2.getDiff() <= 0L) continue;
            return false;
        }
        return true;
    }

    private void close() {
        Iterator iter = null;
        FileWatcher watcher2 = null;
        for (FileWatcher watcher2 : this.list) {
            watcher2.close();
        }
    }

    public void stop() {
        this._logger.debug("[tail] stop called");
        this._stop = true;
    }

    class FileWatcher {
        private RandomAccessFile _ras;
        private OutputStream _out;
        private long _pos;

        public FileWatcher(File file, OutputStream out, int pos) throws IOException {
            this._ras = new RandomAccessFile(file, "r");
            this._out = out;
            this._pos = pos;
        }

        public void init() throws IOException {
            this._ras.seek(this._pos);
        }

        public long getDiff() throws IOException {
            return this._ras.length() - this._pos;
        }

        public void moveBuffer(byte[] buffer, int size) throws IOException {
            this._ras.readFully(buffer, 0, size);
            this._pos += (long)size;
            if (Tail.this._logger.isDebugEnabled()) {
                Tail.this._logger.debug("[tail] output size: " + size);
            }
            this._out.write(buffer, 0, size);
        }

        public void close() {
            try {
                this._ras.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this._out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

