/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.util;

import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.helpers.CertificateHelpers;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.italiangrid.voms.util.FilePermissionHelper;

public class CredentialsUtils {
    public static void saveProxyCredentials(OutputStream os, X509Credential uc) throws UnrecoverableKeyException, KeyStoreException, IllegalArgumentException, NoSuchAlgorithmException, IOException, NoSuchProviderException, CertificateException {
        X509Certificate[] chain = CertificateHelpers.sortChain(Arrays.asList(uc.getCertificateChain()));
        PrivateKey key = uc.getKey();
        X509Certificate cert = uc.getCertificate();
        CertificateUtils.saveCertificate(os, cert, CertificateUtils.Encoding.PEM);
        if (key != null) {
            CertificateUtils.savePrivateKey(os, key, CertificateUtils.Encoding.PEM, null, null);
        }
        X509Certificate c = null;
        for (int index = 1; index < chain.length; ++index) {
            c = chain[index];
            int basicConstraints = c.getBasicConstraints();
            if (basicConstraints >= 0) continue;
            CertificateUtils.saveCertificate(os, c, CertificateUtils.Encoding.PEM);
        }
        os.flush();
    }

    public static void saveProxyCredentials(String proxyFileName, X509Credential uc) throws IOException, UnrecoverableKeyException, KeyStoreException, IllegalArgumentException, NoSuchAlgorithmException, NoSuchProviderException, CertificateException {
        File f = new File(proxyFileName);
        RandomAccessFile raf = new RandomAccessFile(f, "rws");
        FileChannel channel = raf.getChannel();
        FilePermissionHelper.setProxyPermissions(proxyFileName);
        channel.truncate(0L);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CredentialsUtils.saveProxyCredentials(baos, uc);
        baos.close();
        channel.write(ByteBuffer.wrap(baos.toByteArray()));
        channel.close();
        raf.close();
    }
}

