/*
 * Decompiled with CFR 0.152.
 */
package apmon;

import apmon.ApMon;
import apmon.ApMonException;
import apmon.ApMonMonitoringConstants;
import apmon.MonitoredJob;
import apmon.host.HostPropertiesMonitor;
import apmon.host.Parser;
import apmon.host.cmdExec;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

class BkThread
extends Thread {
    public static final int RECHECK_CONF = 0;
    public static final int SYS_INFO_SEND = 1;
    public static final int JOB_INFO_SEND = 2;
    static String osName = System.getProperty("os.name");
    private static Logger logger = Logger.getLogger("apmon");
    ApMon apm;
    boolean hasToRun = true;
    HostPropertiesMonitor monitor = null;

    public BkThread(ApMon apm) {
        this.apm = apm;
        this.monitor = new HostPropertiesMonitor();
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable getCpuInfo() throws IOException, ApMonException {
        if (osName.indexOf("Linux") < 0) {
            return null;
        }
        Hashtable<Long, String> info = new Hashtable<Long, String>();
        BufferedReader in = null;
        FileReader fr = null;
        try {
            fr = new FileReader("/proc/cpuinfo");
            in = new BufferedReader(fr);
            String line = null;
            while ((line = in.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line, ":");
                if (line.startsWith("cpu MHz")) {
                    st.nextToken();
                    String freq_s = st.nextToken();
                    if (freq_s == null) {
                        throw new ApMonException("Error reading CPU frequency from /proc/cpuinfo");
                    }
                    info.put(ApMonMonitoringConstants.LGEN_CPU_MHZ, freq_s);
                }
                if (line.startsWith("vendor_id")) {
                    st.nextToken();
                    String vendor = st.nextToken();
                    if (vendor == null) {
                        throw new ApMonException("Error reading CPU vendor_id from /proc/cpuinfo");
                    }
                    info.put(ApMonMonitoringConstants.LGEN_CPU_VENDOR_ID, vendor);
                }
                if (line.startsWith("model") && !line.startsWith("model name")) {
                    st.nextToken();
                    String model = st.nextToken();
                    if (model == null) {
                        throw new ApMonException("Error reading CPU model from /proc/cpuinfo");
                    }
                    info.put(ApMonMonitoringConstants.LGEN_CPU_MODEL, model);
                }
                if (line.startsWith("cpu family")) {
                    st.nextToken();
                    String cpufam = st.nextToken();
                    if (cpufam == null) {
                        throw new ApMonException("Error reading CPU family from /proc/cpuinfo");
                    }
                    info.put(ApMonMonitoringConstants.LGEN_CPU_FAMILY, cpufam);
                }
                if (line.startsWith("model name")) {
                    st.nextToken();
                    String modelname = st.nextToken();
                    if (modelname == null) {
                        throw new ApMonException("Error reading CPU model name from /proc/cpuinfo");
                    }
                    info.put(ApMonMonitoringConstants.LGEN_CPU_MODEL_NAME, modelname);
                }
                if (!line.startsWith("bogomips")) continue;
                st.nextToken();
                String bogomips = st.nextToken();
                if (bogomips == null) {
                    throw new ApMonException("Error reading CPU bogomips from /proc/cpuinfo");
                }
                info.put(ApMonMonitoringConstants.LGEN_BOGOMIPS, bogomips);
            }
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (Throwable throwable) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getBootTime() throws IOException, ApMonException {
        if (osName.indexOf("Linux") < 0) {
            return 0L;
        }
        BufferedReader in = null;
        FileReader fr = null;
        try {
            fr = new FileReader("/proc/stat");
            in = new BufferedReader(fr);
            String line = null;
            while ((line = in.readLine()) != null && !line.startsWith("btime")) {
            }
            if (line == null) {
                throw new ApMonException("Error reading boot time from /proc/stat");
            }
            StringTokenizer st = new StringTokenizer(line);
            st.nextToken();
            String btime_s = st.nextToken();
            if (btime_s == null) {
                throw new ApMonException("Error reading boot time from /proc/stat");
            }
            long l = Long.parseLong(btime_s) * 1000L;
            return l;
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (Throwable throwable) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double getUpTime() throws IOException, ApMonException {
        if (osName.indexOf("Linux") < 0) {
            return 0.0;
        }
        FileReader fr = null;
        BufferedReader in = null;
        try {
            fr = new FileReader("/proc/uptime");
            in = new BufferedReader(fr);
            String line = in.readLine();
            if (line == null) {
                throw new ApMonException("Error reading boot time from /proc/uptime");
            }
            StringTokenizer st = new StringTokenizer(line);
            String up_time = st.nextToken();
            if (up_time == null) {
                throw new ApMonException("Error reading optime from /proc/uptime");
            }
            double d = Double.parseDouble(up_time) / 86400.0;
            return d;
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (Throwable throwable) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNumCPUs() throws IOException, ApMonException {
        if (osName.indexOf("Linux") < 0) {
            return 0;
        }
        FileReader fr = null;
        BufferedReader in = null;
        try {
            fr = new FileReader("/proc/stat");
            in = new BufferedReader(fr);
            String line = null;
            int numCPUs = 0;
            while ((line = in.readLine()) != null) {
                if (!line.startsWith("cpu") || !Character.isDigit(line.charAt(3))) continue;
                ++numCPUs;
            }
            if (numCPUs == 0) {
                throw new ApMonException("Error reading CPU frequency from /proc/stat");
            }
            int n = numCPUs;
            return n;
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (Throwable throwable) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static void getNetConfig(Vector netInterfaces, Vector ips) throws IOException, ApMonException {
        Parser parser = new Parser();
        cmdExec exec = new cmdExec();
        String output = exec.executeCommandReality("/sbin/ifconfig -a", "");
        if (exec.isError()) {
            output = null;
        }
        exec.stopIt();
        String crtIfaceName = null;
        if (output != null && !output.equals("")) {
            parser.parse(output);
            String line = parser.nextLine();
            while (line != null && line != null) {
                StringTokenizer lst = new StringTokenizer(line, " :\t");
                if (line.startsWith(" ") || line.startsWith("\t")) {
                    if (line.indexOf("inet") < 0) {
                        line = parser.nextLine();
                        continue;
                    }
                    lst.nextToken();
                    lst.nextToken();
                    String addr_t = lst.nextToken();
                    if (!addr_t.equals("127.0.0.1")) {
                        ips.add(addr_t);
                        netInterfaces.add(crtIfaceName);
                    }
                } else {
                    String netName = lst.nextToken();
                    if (netName != null && !netName.startsWith("lo") && netName.indexOf("eth") != -1) {
                        crtIfaceName = new String(netName);
                    }
                }
                line = parser.nextLine();
            }
        }
    }

    void stopIt() {
        this.hasToRun = false;
    }

    boolean isActive_Sys(long param) {
        return (this.apm.sysMonitorParams & param) == param;
    }

    boolean isActive_Sys(Long param) {
        return this.isActive_Sys((long)param);
    }

    boolean isActive_Job(long param) {
        return (this.apm.jobMonitorParams & param) == param;
    }

    boolean isActive_Job(Long param) {
        return this.isActive_Job((long)param);
    }

    boolean isActive_Gen(long param) {
        return (this.apm.genMonitorParams & param) == param;
    }

    boolean isActive_Gen(Long param) {
        return this.isActive_Gen((long)param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendJobInfo() {
        Object object = this.apm.mutexBack;
        synchronized (object) {
            if (this.apm.monJobs.size() == 0) {
                logger.warning("There are not jobs to be monitored, not sending job monitoring information...");
                return;
            }
            Date d = new Date();
            logger.info("Sending job monitoring information...");
            this.apm.lastJobInfoSend = d.getTime();
            for (int i = 0; i < this.apm.monJobs.size(); ++i) {
                this.sendOneJobInfo((MonitoredJob)this.apm.monJobs.get(i));
            }
        }
    }

    void sendOneJobInfo(MonitoredJob monJob) {
        long crtTime;
        this.apm.lastJobInfoSend = crtTime = System.currentTimeMillis();
        Vector<String> paramNames = new Vector<String>();
        Vector<Double> paramValues = new Vector<Double>();
        HashMap hmJobInfo = null;
        try {
            hmJobInfo = monJob.readJobInfo();
        }
        catch (IOException e) {
            logger.warning("Unable to read job info for " + monJob.getPid());
            hmJobInfo = null;
        }
        if (hmJobInfo == null) {
            logger.warning("Job " + monJob.pid + " does not exist");
            this.apm.removeJobToMonitor(monJob.pid);
            return;
        }
        HashMap hmJobDisk = null;
        try {
            hmJobDisk = monJob.readJobDiskUsage();
        }
        catch (Throwable t1) {
            logger.warning("Unable to read job Disk Usage info for " + monJob.getPid());
            hmJobDisk = null;
        }
        HashMap hm = hmJobInfo;
        if (hmJobDisk != null) {
            hm.putAll(hmJobDisk);
        }
        for (Long lParam : hm.keySet()) {
            try {
                if (!this.isActive_Job(lParam)) continue;
                Double val = (Double)hm.get(lParam);
                paramNames.add(ApMonMonitoringConstants.getJobMLParamName(lParam));
                paramValues.add(val);
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "", t);
                if (!this.apm.autoDisableMonitoring) continue;
                logger.warning("parameter " + ApMonMonitoringConstants.getJobName(lParam) + " disabled");
                this.apm.sysMonitorParams &= lParam ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        try {
            this.apm.sendParameters(monJob.clusterName, monJob.nodeName, paramNames.size(), paramNames, paramValues);
        }
        catch (Exception e) {
            logger.warning("Error while sending system information: " + e);
        }
    }

    void sendSysInfo() {
        Vector<Number> paramValues;
        Vector<String> paramNames;
        block33: {
            Integer val;
            String name;
            Enumeration e;
            Hashtable vals;
            block32: {
                block31: {
                    block30: {
                        double value = 0.0;
                        this.monitor.updateCall();
                        long crtTime = System.currentTimeMillis();
                        logger.log(Level.FINER, "Sending system monitoring information...");
                        this.apm.lastSysInfoSend = crtTime;
                        paramNames = new Vector<String>();
                        paramValues = new Vector<Number>();
                        HashMap hms = this.monitor.getHashParams();
                        if (hms != null) {
                            for (Long lParam : hms.keySet()) {
                                try {
                                    if (!this.isActive_Sys(lParam)) continue;
                                    Double val2 = Double.valueOf((String)hms.get(lParam));
                                    paramNames.add(ApMonMonitoringConstants.getSysMLParamName(lParam));
                                    paramValues.add(val2);
                                }
                                catch (Throwable t) {
                                    if (!this.apm.autoDisableMonitoring) continue;
                                    logger.warning("parameter " + ApMonMonitoringConstants.getSysName(lParam) + " disabled");
                                    this.apm.sysMonitorParams &= lParam ^ 0xFFFFFFFFFFFFFFFFL;
                                }
                            }
                        }
                        if (this.apm.netInterfaces != null && this.apm.netInterfaces.size() != 0) {
                            for (int i = 0; i < this.apm.netInterfaces.size(); ++i) {
                                String iName = (String)this.apm.netInterfaces.get(i);
                                if (iName == null) continue;
                                try {
                                    if (this.isActive_Sys(8192L)) {
                                        value = Double.parseDouble(this.monitor.getNetInCall(iName));
                                        if (osName.indexOf("Mac") == -1) {
                                            value *= 1024.0;
                                        }
                                        paramNames.add(iName + "_" + ApMonMonitoringConstants.getSysMLParamName(8192L));
                                        paramValues.add(new Double(value));
                                    }
                                }
                                catch (Throwable t) {
                                    logger.log(Level.WARNING, "", t);
                                }
                                try {
                                    if (!this.isActive_Sys(16384L)) continue;
                                    value = Double.parseDouble(this.monitor.getNetOutCall(iName));
                                    if (osName.indexOf("Mac") == -1) {
                                        value *= 1024.0;
                                    }
                                    paramNames.add(iName + "_" + ApMonMonitoringConstants.getSysMLParamName(16384L));
                                    paramValues.add(new Double(value));
                                    continue;
                                }
                                catch (Throwable t) {
                                    logger.log(Level.WARNING, "", t);
                                }
                            }
                        }
                        if (this.isActive_Sys(0x400000L)) {
                            try {
                                value = BkThread.getUpTime();
                                paramNames.add(ApMonMonitoringConstants.getSysMLParamName(0x400000L));
                                paramValues.add(new Double(value));
                            }
                            catch (Exception e2) {
                                logger.log(Level.WARNING, "", e2);
                                if (!this.apm.autoDisableMonitoring) break block30;
                                logger.warning("parameter sys_uptime disabled");
                                this.apm.sysMonitorParams &= 0xFFFFFFFFFFBFFFFFL;
                            }
                        }
                    }
                    if (this.isActive_Sys(524288L)) {
                        try {
                            vals = this.monitor.getPState();
                            e = vals.keys();
                            while (e.hasMoreElements()) {
                                name = (String)e.nextElement();
                                val = (Integer)vals.get(name);
                                paramNames.add(ApMonMonitoringConstants.getSysMLParamName(524288L) + "_" + name);
                                paramValues.add(val);
                            }
                        }
                        catch (Exception e3) {
                            logger.log(Level.WARNING, "", e3);
                            if (!this.apm.autoDisableMonitoring) break block31;
                            logger.warning("parameter processes disabled");
                            this.apm.sysMonitorParams &= 0xFFFFFFFFFFF7FFFFL;
                        }
                    }
                }
                if (this.isActive_Sys(0x100000L)) {
                    try {
                        vals = this.monitor.getSockets();
                        e = vals.keys();
                        while (e.hasMoreElements()) {
                            name = (String)e.nextElement();
                            val = (Integer)vals.get(name);
                            paramNames.add(ApMonMonitoringConstants.getSysMLParamName(0x100000L) + "_" + name);
                            paramValues.add(val);
                        }
                    }
                    catch (Exception e4) {
                        logger.log(Level.WARNING, "", e4);
                        if (!this.apm.autoDisableMonitoring) break block32;
                        logger.warning("parameter processes disabled");
                        this.apm.sysMonitorParams &= 0xFFFFFFFFFFEFFFFFL;
                    }
                }
            }
            if (this.isActive_Sys(0x200000L)) {
                try {
                    vals = this.monitor.getTCPDetails();
                    e = vals.keys();
                    while (e.hasMoreElements()) {
                        name = (String)e.nextElement();
                        val = (Integer)vals.get(name);
                        paramNames.add(ApMonMonitoringConstants.getSysMLParamName(0x200000L) + "_" + name);
                        paramValues.add(val);
                    }
                }
                catch (Exception e5) {
                    logger.log(Level.WARNING, "", e5);
                    if (!this.apm.autoDisableMonitoring) break block33;
                    logger.warning("parameter processes disabled");
                    this.apm.sysMonitorParams &= 0xFFFFFFFFFFDFFFFFL;
                }
            }
        }
        try {
            this.apm.sendParameters(this.apm.sysClusterName, this.apm.sysNodeName, paramNames.size(), paramNames, paramValues);
        }
        catch (Exception e) {
            logger.warning("Error while sending system information: " + e);
        }
    }

    void sendGeneralInfo() {
        Vector<Object> paramValues;
        Vector<String> paramNames;
        block42: {
            Double tm;
            block41: {
                block40: {
                    block39: {
                        Hashtable cpuInfo;
                        block38: {
                            String val;
                            block37: {
                                block36: {
                                    block35: {
                                        block34: {
                                            paramNames = new Vector<String>();
                                            paramValues = new Vector<Object>();
                                            paramNames.add("hostname");
                                            paramValues.add(this.apm.myHostname);
                                            for (int i = 0; i < this.apm.netInterfaces.size(); ++i) {
                                                try {
                                                    paramNames.add("ip_" + this.apm.netInterfaces.get(i));
                                                    paramValues.add(this.apm.allMyIPs.get(i));
                                                    continue;
                                                }
                                                catch (Exception e) {
                                                    logger.log(Level.FINE, "BkThread got exception, ignoring network interface: ", e);
                                                }
                                            }
                                            cpuInfo = new Hashtable();
                                            try {
                                                cpuInfo = BkThread.getCpuInfo();
                                            }
                                            catch (Exception e) {
                                                e.printStackTrace();
                                            }
                                            if (this.isActive_Gen(4L)) {
                                                try {
                                                    double cpu_MHz = Double.parseDouble((String)cpuInfo.get(ApMonMonitoringConstants.LGEN_CPU_MHZ));
                                                    paramNames.add(ApMonMonitoringConstants.getGenMLParamName(ApMonMonitoringConstants.LGEN_CPU_MHZ));
                                                    paramValues.add(new Double(cpu_MHz));
                                                }
                                                catch (Throwable t) {
                                                    logger.log(Level.WARNING, "", t);
                                                    if (!this.apm.autoDisableMonitoring) break block34;
                                                    this.apm.genMonitorParams &= 0xFFFFFFFFFFFFFFFBL;
                                                }
                                            }
                                        }
                                        if (this.isActive_Gen(64L)) {
                                            try {
                                                val = ((String)cpuInfo.get(ApMonMonitoringConstants.LGEN_CPU_VENDOR_ID)).trim();
                                                paramNames.add(ApMonMonitoringConstants.getGenMLParamName(ApMonMonitoringConstants.LGEN_CPU_VENDOR_ID));
                                                paramValues.add(val);
                                            }
                                            catch (Throwable t) {
                                                logger.log(Level.WARNING, "", t);
                                                if (!this.apm.autoDisableMonitoring) break block35;
                                                this.apm.genMonitorParams &= 0xFFFFFFFFFFFFFFBFL;
                                            }
                                        }
                                    }
                                    if (this.isActive_Gen(128L)) {
                                        try {
                                            val = ((String)cpuInfo.get(ApMonMonitoringConstants.LGEN_CPU_FAMILY)).trim();
                                            paramNames.add(ApMonMonitoringConstants.getGenMLParamName(ApMonMonitoringConstants.LGEN_CPU_FAMILY));
                                            paramValues.add(val);
                                        }
                                        catch (Throwable t) {
                                            logger.log(Level.WARNING, "", t);
                                            if (!this.apm.autoDisableMonitoring) break block36;
                                            this.apm.genMonitorParams &= 0xFFFFFFFFFFFFFF7FL;
                                        }
                                    }
                                }
                                if (this.isActive_Gen(256L)) {
                                    try {
                                        val = ((String)cpuInfo.get(ApMonMonitoringConstants.LGEN_CPU_MODEL)).trim();
                                        paramNames.add(ApMonMonitoringConstants.getGenMLParamName(ApMonMonitoringConstants.LGEN_CPU_MODEL));
                                        paramValues.add(val);
                                    }
                                    catch (Throwable t) {
                                        logger.log(Level.WARNING, "", t);
                                        if (!this.apm.autoDisableMonitoring) break block37;
                                        this.apm.genMonitorParams &= 0xFFFFFFFFFFFFFEFFL;
                                    }
                                }
                            }
                            if (this.isActive_Gen(512L)) {
                                try {
                                    val = ((String)cpuInfo.get(ApMonMonitoringConstants.LGEN_CPU_MODEL_NAME)).trim();
                                    paramNames.add(ApMonMonitoringConstants.getGenMLParamName(ApMonMonitoringConstants.LGEN_CPU_MODEL_NAME));
                                    paramValues.add(val);
                                }
                                catch (Throwable t) {
                                    logger.log(Level.WARNING, "", t);
                                    if (!this.apm.autoDisableMonitoring) break block38;
                                    this.apm.genMonitorParams &= 0xFFFFFFFFFFFFFDFFL;
                                }
                            }
                        }
                        if (this.isActive_Gen(1024L)) {
                            try {
                                double bogomips = Double.parseDouble((String)cpuInfo.get(ApMonMonitoringConstants.LGEN_BOGOMIPS));
                                paramNames.add(ApMonMonitoringConstants.getGenMLParamName(ApMonMonitoringConstants.LGEN_BOGOMIPS));
                                paramValues.add(new Double(bogomips));
                            }
                            catch (Throwable t) {
                                logger.log(Level.WARNING, "", t);
                                if (!this.apm.autoDisableMonitoring) break block39;
                                this.apm.genMonitorParams &= 0xFFFFFFFFFFFFFBFFL;
                            }
                        }
                    }
                    if (this.isActive_Gen(8L)) {
                        try {
                            int no_CPUs = BkThread.getNumCPUs();
                            paramNames.add(ApMonMonitoringConstants.getGenMLParamName(ApMonMonitoringConstants.LGEN_NO_CPUS));
                            paramValues.add(new Integer(no_CPUs));
                        }
                        catch (Throwable t) {
                            logger.log(Level.WARNING, "", t);
                            if (!this.apm.autoDisableMonitoring) break block40;
                            this.apm.genMonitorParams &= 0xFFFFFFFFFFFFFFF7L;
                        }
                    }
                }
                if (this.isActive_Gen(16L)) {
                    try {
                        tm = Double.valueOf(this.monitor.getMemTotalCall());
                        paramNames.add(ApMonMonitoringConstants.getGenName(ApMonMonitoringConstants.LGEN_TOTAL_MEM));
                        paramValues.add(tm);
                    }
                    catch (Throwable t) {
                        logger.log(Level.WARNING, "", t);
                        if (!this.apm.autoDisableMonitoring) break block41;
                        this.apm.genMonitorParams &= 0xFFFFFFFFFFFFFFEFL;
                    }
                }
            }
            if (this.isActive_Gen(32L)) {
                try {
                    tm = Double.valueOf(this.monitor.getSwapTotalCall());
                    paramNames.add(ApMonMonitoringConstants.getGenName(ApMonMonitoringConstants.LGEN_TOTAL_SWAP));
                    paramValues.add(tm);
                }
                catch (Throwable t) {
                    logger.log(Level.WARNING, "", t);
                    if (!this.apm.autoDisableMonitoring) break block42;
                    this.apm.genMonitorParams &= 0xFFFFFFFFFFFFFFDFL;
                }
            }
        }
        try {
            this.apm.sendParameters(this.apm.sysClusterName, this.apm.sysNodeName, paramNames.size(), paramNames, paramValues);
        }
        catch (Exception e) {
            logger.warning("Error while sending general system information: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long nextRecheck = 0L;
        long nextJobInfoSend = 0L;
        long nextSysInfoSend = 0L;
        int nextOp = 0;
        logger.info("[Starting background thread...]");
        long crtTime = System.currentTimeMillis();
        Object object = this.apm.mutexBack;
        synchronized (object) {
            if (this.apm.confCheck) {
                nextRecheck = crtTime + this.apm.crtRecheckInterval * 1000L;
            }
            if (this.apm.jobMonitoring) {
                nextJobInfoSend = crtTime + this.apm.jobMonitorInterval * 1000L;
            }
            if (this.apm.sysMonitoring) {
                nextSysInfoSend = crtTime + this.apm.sysMonitorInterval * 1000L;
            }
        }
        long nextOpTime = -1L;
        long timeRemained = -1L;
        int generalInfoCount = 0;
        while (this.hasToRun) {
            boolean haveTimeout;
            crtTime = System.currentTimeMillis();
            if (nextRecheck > 0L && (nextJobInfoSend <= 0L || nextRecheck <= nextJobInfoSend)) {
                if (nextSysInfoSend <= 0L || nextRecheck <= nextSysInfoSend) {
                    nextOp = 0;
                    nextOpTime = nextRecheck;
                } else {
                    nextOp = 1;
                    nextOpTime = nextSysInfoSend;
                }
            } else if (nextJobInfoSend > 0L && (nextSysInfoSend <= 0L || nextJobInfoSend <= nextSysInfoSend)) {
                nextOp = 2;
                nextOpTime = nextJobInfoSend;
            } else if (nextSysInfoSend > 0L) {
                nextOp = 1;
                nextOpTime = nextSysInfoSend;
            }
            if (nextOpTime == -1L) {
                nextOpTime = crtTime + 600000L;
            }
            object = this.apm.mutexCond;
            synchronized (object) {
                boolean haveChange;
                Object object2 = this.apm.mutexBack;
                synchronized (object2) {
                    haveChange = false;
                    if (this.apm.jobMonChanged || this.apm.sysMonChanged || this.apm.recheckChanged) {
                        haveChange = true;
                    }
                    if (this.apm.jobMonChanged) {
                        nextJobInfoSend = this.apm.jobMonitoring ? crtTime + this.apm.jobMonitorInterval * 1000L : -1L;
                        this.apm.jobMonChanged = false;
                    }
                    if (this.apm.sysMonChanged) {
                        nextSysInfoSend = this.apm.sysMonitoring ? crtTime + this.apm.sysMonitorInterval * 1000L : -1L;
                        this.apm.sysMonChanged = false;
                    }
                    if (this.apm.recheckChanged) {
                        nextRecheck = this.apm.confCheck ? crtTime + this.apm.crtRecheckInterval * 1000L : -1L;
                        this.apm.recheckChanged = false;
                    }
                }
                if (haveChange) {
                    continue;
                }
                timeRemained = nextOpTime - System.currentTimeMillis();
                haveTimeout = true;
                try {
                    if (timeRemained > 0L) {
                        this.apm.mutexCond.wait(timeRemained);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.apm.condChanged) {
                    haveTimeout = false;
                }
                this.apm.condChanged = false;
            }
            crtTime = System.currentTimeMillis();
            if (!haveTimeout) continue;
            if (nextOp == 2) {
                this.sendJobInfo();
                nextJobInfoSend = crtTime + this.apm.getJobMonitorInterval() * 1000L;
            }
            if (nextOp == 1) {
                this.sendSysInfo();
                if (this.apm.getGenMonitoring()) {
                    if (generalInfoCount <= 1) {
                        this.sendGeneralInfo();
                    }
                    generalInfoCount = (generalInfoCount + 1) % this.apm.genMonitorIntervals;
                }
                nextSysInfoSend = crtTime + this.apm.getSysMonitorInterval() * 1000L;
            }
            if (nextOp != 0) continue;
            Enumeration e = this.apm.confResources.keys();
            boolean resourceChanged = false;
            try {
                while (e.hasMoreElements()) {
                    long lmt;
                    Object obj = e.nextElement();
                    Long lastModified = (Long)this.apm.confResources.get(obj);
                    if (obj instanceof File) {
                        File f = (File)obj;
                        logger.info(" [Checking for modifications for " + f.getCanonicalPath() + "]");
                        lmt = f.lastModified();
                        if (lmt > lastModified) {
                            logger.info("[File " + f.getCanonicalPath() + " modified]");
                            resourceChanged = true;
                            break;
                        }
                    }
                    if (!(obj instanceof URL)) continue;
                    URL u = (URL)obj;
                    lmt = 0L;
                    logger.info("[Checking for modifications for " + u + "]");
                    URLConnection urlConn = u.openConnection();
                    lmt = urlConn.getLastModified();
                    if (lmt <= lastModified && lmt != 0L) continue;
                    logger.info("[Location " + u + " modified]");
                    resourceChanged = true;
                    break;
                }
                if (resourceChanged) {
                    if (this.apm.initType == 1) {
                        this.apm.initialize((String)this.apm.initSource, false);
                    }
                    if (this.apm.initType == 2) {
                        this.apm.initialize((Vector)this.apm.initSource, false);
                    }
                }
                this.apm.setCrtRecheckInterval(this.apm.getRecheckInterval());
            }
            catch (Throwable exc) {
                this.apm.setCrtRecheckInterval(10L * this.apm.getRecheckInterval());
            }
            crtTime = System.currentTimeMillis();
            nextRecheck = crtTime + this.apm.getRecheckInterval() * 1000L;
        }
    }
}

